/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.alexaforbusiness.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.alexaforbusiness.model.AlexaForBusinessResponse;
import software.amazon.awssdk.services.alexaforbusiness.model.BusinessReportSchedule;
import software.amazon.awssdk.services.alexaforbusiness.model.BusinessReportScheduleListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListBusinessReportSchedulesResponse
extends AlexaForBusinessResponse
implements ToCopyableBuilder<Builder, ListBusinessReportSchedulesResponse> {
    private static final SdkField<List<BusinessReportSchedule>> BUSINESS_REPORT_SCHEDULES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("BusinessReportSchedules").getter(ListBusinessReportSchedulesResponse.getter(ListBusinessReportSchedulesResponse::businessReportSchedules)).setter(ListBusinessReportSchedulesResponse.setter(Builder::businessReportSchedules)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BusinessReportSchedules").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(BusinessReportSchedule::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListBusinessReportSchedulesResponse.getter(ListBusinessReportSchedulesResponse::nextToken)).setter(ListBusinessReportSchedulesResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BUSINESS_REPORT_SCHEDULES_FIELD, NEXT_TOKEN_FIELD));
    private final List<BusinessReportSchedule> businessReportSchedules;
    private final String nextToken;

    private ListBusinessReportSchedulesResponse(BuilderImpl builder) {
        super(builder);
        this.businessReportSchedules = builder.businessReportSchedules;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasBusinessReportSchedules() {
        return this.businessReportSchedules != null && !(this.businessReportSchedules instanceof SdkAutoConstructList);
    }

    public final List<BusinessReportSchedule> businessReportSchedules() {
        return this.businessReportSchedules;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasBusinessReportSchedules() ? this.businessReportSchedules() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListBusinessReportSchedulesResponse)) {
            return false;
        }
        ListBusinessReportSchedulesResponse other = (ListBusinessReportSchedulesResponse)((Object)obj);
        return this.hasBusinessReportSchedules() == other.hasBusinessReportSchedules() && Objects.equals(this.businessReportSchedules(), other.businessReportSchedules()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListBusinessReportSchedulesResponse").add("BusinessReportSchedules", this.hasBusinessReportSchedules() ? this.businessReportSchedules() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "BusinessReportSchedules": {
                return Optional.ofNullable(clazz.cast(this.businessReportSchedules()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListBusinessReportSchedulesResponse, T> g) {
        return obj -> g.apply((ListBusinessReportSchedulesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends AlexaForBusinessResponse.BuilderImpl
    implements Builder {
        private List<BusinessReportSchedule> businessReportSchedules = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListBusinessReportSchedulesResponse model) {
            super(model);
            this.businessReportSchedules(model.businessReportSchedules);
            this.nextToken(model.nextToken);
        }

        public final Collection<BusinessReportSchedule.Builder> getBusinessReportSchedules() {
            if (this.businessReportSchedules instanceof SdkAutoConstructList) {
                return null;
            }
            return this.businessReportSchedules != null ? (Collection)this.businessReportSchedules.stream().map(BusinessReportSchedule::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder businessReportSchedules(Collection<BusinessReportSchedule> businessReportSchedules) {
            this.businessReportSchedules = BusinessReportScheduleListCopier.copy(businessReportSchedules);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder businessReportSchedules(BusinessReportSchedule ... businessReportSchedules) {
            this.businessReportSchedules(Arrays.asList(businessReportSchedules));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder businessReportSchedules(Consumer<BusinessReportSchedule.Builder> ... businessReportSchedules) {
            this.businessReportSchedules(Stream.of(businessReportSchedules).map(c -> (BusinessReportSchedule)((BusinessReportSchedule.Builder)BusinessReportSchedule.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setBusinessReportSchedules(Collection<BusinessReportSchedule.BuilderImpl> businessReportSchedules) {
            this.businessReportSchedules = BusinessReportScheduleListCopier.copyFromBuilder(businessReportSchedules);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListBusinessReportSchedulesResponse build() {
            return new ListBusinessReportSchedulesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends AlexaForBusinessResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListBusinessReportSchedulesResponse> {
        public Builder businessReportSchedules(Collection<BusinessReportSchedule> var1);

        public Builder businessReportSchedules(BusinessReportSchedule ... var1);

        public Builder businessReportSchedules(Consumer<BusinessReportSchedule.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

