/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.alexaforbusiness.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.alexaforbusiness.model.AlexaForBusinessResponse;
import software.amazon.awssdk.services.alexaforbusiness.model.SkillsStoreSkill;
import software.amazon.awssdk.services.alexaforbusiness.model.SkillsStoreSkillListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListSkillsStoreSkillsByCategoryResponse
extends AlexaForBusinessResponse
implements ToCopyableBuilder<Builder, ListSkillsStoreSkillsByCategoryResponse> {
    private static final SdkField<List<SkillsStoreSkill>> SKILLS_STORE_SKILLS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("SkillsStoreSkills").getter(ListSkillsStoreSkillsByCategoryResponse.getter(ListSkillsStoreSkillsByCategoryResponse::skillsStoreSkills)).setter(ListSkillsStoreSkillsByCategoryResponse.setter(Builder::skillsStoreSkills)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SkillsStoreSkills").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(SkillsStoreSkill::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListSkillsStoreSkillsByCategoryResponse.getter(ListSkillsStoreSkillsByCategoryResponse::nextToken)).setter(ListSkillsStoreSkillsByCategoryResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SKILLS_STORE_SKILLS_FIELD, NEXT_TOKEN_FIELD));
    private final List<SkillsStoreSkill> skillsStoreSkills;
    private final String nextToken;

    private ListSkillsStoreSkillsByCategoryResponse(BuilderImpl builder) {
        super(builder);
        this.skillsStoreSkills = builder.skillsStoreSkills;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasSkillsStoreSkills() {
        return this.skillsStoreSkills != null && !(this.skillsStoreSkills instanceof SdkAutoConstructList);
    }

    public final List<SkillsStoreSkill> skillsStoreSkills() {
        return this.skillsStoreSkills;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSkillsStoreSkills() ? this.skillsStoreSkills() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListSkillsStoreSkillsByCategoryResponse)) {
            return false;
        }
        ListSkillsStoreSkillsByCategoryResponse other = (ListSkillsStoreSkillsByCategoryResponse)((Object)obj);
        return this.hasSkillsStoreSkills() == other.hasSkillsStoreSkills() && Objects.equals(this.skillsStoreSkills(), other.skillsStoreSkills()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListSkillsStoreSkillsByCategoryResponse").add("SkillsStoreSkills", this.hasSkillsStoreSkills() ? this.skillsStoreSkills() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "SkillsStoreSkills": {
                return Optional.ofNullable(clazz.cast(this.skillsStoreSkills()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListSkillsStoreSkillsByCategoryResponse, T> g) {
        return obj -> g.apply((ListSkillsStoreSkillsByCategoryResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends AlexaForBusinessResponse.BuilderImpl
    implements Builder {
        private List<SkillsStoreSkill> skillsStoreSkills = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListSkillsStoreSkillsByCategoryResponse model) {
            super(model);
            this.skillsStoreSkills(model.skillsStoreSkills);
            this.nextToken(model.nextToken);
        }

        public final Collection<SkillsStoreSkill.Builder> getSkillsStoreSkills() {
            if (this.skillsStoreSkills instanceof SdkAutoConstructList) {
                return null;
            }
            return this.skillsStoreSkills != null ? (Collection)this.skillsStoreSkills.stream().map(SkillsStoreSkill::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder skillsStoreSkills(Collection<SkillsStoreSkill> skillsStoreSkills) {
            this.skillsStoreSkills = SkillsStoreSkillListCopier.copy(skillsStoreSkills);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder skillsStoreSkills(SkillsStoreSkill ... skillsStoreSkills) {
            this.skillsStoreSkills(Arrays.asList(skillsStoreSkills));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder skillsStoreSkills(Consumer<SkillsStoreSkill.Builder> ... skillsStoreSkills) {
            this.skillsStoreSkills(Stream.of(skillsStoreSkills).map(c -> (SkillsStoreSkill)((SkillsStoreSkill.Builder)SkillsStoreSkill.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setSkillsStoreSkills(Collection<SkillsStoreSkill.BuilderImpl> skillsStoreSkills) {
            this.skillsStoreSkills = SkillsStoreSkillListCopier.copyFromBuilder(skillsStoreSkills);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListSkillsStoreSkillsByCategoryResponse build() {
            return new ListSkillsStoreSkillsByCategoryResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends AlexaForBusinessResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListSkillsStoreSkillsByCategoryResponse> {
        public Builder skillsStoreSkills(Collection<SkillsStoreSkill> var1);

        public Builder skillsStoreSkills(SkillsStoreSkill ... var1);

        public Builder skillsStoreSkills(Consumer<SkillsStoreSkill.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

