/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.alexaforbusiness.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.alexaforbusiness.model.AlexaForBusinessResponse;
import software.amazon.awssdk.services.alexaforbusiness.model.SmartHomeAppliance;
import software.amazon.awssdk.services.alexaforbusiness.model.SmartHomeApplianceListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListSmartHomeAppliancesResponse
extends AlexaForBusinessResponse
implements ToCopyableBuilder<Builder, ListSmartHomeAppliancesResponse> {
    private static final SdkField<List<SmartHomeAppliance>> SMART_HOME_APPLIANCES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("SmartHomeAppliances").getter(ListSmartHomeAppliancesResponse.getter(ListSmartHomeAppliancesResponse::smartHomeAppliances)).setter(ListSmartHomeAppliancesResponse.setter(Builder::smartHomeAppliances)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SmartHomeAppliances").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(SmartHomeAppliance::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListSmartHomeAppliancesResponse.getter(ListSmartHomeAppliancesResponse::nextToken)).setter(ListSmartHomeAppliancesResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SMART_HOME_APPLIANCES_FIELD, NEXT_TOKEN_FIELD));
    private final List<SmartHomeAppliance> smartHomeAppliances;
    private final String nextToken;

    private ListSmartHomeAppliancesResponse(BuilderImpl builder) {
        super(builder);
        this.smartHomeAppliances = builder.smartHomeAppliances;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasSmartHomeAppliances() {
        return this.smartHomeAppliances != null && !(this.smartHomeAppliances instanceof SdkAutoConstructList);
    }

    public final List<SmartHomeAppliance> smartHomeAppliances() {
        return this.smartHomeAppliances;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSmartHomeAppliances() ? this.smartHomeAppliances() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListSmartHomeAppliancesResponse)) {
            return false;
        }
        ListSmartHomeAppliancesResponse other = (ListSmartHomeAppliancesResponse)((Object)obj);
        return this.hasSmartHomeAppliances() == other.hasSmartHomeAppliances() && Objects.equals(this.smartHomeAppliances(), other.smartHomeAppliances()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListSmartHomeAppliancesResponse").add("SmartHomeAppliances", this.hasSmartHomeAppliances() ? this.smartHomeAppliances() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "SmartHomeAppliances": {
                return Optional.ofNullable(clazz.cast(this.smartHomeAppliances()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListSmartHomeAppliancesResponse, T> g) {
        return obj -> g.apply((ListSmartHomeAppliancesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends AlexaForBusinessResponse.BuilderImpl
    implements Builder {
        private List<SmartHomeAppliance> smartHomeAppliances = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListSmartHomeAppliancesResponse model) {
            super(model);
            this.smartHomeAppliances(model.smartHomeAppliances);
            this.nextToken(model.nextToken);
        }

        public final Collection<SmartHomeAppliance.Builder> getSmartHomeAppliances() {
            if (this.smartHomeAppliances instanceof SdkAutoConstructList) {
                return null;
            }
            return this.smartHomeAppliances != null ? (Collection)this.smartHomeAppliances.stream().map(SmartHomeAppliance::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder smartHomeAppliances(Collection<SmartHomeAppliance> smartHomeAppliances) {
            this.smartHomeAppliances = SmartHomeApplianceListCopier.copy(smartHomeAppliances);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder smartHomeAppliances(SmartHomeAppliance ... smartHomeAppliances) {
            this.smartHomeAppliances(Arrays.asList(smartHomeAppliances));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder smartHomeAppliances(Consumer<SmartHomeAppliance.Builder> ... smartHomeAppliances) {
            this.smartHomeAppliances(Stream.of(smartHomeAppliances).map(c -> (SmartHomeAppliance)((SmartHomeAppliance.Builder)SmartHomeAppliance.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setSmartHomeAppliances(Collection<SmartHomeAppliance.BuilderImpl> smartHomeAppliances) {
            this.smartHomeAppliances = SmartHomeApplianceListCopier.copyFromBuilder(smartHomeAppliances);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListSmartHomeAppliancesResponse build() {
            return new ListSmartHomeAppliancesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends AlexaForBusinessResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListSmartHomeAppliancesResponse> {
        public Builder smartHomeAppliances(Collection<SmartHomeAppliance> var1);

        public Builder smartHomeAppliances(SmartHomeAppliance ... var1);

        public Builder smartHomeAppliances(Consumer<SmartHomeAppliance.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

