/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.alexaforbusiness.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateSkillGroupRequest extends AlexaForBusinessRequest implements
        ToCopyableBuilder<UpdateSkillGroupRequest.Builder, UpdateSkillGroupRequest> {
    private static final SdkField<String> SKILL_GROUP_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SkillGroupArn").getter(getter(UpdateSkillGroupRequest::skillGroupArn))
            .setter(setter(Builder::skillGroupArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SkillGroupArn").build()).build();

    private static final SdkField<String> SKILL_GROUP_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SkillGroupName").getter(getter(UpdateSkillGroupRequest::skillGroupName))
            .setter(setter(Builder::skillGroupName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SkillGroupName").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(UpdateSkillGroupRequest::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SKILL_GROUP_ARN_FIELD,
            SKILL_GROUP_NAME_FIELD, DESCRIPTION_FIELD));

    private final String skillGroupArn;

    private final String skillGroupName;

    private final String description;

    private UpdateSkillGroupRequest(BuilderImpl builder) {
        super(builder);
        this.skillGroupArn = builder.skillGroupArn;
        this.skillGroupName = builder.skillGroupName;
        this.description = builder.description;
    }

    /**
     * <p>
     * The ARN of the skill group to update.
     * </p>
     * 
     * @return The ARN of the skill group to update.
     */
    public final String skillGroupArn() {
        return skillGroupArn;
    }

    /**
     * <p>
     * The updated name for the skill group.
     * </p>
     * 
     * @return The updated name for the skill group.
     */
    public final String skillGroupName() {
        return skillGroupName;
    }

    /**
     * <p>
     * The updated description for the skill group.
     * </p>
     * 
     * @return The updated description for the skill group.
     */
    public final String description() {
        return description;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(skillGroupArn());
        hashCode = 31 * hashCode + Objects.hashCode(skillGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateSkillGroupRequest)) {
            return false;
        }
        UpdateSkillGroupRequest other = (UpdateSkillGroupRequest) obj;
        return Objects.equals(skillGroupArn(), other.skillGroupArn()) && Objects.equals(skillGroupName(), other.skillGroupName())
                && Objects.equals(description(), other.description());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateSkillGroupRequest").add("SkillGroupArn", skillGroupArn())
                .add("SkillGroupName", skillGroupName()).add("Description", description()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SkillGroupArn":
            return Optional.ofNullable(clazz.cast(skillGroupArn()));
        case "SkillGroupName":
            return Optional.ofNullable(clazz.cast(skillGroupName()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateSkillGroupRequest, T> g) {
        return obj -> g.apply((UpdateSkillGroupRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends AlexaForBusinessRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateSkillGroupRequest> {
        /**
         * <p>
         * The ARN of the skill group to update.
         * </p>
         * 
         * @param skillGroupArn
         *        The ARN of the skill group to update.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder skillGroupArn(String skillGroupArn);

        /**
         * <p>
         * The updated name for the skill group.
         * </p>
         * 
         * @param skillGroupName
         *        The updated name for the skill group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder skillGroupName(String skillGroupName);

        /**
         * <p>
         * The updated description for the skill group.
         * </p>
         * 
         * @param description
         *        The updated description for the skill group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends AlexaForBusinessRequest.BuilderImpl implements Builder {
        private String skillGroupArn;

        private String skillGroupName;

        private String description;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateSkillGroupRequest model) {
            super(model);
            skillGroupArn(model.skillGroupArn);
            skillGroupName(model.skillGroupName);
            description(model.description);
        }

        public final String getSkillGroupArn() {
            return skillGroupArn;
        }

        @Override
        public final Builder skillGroupArn(String skillGroupArn) {
            this.skillGroupArn = skillGroupArn;
            return this;
        }

        public final void setSkillGroupArn(String skillGroupArn) {
            this.skillGroupArn = skillGroupArn;
        }

        public final String getSkillGroupName() {
            return skillGroupName;
        }

        @Override
        public final Builder skillGroupName(String skillGroupName) {
            this.skillGroupName = skillGroupName;
            return this;
        }

        public final void setSkillGroupName(String skillGroupName) {
            this.skillGroupName = skillGroupName;
        }

        public final String getDescription() {
            return description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateSkillGroupRequest build() {
            return new UpdateSkillGroupRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
