/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.alexaforbusiness.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DeleteProfileRequest extends AlexaForBusinessRequest implements
        ToCopyableBuilder<DeleteProfileRequest.Builder, DeleteProfileRequest> {
    private static final SdkField<String> PROFILE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ProfileArn").getter(getter(DeleteProfileRequest::profileArn)).setter(setter(Builder::profileArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProfileArn").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PROFILE_ARN_FIELD));

    private final String profileArn;

    private DeleteProfileRequest(BuilderImpl builder) {
        super(builder);
        this.profileArn = builder.profileArn;
    }

    /**
     * <p>
     * The ARN of the room profile to delete. Required.
     * </p>
     * 
     * @return The ARN of the room profile to delete. Required.
     */
    public final String profileArn() {
        return profileArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(profileArn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteProfileRequest)) {
            return false;
        }
        DeleteProfileRequest other = (DeleteProfileRequest) obj;
        return Objects.equals(profileArn(), other.profileArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DeleteProfileRequest").add("ProfileArn", profileArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ProfileArn":
            return Optional.ofNullable(clazz.cast(profileArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DeleteProfileRequest, T> g) {
        return obj -> g.apply((DeleteProfileRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends AlexaForBusinessRequest.Builder, SdkPojo, CopyableBuilder<Builder, DeleteProfileRequest> {
        /**
         * <p>
         * The ARN of the room profile to delete. Required.
         * </p>
         * 
         * @param profileArn
         *        The ARN of the room profile to delete. Required.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder profileArn(String profileArn);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends AlexaForBusinessRequest.BuilderImpl implements Builder {
        private String profileArn;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteProfileRequest model) {
            super(model);
            profileArn(model.profileArn);
        }

        public final String getProfileArn() {
            return profileArn;
        }

        @Override
        public final Builder profileArn(String profileArn) {
            this.profileArn = profileArn;
            return this;
        }

        public final void setProfileArn(String profileArn) {
            this.profileArn = profileArn;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DeleteProfileRequest build() {
            return new DeleteProfileRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
