/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.alexaforbusiness.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Granular information about the skill.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SkillDetails implements SdkPojo, Serializable, ToCopyableBuilder<SkillDetails.Builder, SkillDetails> {
    private static final SdkField<String> PRODUCT_DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ProductDescription").getter(getter(SkillDetails::productDescription))
            .setter(setter(Builder::productDescription))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProductDescription").build())
            .build();

    private static final SdkField<String> INVOCATION_PHRASE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("InvocationPhrase").getter(getter(SkillDetails::invocationPhrase))
            .setter(setter(Builder::invocationPhrase))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InvocationPhrase").build()).build();

    private static final SdkField<String> RELEASE_DATE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ReleaseDate").getter(getter(SkillDetails::releaseDate)).setter(setter(Builder::releaseDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReleaseDate").build()).build();

    private static final SdkField<String> END_USER_LICENSE_AGREEMENT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EndUserLicenseAgreement").getter(getter(SkillDetails::endUserLicenseAgreement))
            .setter(setter(Builder::endUserLicenseAgreement))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndUserLicenseAgreement").build())
            .build();

    private static final SdkField<List<String>> GENERIC_KEYWORDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("GenericKeywords")
            .getter(getter(SkillDetails::genericKeywords))
            .setter(setter(Builder::genericKeywords))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GenericKeywords").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> BULLET_POINTS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("BulletPoints")
            .getter(getter(SkillDetails::bulletPoints))
            .setter(setter(Builder::bulletPoints))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BulletPoints").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> NEW_IN_THIS_VERSION_BULLET_POINTS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("NewInThisVersionBulletPoints")
            .getter(getter(SkillDetails::newInThisVersionBulletPoints))
            .setter(setter(Builder::newInThisVersionBulletPoints))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NewInThisVersionBulletPoints")
                    .build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> SKILL_TYPES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("SkillTypes")
            .getter(getter(SkillDetails::skillTypes))
            .setter(setter(Builder::skillTypes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SkillTypes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Map<String, String>> REVIEWS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("Reviews")
            .getter(getter(SkillDetails::reviews))
            .setter(setter(Builder::reviews))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Reviews").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<DeveloperInfo> DEVELOPER_INFO_FIELD = SdkField
            .<DeveloperInfo> builder(MarshallingType.SDK_POJO).memberName("DeveloperInfo")
            .getter(getter(SkillDetails::developerInfo)).setter(setter(Builder::developerInfo))
            .constructor(DeveloperInfo::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeveloperInfo").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections
            .unmodifiableList(Arrays.asList(PRODUCT_DESCRIPTION_FIELD, INVOCATION_PHRASE_FIELD, RELEASE_DATE_FIELD,
                    END_USER_LICENSE_AGREEMENT_FIELD, GENERIC_KEYWORDS_FIELD, BULLET_POINTS_FIELD,
                    NEW_IN_THIS_VERSION_BULLET_POINTS_FIELD, SKILL_TYPES_FIELD, REVIEWS_FIELD, DEVELOPER_INFO_FIELD));

    private static final long serialVersionUID = 1L;

    private final String productDescription;

    private final String invocationPhrase;

    private final String releaseDate;

    private final String endUserLicenseAgreement;

    private final List<String> genericKeywords;

    private final List<String> bulletPoints;

    private final List<String> newInThisVersionBulletPoints;

    private final List<String> skillTypes;

    private final Map<String, String> reviews;

    private final DeveloperInfo developerInfo;

    private SkillDetails(BuilderImpl builder) {
        this.productDescription = builder.productDescription;
        this.invocationPhrase = builder.invocationPhrase;
        this.releaseDate = builder.releaseDate;
        this.endUserLicenseAgreement = builder.endUserLicenseAgreement;
        this.genericKeywords = builder.genericKeywords;
        this.bulletPoints = builder.bulletPoints;
        this.newInThisVersionBulletPoints = builder.newInThisVersionBulletPoints;
        this.skillTypes = builder.skillTypes;
        this.reviews = builder.reviews;
        this.developerInfo = builder.developerInfo;
    }

    /**
     * <p>
     * The description of the product.
     * </p>
     * 
     * @return The description of the product.
     */
    public final String productDescription() {
        return productDescription;
    }

    /**
     * <p>
     * The phrase used to trigger the skill.
     * </p>
     * 
     * @return The phrase used to trigger the skill.
     */
    public final String invocationPhrase() {
        return invocationPhrase;
    }

    /**
     * <p>
     * The date when the skill was released.
     * </p>
     * 
     * @return The date when the skill was released.
     */
    public final String releaseDate() {
        return releaseDate;
    }

    /**
     * <p>
     * The URL of the end user license agreement.
     * </p>
     * 
     * @return The URL of the end user license agreement.
     */
    public final String endUserLicenseAgreement() {
        return endUserLicenseAgreement;
    }

    /**
     * Returns true if the GenericKeywords property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public final boolean hasGenericKeywords() {
        return genericKeywords != null && !(genericKeywords instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The generic keywords associated with the skill that can be used to find a skill.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasGenericKeywords()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The generic keywords associated with the skill that can be used to find a skill.
     */
    public final List<String> genericKeywords() {
        return genericKeywords;
    }

    /**
     * Returns true if the BulletPoints property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasBulletPoints() {
        return bulletPoints != null && !(bulletPoints instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The details about what the skill supports organized as bullet points.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasBulletPoints()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The details about what the skill supports organized as bullet points.
     */
    public final List<String> bulletPoints() {
        return bulletPoints;
    }

    /**
     * Returns true if the NewInThisVersionBulletPoints property was specified by the sender (it may be empty), or false
     * if the sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the
     * AWS service.
     */
    public final boolean hasNewInThisVersionBulletPoints() {
        return newInThisVersionBulletPoints != null && !(newInThisVersionBulletPoints instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The updates added in bullet points.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasNewInThisVersionBulletPoints()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The updates added in bullet points.
     */
    public final List<String> newInThisVersionBulletPoints() {
        return newInThisVersionBulletPoints;
    }

    /**
     * Returns true if the SkillTypes property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasSkillTypes() {
        return skillTypes != null && !(skillTypes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The types of skills.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasSkillTypes()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The types of skills.
     */
    public final List<String> skillTypes() {
        return skillTypes;
    }

    /**
     * Returns true if the Reviews property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasReviews() {
        return reviews != null && !(reviews instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * <i>This member has been deprecated.</i>
     * </p>
     * <p>
     * The list of reviews for the skill, including Key and Value pair.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasReviews()} to see if a value was sent in this field.
     * </p>
     * 
     * @return <i>This member has been deprecated.</i> </p>
     *         <p>
     *         The list of reviews for the skill, including Key and Value pair.
     */
    public final Map<String, String> reviews() {
        return reviews;
    }

    /**
     * <p>
     * The details about the developer that published the skill.
     * </p>
     * 
     * @return The details about the developer that published the skill.
     */
    public final DeveloperInfo developerInfo() {
        return developerInfo;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(productDescription());
        hashCode = 31 * hashCode + Objects.hashCode(invocationPhrase());
        hashCode = 31 * hashCode + Objects.hashCode(releaseDate());
        hashCode = 31 * hashCode + Objects.hashCode(endUserLicenseAgreement());
        hashCode = 31 * hashCode + Objects.hashCode(hasGenericKeywords() ? genericKeywords() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasBulletPoints() ? bulletPoints() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasNewInThisVersionBulletPoints() ? newInThisVersionBulletPoints() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasSkillTypes() ? skillTypes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasReviews() ? reviews() : null);
        hashCode = 31 * hashCode + Objects.hashCode(developerInfo());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SkillDetails)) {
            return false;
        }
        SkillDetails other = (SkillDetails) obj;
        return Objects.equals(productDescription(), other.productDescription())
                && Objects.equals(invocationPhrase(), other.invocationPhrase())
                && Objects.equals(releaseDate(), other.releaseDate())
                && Objects.equals(endUserLicenseAgreement(), other.endUserLicenseAgreement())
                && hasGenericKeywords() == other.hasGenericKeywords()
                && Objects.equals(genericKeywords(), other.genericKeywords()) && hasBulletPoints() == other.hasBulletPoints()
                && Objects.equals(bulletPoints(), other.bulletPoints())
                && hasNewInThisVersionBulletPoints() == other.hasNewInThisVersionBulletPoints()
                && Objects.equals(newInThisVersionBulletPoints(), other.newInThisVersionBulletPoints())
                && hasSkillTypes() == other.hasSkillTypes() && Objects.equals(skillTypes(), other.skillTypes())
                && hasReviews() == other.hasReviews() && Objects.equals(reviews(), other.reviews())
                && Objects.equals(developerInfo(), other.developerInfo());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SkillDetails").add("ProductDescription", productDescription())
                .add("InvocationPhrase", invocationPhrase()).add("ReleaseDate", releaseDate())
                .add("EndUserLicenseAgreement", endUserLicenseAgreement())
                .add("GenericKeywords", hasGenericKeywords() ? genericKeywords() : null)
                .add("BulletPoints", hasBulletPoints() ? bulletPoints() : null)
                .add("NewInThisVersionBulletPoints", hasNewInThisVersionBulletPoints() ? newInThisVersionBulletPoints() : null)
                .add("SkillTypes", hasSkillTypes() ? skillTypes() : null).add("Reviews", hasReviews() ? reviews() : null)
                .add("DeveloperInfo", developerInfo()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ProductDescription":
            return Optional.ofNullable(clazz.cast(productDescription()));
        case "InvocationPhrase":
            return Optional.ofNullable(clazz.cast(invocationPhrase()));
        case "ReleaseDate":
            return Optional.ofNullable(clazz.cast(releaseDate()));
        case "EndUserLicenseAgreement":
            return Optional.ofNullable(clazz.cast(endUserLicenseAgreement()));
        case "GenericKeywords":
            return Optional.ofNullable(clazz.cast(genericKeywords()));
        case "BulletPoints":
            return Optional.ofNullable(clazz.cast(bulletPoints()));
        case "NewInThisVersionBulletPoints":
            return Optional.ofNullable(clazz.cast(newInThisVersionBulletPoints()));
        case "SkillTypes":
            return Optional.ofNullable(clazz.cast(skillTypes()));
        case "Reviews":
            return Optional.ofNullable(clazz.cast(reviews()));
        case "DeveloperInfo":
            return Optional.ofNullable(clazz.cast(developerInfo()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SkillDetails, T> g) {
        return obj -> g.apply((SkillDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SkillDetails> {
        /**
         * <p>
         * The description of the product.
         * </p>
         * 
         * @param productDescription
         *        The description of the product.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder productDescription(String productDescription);

        /**
         * <p>
         * The phrase used to trigger the skill.
         * </p>
         * 
         * @param invocationPhrase
         *        The phrase used to trigger the skill.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder invocationPhrase(String invocationPhrase);

        /**
         * <p>
         * The date when the skill was released.
         * </p>
         * 
         * @param releaseDate
         *        The date when the skill was released.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder releaseDate(String releaseDate);

        /**
         * <p>
         * The URL of the end user license agreement.
         * </p>
         * 
         * @param endUserLicenseAgreement
         *        The URL of the end user license agreement.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endUserLicenseAgreement(String endUserLicenseAgreement);

        /**
         * <p>
         * The generic keywords associated with the skill that can be used to find a skill.
         * </p>
         * 
         * @param genericKeywords
         *        The generic keywords associated with the skill that can be used to find a skill.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder genericKeywords(Collection<String> genericKeywords);

        /**
         * <p>
         * The generic keywords associated with the skill that can be used to find a skill.
         * </p>
         * 
         * @param genericKeywords
         *        The generic keywords associated with the skill that can be used to find a skill.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder genericKeywords(String... genericKeywords);

        /**
         * <p>
         * The details about what the skill supports organized as bullet points.
         * </p>
         * 
         * @param bulletPoints
         *        The details about what the skill supports organized as bullet points.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder bulletPoints(Collection<String> bulletPoints);

        /**
         * <p>
         * The details about what the skill supports organized as bullet points.
         * </p>
         * 
         * @param bulletPoints
         *        The details about what the skill supports organized as bullet points.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder bulletPoints(String... bulletPoints);

        /**
         * <p>
         * The updates added in bullet points.
         * </p>
         * 
         * @param newInThisVersionBulletPoints
         *        The updates added in bullet points.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder newInThisVersionBulletPoints(Collection<String> newInThisVersionBulletPoints);

        /**
         * <p>
         * The updates added in bullet points.
         * </p>
         * 
         * @param newInThisVersionBulletPoints
         *        The updates added in bullet points.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder newInThisVersionBulletPoints(String... newInThisVersionBulletPoints);

        /**
         * <p>
         * The types of skills.
         * </p>
         * 
         * @param skillTypes
         *        The types of skills.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder skillTypes(Collection<String> skillTypes);

        /**
         * <p>
         * The types of skills.
         * </p>
         * 
         * @param skillTypes
         *        The types of skills.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder skillTypes(String... skillTypes);

        /**
         * <p>
         * <i>This member has been deprecated.</i>
         * </p>
         * <p>
         * The list of reviews for the skill, including Key and Value pair.
         * </p>
         * 
         * @param reviews
         *        <i>This member has been deprecated.</i> </p>
         *        <p>
         *        The list of reviews for the skill, including Key and Value pair.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder reviews(Map<String, String> reviews);

        /**
         * <p>
         * The details about the developer that published the skill.
         * </p>
         * 
         * @param developerInfo
         *        The details about the developer that published the skill.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder developerInfo(DeveloperInfo developerInfo);

        /**
         * <p>
         * The details about the developer that published the skill.
         * </p>
         * This is a convenience that creates an instance of the {@link DeveloperInfo.Builder} avoiding the need to
         * create one manually via {@link DeveloperInfo#builder()}.
         *
         * When the {@link Consumer} completes, {@link DeveloperInfo.Builder#build()} is called immediately and its
         * result is passed to {@link #developerInfo(DeveloperInfo)}.
         * 
         * @param developerInfo
         *        a consumer that will call methods on {@link DeveloperInfo.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #developerInfo(DeveloperInfo)
         */
        default Builder developerInfo(Consumer<DeveloperInfo.Builder> developerInfo) {
            return developerInfo(DeveloperInfo.builder().applyMutation(developerInfo).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String productDescription;

        private String invocationPhrase;

        private String releaseDate;

        private String endUserLicenseAgreement;

        private List<String> genericKeywords = DefaultSdkAutoConstructList.getInstance();

        private List<String> bulletPoints = DefaultSdkAutoConstructList.getInstance();

        private List<String> newInThisVersionBulletPoints = DefaultSdkAutoConstructList.getInstance();

        private List<String> skillTypes = DefaultSdkAutoConstructList.getInstance();

        private Map<String, String> reviews = DefaultSdkAutoConstructMap.getInstance();

        private DeveloperInfo developerInfo;

        private BuilderImpl() {
        }

        private BuilderImpl(SkillDetails model) {
            productDescription(model.productDescription);
            invocationPhrase(model.invocationPhrase);
            releaseDate(model.releaseDate);
            endUserLicenseAgreement(model.endUserLicenseAgreement);
            genericKeywords(model.genericKeywords);
            bulletPoints(model.bulletPoints);
            newInThisVersionBulletPoints(model.newInThisVersionBulletPoints);
            skillTypes(model.skillTypes);
            reviews(model.reviews);
            developerInfo(model.developerInfo);
        }

        public final String getProductDescription() {
            return productDescription;
        }

        @Override
        public final Builder productDescription(String productDescription) {
            this.productDescription = productDescription;
            return this;
        }

        public final void setProductDescription(String productDescription) {
            this.productDescription = productDescription;
        }

        public final String getInvocationPhrase() {
            return invocationPhrase;
        }

        @Override
        public final Builder invocationPhrase(String invocationPhrase) {
            this.invocationPhrase = invocationPhrase;
            return this;
        }

        public final void setInvocationPhrase(String invocationPhrase) {
            this.invocationPhrase = invocationPhrase;
        }

        public final String getReleaseDate() {
            return releaseDate;
        }

        @Override
        public final Builder releaseDate(String releaseDate) {
            this.releaseDate = releaseDate;
            return this;
        }

        public final void setReleaseDate(String releaseDate) {
            this.releaseDate = releaseDate;
        }

        public final String getEndUserLicenseAgreement() {
            return endUserLicenseAgreement;
        }

        @Override
        public final Builder endUserLicenseAgreement(String endUserLicenseAgreement) {
            this.endUserLicenseAgreement = endUserLicenseAgreement;
            return this;
        }

        public final void setEndUserLicenseAgreement(String endUserLicenseAgreement) {
            this.endUserLicenseAgreement = endUserLicenseAgreement;
        }

        public final Collection<String> getGenericKeywords() {
            if (genericKeywords instanceof SdkAutoConstructList) {
                return null;
            }
            return genericKeywords;
        }

        @Override
        public final Builder genericKeywords(Collection<String> genericKeywords) {
            this.genericKeywords = GenericKeywordsCopier.copy(genericKeywords);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder genericKeywords(String... genericKeywords) {
            genericKeywords(Arrays.asList(genericKeywords));
            return this;
        }

        public final void setGenericKeywords(Collection<String> genericKeywords) {
            this.genericKeywords = GenericKeywordsCopier.copy(genericKeywords);
        }

        public final Collection<String> getBulletPoints() {
            if (bulletPoints instanceof SdkAutoConstructList) {
                return null;
            }
            return bulletPoints;
        }

        @Override
        public final Builder bulletPoints(Collection<String> bulletPoints) {
            this.bulletPoints = BulletPointsCopier.copy(bulletPoints);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder bulletPoints(String... bulletPoints) {
            bulletPoints(Arrays.asList(bulletPoints));
            return this;
        }

        public final void setBulletPoints(Collection<String> bulletPoints) {
            this.bulletPoints = BulletPointsCopier.copy(bulletPoints);
        }

        public final Collection<String> getNewInThisVersionBulletPoints() {
            if (newInThisVersionBulletPoints instanceof SdkAutoConstructList) {
                return null;
            }
            return newInThisVersionBulletPoints;
        }

        @Override
        public final Builder newInThisVersionBulletPoints(Collection<String> newInThisVersionBulletPoints) {
            this.newInThisVersionBulletPoints = NewInThisVersionBulletPointsCopier.copy(newInThisVersionBulletPoints);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder newInThisVersionBulletPoints(String... newInThisVersionBulletPoints) {
            newInThisVersionBulletPoints(Arrays.asList(newInThisVersionBulletPoints));
            return this;
        }

        public final void setNewInThisVersionBulletPoints(Collection<String> newInThisVersionBulletPoints) {
            this.newInThisVersionBulletPoints = NewInThisVersionBulletPointsCopier.copy(newInThisVersionBulletPoints);
        }

        public final Collection<String> getSkillTypes() {
            if (skillTypes instanceof SdkAutoConstructList) {
                return null;
            }
            return skillTypes;
        }

        @Override
        public final Builder skillTypes(Collection<String> skillTypes) {
            this.skillTypes = SkillTypesCopier.copy(skillTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder skillTypes(String... skillTypes) {
            skillTypes(Arrays.asList(skillTypes));
            return this;
        }

        public final void setSkillTypes(Collection<String> skillTypes) {
            this.skillTypes = SkillTypesCopier.copy(skillTypes);
        }

        public final Map<String, String> getReviews() {
            if (reviews instanceof SdkAutoConstructMap) {
                return null;
            }
            return reviews;
        }

        @Override
        public final Builder reviews(Map<String, String> reviews) {
            this.reviews = ReviewsCopier.copy(reviews);
            return this;
        }

        public final void setReviews(Map<String, String> reviews) {
            this.reviews = ReviewsCopier.copy(reviews);
        }

        public final DeveloperInfo.Builder getDeveloperInfo() {
            return developerInfo != null ? developerInfo.toBuilder() : null;
        }

        @Override
        public final Builder developerInfo(DeveloperInfo developerInfo) {
            this.developerInfo = developerInfo;
            return this;
        }

        public final void setDeveloperInfo(DeveloperInfo.BuilderImpl developerInfo) {
            this.developerInfo = developerInfo != null ? developerInfo.build() : null;
        }

        @Override
        public SkillDetails build() {
            return new SkillDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
