/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.alexaforbusiness.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A skill parameter associated with a room.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RoomSkillParameter implements SdkPojo, Serializable,
        ToCopyableBuilder<RoomSkillParameter.Builder, RoomSkillParameter> {
    private static final SdkField<String> PARAMETER_KEY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ParameterKey").getter(getter(RoomSkillParameter::parameterKey)).setter(setter(Builder::parameterKey))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ParameterKey").build()).build();

    private static final SdkField<String> PARAMETER_VALUE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ParameterValue").getter(getter(RoomSkillParameter::parameterValue))
            .setter(setter(Builder::parameterValue))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ParameterValue").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PARAMETER_KEY_FIELD,
            PARAMETER_VALUE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String parameterKey;

    private final String parameterValue;

    private RoomSkillParameter(BuilderImpl builder) {
        this.parameterKey = builder.parameterKey;
        this.parameterValue = builder.parameterValue;
    }

    /**
     * <p>
     * The parameter key of a room skill parameter. ParameterKey is an enumerated type that only takes “DEFAULT” or
     * “SCOPE” as valid values.
     * </p>
     * 
     * @return The parameter key of a room skill parameter. ParameterKey is an enumerated type that only takes “DEFAULT”
     *         or “SCOPE” as valid values.
     */
    public String parameterKey() {
        return parameterKey;
    }

    /**
     * <p>
     * The parameter value of a room skill parameter.
     * </p>
     * 
     * @return The parameter value of a room skill parameter.
     */
    public String parameterValue() {
        return parameterValue;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(parameterKey());
        hashCode = 31 * hashCode + Objects.hashCode(parameterValue());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RoomSkillParameter)) {
            return false;
        }
        RoomSkillParameter other = (RoomSkillParameter) obj;
        return Objects.equals(parameterKey(), other.parameterKey()) && Objects.equals(parameterValue(), other.parameterValue());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("RoomSkillParameter").add("ParameterKey", parameterKey()).add("ParameterValue", parameterValue())
                .build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ParameterKey":
            return Optional.ofNullable(clazz.cast(parameterKey()));
        case "ParameterValue":
            return Optional.ofNullable(clazz.cast(parameterValue()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RoomSkillParameter, T> g) {
        return obj -> g.apply((RoomSkillParameter) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RoomSkillParameter> {
        /**
         * <p>
         * The parameter key of a room skill parameter. ParameterKey is an enumerated type that only takes “DEFAULT” or
         * “SCOPE” as valid values.
         * </p>
         * 
         * @param parameterKey
         *        The parameter key of a room skill parameter. ParameterKey is an enumerated type that only takes
         *        “DEFAULT” or “SCOPE” as valid values.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder parameterKey(String parameterKey);

        /**
         * <p>
         * The parameter value of a room skill parameter.
         * </p>
         * 
         * @param parameterValue
         *        The parameter value of a room skill parameter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder parameterValue(String parameterValue);
    }

    static final class BuilderImpl implements Builder {
        private String parameterKey;

        private String parameterValue;

        private BuilderImpl() {
        }

        private BuilderImpl(RoomSkillParameter model) {
            parameterKey(model.parameterKey);
            parameterValue(model.parameterValue);
        }

        public final String getParameterKey() {
            return parameterKey;
        }

        @Override
        public final Builder parameterKey(String parameterKey) {
            this.parameterKey = parameterKey;
            return this;
        }

        public final void setParameterKey(String parameterKey) {
            this.parameterKey = parameterKey;
        }

        public final String getParameterValue() {
            return parameterValue;
        }

        @Override
        public final Builder parameterValue(String parameterValue) {
            this.parameterValue = parameterValue;
            return this;
        }

        public final void setParameterValue(String parameterValue) {
            this.parameterValue = parameterValue;
        }

        @Override
        public RoomSkillParameter build() {
            return new RoomSkillParameter(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
