/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.alexaforbusiness.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.alexaforbusiness.model.AlexaForBusinessRequest;
import software.amazon.awssdk.services.alexaforbusiness.model.TrustAnchorListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateNetworkProfileRequest
extends AlexaForBusinessRequest
implements ToCopyableBuilder<Builder, UpdateNetworkProfileRequest> {
    private static final SdkField<String> NETWORK_PROFILE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NetworkProfileArn").getter(UpdateNetworkProfileRequest.getter(UpdateNetworkProfileRequest::networkProfileArn)).setter(UpdateNetworkProfileRequest.setter(Builder::networkProfileArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NetworkProfileArn").build()}).build();
    private static final SdkField<String> NETWORK_PROFILE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NetworkProfileName").getter(UpdateNetworkProfileRequest.getter(UpdateNetworkProfileRequest::networkProfileName)).setter(UpdateNetworkProfileRequest.setter(Builder::networkProfileName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NetworkProfileName").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(UpdateNetworkProfileRequest.getter(UpdateNetworkProfileRequest::description)).setter(UpdateNetworkProfileRequest.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<String> CURRENT_PASSWORD_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CurrentPassword").getter(UpdateNetworkProfileRequest.getter(UpdateNetworkProfileRequest::currentPassword)).setter(UpdateNetworkProfileRequest.setter(Builder::currentPassword)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CurrentPassword").build()}).build();
    private static final SdkField<String> NEXT_PASSWORD_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextPassword").getter(UpdateNetworkProfileRequest.getter(UpdateNetworkProfileRequest::nextPassword)).setter(UpdateNetworkProfileRequest.setter(Builder::nextPassword)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextPassword").build()}).build();
    private static final SdkField<String> CERTIFICATE_AUTHORITY_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CertificateAuthorityArn").getter(UpdateNetworkProfileRequest.getter(UpdateNetworkProfileRequest::certificateAuthorityArn)).setter(UpdateNetworkProfileRequest.setter(Builder::certificateAuthorityArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CertificateAuthorityArn").build()}).build();
    private static final SdkField<List<String>> TRUST_ANCHORS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("TrustAnchors").getter(UpdateNetworkProfileRequest.getter(UpdateNetworkProfileRequest::trustAnchors)).setter(UpdateNetworkProfileRequest.setter(Builder::trustAnchors)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TrustAnchors").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NETWORK_PROFILE_ARN_FIELD, NETWORK_PROFILE_NAME_FIELD, DESCRIPTION_FIELD, CURRENT_PASSWORD_FIELD, NEXT_PASSWORD_FIELD, CERTIFICATE_AUTHORITY_ARN_FIELD, TRUST_ANCHORS_FIELD));
    private final String networkProfileArn;
    private final String networkProfileName;
    private final String description;
    private final String currentPassword;
    private final String nextPassword;
    private final String certificateAuthorityArn;
    private final List<String> trustAnchors;

    private UpdateNetworkProfileRequest(BuilderImpl builder) {
        super(builder);
        this.networkProfileArn = builder.networkProfileArn;
        this.networkProfileName = builder.networkProfileName;
        this.description = builder.description;
        this.currentPassword = builder.currentPassword;
        this.nextPassword = builder.nextPassword;
        this.certificateAuthorityArn = builder.certificateAuthorityArn;
        this.trustAnchors = builder.trustAnchors;
    }

    public final String networkProfileArn() {
        return this.networkProfileArn;
    }

    public final String networkProfileName() {
        return this.networkProfileName;
    }

    public final String description() {
        return this.description;
    }

    public final String currentPassword() {
        return this.currentPassword;
    }

    public final String nextPassword() {
        return this.nextPassword;
    }

    public final String certificateAuthorityArn() {
        return this.certificateAuthorityArn;
    }

    public final boolean hasTrustAnchors() {
        return this.trustAnchors != null && !(this.trustAnchors instanceof SdkAutoConstructList);
    }

    public final List<String> trustAnchors() {
        return this.trustAnchors;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.networkProfileArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.networkProfileName());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.currentPassword());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextPassword());
        hashCode = 31 * hashCode + Objects.hashCode(this.certificateAuthorityArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTrustAnchors() ? this.trustAnchors() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateNetworkProfileRequest)) {
            return false;
        }
        UpdateNetworkProfileRequest other = (UpdateNetworkProfileRequest)((Object)obj);
        return Objects.equals(this.networkProfileArn(), other.networkProfileArn()) && Objects.equals(this.networkProfileName(), other.networkProfileName()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.currentPassword(), other.currentPassword()) && Objects.equals(this.nextPassword(), other.nextPassword()) && Objects.equals(this.certificateAuthorityArn(), other.certificateAuthorityArn()) && this.hasTrustAnchors() == other.hasTrustAnchors() && Objects.equals(this.trustAnchors(), other.trustAnchors());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateNetworkProfileRequest").add("NetworkProfileArn", (Object)this.networkProfileArn()).add("NetworkProfileName", (Object)this.networkProfileName()).add("Description", (Object)this.description()).add("CurrentPassword", (Object)(this.currentPassword() == null ? null : "*** Sensitive Data Redacted ***")).add("NextPassword", (Object)(this.nextPassword() == null ? null : "*** Sensitive Data Redacted ***")).add("CertificateAuthorityArn", (Object)this.certificateAuthorityArn()).add("TrustAnchors", this.hasTrustAnchors() ? this.trustAnchors() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "NetworkProfileArn": {
                return Optional.ofNullable(clazz.cast(this.networkProfileArn()));
            }
            case "NetworkProfileName": {
                return Optional.ofNullable(clazz.cast(this.networkProfileName()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "CurrentPassword": {
                return Optional.ofNullable(clazz.cast(this.currentPassword()));
            }
            case "NextPassword": {
                return Optional.ofNullable(clazz.cast(this.nextPassword()));
            }
            case "CertificateAuthorityArn": {
                return Optional.ofNullable(clazz.cast(this.certificateAuthorityArn()));
            }
            case "TrustAnchors": {
                return Optional.ofNullable(clazz.cast(this.trustAnchors()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateNetworkProfileRequest, T> g) {
        return obj -> g.apply((UpdateNetworkProfileRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends AlexaForBusinessRequest.BuilderImpl
    implements Builder {
        private String networkProfileArn;
        private String networkProfileName;
        private String description;
        private String currentPassword;
        private String nextPassword;
        private String certificateAuthorityArn;
        private List<String> trustAnchors = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateNetworkProfileRequest model) {
            super(model);
            this.networkProfileArn(model.networkProfileArn);
            this.networkProfileName(model.networkProfileName);
            this.description(model.description);
            this.currentPassword(model.currentPassword);
            this.nextPassword(model.nextPassword);
            this.certificateAuthorityArn(model.certificateAuthorityArn);
            this.trustAnchors(model.trustAnchors);
        }

        public final String getNetworkProfileArn() {
            return this.networkProfileArn;
        }

        @Override
        public final Builder networkProfileArn(String networkProfileArn) {
            this.networkProfileArn = networkProfileArn;
            return this;
        }

        public final void setNetworkProfileArn(String networkProfileArn) {
            this.networkProfileArn = networkProfileArn;
        }

        public final String getNetworkProfileName() {
            return this.networkProfileName;
        }

        @Override
        public final Builder networkProfileName(String networkProfileName) {
            this.networkProfileName = networkProfileName;
            return this;
        }

        public final void setNetworkProfileName(String networkProfileName) {
            this.networkProfileName = networkProfileName;
        }

        public final String getDescription() {
            return this.description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final String getCurrentPassword() {
            return this.currentPassword;
        }

        @Override
        public final Builder currentPassword(String currentPassword) {
            this.currentPassword = currentPassword;
            return this;
        }

        public final void setCurrentPassword(String currentPassword) {
            this.currentPassword = currentPassword;
        }

        public final String getNextPassword() {
            return this.nextPassword;
        }

        @Override
        public final Builder nextPassword(String nextPassword) {
            this.nextPassword = nextPassword;
            return this;
        }

        public final void setNextPassword(String nextPassword) {
            this.nextPassword = nextPassword;
        }

        public final String getCertificateAuthorityArn() {
            return this.certificateAuthorityArn;
        }

        @Override
        public final Builder certificateAuthorityArn(String certificateAuthorityArn) {
            this.certificateAuthorityArn = certificateAuthorityArn;
            return this;
        }

        public final void setCertificateAuthorityArn(String certificateAuthorityArn) {
            this.certificateAuthorityArn = certificateAuthorityArn;
        }

        public final Collection<String> getTrustAnchors() {
            if (this.trustAnchors instanceof SdkAutoConstructList) {
                return null;
            }
            return this.trustAnchors;
        }

        @Override
        public final Builder trustAnchors(Collection<String> trustAnchors) {
            this.trustAnchors = TrustAnchorListCopier.copy(trustAnchors);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder trustAnchors(String ... trustAnchors) {
            this.trustAnchors(Arrays.asList(trustAnchors));
            return this;
        }

        public final void setTrustAnchors(Collection<String> trustAnchors) {
            this.trustAnchors = TrustAnchorListCopier.copy(trustAnchors);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateNetworkProfileRequest build() {
            return new UpdateNetworkProfileRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends AlexaForBusinessRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateNetworkProfileRequest> {
        public Builder networkProfileArn(String var1);

        public Builder networkProfileName(String var1);

        public Builder description(String var1);

        public Builder currentPassword(String var1);

        public Builder nextPassword(String var1);

        public Builder certificateAuthorityArn(String var1);

        public Builder trustAnchors(Collection<String> var1);

        public Builder trustAnchors(String ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

