/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.alexaforbusiness.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum CommsProtocol {
    SIP("SIP"),
    SIPS("SIPS"),
    H323("H323"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private CommsProtocol(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static CommsProtocol fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(CommsProtocol.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<CommsProtocol> knownValues() {
        return Stream.of(CommsProtocol.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

