/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.alexaforbusiness.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.alexaforbusiness.model.Audio;
import software.amazon.awssdk.services.alexaforbusiness.model.AudioListCopier;
import software.amazon.awssdk.services.alexaforbusiness.model.Ssml;
import software.amazon.awssdk.services.alexaforbusiness.model.SsmlListCopier;
import software.amazon.awssdk.services.alexaforbusiness.model.Text;
import software.amazon.awssdk.services.alexaforbusiness.model.TextListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Content
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Content> {
    private static final SdkField<List<Text>> TEXT_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("TextList").getter(Content.getter(Content::textList)).setter(Content.setter(Builder::textList)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TextList").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Text::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<Ssml>> SSML_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("SsmlList").getter(Content.getter(Content::ssmlList)).setter(Content.setter(Builder::ssmlList)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SsmlList").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Ssml::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<Audio>> AUDIO_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("AudioList").getter(Content.getter(Content::audioList)).setter(Content.setter(Builder::audioList)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AudioList").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Audio::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TEXT_LIST_FIELD, SSML_LIST_FIELD, AUDIO_LIST_FIELD));
    private static final long serialVersionUID = 1L;
    private final List<Text> textList;
    private final List<Ssml> ssmlList;
    private final List<Audio> audioList;

    private Content(BuilderImpl builder) {
        this.textList = builder.textList;
        this.ssmlList = builder.ssmlList;
        this.audioList = builder.audioList;
    }

    public final boolean hasTextList() {
        return this.textList != null && !(this.textList instanceof SdkAutoConstructList);
    }

    public final List<Text> textList() {
        return this.textList;
    }

    public final boolean hasSsmlList() {
        return this.ssmlList != null && !(this.ssmlList instanceof SdkAutoConstructList);
    }

    public final List<Ssml> ssmlList() {
        return this.ssmlList;
    }

    public final boolean hasAudioList() {
        return this.audioList != null && !(this.audioList instanceof SdkAutoConstructList);
    }

    public final List<Audio> audioList() {
        return this.audioList;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTextList() ? this.textList() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSsmlList() ? this.ssmlList() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAudioList() ? this.audioList() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Content)) {
            return false;
        }
        Content other = (Content)obj;
        return this.hasTextList() == other.hasTextList() && Objects.equals(this.textList(), other.textList()) && this.hasSsmlList() == other.hasSsmlList() && Objects.equals(this.ssmlList(), other.ssmlList()) && this.hasAudioList() == other.hasAudioList() && Objects.equals(this.audioList(), other.audioList());
    }

    public final String toString() {
        return ToString.builder((String)"Content").add("TextList", this.hasTextList() ? this.textList() : null).add("SsmlList", this.hasSsmlList() ? this.ssmlList() : null).add("AudioList", this.hasAudioList() ? this.audioList() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "TextList": {
                return Optional.ofNullable(clazz.cast(this.textList()));
            }
            case "SsmlList": {
                return Optional.ofNullable(clazz.cast(this.ssmlList()));
            }
            case "AudioList": {
                return Optional.ofNullable(clazz.cast(this.audioList()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Content, T> g) {
        return obj -> g.apply((Content)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<Text> textList = DefaultSdkAutoConstructList.getInstance();
        private List<Ssml> ssmlList = DefaultSdkAutoConstructList.getInstance();
        private List<Audio> audioList = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(Content model) {
            this.textList(model.textList);
            this.ssmlList(model.ssmlList);
            this.audioList(model.audioList);
        }

        public final Collection<Text.Builder> getTextList() {
            if (this.textList instanceof SdkAutoConstructList) {
                return null;
            }
            return this.textList != null ? (Collection)this.textList.stream().map(Text::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder textList(Collection<Text> textList) {
            this.textList = TextListCopier.copy(textList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder textList(Text ... textList) {
            this.textList(Arrays.asList(textList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder textList(Consumer<Text.Builder> ... textList) {
            this.textList(Stream.of(textList).map(c -> (Text)((Text.Builder)Text.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTextList(Collection<Text.BuilderImpl> textList) {
            this.textList = TextListCopier.copyFromBuilder(textList);
        }

        public final Collection<Ssml.Builder> getSsmlList() {
            if (this.ssmlList instanceof SdkAutoConstructList) {
                return null;
            }
            return this.ssmlList != null ? (Collection)this.ssmlList.stream().map(Ssml::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder ssmlList(Collection<Ssml> ssmlList) {
            this.ssmlList = SsmlListCopier.copy(ssmlList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ssmlList(Ssml ... ssmlList) {
            this.ssmlList(Arrays.asList(ssmlList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ssmlList(Consumer<Ssml.Builder> ... ssmlList) {
            this.ssmlList(Stream.of(ssmlList).map(c -> (Ssml)((Ssml.Builder)Ssml.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setSsmlList(Collection<Ssml.BuilderImpl> ssmlList) {
            this.ssmlList = SsmlListCopier.copyFromBuilder(ssmlList);
        }

        public final Collection<Audio.Builder> getAudioList() {
            if (this.audioList instanceof SdkAutoConstructList) {
                return null;
            }
            return this.audioList != null ? (Collection)this.audioList.stream().map(Audio::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder audioList(Collection<Audio> audioList) {
            this.audioList = AudioListCopier.copy(audioList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder audioList(Audio ... audioList) {
            this.audioList(Arrays.asList(audioList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder audioList(Consumer<Audio.Builder> ... audioList) {
            this.audioList(Stream.of(audioList).map(c -> (Audio)((Audio.Builder)Audio.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setAudioList(Collection<Audio.BuilderImpl> audioList) {
            this.audioList = AudioListCopier.copyFromBuilder(audioList);
        }

        public Content build() {
            return new Content(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Content> {
        public Builder textList(Collection<Text> var1);

        public Builder textList(Text ... var1);

        public Builder textList(Consumer<Text.Builder> ... var1);

        public Builder ssmlList(Collection<Ssml> var1);

        public Builder ssmlList(Ssml ... var1);

        public Builder ssmlList(Consumer<Ssml.Builder> ... var1);

        public Builder audioList(Collection<Audio> var1);

        public Builder audioList(Audio ... var1);

        public Builder audioList(Consumer<Audio.Builder> ... var1);
    }
}

