/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.alexaforbusiness.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListSkillsResponse extends AlexaForBusinessResponse implements
        ToCopyableBuilder<ListSkillsResponse.Builder, ListSkillsResponse> {
    private static final SdkField<List<SkillSummary>> SKILL_SUMMARIES_FIELD = SdkField
            .<List<SkillSummary>> builder(MarshallingType.LIST)
            .memberName("SkillSummaries")
            .getter(getter(ListSkillsResponse::skillSummaries))
            .setter(setter(Builder::skillSummaries))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SkillSummaries").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<SkillSummary> builder(MarshallingType.SDK_POJO)
                                            .constructor(SkillSummary::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListSkillsResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SKILL_SUMMARIES_FIELD,
            NEXT_TOKEN_FIELD));

    private final List<SkillSummary> skillSummaries;

    private final String nextToken;

    private ListSkillsResponse(BuilderImpl builder) {
        super(builder);
        this.skillSummaries = builder.skillSummaries;
        this.nextToken = builder.nextToken;
    }

    /**
     * Returns true if the SkillSummaries property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasSkillSummaries() {
        return skillSummaries != null && !(skillSummaries instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of enabled skills requested. Required.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasSkillSummaries()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The list of enabled skills requested. Required.
     */
    public final List<SkillSummary> skillSummaries() {
        return skillSummaries;
    }

    /**
     * <p>
     * The token returned to indicate that there is more data available.
     * </p>
     * 
     * @return The token returned to indicate that there is more data available.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasSkillSummaries() ? skillSummaries() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListSkillsResponse)) {
            return false;
        }
        ListSkillsResponse other = (ListSkillsResponse) obj;
        return hasSkillSummaries() == other.hasSkillSummaries() && Objects.equals(skillSummaries(), other.skillSummaries())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListSkillsResponse").add("SkillSummaries", hasSkillSummaries() ? skillSummaries() : null)
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SkillSummaries":
            return Optional.ofNullable(clazz.cast(skillSummaries()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListSkillsResponse, T> g) {
        return obj -> g.apply((ListSkillsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends AlexaForBusinessResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListSkillsResponse> {
        /**
         * <p>
         * The list of enabled skills requested. Required.
         * </p>
         * 
         * @param skillSummaries
         *        The list of enabled skills requested. Required.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder skillSummaries(Collection<SkillSummary> skillSummaries);

        /**
         * <p>
         * The list of enabled skills requested. Required.
         * </p>
         * 
         * @param skillSummaries
         *        The list of enabled skills requested. Required.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder skillSummaries(SkillSummary... skillSummaries);

        /**
         * <p>
         * The list of enabled skills requested. Required.
         * </p>
         * This is a convenience that creates an instance of the {@link List<SkillSummary>.Builder} avoiding the need to
         * create one manually via {@link List<SkillSummary>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<SkillSummary>.Builder#build()} is called immediately and its
         * result is passed to {@link #skillSummaries(List<SkillSummary>)}.
         * 
         * @param skillSummaries
         *        a consumer that will call methods on {@link List<SkillSummary>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #skillSummaries(List<SkillSummary>)
         */
        Builder skillSummaries(Consumer<SkillSummary.Builder>... skillSummaries);

        /**
         * <p>
         * The token returned to indicate that there is more data available.
         * </p>
         * 
         * @param nextToken
         *        The token returned to indicate that there is more data available.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends AlexaForBusinessResponse.BuilderImpl implements Builder {
        private List<SkillSummary> skillSummaries = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListSkillsResponse model) {
            super(model);
            skillSummaries(model.skillSummaries);
            nextToken(model.nextToken);
        }

        public final Collection<SkillSummary.Builder> getSkillSummaries() {
            if (skillSummaries instanceof SdkAutoConstructList) {
                return null;
            }
            return skillSummaries != null ? skillSummaries.stream().map(SkillSummary::toBuilder).collect(Collectors.toList())
                    : null;
        }

        @Override
        public final Builder skillSummaries(Collection<SkillSummary> skillSummaries) {
            this.skillSummaries = SkillSummaryListCopier.copy(skillSummaries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder skillSummaries(SkillSummary... skillSummaries) {
            skillSummaries(Arrays.asList(skillSummaries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder skillSummaries(Consumer<SkillSummary.Builder>... skillSummaries) {
            skillSummaries(Stream.of(skillSummaries).map(c -> SkillSummary.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setSkillSummaries(Collection<SkillSummary.BuilderImpl> skillSummaries) {
            this.skillSummaries = SkillSummaryListCopier.copyFromBuilder(skillSummaries);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListSkillsResponse build() {
            return new ListSkillsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
