/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.alexaforbusiness.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The skill store category that is shown. Alexa skills are assigned a specific skill category during creation, such as
 * News, Social, and Sports.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Category implements SdkPojo, Serializable, ToCopyableBuilder<Category.Builder, Category> {
    private static final SdkField<Long> CATEGORY_ID_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("CategoryId").getter(getter(Category::categoryId)).setter(setter(Builder::categoryId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CategoryId").build()).build();

    private static final SdkField<String> CATEGORY_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CategoryName").getter(getter(Category::categoryName)).setter(setter(Builder::categoryName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CategoryName").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CATEGORY_ID_FIELD,
            CATEGORY_NAME_FIELD));

    private static final long serialVersionUID = 1L;

    private final Long categoryId;

    private final String categoryName;

    private Category(BuilderImpl builder) {
        this.categoryId = builder.categoryId;
        this.categoryName = builder.categoryName;
    }

    /**
     * <p>
     * The ID of the skill store category.
     * </p>
     * 
     * @return The ID of the skill store category.
     */
    public final Long categoryId() {
        return categoryId;
    }

    /**
     * <p>
     * The name of the skill store category.
     * </p>
     * 
     * @return The name of the skill store category.
     */
    public final String categoryName() {
        return categoryName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(categoryId());
        hashCode = 31 * hashCode + Objects.hashCode(categoryName());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Category)) {
            return false;
        }
        Category other = (Category) obj;
        return Objects.equals(categoryId(), other.categoryId()) && Objects.equals(categoryName(), other.categoryName());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Category").add("CategoryId", categoryId()).add("CategoryName", categoryName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CategoryId":
            return Optional.ofNullable(clazz.cast(categoryId()));
        case "CategoryName":
            return Optional.ofNullable(clazz.cast(categoryName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Category, T> g) {
        return obj -> g.apply((Category) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Category> {
        /**
         * <p>
         * The ID of the skill store category.
         * </p>
         * 
         * @param categoryId
         *        The ID of the skill store category.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder categoryId(Long categoryId);

        /**
         * <p>
         * The name of the skill store category.
         * </p>
         * 
         * @param categoryName
         *        The name of the skill store category.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder categoryName(String categoryName);
    }

    static final class BuilderImpl implements Builder {
        private Long categoryId;

        private String categoryName;

        private BuilderImpl() {
        }

        private BuilderImpl(Category model) {
            categoryId(model.categoryId);
            categoryName(model.categoryName);
        }

        public final Long getCategoryId() {
            return categoryId;
        }

        @Override
        public final Builder categoryId(Long categoryId) {
            this.categoryId = categoryId;
            return this;
        }

        public final void setCategoryId(Long categoryId) {
            this.categoryId = categoryId;
        }

        public final String getCategoryName() {
            return categoryName;
        }

        @Override
        public final Builder categoryName(String categoryName) {
            this.categoryName = categoryName;
            return this;
        }

        public final void setCategoryName(String categoryName) {
            this.categoryName = categoryName;
        }

        @Override
        public Category build() {
            return new Category(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
