/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.alexaforbusiness.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.alexaforbusiness.model.AlexaForBusinessRequest;
import software.amazon.awssdk.services.alexaforbusiness.model.ConferenceProviderType;
import software.amazon.awssdk.services.alexaforbusiness.model.IPDialIn;
import software.amazon.awssdk.services.alexaforbusiness.model.MeetingSetting;
import software.amazon.awssdk.services.alexaforbusiness.model.PSTNDialIn;
import software.amazon.awssdk.services.alexaforbusiness.model.Tag;
import software.amazon.awssdk.services.alexaforbusiness.model.TagListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateConferenceProviderRequest
extends AlexaForBusinessRequest
implements ToCopyableBuilder<Builder, CreateConferenceProviderRequest> {
    private static final SdkField<String> CONFERENCE_PROVIDER_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ConferenceProviderName").getter(CreateConferenceProviderRequest.getter(CreateConferenceProviderRequest::conferenceProviderName)).setter(CreateConferenceProviderRequest.setter(Builder::conferenceProviderName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConferenceProviderName").build()}).build();
    private static final SdkField<String> CONFERENCE_PROVIDER_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ConferenceProviderType").getter(CreateConferenceProviderRequest.getter(CreateConferenceProviderRequest::conferenceProviderTypeAsString)).setter(CreateConferenceProviderRequest.setter(Builder::conferenceProviderType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConferenceProviderType").build()}).build();
    private static final SdkField<IPDialIn> IP_DIAL_IN_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("IPDialIn").getter(CreateConferenceProviderRequest.getter(CreateConferenceProviderRequest::ipDialIn)).setter(CreateConferenceProviderRequest.setter(Builder::ipDialIn)).constructor(IPDialIn::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IPDialIn").build()}).build();
    private static final SdkField<PSTNDialIn> PSTN_DIAL_IN_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("PSTNDialIn").getter(CreateConferenceProviderRequest.getter(CreateConferenceProviderRequest::pstnDialIn)).setter(CreateConferenceProviderRequest.setter(Builder::pstnDialIn)).constructor(PSTNDialIn::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PSTNDialIn").build()}).build();
    private static final SdkField<MeetingSetting> MEETING_SETTING_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("MeetingSetting").getter(CreateConferenceProviderRequest.getter(CreateConferenceProviderRequest::meetingSetting)).setter(CreateConferenceProviderRequest.setter(Builder::meetingSetting)).constructor(MeetingSetting::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MeetingSetting").build()}).build();
    private static final SdkField<String> CLIENT_REQUEST_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ClientRequestToken").getter(CreateConferenceProviderRequest.getter(CreateConferenceProviderRequest::clientRequestToken)).setter(CreateConferenceProviderRequest.setter(Builder::clientRequestToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientRequestToken").build(), DefaultValueTrait.idempotencyToken()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Tags").getter(CreateConferenceProviderRequest.getter(CreateConferenceProviderRequest::tags)).setter(CreateConferenceProviderRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONFERENCE_PROVIDER_NAME_FIELD, CONFERENCE_PROVIDER_TYPE_FIELD, IP_DIAL_IN_FIELD, PSTN_DIAL_IN_FIELD, MEETING_SETTING_FIELD, CLIENT_REQUEST_TOKEN_FIELD, TAGS_FIELD));
    private final String conferenceProviderName;
    private final String conferenceProviderType;
    private final IPDialIn ipDialIn;
    private final PSTNDialIn pstnDialIn;
    private final MeetingSetting meetingSetting;
    private final String clientRequestToken;
    private final List<Tag> tags;

    private CreateConferenceProviderRequest(BuilderImpl builder) {
        super(builder);
        this.conferenceProviderName = builder.conferenceProviderName;
        this.conferenceProviderType = builder.conferenceProviderType;
        this.ipDialIn = builder.ipDialIn;
        this.pstnDialIn = builder.pstnDialIn;
        this.meetingSetting = builder.meetingSetting;
        this.clientRequestToken = builder.clientRequestToken;
        this.tags = builder.tags;
    }

    public final String conferenceProviderName() {
        return this.conferenceProviderName;
    }

    public final ConferenceProviderType conferenceProviderType() {
        return ConferenceProviderType.fromValue(this.conferenceProviderType);
    }

    public final String conferenceProviderTypeAsString() {
        return this.conferenceProviderType;
    }

    public final IPDialIn ipDialIn() {
        return this.ipDialIn;
    }

    public final PSTNDialIn pstnDialIn() {
        return this.pstnDialIn;
    }

    public final MeetingSetting meetingSetting() {
        return this.meetingSetting;
    }

    public final String clientRequestToken() {
        return this.clientRequestToken;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public final List<Tag> tags() {
        return this.tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.conferenceProviderName());
        hashCode = 31 * hashCode + Objects.hashCode(this.conferenceProviderTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.ipDialIn());
        hashCode = 31 * hashCode + Objects.hashCode(this.pstnDialIn());
        hashCode = 31 * hashCode + Objects.hashCode(this.meetingSetting());
        hashCode = 31 * hashCode + Objects.hashCode(this.clientRequestToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateConferenceProviderRequest)) {
            return false;
        }
        CreateConferenceProviderRequest other = (CreateConferenceProviderRequest)((Object)obj);
        return Objects.equals(this.conferenceProviderName(), other.conferenceProviderName()) && Objects.equals(this.conferenceProviderTypeAsString(), other.conferenceProviderTypeAsString()) && Objects.equals(this.ipDialIn(), other.ipDialIn()) && Objects.equals(this.pstnDialIn(), other.pstnDialIn()) && Objects.equals(this.meetingSetting(), other.meetingSetting()) && Objects.equals(this.clientRequestToken(), other.clientRequestToken()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public final String toString() {
        return ToString.builder((String)"CreateConferenceProviderRequest").add("ConferenceProviderName", (Object)this.conferenceProviderName()).add("ConferenceProviderType", (Object)this.conferenceProviderTypeAsString()).add("IPDialIn", (Object)this.ipDialIn()).add("PSTNDialIn", (Object)this.pstnDialIn()).add("MeetingSetting", (Object)this.meetingSetting()).add("ClientRequestToken", (Object)this.clientRequestToken()).add("Tags", this.hasTags() ? this.tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ConferenceProviderName": {
                return Optional.ofNullable(clazz.cast(this.conferenceProviderName()));
            }
            case "ConferenceProviderType": {
                return Optional.ofNullable(clazz.cast(this.conferenceProviderTypeAsString()));
            }
            case "IPDialIn": {
                return Optional.ofNullable(clazz.cast(this.ipDialIn()));
            }
            case "PSTNDialIn": {
                return Optional.ofNullable(clazz.cast(this.pstnDialIn()));
            }
            case "MeetingSetting": {
                return Optional.ofNullable(clazz.cast(this.meetingSetting()));
            }
            case "ClientRequestToken": {
                return Optional.ofNullable(clazz.cast(this.clientRequestToken()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateConferenceProviderRequest, T> g) {
        return obj -> g.apply((CreateConferenceProviderRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends AlexaForBusinessRequest.BuilderImpl
    implements Builder {
        private String conferenceProviderName;
        private String conferenceProviderType;
        private IPDialIn ipDialIn;
        private PSTNDialIn pstnDialIn;
        private MeetingSetting meetingSetting;
        private String clientRequestToken;
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateConferenceProviderRequest model) {
            super(model);
            this.conferenceProviderName(model.conferenceProviderName);
            this.conferenceProviderType(model.conferenceProviderType);
            this.ipDialIn(model.ipDialIn);
            this.pstnDialIn(model.pstnDialIn);
            this.meetingSetting(model.meetingSetting);
            this.clientRequestToken(model.clientRequestToken);
            this.tags(model.tags);
        }

        public final String getConferenceProviderName() {
            return this.conferenceProviderName;
        }

        @Override
        public final Builder conferenceProviderName(String conferenceProviderName) {
            this.conferenceProviderName = conferenceProviderName;
            return this;
        }

        public final void setConferenceProviderName(String conferenceProviderName) {
            this.conferenceProviderName = conferenceProviderName;
        }

        public final String getConferenceProviderType() {
            return this.conferenceProviderType;
        }

        @Override
        public final Builder conferenceProviderType(String conferenceProviderType) {
            this.conferenceProviderType = conferenceProviderType;
            return this;
        }

        @Override
        public final Builder conferenceProviderType(ConferenceProviderType conferenceProviderType) {
            this.conferenceProviderType(conferenceProviderType == null ? null : conferenceProviderType.toString());
            return this;
        }

        public final void setConferenceProviderType(String conferenceProviderType) {
            this.conferenceProviderType = conferenceProviderType;
        }

        public final IPDialIn.Builder getIpDialIn() {
            return this.ipDialIn != null ? this.ipDialIn.toBuilder() : null;
        }

        @Override
        public final Builder ipDialIn(IPDialIn ipDialIn) {
            this.ipDialIn = ipDialIn;
            return this;
        }

        public final void setIpDialIn(IPDialIn.BuilderImpl ipDialIn) {
            this.ipDialIn = ipDialIn != null ? ipDialIn.build() : null;
        }

        public final PSTNDialIn.Builder getPstnDialIn() {
            return this.pstnDialIn != null ? this.pstnDialIn.toBuilder() : null;
        }

        @Override
        public final Builder pstnDialIn(PSTNDialIn pstnDialIn) {
            this.pstnDialIn = pstnDialIn;
            return this;
        }

        public final void setPstnDialIn(PSTNDialIn.BuilderImpl pstnDialIn) {
            this.pstnDialIn = pstnDialIn != null ? pstnDialIn.build() : null;
        }

        public final MeetingSetting.Builder getMeetingSetting() {
            return this.meetingSetting != null ? this.meetingSetting.toBuilder() : null;
        }

        @Override
        public final Builder meetingSetting(MeetingSetting meetingSetting) {
            this.meetingSetting = meetingSetting;
            return this;
        }

        public final void setMeetingSetting(MeetingSetting.BuilderImpl meetingSetting) {
            this.meetingSetting = meetingSetting != null ? meetingSetting.build() : null;
        }

        public final String getClientRequestToken() {
            return this.clientRequestToken;
        }

        @Override
        public final Builder clientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
            return this;
        }

        public final void setClientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
        }

        public final Collection<Tag.Builder> getTags() {
            if (this.tags instanceof SdkAutoConstructList) {
                return null;
            }
            return this.tags != null ? (Collection)this.tags.stream().map(Tag::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateConferenceProviderRequest build() {
            return new CreateConferenceProviderRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends AlexaForBusinessRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateConferenceProviderRequest> {
        public Builder conferenceProviderName(String var1);

        public Builder conferenceProviderType(String var1);

        public Builder conferenceProviderType(ConferenceProviderType var1);

        public Builder ipDialIn(IPDialIn var1);

        default public Builder ipDialIn(Consumer<IPDialIn.Builder> ipDialIn) {
            return this.ipDialIn((IPDialIn)((IPDialIn.Builder)IPDialIn.builder().applyMutation(ipDialIn)).build());
        }

        public Builder pstnDialIn(PSTNDialIn var1);

        default public Builder pstnDialIn(Consumer<PSTNDialIn.Builder> pstnDialIn) {
            return this.pstnDialIn((PSTNDialIn)((PSTNDialIn.Builder)PSTNDialIn.builder().applyMutation(pstnDialIn)).build());
        }

        public Builder meetingSetting(MeetingSetting var1);

        default public Builder meetingSetting(Consumer<MeetingSetting.Builder> meetingSetting) {
            return this.meetingSetting((MeetingSetting)((MeetingSetting.Builder)MeetingSetting.builder().applyMutation(meetingSetting)).build());
        }

        public Builder clientRequestToken(String var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

