/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.alexaforbusiness.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ResolveRoomRequest extends AlexaForBusinessRequest implements
        ToCopyableBuilder<ResolveRoomRequest.Builder, ResolveRoomRequest> {
    private static final SdkField<String> USER_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("UserId")
            .getter(getter(ResolveRoomRequest::userId)).setter(setter(Builder::userId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserId").build()).build();

    private static final SdkField<String> SKILL_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SkillId").getter(getter(ResolveRoomRequest::skillId)).setter(setter(Builder::skillId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SkillId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections
            .unmodifiableList(Arrays.asList(USER_ID_FIELD, SKILL_ID_FIELD));

    private final String userId;

    private final String skillId;

    private ResolveRoomRequest(BuilderImpl builder) {
        super(builder);
        this.userId = builder.userId;
        this.skillId = builder.skillId;
    }

    /**
     * <p>
     * The ARN of the user. Required.
     * </p>
     * 
     * @return The ARN of the user. Required.
     */
    public final String userId() {
        return userId;
    }

    /**
     * <p>
     * The ARN of the skill that was requested. Required.
     * </p>
     * 
     * @return The ARN of the skill that was requested. Required.
     */
    public final String skillId() {
        return skillId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(userId());
        hashCode = 31 * hashCode + Objects.hashCode(skillId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ResolveRoomRequest)) {
            return false;
        }
        ResolveRoomRequest other = (ResolveRoomRequest) obj;
        return Objects.equals(userId(), other.userId()) && Objects.equals(skillId(), other.skillId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ResolveRoomRequest").add("UserId", userId()).add("SkillId", skillId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "UserId":
            return Optional.ofNullable(clazz.cast(userId()));
        case "SkillId":
            return Optional.ofNullable(clazz.cast(skillId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ResolveRoomRequest, T> g) {
        return obj -> g.apply((ResolveRoomRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends AlexaForBusinessRequest.Builder, SdkPojo, CopyableBuilder<Builder, ResolveRoomRequest> {
        /**
         * <p>
         * The ARN of the user. Required.
         * </p>
         * 
         * @param userId
         *        The ARN of the user. Required.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userId(String userId);

        /**
         * <p>
         * The ARN of the skill that was requested. Required.
         * </p>
         * 
         * @param skillId
         *        The ARN of the skill that was requested. Required.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder skillId(String skillId);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends AlexaForBusinessRequest.BuilderImpl implements Builder {
        private String userId;

        private String skillId;

        private BuilderImpl() {
        }

        private BuilderImpl(ResolveRoomRequest model) {
            super(model);
            userId(model.userId);
            skillId(model.skillId);
        }

        public final String getUserId() {
            return userId;
        }

        @Override
        public final Builder userId(String userId) {
            this.userId = userId;
            return this;
        }

        public final void setUserId(String userId) {
            this.userId = userId;
        }

        public final String getSkillId() {
            return skillId;
        }

        @Override
        public final Builder skillId(String skillId) {
            this.skillId = skillId;
            return this;
        }

        public final void setSkillId(String skillId) {
            this.skillId = skillId;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ResolveRoomRequest build() {
            return new ResolveRoomRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
