/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.alexaforbusiness.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A skill group with attributes.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SkillGroup implements SdkPojo, Serializable, ToCopyableBuilder<SkillGroup.Builder, SkillGroup> {
    private static final SdkField<String> SKILL_GROUP_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SkillGroupArn").getter(getter(SkillGroup::skillGroupArn)).setter(setter(Builder::skillGroupArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SkillGroupArn").build()).build();

    private static final SdkField<String> SKILL_GROUP_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SkillGroupName").getter(getter(SkillGroup::skillGroupName)).setter(setter(Builder::skillGroupName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SkillGroupName").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(SkillGroup::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SKILL_GROUP_ARN_FIELD,
            SKILL_GROUP_NAME_FIELD, DESCRIPTION_FIELD));

    private static final long serialVersionUID = 1L;

    private final String skillGroupArn;

    private final String skillGroupName;

    private final String description;

    private SkillGroup(BuilderImpl builder) {
        this.skillGroupArn = builder.skillGroupArn;
        this.skillGroupName = builder.skillGroupName;
        this.description = builder.description;
    }

    /**
     * <p>
     * The ARN of a skill group.
     * </p>
     * 
     * @return The ARN of a skill group.
     */
    public final String skillGroupArn() {
        return skillGroupArn;
    }

    /**
     * <p>
     * The name of a skill group.
     * </p>
     * 
     * @return The name of a skill group.
     */
    public final String skillGroupName() {
        return skillGroupName;
    }

    /**
     * <p>
     * The description of a skill group.
     * </p>
     * 
     * @return The description of a skill group.
     */
    public final String description() {
        return description;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(skillGroupArn());
        hashCode = 31 * hashCode + Objects.hashCode(skillGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SkillGroup)) {
            return false;
        }
        SkillGroup other = (SkillGroup) obj;
        return Objects.equals(skillGroupArn(), other.skillGroupArn()) && Objects.equals(skillGroupName(), other.skillGroupName())
                && Objects.equals(description(), other.description());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SkillGroup").add("SkillGroupArn", skillGroupArn()).add("SkillGroupName", skillGroupName())
                .add("Description", description()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SkillGroupArn":
            return Optional.ofNullable(clazz.cast(skillGroupArn()));
        case "SkillGroupName":
            return Optional.ofNullable(clazz.cast(skillGroupName()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SkillGroup, T> g) {
        return obj -> g.apply((SkillGroup) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SkillGroup> {
        /**
         * <p>
         * The ARN of a skill group.
         * </p>
         * 
         * @param skillGroupArn
         *        The ARN of a skill group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder skillGroupArn(String skillGroupArn);

        /**
         * <p>
         * The name of a skill group.
         * </p>
         * 
         * @param skillGroupName
         *        The name of a skill group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder skillGroupName(String skillGroupName);

        /**
         * <p>
         * The description of a skill group.
         * </p>
         * 
         * @param description
         *        The description of a skill group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);
    }

    static final class BuilderImpl implements Builder {
        private String skillGroupArn;

        private String skillGroupName;

        private String description;

        private BuilderImpl() {
        }

        private BuilderImpl(SkillGroup model) {
            skillGroupArn(model.skillGroupArn);
            skillGroupName(model.skillGroupName);
            description(model.description);
        }

        public final String getSkillGroupArn() {
            return skillGroupArn;
        }

        @Override
        public final Builder skillGroupArn(String skillGroupArn) {
            this.skillGroupArn = skillGroupArn;
            return this;
        }

        public final void setSkillGroupArn(String skillGroupArn) {
            this.skillGroupArn = skillGroupArn;
        }

        public final String getSkillGroupName() {
            return skillGroupName;
        }

        @Override
        public final Builder skillGroupName(String skillGroupName) {
            this.skillGroupName = skillGroupName;
            return this;
        }

        public final void setSkillGroupName(String skillGroupName) {
            this.skillGroupName = skillGroupName;
        }

        public final String getDescription() {
            return description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public SkillGroup build() {
            return new SkillGroup(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
