/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.alexaforbusiness.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class SearchContactsResponse extends AlexaForBusinessResponse implements
        ToCopyableBuilder<SearchContactsResponse.Builder, SearchContactsResponse> {
    private static final SdkField<List<ContactData>> CONTACTS_FIELD = SdkField
            .<List<ContactData>> builder(MarshallingType.LIST)
            .memberName("Contacts")
            .getter(getter(SearchContactsResponse::contacts))
            .setter(setter(Builder::contacts))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Contacts").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ContactData> builder(MarshallingType.SDK_POJO)
                                            .constructor(ContactData::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(SearchContactsResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final SdkField<Integer> TOTAL_COUNT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("TotalCount").getter(getter(SearchContactsResponse::totalCount)).setter(setter(Builder::totalCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TotalCount").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONTACTS_FIELD,
            NEXT_TOKEN_FIELD, TOTAL_COUNT_FIELD));

    private final List<ContactData> contacts;

    private final String nextToken;

    private final Integer totalCount;

    private SearchContactsResponse(BuilderImpl builder) {
        super(builder);
        this.contacts = builder.contacts;
        this.nextToken = builder.nextToken;
        this.totalCount = builder.totalCount;
    }

    /**
     * Returns true if the Contacts property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasContacts() {
        return contacts != null && !(contacts instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The contacts that meet the specified set of filter criteria, in sort order.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasContacts()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The contacts that meet the specified set of filter criteria, in sort order.
     */
    public final List<ContactData> contacts() {
        return contacts;
    }

    /**
     * <p>
     * The token returned to indicate that there is more data available.
     * </p>
     * 
     * @return The token returned to indicate that there is more data available.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * The total number of contacts returned.
     * </p>
     * 
     * @return The total number of contacts returned.
     */
    public final Integer totalCount() {
        return totalCount;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasContacts() ? contacts() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(totalCount());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SearchContactsResponse)) {
            return false;
        }
        SearchContactsResponse other = (SearchContactsResponse) obj;
        return hasContacts() == other.hasContacts() && Objects.equals(contacts(), other.contacts())
                && Objects.equals(nextToken(), other.nextToken()) && Objects.equals(totalCount(), other.totalCount());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SearchContactsResponse").add("Contacts", hasContacts() ? contacts() : null)
                .add("NextToken", nextToken()).add("TotalCount", totalCount()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Contacts":
            return Optional.ofNullable(clazz.cast(contacts()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "TotalCount":
            return Optional.ofNullable(clazz.cast(totalCount()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SearchContactsResponse, T> g) {
        return obj -> g.apply((SearchContactsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends AlexaForBusinessResponse.Builder, SdkPojo, CopyableBuilder<Builder, SearchContactsResponse> {
        /**
         * <p>
         * The contacts that meet the specified set of filter criteria, in sort order.
         * </p>
         * 
         * @param contacts
         *        The contacts that meet the specified set of filter criteria, in sort order.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder contacts(Collection<ContactData> contacts);

        /**
         * <p>
         * The contacts that meet the specified set of filter criteria, in sort order.
         * </p>
         * 
         * @param contacts
         *        The contacts that meet the specified set of filter criteria, in sort order.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder contacts(ContactData... contacts);

        /**
         * <p>
         * The contacts that meet the specified set of filter criteria, in sort order.
         * </p>
         * This is a convenience that creates an instance of the {@link List<ContactData>.Builder} avoiding the need to
         * create one manually via {@link List<ContactData>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<ContactData>.Builder#build()} is called immediately and its
         * result is passed to {@link #contacts(List<ContactData>)}.
         * 
         * @param contacts
         *        a consumer that will call methods on {@link List<ContactData>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #contacts(List<ContactData>)
         */
        Builder contacts(Consumer<ContactData.Builder>... contacts);

        /**
         * <p>
         * The token returned to indicate that there is more data available.
         * </p>
         * 
         * @param nextToken
         *        The token returned to indicate that there is more data available.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The total number of contacts returned.
         * </p>
         * 
         * @param totalCount
         *        The total number of contacts returned.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder totalCount(Integer totalCount);
    }

    static final class BuilderImpl extends AlexaForBusinessResponse.BuilderImpl implements Builder {
        private List<ContactData> contacts = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private Integer totalCount;

        private BuilderImpl() {
        }

        private BuilderImpl(SearchContactsResponse model) {
            super(model);
            contacts(model.contacts);
            nextToken(model.nextToken);
            totalCount(model.totalCount);
        }

        public final List<ContactData.Builder> getContacts() {
            List<ContactData.Builder> result = ContactDataListCopier.copyToBuilder(this.contacts);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder contacts(Collection<ContactData> contacts) {
            this.contacts = ContactDataListCopier.copy(contacts);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder contacts(ContactData... contacts) {
            contacts(Arrays.asList(contacts));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder contacts(Consumer<ContactData.Builder>... contacts) {
            contacts(Stream.of(contacts).map(c -> ContactData.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setContacts(Collection<ContactData.BuilderImpl> contacts) {
            this.contacts = ContactDataListCopier.copyFromBuilder(contacts);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final Integer getTotalCount() {
            return totalCount;
        }

        @Override
        public final Builder totalCount(Integer totalCount) {
            this.totalCount = totalCount;
            return this;
        }

        public final void setTotalCount(Integer totalCount) {
            this.totalCount = totalCount;
        }

        @Override
        public SearchContactsResponse build() {
            return new SearchContactsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
