/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.alexaforbusiness.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.alexaforbusiness.model.AlexaForBusinessResponse;
import software.amazon.awssdk.services.alexaforbusiness.model.ProfileData;
import software.amazon.awssdk.services.alexaforbusiness.model.ProfileDataListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SearchProfilesResponse
extends AlexaForBusinessResponse
implements ToCopyableBuilder<Builder, SearchProfilesResponse> {
    private static final SdkField<List<ProfileData>> PROFILES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Profiles").getter(SearchProfilesResponse.getter(SearchProfilesResponse::profiles)).setter(SearchProfilesResponse.setter(Builder::profiles)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Profiles").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ProfileData::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(SearchProfilesResponse.getter(SearchProfilesResponse::nextToken)).setter(SearchProfilesResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final SdkField<Integer> TOTAL_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("TotalCount").getter(SearchProfilesResponse.getter(SearchProfilesResponse::totalCount)).setter(SearchProfilesResponse.setter(Builder::totalCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TotalCount").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PROFILES_FIELD, NEXT_TOKEN_FIELD, TOTAL_COUNT_FIELD));
    private final List<ProfileData> profiles;
    private final String nextToken;
    private final Integer totalCount;

    private SearchProfilesResponse(BuilderImpl builder) {
        super(builder);
        this.profiles = builder.profiles;
        this.nextToken = builder.nextToken;
        this.totalCount = builder.totalCount;
    }

    public final boolean hasProfiles() {
        return this.profiles != null && !(this.profiles instanceof SdkAutoConstructList);
    }

    public final List<ProfileData> profiles() {
        return this.profiles;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final Integer totalCount() {
        return this.totalCount;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasProfiles() ? this.profiles() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.totalCount());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SearchProfilesResponse)) {
            return false;
        }
        SearchProfilesResponse other = (SearchProfilesResponse)((Object)obj);
        return this.hasProfiles() == other.hasProfiles() && Objects.equals(this.profiles(), other.profiles()) && Objects.equals(this.nextToken(), other.nextToken()) && Objects.equals(this.totalCount(), other.totalCount());
    }

    public final String toString() {
        return ToString.builder((String)"SearchProfilesResponse").add("Profiles", this.hasProfiles() ? this.profiles() : null).add("NextToken", (Object)this.nextToken()).add("TotalCount", (Object)this.totalCount()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Profiles": {
                return Optional.ofNullable(clazz.cast(this.profiles()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "TotalCount": {
                return Optional.ofNullable(clazz.cast(this.totalCount()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SearchProfilesResponse, T> g) {
        return obj -> g.apply((SearchProfilesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends AlexaForBusinessResponse.BuilderImpl
    implements Builder {
        private List<ProfileData> profiles = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;
        private Integer totalCount;

        private BuilderImpl() {
        }

        private BuilderImpl(SearchProfilesResponse model) {
            super(model);
            this.profiles(model.profiles);
            this.nextToken(model.nextToken);
            this.totalCount(model.totalCount);
        }

        public final List<ProfileData.Builder> getProfiles() {
            List<ProfileData.Builder> result = ProfileDataListCopier.copyToBuilder(this.profiles);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder profiles(Collection<ProfileData> profiles) {
            this.profiles = ProfileDataListCopier.copy(profiles);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder profiles(ProfileData ... profiles) {
            this.profiles(Arrays.asList(profiles));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder profiles(Consumer<ProfileData.Builder> ... profiles) {
            this.profiles(Stream.of(profiles).map(c -> (ProfileData)((ProfileData.Builder)ProfileData.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setProfiles(Collection<ProfileData.BuilderImpl> profiles) {
            this.profiles = ProfileDataListCopier.copyFromBuilder(profiles);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final Integer getTotalCount() {
            return this.totalCount;
        }

        @Override
        public final Builder totalCount(Integer totalCount) {
            this.totalCount = totalCount;
            return this;
        }

        public final void setTotalCount(Integer totalCount) {
            this.totalCount = totalCount;
        }

        @Override
        public SearchProfilesResponse build() {
            return new SearchProfilesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends AlexaForBusinessResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, SearchProfilesResponse> {
        public Builder profiles(Collection<ProfileData> var1);

        public Builder profiles(ProfileData ... var1);

        public Builder profiles(Consumer<ProfileData.Builder> ... var1);

        public Builder nextToken(String var1);

        public Builder totalCount(Integer var1);
    }
}

