/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.alexaforbusiness.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.alexaforbusiness.model.AlexaForBusinessResponse;
import software.amazon.awssdk.services.alexaforbusiness.model.UserData;
import software.amazon.awssdk.services.alexaforbusiness.model.UserDataListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SearchUsersResponse
extends AlexaForBusinessResponse
implements ToCopyableBuilder<Builder, SearchUsersResponse> {
    private static final SdkField<List<UserData>> USERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Users").getter(SearchUsersResponse.getter(SearchUsersResponse::users)).setter(SearchUsersResponse.setter(Builder::users)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Users").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(UserData::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(SearchUsersResponse.getter(SearchUsersResponse::nextToken)).setter(SearchUsersResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final SdkField<Integer> TOTAL_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("TotalCount").getter(SearchUsersResponse.getter(SearchUsersResponse::totalCount)).setter(SearchUsersResponse.setter(Builder::totalCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TotalCount").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(USERS_FIELD, NEXT_TOKEN_FIELD, TOTAL_COUNT_FIELD));
    private final List<UserData> users;
    private final String nextToken;
    private final Integer totalCount;

    private SearchUsersResponse(BuilderImpl builder) {
        super(builder);
        this.users = builder.users;
        this.nextToken = builder.nextToken;
        this.totalCount = builder.totalCount;
    }

    public final boolean hasUsers() {
        return this.users != null && !(this.users instanceof SdkAutoConstructList);
    }

    public final List<UserData> users() {
        return this.users;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final Integer totalCount() {
        return this.totalCount;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasUsers() ? this.users() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.totalCount());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SearchUsersResponse)) {
            return false;
        }
        SearchUsersResponse other = (SearchUsersResponse)((Object)obj);
        return this.hasUsers() == other.hasUsers() && Objects.equals(this.users(), other.users()) && Objects.equals(this.nextToken(), other.nextToken()) && Objects.equals(this.totalCount(), other.totalCount());
    }

    public final String toString() {
        return ToString.builder((String)"SearchUsersResponse").add("Users", this.hasUsers() ? this.users() : null).add("NextToken", (Object)this.nextToken()).add("TotalCount", (Object)this.totalCount()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Users": {
                return Optional.ofNullable(clazz.cast(this.users()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "TotalCount": {
                return Optional.ofNullable(clazz.cast(this.totalCount()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SearchUsersResponse, T> g) {
        return obj -> g.apply((SearchUsersResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends AlexaForBusinessResponse.BuilderImpl
    implements Builder {
        private List<UserData> users = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;
        private Integer totalCount;

        private BuilderImpl() {
        }

        private BuilderImpl(SearchUsersResponse model) {
            super(model);
            this.users(model.users);
            this.nextToken(model.nextToken);
            this.totalCount(model.totalCount);
        }

        public final List<UserData.Builder> getUsers() {
            List<UserData.Builder> result = UserDataListCopier.copyToBuilder(this.users);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder users(Collection<UserData> users) {
            this.users = UserDataListCopier.copy(users);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder users(UserData ... users) {
            this.users(Arrays.asList(users));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder users(Consumer<UserData.Builder> ... users) {
            this.users(Stream.of(users).map(c -> (UserData)((UserData.Builder)UserData.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setUsers(Collection<UserData.BuilderImpl> users) {
            this.users = UserDataListCopier.copyFromBuilder(users);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final Integer getTotalCount() {
            return this.totalCount;
        }

        @Override
        public final Builder totalCount(Integer totalCount) {
            this.totalCount = totalCount;
            return this;
        }

        public final void setTotalCount(Integer totalCount) {
            this.totalCount = totalCount;
        }

        @Override
        public SearchUsersResponse build() {
            return new SearchUsersResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends AlexaForBusinessResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, SearchUsersResponse> {
        public Builder users(Collection<UserData> var1);

        public Builder users(UserData ... var1);

        public Builder users(Consumer<UserData.Builder> ... var1);

        public Builder nextToken(String var1);

        public Builder totalCount(Integer var1);
    }
}

