/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.alexaforbusiness.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateContactRequest extends AlexaForBusinessRequest implements
        ToCopyableBuilder<CreateContactRequest.Builder, CreateContactRequest> {
    private static final SdkField<String> DISPLAY_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DisplayName").getter(getter(CreateContactRequest::displayName)).setter(setter(Builder::displayName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DisplayName").build()).build();

    private static final SdkField<String> FIRST_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FirstName").getter(getter(CreateContactRequest::firstName)).setter(setter(Builder::firstName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FirstName").build()).build();

    private static final SdkField<String> LAST_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LastName").getter(getter(CreateContactRequest::lastName)).setter(setter(Builder::lastName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastName").build()).build();

    private static final SdkField<String> PHONE_NUMBER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PhoneNumber").getter(getter(CreateContactRequest::phoneNumber)).setter(setter(Builder::phoneNumber))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PhoneNumber").build()).build();

    private static final SdkField<List<PhoneNumber>> PHONE_NUMBERS_FIELD = SdkField
            .<List<PhoneNumber>> builder(MarshallingType.LIST)
            .memberName("PhoneNumbers")
            .getter(getter(CreateContactRequest::phoneNumbers))
            .setter(setter(Builder::phoneNumbers))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PhoneNumbers").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<PhoneNumber> builder(MarshallingType.SDK_POJO)
                                            .constructor(PhoneNumber::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<SipAddress>> SIP_ADDRESSES_FIELD = SdkField
            .<List<SipAddress>> builder(MarshallingType.LIST)
            .memberName("SipAddresses")
            .getter(getter(CreateContactRequest::sipAddresses))
            .setter(setter(Builder::sipAddresses))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SipAddresses").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<SipAddress> builder(MarshallingType.SDK_POJO)
                                            .constructor(SipAddress::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> CLIENT_REQUEST_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ClientRequestToken")
            .getter(getter(CreateContactRequest::clientRequestToken))
            .setter(setter(Builder::clientRequestToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientRequestToken").build(),
                    DefaultValueTrait.idempotencyToken()).build();

    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .memberName("Tags")
            .getter(getter(CreateContactRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DISPLAY_NAME_FIELD,
            FIRST_NAME_FIELD, LAST_NAME_FIELD, PHONE_NUMBER_FIELD, PHONE_NUMBERS_FIELD, SIP_ADDRESSES_FIELD,
            CLIENT_REQUEST_TOKEN_FIELD, TAGS_FIELD));

    private final String displayName;

    private final String firstName;

    private final String lastName;

    private final String phoneNumber;

    private final List<PhoneNumber> phoneNumbers;

    private final List<SipAddress> sipAddresses;

    private final String clientRequestToken;

    private final List<Tag> tags;

    private CreateContactRequest(BuilderImpl builder) {
        super(builder);
        this.displayName = builder.displayName;
        this.firstName = builder.firstName;
        this.lastName = builder.lastName;
        this.phoneNumber = builder.phoneNumber;
        this.phoneNumbers = builder.phoneNumbers;
        this.sipAddresses = builder.sipAddresses;
        this.clientRequestToken = builder.clientRequestToken;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * The name of the contact to display on the console.
     * </p>
     * 
     * @return The name of the contact to display on the console.
     */
    public final String displayName() {
        return displayName;
    }

    /**
     * <p>
     * The first name of the contact that is used to call the contact on the device.
     * </p>
     * 
     * @return The first name of the contact that is used to call the contact on the device.
     */
    public final String firstName() {
        return firstName;
    }

    /**
     * <p>
     * The last name of the contact that is used to call the contact on the device.
     * </p>
     * 
     * @return The last name of the contact that is used to call the contact on the device.
     */
    public final String lastName() {
        return lastName;
    }

    /**
     * <p>
     * The phone number of the contact in E.164 format. The phone number type defaults to WORK. You can specify
     * PhoneNumber or PhoneNumbers. We recommend that you use PhoneNumbers, which lets you specify the phone number type
     * and multiple numbers.
     * </p>
     * 
     * @return The phone number of the contact in E.164 format. The phone number type defaults to WORK. You can specify
     *         PhoneNumber or PhoneNumbers. We recommend that you use PhoneNumbers, which lets you specify the phone
     *         number type and multiple numbers.
     */
    public final String phoneNumber() {
        return phoneNumber;
    }

    /**
     * Returns true if the PhoneNumbers property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasPhoneNumbers() {
        return phoneNumbers != null && !(phoneNumbers instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of phone numbers for the contact.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasPhoneNumbers()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The list of phone numbers for the contact.
     */
    public final List<PhoneNumber> phoneNumbers() {
        return phoneNumbers;
    }

    /**
     * Returns true if the SipAddresses property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasSipAddresses() {
        return sipAddresses != null && !(sipAddresses instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of SIP addresses for the contact.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasSipAddresses()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The list of SIP addresses for the contact.
     */
    public final List<SipAddress> sipAddresses() {
        return sipAddresses;
    }

    /**
     * <p>
     * A unique, user-specified identifier for this request that ensures idempotency.
     * </p>
     * 
     * @return A unique, user-specified identifier for this request that ensures idempotency.
     */
    public final String clientRequestToken() {
        return clientRequestToken;
    }

    /**
     * Returns true if the Tags property was specified by the sender (it may be empty), or false if the sender did not
     * specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The tags to be added to the specified resource. Do not provide system tags.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasTags()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The tags to be added to the specified resource. Do not provide system tags.
     */
    public final List<Tag> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(displayName());
        hashCode = 31 * hashCode + Objects.hashCode(firstName());
        hashCode = 31 * hashCode + Objects.hashCode(lastName());
        hashCode = 31 * hashCode + Objects.hashCode(phoneNumber());
        hashCode = 31 * hashCode + Objects.hashCode(hasPhoneNumbers() ? phoneNumbers() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasSipAddresses() ? sipAddresses() : null);
        hashCode = 31 * hashCode + Objects.hashCode(clientRequestToken());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateContactRequest)) {
            return false;
        }
        CreateContactRequest other = (CreateContactRequest) obj;
        return Objects.equals(displayName(), other.displayName()) && Objects.equals(firstName(), other.firstName())
                && Objects.equals(lastName(), other.lastName()) && Objects.equals(phoneNumber(), other.phoneNumber())
                && hasPhoneNumbers() == other.hasPhoneNumbers() && Objects.equals(phoneNumbers(), other.phoneNumbers())
                && hasSipAddresses() == other.hasSipAddresses() && Objects.equals(sipAddresses(), other.sipAddresses())
                && Objects.equals(clientRequestToken(), other.clientRequestToken()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateContactRequest").add("DisplayName", displayName()).add("FirstName", firstName())
                .add("LastName", lastName()).add("PhoneNumber", phoneNumber() == null ? null : "*** Sensitive Data Redacted ***")
                .add("PhoneNumbers", hasPhoneNumbers() ? phoneNumbers() : null)
                .add("SipAddresses", hasSipAddresses() ? sipAddresses() : null).add("ClientRequestToken", clientRequestToken())
                .add("Tags", hasTags() ? tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DisplayName":
            return Optional.ofNullable(clazz.cast(displayName()));
        case "FirstName":
            return Optional.ofNullable(clazz.cast(firstName()));
        case "LastName":
            return Optional.ofNullable(clazz.cast(lastName()));
        case "PhoneNumber":
            return Optional.ofNullable(clazz.cast(phoneNumber()));
        case "PhoneNumbers":
            return Optional.ofNullable(clazz.cast(phoneNumbers()));
        case "SipAddresses":
            return Optional.ofNullable(clazz.cast(sipAddresses()));
        case "ClientRequestToken":
            return Optional.ofNullable(clazz.cast(clientRequestToken()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateContactRequest, T> g) {
        return obj -> g.apply((CreateContactRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends AlexaForBusinessRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateContactRequest> {
        /**
         * <p>
         * The name of the contact to display on the console.
         * </p>
         * 
         * @param displayName
         *        The name of the contact to display on the console.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder displayName(String displayName);

        /**
         * <p>
         * The first name of the contact that is used to call the contact on the device.
         * </p>
         * 
         * @param firstName
         *        The first name of the contact that is used to call the contact on the device.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder firstName(String firstName);

        /**
         * <p>
         * The last name of the contact that is used to call the contact on the device.
         * </p>
         * 
         * @param lastName
         *        The last name of the contact that is used to call the contact on the device.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastName(String lastName);

        /**
         * <p>
         * The phone number of the contact in E.164 format. The phone number type defaults to WORK. You can specify
         * PhoneNumber or PhoneNumbers. We recommend that you use PhoneNumbers, which lets you specify the phone number
         * type and multiple numbers.
         * </p>
         * 
         * @param phoneNumber
         *        The phone number of the contact in E.164 format. The phone number type defaults to WORK. You can
         *        specify PhoneNumber or PhoneNumbers. We recommend that you use PhoneNumbers, which lets you specify
         *        the phone number type and multiple numbers.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder phoneNumber(String phoneNumber);

        /**
         * <p>
         * The list of phone numbers for the contact.
         * </p>
         * 
         * @param phoneNumbers
         *        The list of phone numbers for the contact.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder phoneNumbers(Collection<PhoneNumber> phoneNumbers);

        /**
         * <p>
         * The list of phone numbers for the contact.
         * </p>
         * 
         * @param phoneNumbers
         *        The list of phone numbers for the contact.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder phoneNumbers(PhoneNumber... phoneNumbers);

        /**
         * <p>
         * The list of phone numbers for the contact.
         * </p>
         * This is a convenience that creates an instance of the {@link List<PhoneNumber>.Builder} avoiding the need to
         * create one manually via {@link List<PhoneNumber>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<PhoneNumber>.Builder#build()} is called immediately and its
         * result is passed to {@link #phoneNumbers(List<PhoneNumber>)}.
         * 
         * @param phoneNumbers
         *        a consumer that will call methods on {@link List<PhoneNumber>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #phoneNumbers(List<PhoneNumber>)
         */
        Builder phoneNumbers(Consumer<PhoneNumber.Builder>... phoneNumbers);

        /**
         * <p>
         * The list of SIP addresses for the contact.
         * </p>
         * 
         * @param sipAddresses
         *        The list of SIP addresses for the contact.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sipAddresses(Collection<SipAddress> sipAddresses);

        /**
         * <p>
         * The list of SIP addresses for the contact.
         * </p>
         * 
         * @param sipAddresses
         *        The list of SIP addresses for the contact.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sipAddresses(SipAddress... sipAddresses);

        /**
         * <p>
         * The list of SIP addresses for the contact.
         * </p>
         * This is a convenience that creates an instance of the {@link List<SipAddress>.Builder} avoiding the need to
         * create one manually via {@link List<SipAddress>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<SipAddress>.Builder#build()} is called immediately and its
         * result is passed to {@link #sipAddresses(List<SipAddress>)}.
         * 
         * @param sipAddresses
         *        a consumer that will call methods on {@link List<SipAddress>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #sipAddresses(List<SipAddress>)
         */
        Builder sipAddresses(Consumer<SipAddress.Builder>... sipAddresses);

        /**
         * <p>
         * A unique, user-specified identifier for this request that ensures idempotency.
         * </p>
         * 
         * @param clientRequestToken
         *        A unique, user-specified identifier for this request that ensures idempotency.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientRequestToken(String clientRequestToken);

        /**
         * <p>
         * The tags to be added to the specified resource. Do not provide system tags.
         * </p>
         * 
         * @param tags
         *        The tags to be added to the specified resource. Do not provide system tags.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * The tags to be added to the specified resource. Do not provide system tags.
         * </p>
         * 
         * @param tags
         *        The tags to be added to the specified resource. Do not provide system tags.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * <p>
         * The tags to be added to the specified resource. Do not provide system tags.
         * </p>
         * This is a convenience that creates an instance of the {@link List<Tag>.Builder} avoiding the need to create
         * one manually via {@link List<Tag>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Tag>.Builder#build()} is called immediately and its result
         * is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on {@link List<Tag>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(List<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends AlexaForBusinessRequest.BuilderImpl implements Builder {
        private String displayName;

        private String firstName;

        private String lastName;

        private String phoneNumber;

        private List<PhoneNumber> phoneNumbers = DefaultSdkAutoConstructList.getInstance();

        private List<SipAddress> sipAddresses = DefaultSdkAutoConstructList.getInstance();

        private String clientRequestToken;

        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateContactRequest model) {
            super(model);
            displayName(model.displayName);
            firstName(model.firstName);
            lastName(model.lastName);
            phoneNumber(model.phoneNumber);
            phoneNumbers(model.phoneNumbers);
            sipAddresses(model.sipAddresses);
            clientRequestToken(model.clientRequestToken);
            tags(model.tags);
        }

        public final String getDisplayName() {
            return displayName;
        }

        @Override
        public final Builder displayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        public final void setDisplayName(String displayName) {
            this.displayName = displayName;
        }

        public final String getFirstName() {
            return firstName;
        }

        @Override
        public final Builder firstName(String firstName) {
            this.firstName = firstName;
            return this;
        }

        public final void setFirstName(String firstName) {
            this.firstName = firstName;
        }

        public final String getLastName() {
            return lastName;
        }

        @Override
        public final Builder lastName(String lastName) {
            this.lastName = lastName;
            return this;
        }

        public final void setLastName(String lastName) {
            this.lastName = lastName;
        }

        public final String getPhoneNumber() {
            return phoneNumber;
        }

        @Override
        public final Builder phoneNumber(String phoneNumber) {
            this.phoneNumber = phoneNumber;
            return this;
        }

        public final void setPhoneNumber(String phoneNumber) {
            this.phoneNumber = phoneNumber;
        }

        public final List<PhoneNumber.Builder> getPhoneNumbers() {
            List<PhoneNumber.Builder> result = PhoneNumberListCopier.copyToBuilder(this.phoneNumbers);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder phoneNumbers(Collection<PhoneNumber> phoneNumbers) {
            this.phoneNumbers = PhoneNumberListCopier.copy(phoneNumbers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder phoneNumbers(PhoneNumber... phoneNumbers) {
            phoneNumbers(Arrays.asList(phoneNumbers));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder phoneNumbers(Consumer<PhoneNumber.Builder>... phoneNumbers) {
            phoneNumbers(Stream.of(phoneNumbers).map(c -> PhoneNumber.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setPhoneNumbers(Collection<PhoneNumber.BuilderImpl> phoneNumbers) {
            this.phoneNumbers = PhoneNumberListCopier.copyFromBuilder(phoneNumbers);
        }

        public final List<SipAddress.Builder> getSipAddresses() {
            List<SipAddress.Builder> result = SipAddressListCopier.copyToBuilder(this.sipAddresses);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder sipAddresses(Collection<SipAddress> sipAddresses) {
            this.sipAddresses = SipAddressListCopier.copy(sipAddresses);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sipAddresses(SipAddress... sipAddresses) {
            sipAddresses(Arrays.asList(sipAddresses));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sipAddresses(Consumer<SipAddress.Builder>... sipAddresses) {
            sipAddresses(Stream.of(sipAddresses).map(c -> SipAddress.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setSipAddresses(Collection<SipAddress.BuilderImpl> sipAddresses) {
            this.sipAddresses = SipAddressListCopier.copyFromBuilder(sipAddresses);
        }

        public final String getClientRequestToken() {
            return clientRequestToken;
        }

        @Override
        public final Builder clientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
            return this;
        }

        public final void setClientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateContactRequest build() {
            return new CreateContactRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
