/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.alexaforbusiness.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListSmartHomeAppliancesResponse extends AlexaForBusinessResponse implements
        ToCopyableBuilder<ListSmartHomeAppliancesResponse.Builder, ListSmartHomeAppliancesResponse> {
    private static final SdkField<List<SmartHomeAppliance>> SMART_HOME_APPLIANCES_FIELD = SdkField
            .<List<SmartHomeAppliance>> builder(MarshallingType.LIST)
            .memberName("SmartHomeAppliances")
            .getter(getter(ListSmartHomeAppliancesResponse::smartHomeAppliances))
            .setter(setter(Builder::smartHomeAppliances))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SmartHomeAppliances").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<SmartHomeAppliance> builder(MarshallingType.SDK_POJO)
                                            .constructor(SmartHomeAppliance::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListSmartHomeAppliancesResponse::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SMART_HOME_APPLIANCES_FIELD,
            NEXT_TOKEN_FIELD));

    private final List<SmartHomeAppliance> smartHomeAppliances;

    private final String nextToken;

    private ListSmartHomeAppliancesResponse(BuilderImpl builder) {
        super(builder);
        this.smartHomeAppliances = builder.smartHomeAppliances;
        this.nextToken = builder.nextToken;
    }

    /**
     * Returns true if the SmartHomeAppliances property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public final boolean hasSmartHomeAppliances() {
        return smartHomeAppliances != null && !(smartHomeAppliances instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The smart home appliances.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasSmartHomeAppliances()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The smart home appliances.
     */
    public final List<SmartHomeAppliance> smartHomeAppliances() {
        return smartHomeAppliances;
    }

    /**
     * <p>
     * The tokens used for pagination.
     * </p>
     * 
     * @return The tokens used for pagination.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasSmartHomeAppliances() ? smartHomeAppliances() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListSmartHomeAppliancesResponse)) {
            return false;
        }
        ListSmartHomeAppliancesResponse other = (ListSmartHomeAppliancesResponse) obj;
        return hasSmartHomeAppliances() == other.hasSmartHomeAppliances()
                && Objects.equals(smartHomeAppliances(), other.smartHomeAppliances())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListSmartHomeAppliancesResponse")
                .add("SmartHomeAppliances", hasSmartHomeAppliances() ? smartHomeAppliances() : null)
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SmartHomeAppliances":
            return Optional.ofNullable(clazz.cast(smartHomeAppliances()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListSmartHomeAppliancesResponse, T> g) {
        return obj -> g.apply((ListSmartHomeAppliancesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends AlexaForBusinessResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, ListSmartHomeAppliancesResponse> {
        /**
         * <p>
         * The smart home appliances.
         * </p>
         * 
         * @param smartHomeAppliances
         *        The smart home appliances.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder smartHomeAppliances(Collection<SmartHomeAppliance> smartHomeAppliances);

        /**
         * <p>
         * The smart home appliances.
         * </p>
         * 
         * @param smartHomeAppliances
         *        The smart home appliances.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder smartHomeAppliances(SmartHomeAppliance... smartHomeAppliances);

        /**
         * <p>
         * The smart home appliances.
         * </p>
         * This is a convenience that creates an instance of the {@link List<SmartHomeAppliance>.Builder} avoiding the
         * need to create one manually via {@link List<SmartHomeAppliance>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<SmartHomeAppliance>.Builder#build()} is called immediately
         * and its result is passed to {@link #smartHomeAppliances(List<SmartHomeAppliance>)}.
         * 
         * @param smartHomeAppliances
         *        a consumer that will call methods on {@link List<SmartHomeAppliance>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #smartHomeAppliances(List<SmartHomeAppliance>)
         */
        Builder smartHomeAppliances(Consumer<SmartHomeAppliance.Builder>... smartHomeAppliances);

        /**
         * <p>
         * The tokens used for pagination.
         * </p>
         * 
         * @param nextToken
         *        The tokens used for pagination.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends AlexaForBusinessResponse.BuilderImpl implements Builder {
        private List<SmartHomeAppliance> smartHomeAppliances = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListSmartHomeAppliancesResponse model) {
            super(model);
            smartHomeAppliances(model.smartHomeAppliances);
            nextToken(model.nextToken);
        }

        public final List<SmartHomeAppliance.Builder> getSmartHomeAppliances() {
            List<SmartHomeAppliance.Builder> result = SmartHomeApplianceListCopier.copyToBuilder(this.smartHomeAppliances);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder smartHomeAppliances(Collection<SmartHomeAppliance> smartHomeAppliances) {
            this.smartHomeAppliances = SmartHomeApplianceListCopier.copy(smartHomeAppliances);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder smartHomeAppliances(SmartHomeAppliance... smartHomeAppliances) {
            smartHomeAppliances(Arrays.asList(smartHomeAppliances));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder smartHomeAppliances(Consumer<SmartHomeAppliance.Builder>... smartHomeAppliances) {
            smartHomeAppliances(Stream.of(smartHomeAppliances).map(c -> SmartHomeAppliance.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setSmartHomeAppliances(Collection<SmartHomeAppliance.BuilderImpl> smartHomeAppliances) {
            this.smartHomeAppliances = SmartHomeApplianceListCopier.copyFromBuilder(smartHomeAppliances);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListSmartHomeAppliancesResponse build() {
            return new ListSmartHomeAppliancesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
