/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.alexaforbusiness.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetSkillGroupResponse extends AlexaForBusinessResponse implements
        ToCopyableBuilder<GetSkillGroupResponse.Builder, GetSkillGroupResponse> {
    private static final SdkField<SkillGroup> SKILL_GROUP_FIELD = SdkField.<SkillGroup> builder(MarshallingType.SDK_POJO)
            .memberName("SkillGroup").getter(getter(GetSkillGroupResponse::skillGroup)).setter(setter(Builder::skillGroup))
            .constructor(SkillGroup::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SkillGroup").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SKILL_GROUP_FIELD));

    private final SkillGroup skillGroup;

    private GetSkillGroupResponse(BuilderImpl builder) {
        super(builder);
        this.skillGroup = builder.skillGroup;
    }

    /**
     * <p>
     * The details of the skill group requested. Required.
     * </p>
     * 
     * @return The details of the skill group requested. Required.
     */
    public final SkillGroup skillGroup() {
        return skillGroup;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(skillGroup());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetSkillGroupResponse)) {
            return false;
        }
        GetSkillGroupResponse other = (GetSkillGroupResponse) obj;
        return Objects.equals(skillGroup(), other.skillGroup());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetSkillGroupResponse").add("SkillGroup", skillGroup()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SkillGroup":
            return Optional.ofNullable(clazz.cast(skillGroup()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetSkillGroupResponse, T> g) {
        return obj -> g.apply((GetSkillGroupResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends AlexaForBusinessResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetSkillGroupResponse> {
        /**
         * <p>
         * The details of the skill group requested. Required.
         * </p>
         * 
         * @param skillGroup
         *        The details of the skill group requested. Required.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder skillGroup(SkillGroup skillGroup);

        /**
         * <p>
         * The details of the skill group requested. Required.
         * </p>
         * This is a convenience that creates an instance of the {@link SkillGroup.Builder} avoiding the need to create
         * one manually via {@link SkillGroup#builder()}.
         *
         * When the {@link Consumer} completes, {@link SkillGroup.Builder#build()} is called immediately and its result
         * is passed to {@link #skillGroup(SkillGroup)}.
         * 
         * @param skillGroup
         *        a consumer that will call methods on {@link SkillGroup.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #skillGroup(SkillGroup)
         */
        default Builder skillGroup(Consumer<SkillGroup.Builder> skillGroup) {
            return skillGroup(SkillGroup.builder().applyMutation(skillGroup).build());
        }
    }

    static final class BuilderImpl extends AlexaForBusinessResponse.BuilderImpl implements Builder {
        private SkillGroup skillGroup;

        private BuilderImpl() {
        }

        private BuilderImpl(GetSkillGroupResponse model) {
            super(model);
            skillGroup(model.skillGroup);
        }

        public final SkillGroup.Builder getSkillGroup() {
            return skillGroup != null ? skillGroup.toBuilder() : null;
        }

        public final void setSkillGroup(SkillGroup.BuilderImpl skillGroup) {
            this.skillGroup = skillGroup != null ? skillGroup.build() : null;
        }

        @Override
        @Transient
        public final Builder skillGroup(SkillGroup skillGroup) {
            this.skillGroup = skillGroup;
            return this;
        }

        @Override
        public GetSkillGroupResponse build() {
            return new GetSkillGroupResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
