/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.alexaforbusiness.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.alexaforbusiness.model.AlexaForBusinessResponse;
import software.amazon.awssdk.services.alexaforbusiness.model.SkillSummary;
import software.amazon.awssdk.services.alexaforbusiness.model.SkillSummaryListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListSkillsResponse
extends AlexaForBusinessResponse
implements ToCopyableBuilder<Builder, ListSkillsResponse> {
    private static final SdkField<List<SkillSummary>> SKILL_SUMMARIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("SkillSummaries").getter(ListSkillsResponse.getter(ListSkillsResponse::skillSummaries)).setter(ListSkillsResponse.setter(Builder::skillSummaries)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SkillSummaries").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(SkillSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListSkillsResponse.getter(ListSkillsResponse::nextToken)).setter(ListSkillsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SKILL_SUMMARIES_FIELD, NEXT_TOKEN_FIELD));
    private final List<SkillSummary> skillSummaries;
    private final String nextToken;

    private ListSkillsResponse(BuilderImpl builder) {
        super(builder);
        this.skillSummaries = builder.skillSummaries;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasSkillSummaries() {
        return this.skillSummaries != null && !(this.skillSummaries instanceof SdkAutoConstructList);
    }

    public final List<SkillSummary> skillSummaries() {
        return this.skillSummaries;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSkillSummaries() ? this.skillSummaries() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListSkillsResponse)) {
            return false;
        }
        ListSkillsResponse other = (ListSkillsResponse)((Object)obj);
        return this.hasSkillSummaries() == other.hasSkillSummaries() && Objects.equals(this.skillSummaries(), other.skillSummaries()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListSkillsResponse").add("SkillSummaries", this.hasSkillSummaries() ? this.skillSummaries() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "SkillSummaries": {
                return Optional.ofNullable(clazz.cast(this.skillSummaries()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListSkillsResponse, T> g) {
        return obj -> g.apply((ListSkillsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends AlexaForBusinessResponse.BuilderImpl
    implements Builder {
        private List<SkillSummary> skillSummaries = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListSkillsResponse model) {
            super(model);
            this.skillSummaries(model.skillSummaries);
            this.nextToken(model.nextToken);
        }

        public final List<SkillSummary.Builder> getSkillSummaries() {
            List<SkillSummary.Builder> result = SkillSummaryListCopier.copyToBuilder(this.skillSummaries);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSkillSummaries(Collection<SkillSummary.BuilderImpl> skillSummaries) {
            this.skillSummaries = SkillSummaryListCopier.copyFromBuilder(skillSummaries);
        }

        @Override
        @Transient
        public final Builder skillSummaries(Collection<SkillSummary> skillSummaries) {
            this.skillSummaries = SkillSummaryListCopier.copy(skillSummaries);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder skillSummaries(SkillSummary ... skillSummaries) {
            this.skillSummaries(Arrays.asList(skillSummaries));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder skillSummaries(Consumer<SkillSummary.Builder> ... skillSummaries) {
            this.skillSummaries(Stream.of(skillSummaries).map(c -> (SkillSummary)((SkillSummary.Builder)SkillSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        @Transient
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListSkillsResponse build() {
            return new ListSkillsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends AlexaForBusinessResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListSkillsResponse> {
        public Builder skillSummaries(Collection<SkillSummary> var1);

        public Builder skillSummaries(SkillSummary ... var1);

        public Builder skillSummaries(Consumer<SkillSummary.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

