/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.alexaforbusiness.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateProfileRequest extends AlexaForBusinessRequest implements
        ToCopyableBuilder<UpdateProfileRequest.Builder, UpdateProfileRequest> {
    private static final SdkField<String> PROFILE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ProfileArn").getter(getter(UpdateProfileRequest::profileArn)).setter(setter(Builder::profileArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProfileArn").build()).build();

    private static final SdkField<String> PROFILE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ProfileName").getter(getter(UpdateProfileRequest::profileName)).setter(setter(Builder::profileName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProfileName").build()).build();

    private static final SdkField<Boolean> IS_DEFAULT_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("IsDefault").getter(getter(UpdateProfileRequest::isDefault)).setter(setter(Builder::isDefault))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IsDefault").build()).build();

    private static final SdkField<String> TIMEZONE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Timezone").getter(getter(UpdateProfileRequest::timezone)).setter(setter(Builder::timezone))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Timezone").build()).build();

    private static final SdkField<String> ADDRESS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Address")
            .getter(getter(UpdateProfileRequest::address)).setter(setter(Builder::address))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Address").build()).build();

    private static final SdkField<String> DISTANCE_UNIT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DistanceUnit").getter(getter(UpdateProfileRequest::distanceUnitAsString))
            .setter(setter(Builder::distanceUnit))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DistanceUnit").build()).build();

    private static final SdkField<String> TEMPERATURE_UNIT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TemperatureUnit").getter(getter(UpdateProfileRequest::temperatureUnitAsString))
            .setter(setter(Builder::temperatureUnit))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TemperatureUnit").build()).build();

    private static final SdkField<String> WAKE_WORD_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("WakeWord").getter(getter(UpdateProfileRequest::wakeWordAsString)).setter(setter(Builder::wakeWord))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WakeWord").build()).build();

    private static final SdkField<String> LOCALE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Locale")
            .getter(getter(UpdateProfileRequest::locale)).setter(setter(Builder::locale))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Locale").build()).build();

    private static final SdkField<Boolean> SETUP_MODE_DISABLED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("SetupModeDisabled").getter(getter(UpdateProfileRequest::setupModeDisabled))
            .setter(setter(Builder::setupModeDisabled))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SetupModeDisabled").build()).build();

    private static final SdkField<Integer> MAX_VOLUME_LIMIT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxVolumeLimit").getter(getter(UpdateProfileRequest::maxVolumeLimit))
            .setter(setter(Builder::maxVolumeLimit))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxVolumeLimit").build()).build();

    private static final SdkField<Boolean> PSTN_ENABLED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("PSTNEnabled").getter(getter(UpdateProfileRequest::pstnEnabled)).setter(setter(Builder::pstnEnabled))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PSTNEnabled").build()).build();

    private static final SdkField<Boolean> DATA_RETENTION_OPT_IN_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("DataRetentionOptIn").getter(getter(UpdateProfileRequest::dataRetentionOptIn))
            .setter(setter(Builder::dataRetentionOptIn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataRetentionOptIn").build())
            .build();

    private static final SdkField<UpdateMeetingRoomConfiguration> MEETING_ROOM_CONFIGURATION_FIELD = SdkField
            .<UpdateMeetingRoomConfiguration> builder(MarshallingType.SDK_POJO).memberName("MeetingRoomConfiguration")
            .getter(getter(UpdateProfileRequest::meetingRoomConfiguration)).setter(setter(Builder::meetingRoomConfiguration))
            .constructor(UpdateMeetingRoomConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MeetingRoomConfiguration").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PROFILE_ARN_FIELD,
            PROFILE_NAME_FIELD, IS_DEFAULT_FIELD, TIMEZONE_FIELD, ADDRESS_FIELD, DISTANCE_UNIT_FIELD, TEMPERATURE_UNIT_FIELD,
            WAKE_WORD_FIELD, LOCALE_FIELD, SETUP_MODE_DISABLED_FIELD, MAX_VOLUME_LIMIT_FIELD, PSTN_ENABLED_FIELD,
            DATA_RETENTION_OPT_IN_FIELD, MEETING_ROOM_CONFIGURATION_FIELD));

    private final String profileArn;

    private final String profileName;

    private final Boolean isDefault;

    private final String timezone;

    private final String address;

    private final String distanceUnit;

    private final String temperatureUnit;

    private final String wakeWord;

    private final String locale;

    private final Boolean setupModeDisabled;

    private final Integer maxVolumeLimit;

    private final Boolean pstnEnabled;

    private final Boolean dataRetentionOptIn;

    private final UpdateMeetingRoomConfiguration meetingRoomConfiguration;

    private UpdateProfileRequest(BuilderImpl builder) {
        super(builder);
        this.profileArn = builder.profileArn;
        this.profileName = builder.profileName;
        this.isDefault = builder.isDefault;
        this.timezone = builder.timezone;
        this.address = builder.address;
        this.distanceUnit = builder.distanceUnit;
        this.temperatureUnit = builder.temperatureUnit;
        this.wakeWord = builder.wakeWord;
        this.locale = builder.locale;
        this.setupModeDisabled = builder.setupModeDisabled;
        this.maxVolumeLimit = builder.maxVolumeLimit;
        this.pstnEnabled = builder.pstnEnabled;
        this.dataRetentionOptIn = builder.dataRetentionOptIn;
        this.meetingRoomConfiguration = builder.meetingRoomConfiguration;
    }

    /**
     * <p>
     * The ARN of the room profile to update. Required.
     * </p>
     * 
     * @return The ARN of the room profile to update. Required.
     */
    public final String profileArn() {
        return profileArn;
    }

    /**
     * <p>
     * The updated name for the room profile.
     * </p>
     * 
     * @return The updated name for the room profile.
     */
    public final String profileName() {
        return profileName;
    }

    /**
     * <p>
     * Sets the profile as default if selected. If this is missing, no update is done to the default status.
     * </p>
     * 
     * @return Sets the profile as default if selected. If this is missing, no update is done to the default status.
     */
    public final Boolean isDefault() {
        return isDefault;
    }

    /**
     * <p>
     * The updated timezone for the room profile.
     * </p>
     * 
     * @return The updated timezone for the room profile.
     */
    public final String timezone() {
        return timezone;
    }

    /**
     * <p>
     * The updated address for the room profile.
     * </p>
     * 
     * @return The updated address for the room profile.
     */
    public final String address() {
        return address;
    }

    /**
     * <p>
     * The updated distance unit for the room profile.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #distanceUnit} will
     * return {@link DistanceUnit#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #distanceUnitAsString}.
     * </p>
     * 
     * @return The updated distance unit for the room profile.
     * @see DistanceUnit
     */
    public final DistanceUnit distanceUnit() {
        return DistanceUnit.fromValue(distanceUnit);
    }

    /**
     * <p>
     * The updated distance unit for the room profile.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #distanceUnit} will
     * return {@link DistanceUnit#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #distanceUnitAsString}.
     * </p>
     * 
     * @return The updated distance unit for the room profile.
     * @see DistanceUnit
     */
    public final String distanceUnitAsString() {
        return distanceUnit;
    }

    /**
     * <p>
     * The updated temperature unit for the room profile.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #temperatureUnit}
     * will return {@link TemperatureUnit#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #temperatureUnitAsString}.
     * </p>
     * 
     * @return The updated temperature unit for the room profile.
     * @see TemperatureUnit
     */
    public final TemperatureUnit temperatureUnit() {
        return TemperatureUnit.fromValue(temperatureUnit);
    }

    /**
     * <p>
     * The updated temperature unit for the room profile.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #temperatureUnit}
     * will return {@link TemperatureUnit#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #temperatureUnitAsString}.
     * </p>
     * 
     * @return The updated temperature unit for the room profile.
     * @see TemperatureUnit
     */
    public final String temperatureUnitAsString() {
        return temperatureUnit;
    }

    /**
     * <p>
     * The updated wake word for the room profile.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #wakeWord} will
     * return {@link WakeWord#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #wakeWordAsString}.
     * </p>
     * 
     * @return The updated wake word for the room profile.
     * @see WakeWord
     */
    public final WakeWord wakeWord() {
        return WakeWord.fromValue(wakeWord);
    }

    /**
     * <p>
     * The updated wake word for the room profile.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #wakeWord} will
     * return {@link WakeWord#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #wakeWordAsString}.
     * </p>
     * 
     * @return The updated wake word for the room profile.
     * @see WakeWord
     */
    public final String wakeWordAsString() {
        return wakeWord;
    }

    /**
     * <p>
     * The updated locale for the room profile. (This is currently only available to a limited preview audience.)
     * </p>
     * 
     * @return The updated locale for the room profile. (This is currently only available to a limited preview
     *         audience.)
     */
    public final String locale() {
        return locale;
    }

    /**
     * <p>
     * Whether the setup mode of the profile is enabled.
     * </p>
     * 
     * @return Whether the setup mode of the profile is enabled.
     */
    public final Boolean setupModeDisabled() {
        return setupModeDisabled;
    }

    /**
     * <p>
     * The updated maximum volume limit for the room profile.
     * </p>
     * 
     * @return The updated maximum volume limit for the room profile.
     */
    public final Integer maxVolumeLimit() {
        return maxVolumeLimit;
    }

    /**
     * <p>
     * Whether the PSTN setting of the room profile is enabled.
     * </p>
     * 
     * @return Whether the PSTN setting of the room profile is enabled.
     */
    public final Boolean pstnEnabled() {
        return pstnEnabled;
    }

    /**
     * <p>
     * Whether data retention of the profile is enabled.
     * </p>
     * 
     * @return Whether data retention of the profile is enabled.
     */
    public final Boolean dataRetentionOptIn() {
        return dataRetentionOptIn;
    }

    /**
     * <p>
     * The updated meeting room settings of a room profile.
     * </p>
     * 
     * @return The updated meeting room settings of a room profile.
     */
    public final UpdateMeetingRoomConfiguration meetingRoomConfiguration() {
        return meetingRoomConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(profileArn());
        hashCode = 31 * hashCode + Objects.hashCode(profileName());
        hashCode = 31 * hashCode + Objects.hashCode(isDefault());
        hashCode = 31 * hashCode + Objects.hashCode(timezone());
        hashCode = 31 * hashCode + Objects.hashCode(address());
        hashCode = 31 * hashCode + Objects.hashCode(distanceUnitAsString());
        hashCode = 31 * hashCode + Objects.hashCode(temperatureUnitAsString());
        hashCode = 31 * hashCode + Objects.hashCode(wakeWordAsString());
        hashCode = 31 * hashCode + Objects.hashCode(locale());
        hashCode = 31 * hashCode + Objects.hashCode(setupModeDisabled());
        hashCode = 31 * hashCode + Objects.hashCode(maxVolumeLimit());
        hashCode = 31 * hashCode + Objects.hashCode(pstnEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(dataRetentionOptIn());
        hashCode = 31 * hashCode + Objects.hashCode(meetingRoomConfiguration());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateProfileRequest)) {
            return false;
        }
        UpdateProfileRequest other = (UpdateProfileRequest) obj;
        return Objects.equals(profileArn(), other.profileArn()) && Objects.equals(profileName(), other.profileName())
                && Objects.equals(isDefault(), other.isDefault()) && Objects.equals(timezone(), other.timezone())
                && Objects.equals(address(), other.address())
                && Objects.equals(distanceUnitAsString(), other.distanceUnitAsString())
                && Objects.equals(temperatureUnitAsString(), other.temperatureUnitAsString())
                && Objects.equals(wakeWordAsString(), other.wakeWordAsString()) && Objects.equals(locale(), other.locale())
                && Objects.equals(setupModeDisabled(), other.setupModeDisabled())
                && Objects.equals(maxVolumeLimit(), other.maxVolumeLimit()) && Objects.equals(pstnEnabled(), other.pstnEnabled())
                && Objects.equals(dataRetentionOptIn(), other.dataRetentionOptIn())
                && Objects.equals(meetingRoomConfiguration(), other.meetingRoomConfiguration());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateProfileRequest").add("ProfileArn", profileArn()).add("ProfileName", profileName())
                .add("IsDefault", isDefault()).add("Timezone", timezone()).add("Address", address())
                .add("DistanceUnit", distanceUnitAsString()).add("TemperatureUnit", temperatureUnitAsString())
                .add("WakeWord", wakeWordAsString()).add("Locale", locale()).add("SetupModeDisabled", setupModeDisabled())
                .add("MaxVolumeLimit", maxVolumeLimit()).add("PSTNEnabled", pstnEnabled())
                .add("DataRetentionOptIn", dataRetentionOptIn()).add("MeetingRoomConfiguration", meetingRoomConfiguration())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ProfileArn":
            return Optional.ofNullable(clazz.cast(profileArn()));
        case "ProfileName":
            return Optional.ofNullable(clazz.cast(profileName()));
        case "IsDefault":
            return Optional.ofNullable(clazz.cast(isDefault()));
        case "Timezone":
            return Optional.ofNullable(clazz.cast(timezone()));
        case "Address":
            return Optional.ofNullable(clazz.cast(address()));
        case "DistanceUnit":
            return Optional.ofNullable(clazz.cast(distanceUnitAsString()));
        case "TemperatureUnit":
            return Optional.ofNullable(clazz.cast(temperatureUnitAsString()));
        case "WakeWord":
            return Optional.ofNullable(clazz.cast(wakeWordAsString()));
        case "Locale":
            return Optional.ofNullable(clazz.cast(locale()));
        case "SetupModeDisabled":
            return Optional.ofNullable(clazz.cast(setupModeDisabled()));
        case "MaxVolumeLimit":
            return Optional.ofNullable(clazz.cast(maxVolumeLimit()));
        case "PSTNEnabled":
            return Optional.ofNullable(clazz.cast(pstnEnabled()));
        case "DataRetentionOptIn":
            return Optional.ofNullable(clazz.cast(dataRetentionOptIn()));
        case "MeetingRoomConfiguration":
            return Optional.ofNullable(clazz.cast(meetingRoomConfiguration()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateProfileRequest, T> g) {
        return obj -> g.apply((UpdateProfileRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends AlexaForBusinessRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateProfileRequest> {
        /**
         * <p>
         * The ARN of the room profile to update. Required.
         * </p>
         * 
         * @param profileArn
         *        The ARN of the room profile to update. Required.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder profileArn(String profileArn);

        /**
         * <p>
         * The updated name for the room profile.
         * </p>
         * 
         * @param profileName
         *        The updated name for the room profile.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder profileName(String profileName);

        /**
         * <p>
         * Sets the profile as default if selected. If this is missing, no update is done to the default status.
         * </p>
         * 
         * @param isDefault
         *        Sets the profile as default if selected. If this is missing, no update is done to the default status.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder isDefault(Boolean isDefault);

        /**
         * <p>
         * The updated timezone for the room profile.
         * </p>
         * 
         * @param timezone
         *        The updated timezone for the room profile.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder timezone(String timezone);

        /**
         * <p>
         * The updated address for the room profile.
         * </p>
         * 
         * @param address
         *        The updated address for the room profile.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder address(String address);

        /**
         * <p>
         * The updated distance unit for the room profile.
         * </p>
         * 
         * @param distanceUnit
         *        The updated distance unit for the room profile.
         * @see DistanceUnit
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DistanceUnit
         */
        Builder distanceUnit(String distanceUnit);

        /**
         * <p>
         * The updated distance unit for the room profile.
         * </p>
         * 
         * @param distanceUnit
         *        The updated distance unit for the room profile.
         * @see DistanceUnit
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DistanceUnit
         */
        Builder distanceUnit(DistanceUnit distanceUnit);

        /**
         * <p>
         * The updated temperature unit for the room profile.
         * </p>
         * 
         * @param temperatureUnit
         *        The updated temperature unit for the room profile.
         * @see TemperatureUnit
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TemperatureUnit
         */
        Builder temperatureUnit(String temperatureUnit);

        /**
         * <p>
         * The updated temperature unit for the room profile.
         * </p>
         * 
         * @param temperatureUnit
         *        The updated temperature unit for the room profile.
         * @see TemperatureUnit
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TemperatureUnit
         */
        Builder temperatureUnit(TemperatureUnit temperatureUnit);

        /**
         * <p>
         * The updated wake word for the room profile.
         * </p>
         * 
         * @param wakeWord
         *        The updated wake word for the room profile.
         * @see WakeWord
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see WakeWord
         */
        Builder wakeWord(String wakeWord);

        /**
         * <p>
         * The updated wake word for the room profile.
         * </p>
         * 
         * @param wakeWord
         *        The updated wake word for the room profile.
         * @see WakeWord
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see WakeWord
         */
        Builder wakeWord(WakeWord wakeWord);

        /**
         * <p>
         * The updated locale for the room profile. (This is currently only available to a limited preview audience.)
         * </p>
         * 
         * @param locale
         *        The updated locale for the room profile. (This is currently only available to a limited preview
         *        audience.)
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder locale(String locale);

        /**
         * <p>
         * Whether the setup mode of the profile is enabled.
         * </p>
         * 
         * @param setupModeDisabled
         *        Whether the setup mode of the profile is enabled.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder setupModeDisabled(Boolean setupModeDisabled);

        /**
         * <p>
         * The updated maximum volume limit for the room profile.
         * </p>
         * 
         * @param maxVolumeLimit
         *        The updated maximum volume limit for the room profile.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxVolumeLimit(Integer maxVolumeLimit);

        /**
         * <p>
         * Whether the PSTN setting of the room profile is enabled.
         * </p>
         * 
         * @param pstnEnabled
         *        Whether the PSTN setting of the room profile is enabled.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pstnEnabled(Boolean pstnEnabled);

        /**
         * <p>
         * Whether data retention of the profile is enabled.
         * </p>
         * 
         * @param dataRetentionOptIn
         *        Whether data retention of the profile is enabled.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataRetentionOptIn(Boolean dataRetentionOptIn);

        /**
         * <p>
         * The updated meeting room settings of a room profile.
         * </p>
         * 
         * @param meetingRoomConfiguration
         *        The updated meeting room settings of a room profile.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder meetingRoomConfiguration(UpdateMeetingRoomConfiguration meetingRoomConfiguration);

        /**
         * <p>
         * The updated meeting room settings of a room profile.
         * </p>
         * This is a convenience that creates an instance of the {@link UpdateMeetingRoomConfiguration.Builder} avoiding
         * the need to create one manually via {@link UpdateMeetingRoomConfiguration#builder()}.
         *
         * When the {@link Consumer} completes, {@link UpdateMeetingRoomConfiguration.Builder#build()} is called
         * immediately and its result is passed to {@link #meetingRoomConfiguration(UpdateMeetingRoomConfiguration)}.
         * 
         * @param meetingRoomConfiguration
         *        a consumer that will call methods on {@link UpdateMeetingRoomConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #meetingRoomConfiguration(UpdateMeetingRoomConfiguration)
         */
        default Builder meetingRoomConfiguration(Consumer<UpdateMeetingRoomConfiguration.Builder> meetingRoomConfiguration) {
            return meetingRoomConfiguration(UpdateMeetingRoomConfiguration.builder().applyMutation(meetingRoomConfiguration)
                    .build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends AlexaForBusinessRequest.BuilderImpl implements Builder {
        private String profileArn;

        private String profileName;

        private Boolean isDefault;

        private String timezone;

        private String address;

        private String distanceUnit;

        private String temperatureUnit;

        private String wakeWord;

        private String locale;

        private Boolean setupModeDisabled;

        private Integer maxVolumeLimit;

        private Boolean pstnEnabled;

        private Boolean dataRetentionOptIn;

        private UpdateMeetingRoomConfiguration meetingRoomConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateProfileRequest model) {
            super(model);
            profileArn(model.profileArn);
            profileName(model.profileName);
            isDefault(model.isDefault);
            timezone(model.timezone);
            address(model.address);
            distanceUnit(model.distanceUnit);
            temperatureUnit(model.temperatureUnit);
            wakeWord(model.wakeWord);
            locale(model.locale);
            setupModeDisabled(model.setupModeDisabled);
            maxVolumeLimit(model.maxVolumeLimit);
            pstnEnabled(model.pstnEnabled);
            dataRetentionOptIn(model.dataRetentionOptIn);
            meetingRoomConfiguration(model.meetingRoomConfiguration);
        }

        public final String getProfileArn() {
            return profileArn;
        }

        public final void setProfileArn(String profileArn) {
            this.profileArn = profileArn;
        }

        @Override
        @Transient
        public final Builder profileArn(String profileArn) {
            this.profileArn = profileArn;
            return this;
        }

        public final String getProfileName() {
            return profileName;
        }

        public final void setProfileName(String profileName) {
            this.profileName = profileName;
        }

        @Override
        @Transient
        public final Builder profileName(String profileName) {
            this.profileName = profileName;
            return this;
        }

        public final Boolean getIsDefault() {
            return isDefault;
        }

        public final void setIsDefault(Boolean isDefault) {
            this.isDefault = isDefault;
        }

        @Override
        @Transient
        public final Builder isDefault(Boolean isDefault) {
            this.isDefault = isDefault;
            return this;
        }

        public final String getTimezone() {
            return timezone;
        }

        public final void setTimezone(String timezone) {
            this.timezone = timezone;
        }

        @Override
        @Transient
        public final Builder timezone(String timezone) {
            this.timezone = timezone;
            return this;
        }

        public final String getAddress() {
            return address;
        }

        public final void setAddress(String address) {
            this.address = address;
        }

        @Override
        @Transient
        public final Builder address(String address) {
            this.address = address;
            return this;
        }

        public final String getDistanceUnit() {
            return distanceUnit;
        }

        public final void setDistanceUnit(String distanceUnit) {
            this.distanceUnit = distanceUnit;
        }

        @Override
        @Transient
        public final Builder distanceUnit(String distanceUnit) {
            this.distanceUnit = distanceUnit;
            return this;
        }

        @Override
        @Transient
        public final Builder distanceUnit(DistanceUnit distanceUnit) {
            this.distanceUnit(distanceUnit == null ? null : distanceUnit.toString());
            return this;
        }

        public final String getTemperatureUnit() {
            return temperatureUnit;
        }

        public final void setTemperatureUnit(String temperatureUnit) {
            this.temperatureUnit = temperatureUnit;
        }

        @Override
        @Transient
        public final Builder temperatureUnit(String temperatureUnit) {
            this.temperatureUnit = temperatureUnit;
            return this;
        }

        @Override
        @Transient
        public final Builder temperatureUnit(TemperatureUnit temperatureUnit) {
            this.temperatureUnit(temperatureUnit == null ? null : temperatureUnit.toString());
            return this;
        }

        public final String getWakeWord() {
            return wakeWord;
        }

        public final void setWakeWord(String wakeWord) {
            this.wakeWord = wakeWord;
        }

        @Override
        @Transient
        public final Builder wakeWord(String wakeWord) {
            this.wakeWord = wakeWord;
            return this;
        }

        @Override
        @Transient
        public final Builder wakeWord(WakeWord wakeWord) {
            this.wakeWord(wakeWord == null ? null : wakeWord.toString());
            return this;
        }

        public final String getLocale() {
            return locale;
        }

        public final void setLocale(String locale) {
            this.locale = locale;
        }

        @Override
        @Transient
        public final Builder locale(String locale) {
            this.locale = locale;
            return this;
        }

        public final Boolean getSetupModeDisabled() {
            return setupModeDisabled;
        }

        public final void setSetupModeDisabled(Boolean setupModeDisabled) {
            this.setupModeDisabled = setupModeDisabled;
        }

        @Override
        @Transient
        public final Builder setupModeDisabled(Boolean setupModeDisabled) {
            this.setupModeDisabled = setupModeDisabled;
            return this;
        }

        public final Integer getMaxVolumeLimit() {
            return maxVolumeLimit;
        }

        public final void setMaxVolumeLimit(Integer maxVolumeLimit) {
            this.maxVolumeLimit = maxVolumeLimit;
        }

        @Override
        @Transient
        public final Builder maxVolumeLimit(Integer maxVolumeLimit) {
            this.maxVolumeLimit = maxVolumeLimit;
            return this;
        }

        public final Boolean getPstnEnabled() {
            return pstnEnabled;
        }

        public final void setPstnEnabled(Boolean pstnEnabled) {
            this.pstnEnabled = pstnEnabled;
        }

        @Override
        @Transient
        public final Builder pstnEnabled(Boolean pstnEnabled) {
            this.pstnEnabled = pstnEnabled;
            return this;
        }

        public final Boolean getDataRetentionOptIn() {
            return dataRetentionOptIn;
        }

        public final void setDataRetentionOptIn(Boolean dataRetentionOptIn) {
            this.dataRetentionOptIn = dataRetentionOptIn;
        }

        @Override
        @Transient
        public final Builder dataRetentionOptIn(Boolean dataRetentionOptIn) {
            this.dataRetentionOptIn = dataRetentionOptIn;
            return this;
        }

        public final UpdateMeetingRoomConfiguration.Builder getMeetingRoomConfiguration() {
            return meetingRoomConfiguration != null ? meetingRoomConfiguration.toBuilder() : null;
        }

        public final void setMeetingRoomConfiguration(UpdateMeetingRoomConfiguration.BuilderImpl meetingRoomConfiguration) {
            this.meetingRoomConfiguration = meetingRoomConfiguration != null ? meetingRoomConfiguration.build() : null;
        }

        @Override
        @Transient
        public final Builder meetingRoomConfiguration(UpdateMeetingRoomConfiguration meetingRoomConfiguration) {
            this.meetingRoomConfiguration = meetingRoomConfiguration;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateProfileRequest build() {
            return new UpdateProfileRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
