/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.alexaforbusiness.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The detailed information about an Alexa skill.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SkillsStoreSkill implements SdkPojo, Serializable,
        ToCopyableBuilder<SkillsStoreSkill.Builder, SkillsStoreSkill> {
    private static final SdkField<String> SKILL_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SkillId").getter(getter(SkillsStoreSkill::skillId)).setter(setter(Builder::skillId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SkillId").build()).build();

    private static final SdkField<String> SKILL_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SkillName").getter(getter(SkillsStoreSkill::skillName)).setter(setter(Builder::skillName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SkillName").build()).build();

    private static final SdkField<String> SHORT_DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ShortDescription").getter(getter(SkillsStoreSkill::shortDescription))
            .setter(setter(Builder::shortDescription))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ShortDescription").build()).build();

    private static final SdkField<String> ICON_URL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("IconUrl").getter(getter(SkillsStoreSkill::iconUrl)).setter(setter(Builder::iconUrl))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IconUrl").build()).build();

    private static final SdkField<List<String>> SAMPLE_UTTERANCES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("SampleUtterances")
            .getter(getter(SkillsStoreSkill::sampleUtterances))
            .setter(setter(Builder::sampleUtterances))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SampleUtterances").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<SkillDetails> SKILL_DETAILS_FIELD = SdkField.<SkillDetails> builder(MarshallingType.SDK_POJO)
            .memberName("SkillDetails").getter(getter(SkillsStoreSkill::skillDetails)).setter(setter(Builder::skillDetails))
            .constructor(SkillDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SkillDetails").build()).build();

    private static final SdkField<Boolean> SUPPORTS_LINKING_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("SupportsLinking").getter(getter(SkillsStoreSkill::supportsLinking))
            .setter(setter(Builder::supportsLinking))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SupportsLinking").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SKILL_ID_FIELD,
            SKILL_NAME_FIELD, SHORT_DESCRIPTION_FIELD, ICON_URL_FIELD, SAMPLE_UTTERANCES_FIELD, SKILL_DETAILS_FIELD,
            SUPPORTS_LINKING_FIELD));

    private static final long serialVersionUID = 1L;

    private final String skillId;

    private final String skillName;

    private final String shortDescription;

    private final String iconUrl;

    private final List<String> sampleUtterances;

    private final SkillDetails skillDetails;

    private final Boolean supportsLinking;

    private SkillsStoreSkill(BuilderImpl builder) {
        this.skillId = builder.skillId;
        this.skillName = builder.skillName;
        this.shortDescription = builder.shortDescription;
        this.iconUrl = builder.iconUrl;
        this.sampleUtterances = builder.sampleUtterances;
        this.skillDetails = builder.skillDetails;
        this.supportsLinking = builder.supportsLinking;
    }

    /**
     * <p>
     * The ARN of the skill.
     * </p>
     * 
     * @return The ARN of the skill.
     */
    public final String skillId() {
        return skillId;
    }

    /**
     * <p>
     * The name of the skill.
     * </p>
     * 
     * @return The name of the skill.
     */
    public final String skillName() {
        return skillName;
    }

    /**
     * <p>
     * Short description about the skill.
     * </p>
     * 
     * @return Short description about the skill.
     */
    public final String shortDescription() {
        return shortDescription;
    }

    /**
     * <p>
     * The URL where the skill icon resides.
     * </p>
     * 
     * @return The URL where the skill icon resides.
     */
    public final String iconUrl() {
        return iconUrl;
    }

    /**
     * Returns true if the SampleUtterances property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public final boolean hasSampleUtterances() {
        return sampleUtterances != null && !(sampleUtterances instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Sample utterances that interact with the skill.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasSampleUtterances()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Sample utterances that interact with the skill.
     */
    public final List<String> sampleUtterances() {
        return sampleUtterances;
    }

    /**
     * <p>
     * Information about the skill.
     * </p>
     * 
     * @return Information about the skill.
     */
    public final SkillDetails skillDetails() {
        return skillDetails;
    }

    /**
     * <p>
     * Linking support for a skill.
     * </p>
     * 
     * @return Linking support for a skill.
     */
    public final Boolean supportsLinking() {
        return supportsLinking;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(skillId());
        hashCode = 31 * hashCode + Objects.hashCode(skillName());
        hashCode = 31 * hashCode + Objects.hashCode(shortDescription());
        hashCode = 31 * hashCode + Objects.hashCode(iconUrl());
        hashCode = 31 * hashCode + Objects.hashCode(hasSampleUtterances() ? sampleUtterances() : null);
        hashCode = 31 * hashCode + Objects.hashCode(skillDetails());
        hashCode = 31 * hashCode + Objects.hashCode(supportsLinking());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SkillsStoreSkill)) {
            return false;
        }
        SkillsStoreSkill other = (SkillsStoreSkill) obj;
        return Objects.equals(skillId(), other.skillId()) && Objects.equals(skillName(), other.skillName())
                && Objects.equals(shortDescription(), other.shortDescription()) && Objects.equals(iconUrl(), other.iconUrl())
                && hasSampleUtterances() == other.hasSampleUtterances()
                && Objects.equals(sampleUtterances(), other.sampleUtterances())
                && Objects.equals(skillDetails(), other.skillDetails())
                && Objects.equals(supportsLinking(), other.supportsLinking());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SkillsStoreSkill").add("SkillId", skillId()).add("SkillName", skillName())
                .add("ShortDescription", shortDescription()).add("IconUrl", iconUrl())
                .add("SampleUtterances", hasSampleUtterances() ? sampleUtterances() : null).add("SkillDetails", skillDetails())
                .add("SupportsLinking", supportsLinking()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SkillId":
            return Optional.ofNullable(clazz.cast(skillId()));
        case "SkillName":
            return Optional.ofNullable(clazz.cast(skillName()));
        case "ShortDescription":
            return Optional.ofNullable(clazz.cast(shortDescription()));
        case "IconUrl":
            return Optional.ofNullable(clazz.cast(iconUrl()));
        case "SampleUtterances":
            return Optional.ofNullable(clazz.cast(sampleUtterances()));
        case "SkillDetails":
            return Optional.ofNullable(clazz.cast(skillDetails()));
        case "SupportsLinking":
            return Optional.ofNullable(clazz.cast(supportsLinking()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SkillsStoreSkill, T> g) {
        return obj -> g.apply((SkillsStoreSkill) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SkillsStoreSkill> {
        /**
         * <p>
         * The ARN of the skill.
         * </p>
         * 
         * @param skillId
         *        The ARN of the skill.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder skillId(String skillId);

        /**
         * <p>
         * The name of the skill.
         * </p>
         * 
         * @param skillName
         *        The name of the skill.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder skillName(String skillName);

        /**
         * <p>
         * Short description about the skill.
         * </p>
         * 
         * @param shortDescription
         *        Short description about the skill.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder shortDescription(String shortDescription);

        /**
         * <p>
         * The URL where the skill icon resides.
         * </p>
         * 
         * @param iconUrl
         *        The URL where the skill icon resides.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder iconUrl(String iconUrl);

        /**
         * <p>
         * Sample utterances that interact with the skill.
         * </p>
         * 
         * @param sampleUtterances
         *        Sample utterances that interact with the skill.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sampleUtterances(Collection<String> sampleUtterances);

        /**
         * <p>
         * Sample utterances that interact with the skill.
         * </p>
         * 
         * @param sampleUtterances
         *        Sample utterances that interact with the skill.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sampleUtterances(String... sampleUtterances);

        /**
         * <p>
         * Information about the skill.
         * </p>
         * 
         * @param skillDetails
         *        Information about the skill.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder skillDetails(SkillDetails skillDetails);

        /**
         * <p>
         * Information about the skill.
         * </p>
         * This is a convenience that creates an instance of the {@link SkillDetails.Builder} avoiding the need to
         * create one manually via {@link SkillDetails#builder()}.
         *
         * When the {@link Consumer} completes, {@link SkillDetails.Builder#build()} is called immediately and its
         * result is passed to {@link #skillDetails(SkillDetails)}.
         * 
         * @param skillDetails
         *        a consumer that will call methods on {@link SkillDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #skillDetails(SkillDetails)
         */
        default Builder skillDetails(Consumer<SkillDetails.Builder> skillDetails) {
            return skillDetails(SkillDetails.builder().applyMutation(skillDetails).build());
        }

        /**
         * <p>
         * Linking support for a skill.
         * </p>
         * 
         * @param supportsLinking
         *        Linking support for a skill.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder supportsLinking(Boolean supportsLinking);
    }

    static final class BuilderImpl implements Builder {
        private String skillId;

        private String skillName;

        private String shortDescription;

        private String iconUrl;

        private List<String> sampleUtterances = DefaultSdkAutoConstructList.getInstance();

        private SkillDetails skillDetails;

        private Boolean supportsLinking;

        private BuilderImpl() {
        }

        private BuilderImpl(SkillsStoreSkill model) {
            skillId(model.skillId);
            skillName(model.skillName);
            shortDescription(model.shortDescription);
            iconUrl(model.iconUrl);
            sampleUtterances(model.sampleUtterances);
            skillDetails(model.skillDetails);
            supportsLinking(model.supportsLinking);
        }

        public final String getSkillId() {
            return skillId;
        }

        public final void setSkillId(String skillId) {
            this.skillId = skillId;
        }

        @Override
        @Transient
        public final Builder skillId(String skillId) {
            this.skillId = skillId;
            return this;
        }

        public final String getSkillName() {
            return skillName;
        }

        public final void setSkillName(String skillName) {
            this.skillName = skillName;
        }

        @Override
        @Transient
        public final Builder skillName(String skillName) {
            this.skillName = skillName;
            return this;
        }

        public final String getShortDescription() {
            return shortDescription;
        }

        public final void setShortDescription(String shortDescription) {
            this.shortDescription = shortDescription;
        }

        @Override
        @Transient
        public final Builder shortDescription(String shortDescription) {
            this.shortDescription = shortDescription;
            return this;
        }

        public final String getIconUrl() {
            return iconUrl;
        }

        public final void setIconUrl(String iconUrl) {
            this.iconUrl = iconUrl;
        }

        @Override
        @Transient
        public final Builder iconUrl(String iconUrl) {
            this.iconUrl = iconUrl;
            return this;
        }

        public final Collection<String> getSampleUtterances() {
            if (sampleUtterances instanceof SdkAutoConstructList) {
                return null;
            }
            return sampleUtterances;
        }

        public final void setSampleUtterances(Collection<String> sampleUtterances) {
            this.sampleUtterances = SampleUtterancesCopier.copy(sampleUtterances);
        }

        @Override
        @Transient
        public final Builder sampleUtterances(Collection<String> sampleUtterances) {
            this.sampleUtterances = SampleUtterancesCopier.copy(sampleUtterances);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder sampleUtterances(String... sampleUtterances) {
            sampleUtterances(Arrays.asList(sampleUtterances));
            return this;
        }

        public final SkillDetails.Builder getSkillDetails() {
            return skillDetails != null ? skillDetails.toBuilder() : null;
        }

        public final void setSkillDetails(SkillDetails.BuilderImpl skillDetails) {
            this.skillDetails = skillDetails != null ? skillDetails.build() : null;
        }

        @Override
        @Transient
        public final Builder skillDetails(SkillDetails skillDetails) {
            this.skillDetails = skillDetails;
            return this;
        }

        public final Boolean getSupportsLinking() {
            return supportsLinking;
        }

        public final void setSupportsLinking(Boolean supportsLinking) {
            this.supportsLinking = supportsLinking;
        }

        @Override
        @Transient
        public final Builder supportsLinking(Boolean supportsLinking) {
            this.supportsLinking = supportsLinking;
            return this;
        }

        @Override
        public SkillsStoreSkill build() {
            return new SkillsStoreSkill(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
