/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.alexaforbusiness.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetNetworkProfileResponse extends AlexaForBusinessResponse implements
        ToCopyableBuilder<GetNetworkProfileResponse.Builder, GetNetworkProfileResponse> {
    private static final SdkField<NetworkProfile> NETWORK_PROFILE_FIELD = SdkField
            .<NetworkProfile> builder(MarshallingType.SDK_POJO).memberName("NetworkProfile")
            .getter(getter(GetNetworkProfileResponse::networkProfile)).setter(setter(Builder::networkProfile))
            .constructor(NetworkProfile::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NetworkProfile").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NETWORK_PROFILE_FIELD));

    private final NetworkProfile networkProfile;

    private GetNetworkProfileResponse(BuilderImpl builder) {
        super(builder);
        this.networkProfile = builder.networkProfile;
    }

    /**
     * <p>
     * The network profile associated with a device.
     * </p>
     * 
     * @return The network profile associated with a device.
     */
    public final NetworkProfile networkProfile() {
        return networkProfile;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(networkProfile());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetNetworkProfileResponse)) {
            return false;
        }
        GetNetworkProfileResponse other = (GetNetworkProfileResponse) obj;
        return Objects.equals(networkProfile(), other.networkProfile());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetNetworkProfileResponse").add("NetworkProfile", networkProfile()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "NetworkProfile":
            return Optional.ofNullable(clazz.cast(networkProfile()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetNetworkProfileResponse, T> g) {
        return obj -> g.apply((GetNetworkProfileResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends AlexaForBusinessResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, GetNetworkProfileResponse> {
        /**
         * <p>
         * The network profile associated with a device.
         * </p>
         * 
         * @param networkProfile
         *        The network profile associated with a device.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder networkProfile(NetworkProfile networkProfile);

        /**
         * <p>
         * The network profile associated with a device.
         * </p>
         * This is a convenience method that creates an instance of the {@link NetworkProfile.Builder} avoiding the need
         * to create one manually via {@link NetworkProfile#builder()}.
         *
         * When the {@link Consumer} completes, {@link NetworkProfile.Builder#build()} is called immediately and its
         * result is passed to {@link #networkProfile(NetworkProfile)}.
         * 
         * @param networkProfile
         *        a consumer that will call methods on {@link NetworkProfile.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #networkProfile(NetworkProfile)
         */
        default Builder networkProfile(Consumer<NetworkProfile.Builder> networkProfile) {
            return networkProfile(NetworkProfile.builder().applyMutation(networkProfile).build());
        }
    }

    static final class BuilderImpl extends AlexaForBusinessResponse.BuilderImpl implements Builder {
        private NetworkProfile networkProfile;

        private BuilderImpl() {
        }

        private BuilderImpl(GetNetworkProfileResponse model) {
            super(model);
            networkProfile(model.networkProfile);
        }

        public final NetworkProfile.Builder getNetworkProfile() {
            return networkProfile != null ? networkProfile.toBuilder() : null;
        }

        public final void setNetworkProfile(NetworkProfile.BuilderImpl networkProfile) {
            this.networkProfile = networkProfile != null ? networkProfile.build() : null;
        }

        @Override
        @Transient
        public final Builder networkProfile(NetworkProfile networkProfile) {
            this.networkProfile = networkProfile;
            return this;
        }

        @Override
        public GetNetworkProfileResponse build() {
            return new GetNetworkProfileResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
