/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.alexaforbusiness.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListDeviceEventsResponse extends AlexaForBusinessResponse implements
        ToCopyableBuilder<ListDeviceEventsResponse.Builder, ListDeviceEventsResponse> {
    private static final SdkField<List<DeviceEvent>> DEVICE_EVENTS_FIELD = SdkField
            .<List<DeviceEvent>> builder(MarshallingType.LIST)
            .memberName("DeviceEvents")
            .getter(getter(ListDeviceEventsResponse::deviceEvents))
            .setter(setter(Builder::deviceEvents))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeviceEvents").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<DeviceEvent> builder(MarshallingType.SDK_POJO)
                                            .constructor(DeviceEvent::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListDeviceEventsResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DEVICE_EVENTS_FIELD,
            NEXT_TOKEN_FIELD));

    private final List<DeviceEvent> deviceEvents;

    private final String nextToken;

    private ListDeviceEventsResponse(BuilderImpl builder) {
        super(builder);
        this.deviceEvents = builder.deviceEvents;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the DeviceEvents property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasDeviceEvents() {
        return deviceEvents != null && !(deviceEvents instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The device events requested for the device ARN.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasDeviceEvents} method.
     * </p>
     * 
     * @return The device events requested for the device ARN.
     */
    public final List<DeviceEvent> deviceEvents() {
        return deviceEvents;
    }

    /**
     * <p>
     * The token returned to indicate that there is more data available.
     * </p>
     * 
     * @return The token returned to indicate that there is more data available.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasDeviceEvents() ? deviceEvents() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListDeviceEventsResponse)) {
            return false;
        }
        ListDeviceEventsResponse other = (ListDeviceEventsResponse) obj;
        return hasDeviceEvents() == other.hasDeviceEvents() && Objects.equals(deviceEvents(), other.deviceEvents())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListDeviceEventsResponse").add("DeviceEvents", hasDeviceEvents() ? deviceEvents() : null)
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DeviceEvents":
            return Optional.ofNullable(clazz.cast(deviceEvents()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListDeviceEventsResponse, T> g) {
        return obj -> g.apply((ListDeviceEventsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends AlexaForBusinessResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, ListDeviceEventsResponse> {
        /**
         * <p>
         * The device events requested for the device ARN.
         * </p>
         * 
         * @param deviceEvents
         *        The device events requested for the device ARN.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deviceEvents(Collection<DeviceEvent> deviceEvents);

        /**
         * <p>
         * The device events requested for the device ARN.
         * </p>
         * 
         * @param deviceEvents
         *        The device events requested for the device ARN.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deviceEvents(DeviceEvent... deviceEvents);

        /**
         * <p>
         * The device events requested for the device ARN.
         * </p>
         * This is a convenience method that creates an instance of the {@link List<DeviceEvent>.Builder} avoiding the
         * need to create one manually via {@link List<DeviceEvent>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<DeviceEvent>.Builder#build()} is called immediately and its
         * result is passed to {@link #deviceEvents(List<DeviceEvent>)}.
         * 
         * @param deviceEvents
         *        a consumer that will call methods on {@link List<DeviceEvent>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #deviceEvents(List<DeviceEvent>)
         */
        Builder deviceEvents(Consumer<DeviceEvent.Builder>... deviceEvents);

        /**
         * <p>
         * The token returned to indicate that there is more data available.
         * </p>
         * 
         * @param nextToken
         *        The token returned to indicate that there is more data available.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends AlexaForBusinessResponse.BuilderImpl implements Builder {
        private List<DeviceEvent> deviceEvents = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListDeviceEventsResponse model) {
            super(model);
            deviceEvents(model.deviceEvents);
            nextToken(model.nextToken);
        }

        public final List<DeviceEvent.Builder> getDeviceEvents() {
            List<DeviceEvent.Builder> result = DeviceEventListCopier.copyToBuilder(this.deviceEvents);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDeviceEvents(Collection<DeviceEvent.BuilderImpl> deviceEvents) {
            this.deviceEvents = DeviceEventListCopier.copyFromBuilder(deviceEvents);
        }

        @Override
        @Transient
        public final Builder deviceEvents(Collection<DeviceEvent> deviceEvents) {
            this.deviceEvents = DeviceEventListCopier.copy(deviceEvents);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder deviceEvents(DeviceEvent... deviceEvents) {
            deviceEvents(Arrays.asList(deviceEvents));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder deviceEvents(Consumer<DeviceEvent.Builder>... deviceEvents) {
            deviceEvents(Stream.of(deviceEvents).map(c -> DeviceEvent.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        @Transient
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListDeviceEventsResponse build() {
            return new ListDeviceEventsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
