/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.alexaforbusiness.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum DeviceStatusDetailCode {
    DEVICE_SOFTWARE_UPDATE_NEEDED("DEVICE_SOFTWARE_UPDATE_NEEDED"),
    DEVICE_WAS_OFFLINE("DEVICE_WAS_OFFLINE"),
    CREDENTIALS_ACCESS_FAILURE("CREDENTIALS_ACCESS_FAILURE"),
    TLS_VERSION_MISMATCH("TLS_VERSION_MISMATCH"),
    ASSOCIATION_REJECTION("ASSOCIATION_REJECTION"),
    AUTHENTICATION_FAILURE("AUTHENTICATION_FAILURE"),
    DHCP_FAILURE("DHCP_FAILURE"),
    INTERNET_UNAVAILABLE("INTERNET_UNAVAILABLE"),
    DNS_FAILURE("DNS_FAILURE"),
    UNKNOWN_FAILURE("UNKNOWN_FAILURE"),
    CERTIFICATE_ISSUING_LIMIT_EXCEEDED("CERTIFICATE_ISSUING_LIMIT_EXCEEDED"),
    INVALID_CERTIFICATE_AUTHORITY("INVALID_CERTIFICATE_AUTHORITY"),
    NETWORK_PROFILE_NOT_FOUND("NETWORK_PROFILE_NOT_FOUND"),
    INVALID_PASSWORD_STATE("INVALID_PASSWORD_STATE"),
    PASSWORD_NOT_FOUND("PASSWORD_NOT_FOUND"),
    PASSWORD_MANAGER_ACCESS_DENIED("PASSWORD_MANAGER_ACCESS_DENIED"),
    CERTIFICATE_AUTHORITY_ACCESS_DENIED("CERTIFICATE_AUTHORITY_ACCESS_DENIED"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, DeviceStatusDetailCode> VALUE_MAP;
    private final String value;

    private DeviceStatusDetailCode(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static DeviceStatusDetailCode fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<DeviceStatusDetailCode> knownValues() {
        EnumSet<DeviceStatusDetailCode> knownValues = EnumSet.allOf(DeviceStatusDetailCode.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(DeviceStatusDetailCode.class, DeviceStatusDetailCode::toString);
    }
}

