/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.alexaforbusiness.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum TemperatureUnit {
    FAHRENHEIT("FAHRENHEIT"),
    CELSIUS("CELSIUS"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, TemperatureUnit> VALUE_MAP;
    private final String value;

    private TemperatureUnit(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static TemperatureUnit fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<TemperatureUnit> knownValues() {
        EnumSet<TemperatureUnit> knownValues = EnumSet.allOf(TemperatureUnit.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(TemperatureUnit.class, TemperatureUnit::toString);
    }
}

