/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.alexaforbusiness.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The content definition. This can contain only one text, SSML, or audio list object.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Content implements SdkPojo, Serializable, ToCopyableBuilder<Content.Builder, Content> {
    private static final SdkField<List<Text>> TEXT_LIST_FIELD = SdkField
            .<List<Text>> builder(MarshallingType.LIST)
            .memberName("TextList")
            .getter(getter(Content::textList))
            .setter(setter(Builder::textList))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TextList").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Text> builder(MarshallingType.SDK_POJO)
                                            .constructor(Text::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<Ssml>> SSML_LIST_FIELD = SdkField
            .<List<Ssml>> builder(MarshallingType.LIST)
            .memberName("SsmlList")
            .getter(getter(Content::ssmlList))
            .setter(setter(Builder::ssmlList))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SsmlList").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Ssml> builder(MarshallingType.SDK_POJO)
                                            .constructor(Ssml::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<Audio>> AUDIO_LIST_FIELD = SdkField
            .<List<Audio>> builder(MarshallingType.LIST)
            .memberName("AudioList")
            .getter(getter(Content::audioList))
            .setter(setter(Builder::audioList))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AudioList").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Audio> builder(MarshallingType.SDK_POJO)
                                            .constructor(Audio::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TEXT_LIST_FIELD,
            SSML_LIST_FIELD, AUDIO_LIST_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<Text> textList;

    private final List<Ssml> ssmlList;

    private final List<Audio> audioList;

    private Content(BuilderImpl builder) {
        this.textList = builder.textList;
        this.ssmlList = builder.ssmlList;
        this.audioList = builder.audioList;
    }

    /**
     * For responses, this returns true if the service returned a value for the TextList property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasTextList() {
        return textList != null && !(textList instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of text messages.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTextList} method.
     * </p>
     * 
     * @return The list of text messages.
     */
    public final List<Text> textList() {
        return textList;
    }

    /**
     * For responses, this returns true if the service returned a value for the SsmlList property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasSsmlList() {
        return ssmlList != null && !(ssmlList instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of SSML messages.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSsmlList} method.
     * </p>
     * 
     * @return The list of SSML messages.
     */
    public final List<Ssml> ssmlList() {
        return ssmlList;
    }

    /**
     * For responses, this returns true if the service returned a value for the AudioList property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasAudioList() {
        return audioList != null && !(audioList instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of audio messages.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAudioList} method.
     * </p>
     * 
     * @return The list of audio messages.
     */
    public final List<Audio> audioList() {
        return audioList;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasTextList() ? textList() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasSsmlList() ? ssmlList() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasAudioList() ? audioList() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Content)) {
            return false;
        }
        Content other = (Content) obj;
        return hasTextList() == other.hasTextList() && Objects.equals(textList(), other.textList())
                && hasSsmlList() == other.hasSsmlList() && Objects.equals(ssmlList(), other.ssmlList())
                && hasAudioList() == other.hasAudioList() && Objects.equals(audioList(), other.audioList());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Content").add("TextList", hasTextList() ? textList() : null)
                .add("SsmlList", hasSsmlList() ? ssmlList() : null).add("AudioList", hasAudioList() ? audioList() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TextList":
            return Optional.ofNullable(clazz.cast(textList()));
        case "SsmlList":
            return Optional.ofNullable(clazz.cast(ssmlList()));
        case "AudioList":
            return Optional.ofNullable(clazz.cast(audioList()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Content, T> g) {
        return obj -> g.apply((Content) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Content> {
        /**
         * <p>
         * The list of text messages.
         * </p>
         * 
         * @param textList
         *        The list of text messages.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder textList(Collection<Text> textList);

        /**
         * <p>
         * The list of text messages.
         * </p>
         * 
         * @param textList
         *        The list of text messages.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder textList(Text... textList);

        /**
         * <p>
         * The list of text messages.
         * </p>
         * This is a convenience method that creates an instance of the {@link List<Text>.Builder} avoiding the need to
         * create one manually via {@link List<Text>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Text>.Builder#build()} is called immediately and its result
         * is passed to {@link #textList(List<Text>)}.
         * 
         * @param textList
         *        a consumer that will call methods on {@link List<Text>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #textList(List<Text>)
         */
        Builder textList(Consumer<Text.Builder>... textList);

        /**
         * <p>
         * The list of SSML messages.
         * </p>
         * 
         * @param ssmlList
         *        The list of SSML messages.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ssmlList(Collection<Ssml> ssmlList);

        /**
         * <p>
         * The list of SSML messages.
         * </p>
         * 
         * @param ssmlList
         *        The list of SSML messages.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ssmlList(Ssml... ssmlList);

        /**
         * <p>
         * The list of SSML messages.
         * </p>
         * This is a convenience method that creates an instance of the {@link List<Ssml>.Builder} avoiding the need to
         * create one manually via {@link List<Ssml>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Ssml>.Builder#build()} is called immediately and its result
         * is passed to {@link #ssmlList(List<Ssml>)}.
         * 
         * @param ssmlList
         *        a consumer that will call methods on {@link List<Ssml>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #ssmlList(List<Ssml>)
         */
        Builder ssmlList(Consumer<Ssml.Builder>... ssmlList);

        /**
         * <p>
         * The list of audio messages.
         * </p>
         * 
         * @param audioList
         *        The list of audio messages.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder audioList(Collection<Audio> audioList);

        /**
         * <p>
         * The list of audio messages.
         * </p>
         * 
         * @param audioList
         *        The list of audio messages.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder audioList(Audio... audioList);

        /**
         * <p>
         * The list of audio messages.
         * </p>
         * This is a convenience method that creates an instance of the {@link List<Audio>.Builder} avoiding the need to
         * create one manually via {@link List<Audio>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Audio>.Builder#build()} is called immediately and its result
         * is passed to {@link #audioList(List<Audio>)}.
         * 
         * @param audioList
         *        a consumer that will call methods on {@link List<Audio>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #audioList(List<Audio>)
         */
        Builder audioList(Consumer<Audio.Builder>... audioList);
    }

    static final class BuilderImpl implements Builder {
        private List<Text> textList = DefaultSdkAutoConstructList.getInstance();

        private List<Ssml> ssmlList = DefaultSdkAutoConstructList.getInstance();

        private List<Audio> audioList = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(Content model) {
            textList(model.textList);
            ssmlList(model.ssmlList);
            audioList(model.audioList);
        }

        public final List<Text.Builder> getTextList() {
            List<Text.Builder> result = TextListCopier.copyToBuilder(this.textList);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTextList(Collection<Text.BuilderImpl> textList) {
            this.textList = TextListCopier.copyFromBuilder(textList);
        }

        @Override
        public final Builder textList(Collection<Text> textList) {
            this.textList = TextListCopier.copy(textList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder textList(Text... textList) {
            textList(Arrays.asList(textList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder textList(Consumer<Text.Builder>... textList) {
            textList(Stream.of(textList).map(c -> Text.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<Ssml.Builder> getSsmlList() {
            List<Ssml.Builder> result = SsmlListCopier.copyToBuilder(this.ssmlList);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSsmlList(Collection<Ssml.BuilderImpl> ssmlList) {
            this.ssmlList = SsmlListCopier.copyFromBuilder(ssmlList);
        }

        @Override
        public final Builder ssmlList(Collection<Ssml> ssmlList) {
            this.ssmlList = SsmlListCopier.copy(ssmlList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ssmlList(Ssml... ssmlList) {
            ssmlList(Arrays.asList(ssmlList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ssmlList(Consumer<Ssml.Builder>... ssmlList) {
            ssmlList(Stream.of(ssmlList).map(c -> Ssml.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<Audio.Builder> getAudioList() {
            List<Audio.Builder> result = AudioListCopier.copyToBuilder(this.audioList);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAudioList(Collection<Audio.BuilderImpl> audioList) {
            this.audioList = AudioListCopier.copyFromBuilder(audioList);
        }

        @Override
        public final Builder audioList(Collection<Audio> audioList) {
            this.audioList = AudioListCopier.copy(audioList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder audioList(Audio... audioList) {
            audioList(Arrays.asList(audioList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder audioList(Consumer<Audio.Builder>... audioList) {
            audioList(Stream.of(audioList).map(c -> Audio.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Content build() {
            return new Content(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
