/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.alexaforbusiness.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class RegisterAvsDeviceRequest extends AlexaForBusinessRequest implements
        ToCopyableBuilder<RegisterAvsDeviceRequest.Builder, RegisterAvsDeviceRequest> {
    private static final SdkField<String> CLIENT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ClientId").getter(getter(RegisterAvsDeviceRequest::clientId)).setter(setter(Builder::clientId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientId").build()).build();

    private static final SdkField<String> USER_CODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("UserCode").getter(getter(RegisterAvsDeviceRequest::userCode)).setter(setter(Builder::userCode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserCode").build()).build();

    private static final SdkField<String> PRODUCT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ProductId").getter(getter(RegisterAvsDeviceRequest::productId)).setter(setter(Builder::productId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProductId").build()).build();

    private static final SdkField<String> DEVICE_SERIAL_NUMBER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DeviceSerialNumber").getter(getter(RegisterAvsDeviceRequest::deviceSerialNumber))
            .setter(setter(Builder::deviceSerialNumber))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeviceSerialNumber").build())
            .build();

    private static final SdkField<String> AMAZON_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AmazonId").getter(getter(RegisterAvsDeviceRequest::amazonId)).setter(setter(Builder::amazonId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AmazonId").build()).build();

    private static final SdkField<String> ROOM_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RoomArn").getter(getter(RegisterAvsDeviceRequest::roomArn)).setter(setter(Builder::roomArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoomArn").build()).build();

    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .memberName("Tags")
            .getter(getter(RegisterAvsDeviceRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLIENT_ID_FIELD,
            USER_CODE_FIELD, PRODUCT_ID_FIELD, DEVICE_SERIAL_NUMBER_FIELD, AMAZON_ID_FIELD, ROOM_ARN_FIELD, TAGS_FIELD));

    private final String clientId;

    private final String userCode;

    private final String productId;

    private final String deviceSerialNumber;

    private final String amazonId;

    private final String roomArn;

    private final List<Tag> tags;

    private RegisterAvsDeviceRequest(BuilderImpl builder) {
        super(builder);
        this.clientId = builder.clientId;
        this.userCode = builder.userCode;
        this.productId = builder.productId;
        this.deviceSerialNumber = builder.deviceSerialNumber;
        this.amazonId = builder.amazonId;
        this.roomArn = builder.roomArn;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * The client ID of the OEM used for code-based linking authorization on an AVS device.
     * </p>
     * 
     * @return The client ID of the OEM used for code-based linking authorization on an AVS device.
     */
    public final String clientId() {
        return clientId;
    }

    /**
     * <p>
     * The code that is obtained after your AVS device has made a POST request to LWA as a part of the Device
     * Authorization Request component of the OAuth code-based linking specification.
     * </p>
     * 
     * @return The code that is obtained after your AVS device has made a POST request to LWA as a part of the Device
     *         Authorization Request component of the OAuth code-based linking specification.
     */
    public final String userCode() {
        return userCode;
    }

    /**
     * <p>
     * The product ID used to identify your AVS device during authorization.
     * </p>
     * 
     * @return The product ID used to identify your AVS device during authorization.
     */
    public final String productId() {
        return productId;
    }

    /**
     * <p>
     * The key generated by the OEM that uniquely identifies a specified instance of your AVS device.
     * </p>
     * 
     * @return The key generated by the OEM that uniquely identifies a specified instance of your AVS device.
     */
    public final String deviceSerialNumber() {
        return deviceSerialNumber;
    }

    /**
     * <p>
     * The device type ID for your AVS device generated by Amazon when the OEM creates a new product on Amazon's
     * Developer Console.
     * </p>
     * 
     * @return The device type ID for your AVS device generated by Amazon when the OEM creates a new product on Amazon's
     *         Developer Console.
     */
    public final String amazonId() {
        return amazonId;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the room with which to associate your AVS device.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the room with which to associate your AVS device.
     */
    public final String roomArn() {
        return roomArn;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The tags to be added to the specified resource. Do not provide system tags.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return The tags to be added to the specified resource. Do not provide system tags.
     */
    public final List<Tag> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(clientId());
        hashCode = 31 * hashCode + Objects.hashCode(userCode());
        hashCode = 31 * hashCode + Objects.hashCode(productId());
        hashCode = 31 * hashCode + Objects.hashCode(deviceSerialNumber());
        hashCode = 31 * hashCode + Objects.hashCode(amazonId());
        hashCode = 31 * hashCode + Objects.hashCode(roomArn());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RegisterAvsDeviceRequest)) {
            return false;
        }
        RegisterAvsDeviceRequest other = (RegisterAvsDeviceRequest) obj;
        return Objects.equals(clientId(), other.clientId()) && Objects.equals(userCode(), other.userCode())
                && Objects.equals(productId(), other.productId())
                && Objects.equals(deviceSerialNumber(), other.deviceSerialNumber())
                && Objects.equals(amazonId(), other.amazonId()) && Objects.equals(roomArn(), other.roomArn())
                && hasTags() == other.hasTags() && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RegisterAvsDeviceRequest").add("ClientId", clientId()).add("UserCode", userCode())
                .add("ProductId", productId()).add("DeviceSerialNumber", deviceSerialNumber()).add("AmazonId", amazonId())
                .add("RoomArn", roomArn()).add("Tags", hasTags() ? tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ClientId":
            return Optional.ofNullable(clazz.cast(clientId()));
        case "UserCode":
            return Optional.ofNullable(clazz.cast(userCode()));
        case "ProductId":
            return Optional.ofNullable(clazz.cast(productId()));
        case "DeviceSerialNumber":
            return Optional.ofNullable(clazz.cast(deviceSerialNumber()));
        case "AmazonId":
            return Optional.ofNullable(clazz.cast(amazonId()));
        case "RoomArn":
            return Optional.ofNullable(clazz.cast(roomArn()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RegisterAvsDeviceRequest, T> g) {
        return obj -> g.apply((RegisterAvsDeviceRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends AlexaForBusinessRequest.Builder, SdkPojo, CopyableBuilder<Builder, RegisterAvsDeviceRequest> {
        /**
         * <p>
         * The client ID of the OEM used for code-based linking authorization on an AVS device.
         * </p>
         * 
         * @param clientId
         *        The client ID of the OEM used for code-based linking authorization on an AVS device.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientId(String clientId);

        /**
         * <p>
         * The code that is obtained after your AVS device has made a POST request to LWA as a part of the Device
         * Authorization Request component of the OAuth code-based linking specification.
         * </p>
         * 
         * @param userCode
         *        The code that is obtained after your AVS device has made a POST request to LWA as a part of the Device
         *        Authorization Request component of the OAuth code-based linking specification.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userCode(String userCode);

        /**
         * <p>
         * The product ID used to identify your AVS device during authorization.
         * </p>
         * 
         * @param productId
         *        The product ID used to identify your AVS device during authorization.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder productId(String productId);

        /**
         * <p>
         * The key generated by the OEM that uniquely identifies a specified instance of your AVS device.
         * </p>
         * 
         * @param deviceSerialNumber
         *        The key generated by the OEM that uniquely identifies a specified instance of your AVS device.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deviceSerialNumber(String deviceSerialNumber);

        /**
         * <p>
         * The device type ID for your AVS device generated by Amazon when the OEM creates a new product on Amazon's
         * Developer Console.
         * </p>
         * 
         * @param amazonId
         *        The device type ID for your AVS device generated by Amazon when the OEM creates a new product on
         *        Amazon's Developer Console.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder amazonId(String amazonId);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the room with which to associate your AVS device.
         * </p>
         * 
         * @param roomArn
         *        The Amazon Resource Name (ARN) of the room with which to associate your AVS device.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roomArn(String roomArn);

        /**
         * <p>
         * The tags to be added to the specified resource. Do not provide system tags.
         * </p>
         * 
         * @param tags
         *        The tags to be added to the specified resource. Do not provide system tags.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * The tags to be added to the specified resource. Do not provide system tags.
         * </p>
         * 
         * @param tags
         *        The tags to be added to the specified resource. Do not provide system tags.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * <p>
         * The tags to be added to the specified resource. Do not provide system tags.
         * </p>
         * This is a convenience method that creates an instance of the {@link List<Tag>.Builder} avoiding the need to
         * create one manually via {@link List<Tag>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Tag>.Builder#build()} is called immediately and its result
         * is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on {@link List<Tag>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(List<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends AlexaForBusinessRequest.BuilderImpl implements Builder {
        private String clientId;

        private String userCode;

        private String productId;

        private String deviceSerialNumber;

        private String amazonId;

        private String roomArn;

        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(RegisterAvsDeviceRequest model) {
            super(model);
            clientId(model.clientId);
            userCode(model.userCode);
            productId(model.productId);
            deviceSerialNumber(model.deviceSerialNumber);
            amazonId(model.amazonId);
            roomArn(model.roomArn);
            tags(model.tags);
        }

        public final String getClientId() {
            return clientId;
        }

        public final void setClientId(String clientId) {
            this.clientId = clientId;
        }

        @Override
        public final Builder clientId(String clientId) {
            this.clientId = clientId;
            return this;
        }

        public final String getUserCode() {
            return userCode;
        }

        public final void setUserCode(String userCode) {
            this.userCode = userCode;
        }

        @Override
        public final Builder userCode(String userCode) {
            this.userCode = userCode;
            return this;
        }

        public final String getProductId() {
            return productId;
        }

        public final void setProductId(String productId) {
            this.productId = productId;
        }

        @Override
        public final Builder productId(String productId) {
            this.productId = productId;
            return this;
        }

        public final String getDeviceSerialNumber() {
            return deviceSerialNumber;
        }

        public final void setDeviceSerialNumber(String deviceSerialNumber) {
            this.deviceSerialNumber = deviceSerialNumber;
        }

        @Override
        public final Builder deviceSerialNumber(String deviceSerialNumber) {
            this.deviceSerialNumber = deviceSerialNumber;
            return this;
        }

        public final String getAmazonId() {
            return amazonId;
        }

        public final void setAmazonId(String amazonId) {
            this.amazonId = amazonId;
        }

        @Override
        public final Builder amazonId(String amazonId) {
            this.amazonId = amazonId;
            return this;
        }

        public final String getRoomArn() {
            return roomArn;
        }

        public final void setRoomArn(String roomArn) {
            this.roomArn = roomArn;
        }

        @Override
        public final Builder roomArn(String roomArn) {
            this.roomArn = roomArn;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public RegisterAvsDeviceRequest build() {
            return new RegisterAvsDeviceRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
