/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.alexaforbusiness.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DeleteConferenceProviderRequest extends AlexaForBusinessRequest implements
        ToCopyableBuilder<DeleteConferenceProviderRequest.Builder, DeleteConferenceProviderRequest> {
    private static final SdkField<String> CONFERENCE_PROVIDER_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ConferenceProviderArn").getter(getter(DeleteConferenceProviderRequest::conferenceProviderArn))
            .setter(setter(Builder::conferenceProviderArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConferenceProviderArn").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections
            .unmodifiableList(Arrays.asList(CONFERENCE_PROVIDER_ARN_FIELD));

    private final String conferenceProviderArn;

    private DeleteConferenceProviderRequest(BuilderImpl builder) {
        super(builder);
        this.conferenceProviderArn = builder.conferenceProviderArn;
    }

    /**
     * <p>
     * The ARN of the conference provider.
     * </p>
     * 
     * @return The ARN of the conference provider.
     */
    public final String conferenceProviderArn() {
        return conferenceProviderArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(conferenceProviderArn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteConferenceProviderRequest)) {
            return false;
        }
        DeleteConferenceProviderRequest other = (DeleteConferenceProviderRequest) obj;
        return Objects.equals(conferenceProviderArn(), other.conferenceProviderArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DeleteConferenceProviderRequest").add("ConferenceProviderArn", conferenceProviderArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ConferenceProviderArn":
            return Optional.ofNullable(clazz.cast(conferenceProviderArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DeleteConferenceProviderRequest, T> g) {
        return obj -> g.apply((DeleteConferenceProviderRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends AlexaForBusinessRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, DeleteConferenceProviderRequest> {
        /**
         * <p>
         * The ARN of the conference provider.
         * </p>
         * 
         * @param conferenceProviderArn
         *        The ARN of the conference provider.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder conferenceProviderArn(String conferenceProviderArn);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends AlexaForBusinessRequest.BuilderImpl implements Builder {
        private String conferenceProviderArn;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteConferenceProviderRequest model) {
            super(model);
            conferenceProviderArn(model.conferenceProviderArn);
        }

        public final String getConferenceProviderArn() {
            return conferenceProviderArn;
        }

        public final void setConferenceProviderArn(String conferenceProviderArn) {
            this.conferenceProviderArn = conferenceProviderArn;
        }

        @Override
        @Transient
        public final Builder conferenceProviderArn(String conferenceProviderArn) {
            this.conferenceProviderArn = conferenceProviderArn;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DeleteConferenceProviderRequest build() {
            return new DeleteConferenceProviderRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
