/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.alexaforbusiness.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The details about the developer that published the skill.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DeveloperInfo implements SdkPojo, Serializable, ToCopyableBuilder<DeveloperInfo.Builder, DeveloperInfo> {
    private static final SdkField<String> DEVELOPER_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DeveloperName").getter(getter(DeveloperInfo::developerName)).setter(setter(Builder::developerName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeveloperName").build()).build();

    private static final SdkField<String> PRIVACY_POLICY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PrivacyPolicy").getter(getter(DeveloperInfo::privacyPolicy)).setter(setter(Builder::privacyPolicy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PrivacyPolicy").build()).build();

    private static final SdkField<String> EMAIL_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Email")
            .getter(getter(DeveloperInfo::email)).setter(setter(Builder::email))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Email").build()).build();

    private static final SdkField<String> URL_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Url")
            .getter(getter(DeveloperInfo::url)).setter(setter(Builder::url))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Url").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DEVELOPER_NAME_FIELD,
            PRIVACY_POLICY_FIELD, EMAIL_FIELD, URL_FIELD));

    private static final long serialVersionUID = 1L;

    private final String developerName;

    private final String privacyPolicy;

    private final String email;

    private final String url;

    private DeveloperInfo(BuilderImpl builder) {
        this.developerName = builder.developerName;
        this.privacyPolicy = builder.privacyPolicy;
        this.email = builder.email;
        this.url = builder.url;
    }

    /**
     * <p>
     * The name of the developer.
     * </p>
     * 
     * @return The name of the developer.
     */
    public final String developerName() {
        return developerName;
    }

    /**
     * <p>
     * The URL of the privacy policy.
     * </p>
     * 
     * @return The URL of the privacy policy.
     */
    public final String privacyPolicy() {
        return privacyPolicy;
    }

    /**
     * <p>
     * The email of the developer.
     * </p>
     * 
     * @return The email of the developer.
     */
    public final String email() {
        return email;
    }

    /**
     * <p>
     * The website of the developer.
     * </p>
     * 
     * @return The website of the developer.
     */
    public final String url() {
        return url;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(developerName());
        hashCode = 31 * hashCode + Objects.hashCode(privacyPolicy());
        hashCode = 31 * hashCode + Objects.hashCode(email());
        hashCode = 31 * hashCode + Objects.hashCode(url());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeveloperInfo)) {
            return false;
        }
        DeveloperInfo other = (DeveloperInfo) obj;
        return Objects.equals(developerName(), other.developerName()) && Objects.equals(privacyPolicy(), other.privacyPolicy())
                && Objects.equals(email(), other.email()) && Objects.equals(url(), other.url());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DeveloperInfo").add("DeveloperName", developerName()).add("PrivacyPolicy", privacyPolicy())
                .add("Email", email()).add("Url", url()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DeveloperName":
            return Optional.ofNullable(clazz.cast(developerName()));
        case "PrivacyPolicy":
            return Optional.ofNullable(clazz.cast(privacyPolicy()));
        case "Email":
            return Optional.ofNullable(clazz.cast(email()));
        case "Url":
            return Optional.ofNullable(clazz.cast(url()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DeveloperInfo, T> g) {
        return obj -> g.apply((DeveloperInfo) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DeveloperInfo> {
        /**
         * <p>
         * The name of the developer.
         * </p>
         * 
         * @param developerName
         *        The name of the developer.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder developerName(String developerName);

        /**
         * <p>
         * The URL of the privacy policy.
         * </p>
         * 
         * @param privacyPolicy
         *        The URL of the privacy policy.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder privacyPolicy(String privacyPolicy);

        /**
         * <p>
         * The email of the developer.
         * </p>
         * 
         * @param email
         *        The email of the developer.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder email(String email);

        /**
         * <p>
         * The website of the developer.
         * </p>
         * 
         * @param url
         *        The website of the developer.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder url(String url);
    }

    static final class BuilderImpl implements Builder {
        private String developerName;

        private String privacyPolicy;

        private String email;

        private String url;

        private BuilderImpl() {
        }

        private BuilderImpl(DeveloperInfo model) {
            developerName(model.developerName);
            privacyPolicy(model.privacyPolicy);
            email(model.email);
            url(model.url);
        }

        public final String getDeveloperName() {
            return developerName;
        }

        public final void setDeveloperName(String developerName) {
            this.developerName = developerName;
        }

        @Override
        @Transient
        public final Builder developerName(String developerName) {
            this.developerName = developerName;
            return this;
        }

        public final String getPrivacyPolicy() {
            return privacyPolicy;
        }

        public final void setPrivacyPolicy(String privacyPolicy) {
            this.privacyPolicy = privacyPolicy;
        }

        @Override
        @Transient
        public final Builder privacyPolicy(String privacyPolicy) {
            this.privacyPolicy = privacyPolicy;
            return this;
        }

        public final String getEmail() {
            return email;
        }

        public final void setEmail(String email) {
            this.email = email;
        }

        @Override
        @Transient
        public final Builder email(String email) {
            this.email = email;
            return this;
        }

        public final String getUrl() {
            return url;
        }

        public final void setUrl(String url) {
            this.url = url;
        }

        @Override
        @Transient
        public final Builder url(String url) {
            this.url = url;
            return this;
        }

        @Override
        public DeveloperInfo build() {
            return new DeveloperInfo(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
