/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.alexaforbusiness.model;

import java.beans.Transient;
import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Detailed information about a device's network profile.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DeviceNetworkProfileInfo implements SdkPojo, Serializable,
        ToCopyableBuilder<DeviceNetworkProfileInfo.Builder, DeviceNetworkProfileInfo> {
    private static final SdkField<String> NETWORK_PROFILE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NetworkProfileArn").getter(getter(DeviceNetworkProfileInfo::networkProfileArn))
            .setter(setter(Builder::networkProfileArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NetworkProfileArn").build()).build();

    private static final SdkField<String> CERTIFICATE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CertificateArn").getter(getter(DeviceNetworkProfileInfo::certificateArn))
            .setter(setter(Builder::certificateArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CertificateArn").build()).build();

    private static final SdkField<Instant> CERTIFICATE_EXPIRATION_TIME_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT).memberName("CertificateExpirationTime")
            .getter(getter(DeviceNetworkProfileInfo::certificateExpirationTime))
            .setter(setter(Builder::certificateExpirationTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CertificateExpirationTime").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NETWORK_PROFILE_ARN_FIELD,
            CERTIFICATE_ARN_FIELD, CERTIFICATE_EXPIRATION_TIME_FIELD));

    private static final long serialVersionUID = 1L;

    private final String networkProfileArn;

    private final String certificateArn;

    private final Instant certificateExpirationTime;

    private DeviceNetworkProfileInfo(BuilderImpl builder) {
        this.networkProfileArn = builder.networkProfileArn;
        this.certificateArn = builder.certificateArn;
        this.certificateExpirationTime = builder.certificateExpirationTime;
    }

    /**
     * <p>
     * The ARN of the network profile associated with a device.
     * </p>
     * 
     * @return The ARN of the network profile associated with a device.
     */
    public final String networkProfileArn() {
        return networkProfileArn;
    }

    /**
     * <p>
     * The ARN of the certificate associated with a device.
     * </p>
     * 
     * @return The ARN of the certificate associated with a device.
     */
    public final String certificateArn() {
        return certificateArn;
    }

    /**
     * <p>
     * The time (in epoch) when the certificate expires.
     * </p>
     * 
     * @return The time (in epoch) when the certificate expires.
     */
    public final Instant certificateExpirationTime() {
        return certificateExpirationTime;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(networkProfileArn());
        hashCode = 31 * hashCode + Objects.hashCode(certificateArn());
        hashCode = 31 * hashCode + Objects.hashCode(certificateExpirationTime());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeviceNetworkProfileInfo)) {
            return false;
        }
        DeviceNetworkProfileInfo other = (DeviceNetworkProfileInfo) obj;
        return Objects.equals(networkProfileArn(), other.networkProfileArn())
                && Objects.equals(certificateArn(), other.certificateArn())
                && Objects.equals(certificateExpirationTime(), other.certificateExpirationTime());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DeviceNetworkProfileInfo").add("NetworkProfileArn", networkProfileArn())
                .add("CertificateArn", certificateArn()).add("CertificateExpirationTime", certificateExpirationTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "NetworkProfileArn":
            return Optional.ofNullable(clazz.cast(networkProfileArn()));
        case "CertificateArn":
            return Optional.ofNullable(clazz.cast(certificateArn()));
        case "CertificateExpirationTime":
            return Optional.ofNullable(clazz.cast(certificateExpirationTime()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DeviceNetworkProfileInfo, T> g) {
        return obj -> g.apply((DeviceNetworkProfileInfo) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DeviceNetworkProfileInfo> {
        /**
         * <p>
         * The ARN of the network profile associated with a device.
         * </p>
         * 
         * @param networkProfileArn
         *        The ARN of the network profile associated with a device.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder networkProfileArn(String networkProfileArn);

        /**
         * <p>
         * The ARN of the certificate associated with a device.
         * </p>
         * 
         * @param certificateArn
         *        The ARN of the certificate associated with a device.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder certificateArn(String certificateArn);

        /**
         * <p>
         * The time (in epoch) when the certificate expires.
         * </p>
         * 
         * @param certificateExpirationTime
         *        The time (in epoch) when the certificate expires.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder certificateExpirationTime(Instant certificateExpirationTime);
    }

    static final class BuilderImpl implements Builder {
        private String networkProfileArn;

        private String certificateArn;

        private Instant certificateExpirationTime;

        private BuilderImpl() {
        }

        private BuilderImpl(DeviceNetworkProfileInfo model) {
            networkProfileArn(model.networkProfileArn);
            certificateArn(model.certificateArn);
            certificateExpirationTime(model.certificateExpirationTime);
        }

        public final String getNetworkProfileArn() {
            return networkProfileArn;
        }

        public final void setNetworkProfileArn(String networkProfileArn) {
            this.networkProfileArn = networkProfileArn;
        }

        @Override
        @Transient
        public final Builder networkProfileArn(String networkProfileArn) {
            this.networkProfileArn = networkProfileArn;
            return this;
        }

        public final String getCertificateArn() {
            return certificateArn;
        }

        public final void setCertificateArn(String certificateArn) {
            this.certificateArn = certificateArn;
        }

        @Override
        @Transient
        public final Builder certificateArn(String certificateArn) {
            this.certificateArn = certificateArn;
            return this;
        }

        public final Instant getCertificateExpirationTime() {
            return certificateExpirationTime;
        }

        public final void setCertificateExpirationTime(Instant certificateExpirationTime) {
            this.certificateExpirationTime = certificateExpirationTime;
        }

        @Override
        @Transient
        public final Builder certificateExpirationTime(Instant certificateExpirationTime) {
            this.certificateExpirationTime = certificateExpirationTime;
            return this;
        }

        @Override
        public DeviceNetworkProfileInfo build() {
            return new DeviceNetworkProfileInfo(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
