/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.alexaforbusiness.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class SearchUsersResponse extends AlexaForBusinessResponse implements
        ToCopyableBuilder<SearchUsersResponse.Builder, SearchUsersResponse> {
    private static final SdkField<List<UserData>> USERS_FIELD = SdkField
            .<List<UserData>> builder(MarshallingType.LIST)
            .memberName("Users")
            .getter(getter(SearchUsersResponse::users))
            .setter(setter(Builder::users))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Users").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<UserData> builder(MarshallingType.SDK_POJO)
                                            .constructor(UserData::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(SearchUsersResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final SdkField<Integer> TOTAL_COUNT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("TotalCount").getter(getter(SearchUsersResponse::totalCount)).setter(setter(Builder::totalCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TotalCount").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(USERS_FIELD, NEXT_TOKEN_FIELD,
            TOTAL_COUNT_FIELD));

    private final List<UserData> users;

    private final String nextToken;

    private final Integer totalCount;

    private SearchUsersResponse(BuilderImpl builder) {
        super(builder);
        this.users = builder.users;
        this.nextToken = builder.nextToken;
        this.totalCount = builder.totalCount;
    }

    /**
     * For responses, this returns true if the service returned a value for the Users property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasUsers() {
        return users != null && !(users instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The users that meet the specified set of filter criteria, in sort order.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasUsers} method.
     * </p>
     * 
     * @return The users that meet the specified set of filter criteria, in sort order.
     */
    public final List<UserData> users() {
        return users;
    }

    /**
     * <p>
     * The token returned to indicate that there is more data available.
     * </p>
     * 
     * @return The token returned to indicate that there is more data available.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * The total number of users returned.
     * </p>
     * 
     * @return The total number of users returned.
     */
    public final Integer totalCount() {
        return totalCount;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasUsers() ? users() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(totalCount());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SearchUsersResponse)) {
            return false;
        }
        SearchUsersResponse other = (SearchUsersResponse) obj;
        return hasUsers() == other.hasUsers() && Objects.equals(users(), other.users())
                && Objects.equals(nextToken(), other.nextToken()) && Objects.equals(totalCount(), other.totalCount());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SearchUsersResponse").add("Users", hasUsers() ? users() : null).add("NextToken", nextToken())
                .add("TotalCount", totalCount()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Users":
            return Optional.ofNullable(clazz.cast(users()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "TotalCount":
            return Optional.ofNullable(clazz.cast(totalCount()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SearchUsersResponse, T> g) {
        return obj -> g.apply((SearchUsersResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends AlexaForBusinessResponse.Builder, SdkPojo, CopyableBuilder<Builder, SearchUsersResponse> {
        /**
         * <p>
         * The users that meet the specified set of filter criteria, in sort order.
         * </p>
         * 
         * @param users
         *        The users that meet the specified set of filter criteria, in sort order.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder users(Collection<UserData> users);

        /**
         * <p>
         * The users that meet the specified set of filter criteria, in sort order.
         * </p>
         * 
         * @param users
         *        The users that meet the specified set of filter criteria, in sort order.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder users(UserData... users);

        /**
         * <p>
         * The users that meet the specified set of filter criteria, in sort order.
         * </p>
         * This is a convenience that creates an instance of the {@link List<UserData>.Builder} avoiding the need to
         * create one manually via {@link List<UserData>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<UserData>.Builder#build()} is called immediately and its
         * result is passed to {@link #users(List<UserData>)}.
         * 
         * @param users
         *        a consumer that will call methods on {@link List<UserData>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #users(List<UserData>)
         */
        Builder users(Consumer<UserData.Builder>... users);

        /**
         * <p>
         * The token returned to indicate that there is more data available.
         * </p>
         * 
         * @param nextToken
         *        The token returned to indicate that there is more data available.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The total number of users returned.
         * </p>
         * 
         * @param totalCount
         *        The total number of users returned.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder totalCount(Integer totalCount);
    }

    static final class BuilderImpl extends AlexaForBusinessResponse.BuilderImpl implements Builder {
        private List<UserData> users = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private Integer totalCount;

        private BuilderImpl() {
        }

        private BuilderImpl(SearchUsersResponse model) {
            super(model);
            users(model.users);
            nextToken(model.nextToken);
            totalCount(model.totalCount);
        }

        public final List<UserData.Builder> getUsers() {
            List<UserData.Builder> result = UserDataListCopier.copyToBuilder(this.users);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setUsers(Collection<UserData.BuilderImpl> users) {
            this.users = UserDataListCopier.copyFromBuilder(users);
        }

        @Override
        @Transient
        public final Builder users(Collection<UserData> users) {
            this.users = UserDataListCopier.copy(users);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder users(UserData... users) {
            users(Arrays.asList(users));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder users(Consumer<UserData.Builder>... users) {
            users(Stream.of(users).map(c -> UserData.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        @Transient
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final Integer getTotalCount() {
            return totalCount;
        }

        public final void setTotalCount(Integer totalCount) {
            this.totalCount = totalCount;
        }

        @Override
        @Transient
        public final Builder totalCount(Integer totalCount) {
            this.totalCount = totalCount;
            return this;
        }

        @Override
        public SearchUsersResponse build() {
            return new SearchUsersResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
