/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.alexaforbusiness.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class SendAnnouncementRequest extends AlexaForBusinessRequest implements
        ToCopyableBuilder<SendAnnouncementRequest.Builder, SendAnnouncementRequest> {
    private static final SdkField<List<Filter>> ROOM_FILTERS_FIELD = SdkField
            .<List<Filter>> builder(MarshallingType.LIST)
            .memberName("RoomFilters")
            .getter(getter(SendAnnouncementRequest::roomFilters))
            .setter(setter(Builder::roomFilters))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoomFilters").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Filter> builder(MarshallingType.SDK_POJO)
                                            .constructor(Filter::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Content> CONTENT_FIELD = SdkField.<Content> builder(MarshallingType.SDK_POJO)
            .memberName("Content").getter(getter(SendAnnouncementRequest::content)).setter(setter(Builder::content))
            .constructor(Content::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Content").build()).build();

    private static final SdkField<Integer> TIME_TO_LIVE_IN_SECONDS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("TimeToLiveInSeconds").getter(getter(SendAnnouncementRequest::timeToLiveInSeconds))
            .setter(setter(Builder::timeToLiveInSeconds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TimeToLiveInSeconds").build())
            .build();

    private static final SdkField<String> CLIENT_REQUEST_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ClientRequestToken")
            .getter(getter(SendAnnouncementRequest::clientRequestToken))
            .setter(setter(Builder::clientRequestToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientRequestToken").build(),
                    DefaultValueTrait.idempotencyToken()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ROOM_FILTERS_FIELD,
            CONTENT_FIELD, TIME_TO_LIVE_IN_SECONDS_FIELD, CLIENT_REQUEST_TOKEN_FIELD));

    private final List<Filter> roomFilters;

    private final Content content;

    private final Integer timeToLiveInSeconds;

    private final String clientRequestToken;

    private SendAnnouncementRequest(BuilderImpl builder) {
        super(builder);
        this.roomFilters = builder.roomFilters;
        this.content = builder.content;
        this.timeToLiveInSeconds = builder.timeToLiveInSeconds;
        this.clientRequestToken = builder.clientRequestToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the RoomFilters property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasRoomFilters() {
        return roomFilters != null && !(roomFilters instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The filters to use to send an announcement to a specified list of rooms. The supported filter keys are RoomName,
     * ProfileName, RoomArn, and ProfileArn. To send to all rooms, specify an empty RoomFilters list.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasRoomFilters} method.
     * </p>
     * 
     * @return The filters to use to send an announcement to a specified list of rooms. The supported filter keys are
     *         RoomName, ProfileName, RoomArn, and ProfileArn. To send to all rooms, specify an empty RoomFilters list.
     */
    public final List<Filter> roomFilters() {
        return roomFilters;
    }

    /**
     * <p>
     * The announcement content. This can contain only one of the three possible announcement types (text, SSML or
     * audio).
     * </p>
     * 
     * @return The announcement content. This can contain only one of the three possible announcement types (text, SSML
     *         or audio).
     */
    public final Content content() {
        return content;
    }

    /**
     * <p>
     * The time to live for an announcement. Default is 300. If delivery doesn't occur within this time, the
     * announcement is not delivered.
     * </p>
     * 
     * @return The time to live for an announcement. Default is 300. If delivery doesn't occur within this time, the
     *         announcement is not delivered.
     */
    public final Integer timeToLiveInSeconds() {
        return timeToLiveInSeconds;
    }

    /**
     * <p>
     * The unique, user-specified identifier for the request that ensures idempotency.
     * </p>
     * 
     * @return The unique, user-specified identifier for the request that ensures idempotency.
     */
    public final String clientRequestToken() {
        return clientRequestToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasRoomFilters() ? roomFilters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(content());
        hashCode = 31 * hashCode + Objects.hashCode(timeToLiveInSeconds());
        hashCode = 31 * hashCode + Objects.hashCode(clientRequestToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SendAnnouncementRequest)) {
            return false;
        }
        SendAnnouncementRequest other = (SendAnnouncementRequest) obj;
        return hasRoomFilters() == other.hasRoomFilters() && Objects.equals(roomFilters(), other.roomFilters())
                && Objects.equals(content(), other.content())
                && Objects.equals(timeToLiveInSeconds(), other.timeToLiveInSeconds())
                && Objects.equals(clientRequestToken(), other.clientRequestToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SendAnnouncementRequest").add("RoomFilters", hasRoomFilters() ? roomFilters() : null)
                .add("Content", content()).add("TimeToLiveInSeconds", timeToLiveInSeconds())
                .add("ClientRequestToken", clientRequestToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "RoomFilters":
            return Optional.ofNullable(clazz.cast(roomFilters()));
        case "Content":
            return Optional.ofNullable(clazz.cast(content()));
        case "TimeToLiveInSeconds":
            return Optional.ofNullable(clazz.cast(timeToLiveInSeconds()));
        case "ClientRequestToken":
            return Optional.ofNullable(clazz.cast(clientRequestToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SendAnnouncementRequest, T> g) {
        return obj -> g.apply((SendAnnouncementRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends AlexaForBusinessRequest.Builder, SdkPojo, CopyableBuilder<Builder, SendAnnouncementRequest> {
        /**
         * <p>
         * The filters to use to send an announcement to a specified list of rooms. The supported filter keys are
         * RoomName, ProfileName, RoomArn, and ProfileArn. To send to all rooms, specify an empty RoomFilters list.
         * </p>
         * 
         * @param roomFilters
         *        The filters to use to send an announcement to a specified list of rooms. The supported filter keys are
         *        RoomName, ProfileName, RoomArn, and ProfileArn. To send to all rooms, specify an empty RoomFilters
         *        list.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roomFilters(Collection<Filter> roomFilters);

        /**
         * <p>
         * The filters to use to send an announcement to a specified list of rooms. The supported filter keys are
         * RoomName, ProfileName, RoomArn, and ProfileArn. To send to all rooms, specify an empty RoomFilters list.
         * </p>
         * 
         * @param roomFilters
         *        The filters to use to send an announcement to a specified list of rooms. The supported filter keys are
         *        RoomName, ProfileName, RoomArn, and ProfileArn. To send to all rooms, specify an empty RoomFilters
         *        list.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roomFilters(Filter... roomFilters);

        /**
         * <p>
         * The filters to use to send an announcement to a specified list of rooms. The supported filter keys are
         * RoomName, ProfileName, RoomArn, and ProfileArn. To send to all rooms, specify an empty RoomFilters list.
         * </p>
         * This is a convenience that creates an instance of the {@link List<Filter>.Builder} avoiding the need to
         * create one manually via {@link List<Filter>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Filter>.Builder#build()} is called immediately and its
         * result is passed to {@link #roomFilters(List<Filter>)}.
         * 
         * @param roomFilters
         *        a consumer that will call methods on {@link List<Filter>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #roomFilters(List<Filter>)
         */
        Builder roomFilters(Consumer<Filter.Builder>... roomFilters);

        /**
         * <p>
         * The announcement content. This can contain only one of the three possible announcement types (text, SSML or
         * audio).
         * </p>
         * 
         * @param content
         *        The announcement content. This can contain only one of the three possible announcement types (text,
         *        SSML or audio).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder content(Content content);

        /**
         * <p>
         * The announcement content. This can contain only one of the three possible announcement types (text, SSML or
         * audio).
         * </p>
         * This is a convenience that creates an instance of the {@link Content.Builder} avoiding the need to create one
         * manually via {@link Content#builder()}.
         *
         * When the {@link Consumer} completes, {@link Content.Builder#build()} is called immediately and its result is
         * passed to {@link #content(Content)}.
         * 
         * @param content
         *        a consumer that will call methods on {@link Content.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #content(Content)
         */
        default Builder content(Consumer<Content.Builder> content) {
            return content(Content.builder().applyMutation(content).build());
        }

        /**
         * <p>
         * The time to live for an announcement. Default is 300. If delivery doesn't occur within this time, the
         * announcement is not delivered.
         * </p>
         * 
         * @param timeToLiveInSeconds
         *        The time to live for an announcement. Default is 300. If delivery doesn't occur within this time, the
         *        announcement is not delivered.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder timeToLiveInSeconds(Integer timeToLiveInSeconds);

        /**
         * <p>
         * The unique, user-specified identifier for the request that ensures idempotency.
         * </p>
         * 
         * @param clientRequestToken
         *        The unique, user-specified identifier for the request that ensures idempotency.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientRequestToken(String clientRequestToken);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends AlexaForBusinessRequest.BuilderImpl implements Builder {
        private List<Filter> roomFilters = DefaultSdkAutoConstructList.getInstance();

        private Content content;

        private Integer timeToLiveInSeconds;

        private String clientRequestToken;

        private BuilderImpl() {
        }

        private BuilderImpl(SendAnnouncementRequest model) {
            super(model);
            roomFilters(model.roomFilters);
            content(model.content);
            timeToLiveInSeconds(model.timeToLiveInSeconds);
            clientRequestToken(model.clientRequestToken);
        }

        public final List<Filter.Builder> getRoomFilters() {
            List<Filter.Builder> result = FilterListCopier.copyToBuilder(this.roomFilters);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setRoomFilters(Collection<Filter.BuilderImpl> roomFilters) {
            this.roomFilters = FilterListCopier.copyFromBuilder(roomFilters);
        }

        @Override
        @Transient
        public final Builder roomFilters(Collection<Filter> roomFilters) {
            this.roomFilters = FilterListCopier.copy(roomFilters);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder roomFilters(Filter... roomFilters) {
            roomFilters(Arrays.asList(roomFilters));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder roomFilters(Consumer<Filter.Builder>... roomFilters) {
            roomFilters(Stream.of(roomFilters).map(c -> Filter.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final Content.Builder getContent() {
            return content != null ? content.toBuilder() : null;
        }

        public final void setContent(Content.BuilderImpl content) {
            this.content = content != null ? content.build() : null;
        }

        @Override
        @Transient
        public final Builder content(Content content) {
            this.content = content;
            return this;
        }

        public final Integer getTimeToLiveInSeconds() {
            return timeToLiveInSeconds;
        }

        public final void setTimeToLiveInSeconds(Integer timeToLiveInSeconds) {
            this.timeToLiveInSeconds = timeToLiveInSeconds;
        }

        @Override
        @Transient
        public final Builder timeToLiveInSeconds(Integer timeToLiveInSeconds) {
            this.timeToLiveInSeconds = timeToLiveInSeconds;
            return this;
        }

        public final String getClientRequestToken() {
            return clientRequestToken;
        }

        public final void setClientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
        }

        @Override
        @Transient
        public final Builder clientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public SendAnnouncementRequest build() {
            return new SendAnnouncementRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
