/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.alexaforbusiness.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information related to a user.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class UserData implements SdkPojo, Serializable, ToCopyableBuilder<UserData.Builder, UserData> {
    private static final SdkField<String> USER_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("UserArn").getter(getter(UserData::userArn)).setter(setter(Builder::userArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserArn").build()).build();

    private static final SdkField<String> FIRST_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FirstName").getter(getter(UserData::firstName)).setter(setter(Builder::firstName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FirstName").build()).build();

    private static final SdkField<String> LAST_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LastName").getter(getter(UserData::lastName)).setter(setter(Builder::lastName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastName").build()).build();

    private static final SdkField<String> EMAIL_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Email")
            .getter(getter(UserData::email)).setter(setter(Builder::email))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Email").build()).build();

    private static final SdkField<String> ENROLLMENT_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EnrollmentStatus").getter(getter(UserData::enrollmentStatusAsString))
            .setter(setter(Builder::enrollmentStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EnrollmentStatus").build()).build();

    private static final SdkField<String> ENROLLMENT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EnrollmentId").getter(getter(UserData::enrollmentId)).setter(setter(Builder::enrollmentId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EnrollmentId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(USER_ARN_FIELD,
            FIRST_NAME_FIELD, LAST_NAME_FIELD, EMAIL_FIELD, ENROLLMENT_STATUS_FIELD, ENROLLMENT_ID_FIELD));

    private static final long serialVersionUID = 1L;

    private final String userArn;

    private final String firstName;

    private final String lastName;

    private final String email;

    private final String enrollmentStatus;

    private final String enrollmentId;

    private UserData(BuilderImpl builder) {
        this.userArn = builder.userArn;
        this.firstName = builder.firstName;
        this.lastName = builder.lastName;
        this.email = builder.email;
        this.enrollmentStatus = builder.enrollmentStatus;
        this.enrollmentId = builder.enrollmentId;
    }

    /**
     * <p>
     * The ARN of a user.
     * </p>
     * 
     * @return The ARN of a user.
     */
    public final String userArn() {
        return userArn;
    }

    /**
     * <p>
     * The first name of a user.
     * </p>
     * 
     * @return The first name of a user.
     */
    public final String firstName() {
        return firstName;
    }

    /**
     * <p>
     * The last name of a user.
     * </p>
     * 
     * @return The last name of a user.
     */
    public final String lastName() {
        return lastName;
    }

    /**
     * <p>
     * The email of a user.
     * </p>
     * 
     * @return The email of a user.
     */
    public final String email() {
        return email;
    }

    /**
     * <p>
     * The enrollment status of a user.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #enrollmentStatus}
     * will return {@link EnrollmentStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #enrollmentStatusAsString}.
     * </p>
     * 
     * @return The enrollment status of a user.
     * @see EnrollmentStatus
     */
    public final EnrollmentStatus enrollmentStatus() {
        return EnrollmentStatus.fromValue(enrollmentStatus);
    }

    /**
     * <p>
     * The enrollment status of a user.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #enrollmentStatus}
     * will return {@link EnrollmentStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #enrollmentStatusAsString}.
     * </p>
     * 
     * @return The enrollment status of a user.
     * @see EnrollmentStatus
     */
    public final String enrollmentStatusAsString() {
        return enrollmentStatus;
    }

    /**
     * <p>
     * The enrollment ARN of a user.
     * </p>
     * 
     * @return The enrollment ARN of a user.
     */
    public final String enrollmentId() {
        return enrollmentId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(userArn());
        hashCode = 31 * hashCode + Objects.hashCode(firstName());
        hashCode = 31 * hashCode + Objects.hashCode(lastName());
        hashCode = 31 * hashCode + Objects.hashCode(email());
        hashCode = 31 * hashCode + Objects.hashCode(enrollmentStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(enrollmentId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UserData)) {
            return false;
        }
        UserData other = (UserData) obj;
        return Objects.equals(userArn(), other.userArn()) && Objects.equals(firstName(), other.firstName())
                && Objects.equals(lastName(), other.lastName()) && Objects.equals(email(), other.email())
                && Objects.equals(enrollmentStatusAsString(), other.enrollmentStatusAsString())
                && Objects.equals(enrollmentId(), other.enrollmentId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UserData").add("UserArn", userArn()).add("FirstName", firstName()).add("LastName", lastName())
                .add("Email", email()).add("EnrollmentStatus", enrollmentStatusAsString()).add("EnrollmentId", enrollmentId())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "UserArn":
            return Optional.ofNullable(clazz.cast(userArn()));
        case "FirstName":
            return Optional.ofNullable(clazz.cast(firstName()));
        case "LastName":
            return Optional.ofNullable(clazz.cast(lastName()));
        case "Email":
            return Optional.ofNullable(clazz.cast(email()));
        case "EnrollmentStatus":
            return Optional.ofNullable(clazz.cast(enrollmentStatusAsString()));
        case "EnrollmentId":
            return Optional.ofNullable(clazz.cast(enrollmentId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UserData, T> g) {
        return obj -> g.apply((UserData) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, UserData> {
        /**
         * <p>
         * The ARN of a user.
         * </p>
         * 
         * @param userArn
         *        The ARN of a user.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userArn(String userArn);

        /**
         * <p>
         * The first name of a user.
         * </p>
         * 
         * @param firstName
         *        The first name of a user.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder firstName(String firstName);

        /**
         * <p>
         * The last name of a user.
         * </p>
         * 
         * @param lastName
         *        The last name of a user.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastName(String lastName);

        /**
         * <p>
         * The email of a user.
         * </p>
         * 
         * @param email
         *        The email of a user.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder email(String email);

        /**
         * <p>
         * The enrollment status of a user.
         * </p>
         * 
         * @param enrollmentStatus
         *        The enrollment status of a user.
         * @see EnrollmentStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EnrollmentStatus
         */
        Builder enrollmentStatus(String enrollmentStatus);

        /**
         * <p>
         * The enrollment status of a user.
         * </p>
         * 
         * @param enrollmentStatus
         *        The enrollment status of a user.
         * @see EnrollmentStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EnrollmentStatus
         */
        Builder enrollmentStatus(EnrollmentStatus enrollmentStatus);

        /**
         * <p>
         * The enrollment ARN of a user.
         * </p>
         * 
         * @param enrollmentId
         *        The enrollment ARN of a user.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enrollmentId(String enrollmentId);
    }

    static final class BuilderImpl implements Builder {
        private String userArn;

        private String firstName;

        private String lastName;

        private String email;

        private String enrollmentStatus;

        private String enrollmentId;

        private BuilderImpl() {
        }

        private BuilderImpl(UserData model) {
            userArn(model.userArn);
            firstName(model.firstName);
            lastName(model.lastName);
            email(model.email);
            enrollmentStatus(model.enrollmentStatus);
            enrollmentId(model.enrollmentId);
        }

        public final String getUserArn() {
            return userArn;
        }

        public final void setUserArn(String userArn) {
            this.userArn = userArn;
        }

        @Override
        @Transient
        public final Builder userArn(String userArn) {
            this.userArn = userArn;
            return this;
        }

        public final String getFirstName() {
            return firstName;
        }

        public final void setFirstName(String firstName) {
            this.firstName = firstName;
        }

        @Override
        @Transient
        public final Builder firstName(String firstName) {
            this.firstName = firstName;
            return this;
        }

        public final String getLastName() {
            return lastName;
        }

        public final void setLastName(String lastName) {
            this.lastName = lastName;
        }

        @Override
        @Transient
        public final Builder lastName(String lastName) {
            this.lastName = lastName;
            return this;
        }

        public final String getEmail() {
            return email;
        }

        public final void setEmail(String email) {
            this.email = email;
        }

        @Override
        @Transient
        public final Builder email(String email) {
            this.email = email;
            return this;
        }

        public final String getEnrollmentStatus() {
            return enrollmentStatus;
        }

        public final void setEnrollmentStatus(String enrollmentStatus) {
            this.enrollmentStatus = enrollmentStatus;
        }

        @Override
        @Transient
        public final Builder enrollmentStatus(String enrollmentStatus) {
            this.enrollmentStatus = enrollmentStatus;
            return this;
        }

        @Override
        @Transient
        public final Builder enrollmentStatus(EnrollmentStatus enrollmentStatus) {
            this.enrollmentStatus(enrollmentStatus == null ? null : enrollmentStatus.toString());
            return this;
        }

        public final String getEnrollmentId() {
            return enrollmentId;
        }

        public final void setEnrollmentId(String enrollmentId) {
            this.enrollmentId = enrollmentId;
        }

        @Override
        @Transient
        public final Builder enrollmentId(String enrollmentId) {
            this.enrollmentId = enrollmentId;
            return this;
        }

        @Override
        public UserData build() {
            return new UserData(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
