/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.alexaforbusiness.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.alexaforbusiness.model.AlexaForBusinessRequest;
import software.amazon.awssdk.services.alexaforbusiness.model.PhoneNumber;
import software.amazon.awssdk.services.alexaforbusiness.model.PhoneNumberListCopier;
import software.amazon.awssdk.services.alexaforbusiness.model.SipAddress;
import software.amazon.awssdk.services.alexaforbusiness.model.SipAddressListCopier;
import software.amazon.awssdk.services.alexaforbusiness.model.Tag;
import software.amazon.awssdk.services.alexaforbusiness.model.TagListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateContactRequest
extends AlexaForBusinessRequest
implements ToCopyableBuilder<Builder, CreateContactRequest> {
    private static final SdkField<String> DISPLAY_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DisplayName").getter(CreateContactRequest.getter(CreateContactRequest::displayName)).setter(CreateContactRequest.setter(Builder::displayName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DisplayName").build()}).build();
    private static final SdkField<String> FIRST_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FirstName").getter(CreateContactRequest.getter(CreateContactRequest::firstName)).setter(CreateContactRequest.setter(Builder::firstName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FirstName").build()}).build();
    private static final SdkField<String> LAST_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LastName").getter(CreateContactRequest.getter(CreateContactRequest::lastName)).setter(CreateContactRequest.setter(Builder::lastName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastName").build()}).build();
    private static final SdkField<String> PHONE_NUMBER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PhoneNumber").getter(CreateContactRequest.getter(CreateContactRequest::phoneNumber)).setter(CreateContactRequest.setter(Builder::phoneNumber)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PhoneNumber").build()}).build();
    private static final SdkField<List<PhoneNumber>> PHONE_NUMBERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("PhoneNumbers").getter(CreateContactRequest.getter(CreateContactRequest::phoneNumbers)).setter(CreateContactRequest.setter(Builder::phoneNumbers)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PhoneNumbers").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(PhoneNumber::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<SipAddress>> SIP_ADDRESSES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("SipAddresses").getter(CreateContactRequest.getter(CreateContactRequest::sipAddresses)).setter(CreateContactRequest.setter(Builder::sipAddresses)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SipAddresses").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(SipAddress::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> CLIENT_REQUEST_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ClientRequestToken").getter(CreateContactRequest.getter(CreateContactRequest::clientRequestToken)).setter(CreateContactRequest.setter(Builder::clientRequestToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientRequestToken").build(), DefaultValueTrait.idempotencyToken()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Tags").getter(CreateContactRequest.getter(CreateContactRequest::tags)).setter(CreateContactRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DISPLAY_NAME_FIELD, FIRST_NAME_FIELD, LAST_NAME_FIELD, PHONE_NUMBER_FIELD, PHONE_NUMBERS_FIELD, SIP_ADDRESSES_FIELD, CLIENT_REQUEST_TOKEN_FIELD, TAGS_FIELD));
    private final String displayName;
    private final String firstName;
    private final String lastName;
    private final String phoneNumber;
    private final List<PhoneNumber> phoneNumbers;
    private final List<SipAddress> sipAddresses;
    private final String clientRequestToken;
    private final List<Tag> tags;

    private CreateContactRequest(BuilderImpl builder) {
        super(builder);
        this.displayName = builder.displayName;
        this.firstName = builder.firstName;
        this.lastName = builder.lastName;
        this.phoneNumber = builder.phoneNumber;
        this.phoneNumbers = builder.phoneNumbers;
        this.sipAddresses = builder.sipAddresses;
        this.clientRequestToken = builder.clientRequestToken;
        this.tags = builder.tags;
    }

    public final String displayName() {
        return this.displayName;
    }

    public final String firstName() {
        return this.firstName;
    }

    public final String lastName() {
        return this.lastName;
    }

    public final String phoneNumber() {
        return this.phoneNumber;
    }

    public final boolean hasPhoneNumbers() {
        return this.phoneNumbers != null && !(this.phoneNumbers instanceof SdkAutoConstructList);
    }

    public final List<PhoneNumber> phoneNumbers() {
        return this.phoneNumbers;
    }

    public final boolean hasSipAddresses() {
        return this.sipAddresses != null && !(this.sipAddresses instanceof SdkAutoConstructList);
    }

    public final List<SipAddress> sipAddresses() {
        return this.sipAddresses;
    }

    public final String clientRequestToken() {
        return this.clientRequestToken;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public final List<Tag> tags() {
        return this.tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.displayName());
        hashCode = 31 * hashCode + Objects.hashCode(this.firstName());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastName());
        hashCode = 31 * hashCode + Objects.hashCode(this.phoneNumber());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasPhoneNumbers() ? this.phoneNumbers() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSipAddresses() ? this.sipAddresses() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.clientRequestToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateContactRequest)) {
            return false;
        }
        CreateContactRequest other = (CreateContactRequest)((Object)obj);
        return Objects.equals(this.displayName(), other.displayName()) && Objects.equals(this.firstName(), other.firstName()) && Objects.equals(this.lastName(), other.lastName()) && Objects.equals(this.phoneNumber(), other.phoneNumber()) && this.hasPhoneNumbers() == other.hasPhoneNumbers() && Objects.equals(this.phoneNumbers(), other.phoneNumbers()) && this.hasSipAddresses() == other.hasSipAddresses() && Objects.equals(this.sipAddresses(), other.sipAddresses()) && Objects.equals(this.clientRequestToken(), other.clientRequestToken()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public final String toString() {
        return ToString.builder((String)"CreateContactRequest").add("DisplayName", (Object)this.displayName()).add("FirstName", (Object)this.firstName()).add("LastName", (Object)this.lastName()).add("PhoneNumber", (Object)(this.phoneNumber() == null ? null : "*** Sensitive Data Redacted ***")).add("PhoneNumbers", this.hasPhoneNumbers() ? this.phoneNumbers() : null).add("SipAddresses", this.hasSipAddresses() ? this.sipAddresses() : null).add("ClientRequestToken", (Object)this.clientRequestToken()).add("Tags", this.hasTags() ? this.tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DisplayName": {
                return Optional.ofNullable(clazz.cast(this.displayName()));
            }
            case "FirstName": {
                return Optional.ofNullable(clazz.cast(this.firstName()));
            }
            case "LastName": {
                return Optional.ofNullable(clazz.cast(this.lastName()));
            }
            case "PhoneNumber": {
                return Optional.ofNullable(clazz.cast(this.phoneNumber()));
            }
            case "PhoneNumbers": {
                return Optional.ofNullable(clazz.cast(this.phoneNumbers()));
            }
            case "SipAddresses": {
                return Optional.ofNullable(clazz.cast(this.sipAddresses()));
            }
            case "ClientRequestToken": {
                return Optional.ofNullable(clazz.cast(this.clientRequestToken()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateContactRequest, T> g) {
        return obj -> g.apply((CreateContactRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends AlexaForBusinessRequest.BuilderImpl
    implements Builder {
        private String displayName;
        private String firstName;
        private String lastName;
        private String phoneNumber;
        private List<PhoneNumber> phoneNumbers = DefaultSdkAutoConstructList.getInstance();
        private List<SipAddress> sipAddresses = DefaultSdkAutoConstructList.getInstance();
        private String clientRequestToken;
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateContactRequest model) {
            super(model);
            this.displayName(model.displayName);
            this.firstName(model.firstName);
            this.lastName(model.lastName);
            this.phoneNumber(model.phoneNumber);
            this.phoneNumbers(model.phoneNumbers);
            this.sipAddresses(model.sipAddresses);
            this.clientRequestToken(model.clientRequestToken);
            this.tags(model.tags);
        }

        public final String getDisplayName() {
            return this.displayName;
        }

        public final void setDisplayName(String displayName) {
            this.displayName = displayName;
        }

        @Override
        public final Builder displayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        public final String getFirstName() {
            return this.firstName;
        }

        public final void setFirstName(String firstName) {
            this.firstName = firstName;
        }

        @Override
        public final Builder firstName(String firstName) {
            this.firstName = firstName;
            return this;
        }

        public final String getLastName() {
            return this.lastName;
        }

        public final void setLastName(String lastName) {
            this.lastName = lastName;
        }

        @Override
        public final Builder lastName(String lastName) {
            this.lastName = lastName;
            return this;
        }

        public final String getPhoneNumber() {
            return this.phoneNumber;
        }

        public final void setPhoneNumber(String phoneNumber) {
            this.phoneNumber = phoneNumber;
        }

        @Override
        public final Builder phoneNumber(String phoneNumber) {
            this.phoneNumber = phoneNumber;
            return this;
        }

        public final List<PhoneNumber.Builder> getPhoneNumbers() {
            List<PhoneNumber.Builder> result = PhoneNumberListCopier.copyToBuilder(this.phoneNumbers);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setPhoneNumbers(Collection<PhoneNumber.BuilderImpl> phoneNumbers) {
            this.phoneNumbers = PhoneNumberListCopier.copyFromBuilder(phoneNumbers);
        }

        @Override
        public final Builder phoneNumbers(Collection<PhoneNumber> phoneNumbers) {
            this.phoneNumbers = PhoneNumberListCopier.copy(phoneNumbers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder phoneNumbers(PhoneNumber ... phoneNumbers) {
            this.phoneNumbers(Arrays.asList(phoneNumbers));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder phoneNumbers(Consumer<PhoneNumber.Builder> ... phoneNumbers) {
            this.phoneNumbers(Stream.of(phoneNumbers).map(c -> (PhoneNumber)((PhoneNumber.Builder)PhoneNumber.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<SipAddress.Builder> getSipAddresses() {
            List<SipAddress.Builder> result = SipAddressListCopier.copyToBuilder(this.sipAddresses);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSipAddresses(Collection<SipAddress.BuilderImpl> sipAddresses) {
            this.sipAddresses = SipAddressListCopier.copyFromBuilder(sipAddresses);
        }

        @Override
        public final Builder sipAddresses(Collection<SipAddress> sipAddresses) {
            this.sipAddresses = SipAddressListCopier.copy(sipAddresses);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sipAddresses(SipAddress ... sipAddresses) {
            this.sipAddresses(Arrays.asList(sipAddresses));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sipAddresses(Consumer<SipAddress.Builder> ... sipAddresses) {
            this.sipAddresses(Stream.of(sipAddresses).map(c -> (SipAddress)((SipAddress.Builder)SipAddress.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getClientRequestToken() {
            return this.clientRequestToken;
        }

        public final void setClientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
        }

        @Override
        public final Builder clientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateContactRequest build() {
            return new CreateContactRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends AlexaForBusinessRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateContactRequest> {
        public Builder displayName(String var1);

        public Builder firstName(String var1);

        public Builder lastName(String var1);

        public Builder phoneNumber(String var1);

        public Builder phoneNumbers(Collection<PhoneNumber> var1);

        public Builder phoneNumbers(PhoneNumber ... var1);

        public Builder phoneNumbers(Consumer<PhoneNumber.Builder> ... var1);

        public Builder sipAddresses(Collection<SipAddress> var1);

        public Builder sipAddresses(SipAddress ... var1);

        public Builder sipAddresses(Consumer<SipAddress.Builder> ... var1);

        public Builder clientRequestToken(String var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

