/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.alexaforbusiness.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.alexaforbusiness.AlexaForBusinessClient;
import software.amazon.awssdk.services.alexaforbusiness.model.ListConferenceProvidersRequest;
import software.amazon.awssdk.services.alexaforbusiness.model.ListConferenceProvidersResponse;

public class ListConferenceProvidersIterable
implements SdkIterable<ListConferenceProvidersResponse> {
    private final AlexaForBusinessClient client;
    private final ListConferenceProvidersRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListConferenceProvidersIterable(AlexaForBusinessClient client, ListConferenceProvidersRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListConferenceProvidersResponseFetcher();
    }

    public Iterator<ListConferenceProvidersResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class ListConferenceProvidersResponseFetcher
    implements SyncPageFetcher<ListConferenceProvidersResponse> {
        private ListConferenceProvidersResponseFetcher() {
        }

        public boolean hasNextPage(ListConferenceProvidersResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListConferenceProvidersResponse nextPage(ListConferenceProvidersResponse previousPage) {
            if (previousPage == null) {
                return ListConferenceProvidersIterable.this.client.listConferenceProviders(ListConferenceProvidersIterable.this.firstRequest);
            }
            return ListConferenceProvidersIterable.this.client.listConferenceProviders((ListConferenceProvidersRequest)((Object)ListConferenceProvidersIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

