/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.alexaforbusiness.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.alexaforbusiness.model.NetworkEapMethod;
import software.amazon.awssdk.services.alexaforbusiness.model.NetworkSecurityType;
import software.amazon.awssdk.services.alexaforbusiness.model.TrustAnchorListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class NetworkProfile
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, NetworkProfile> {
    private static final SdkField<String> NETWORK_PROFILE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NetworkProfileArn").getter(NetworkProfile.getter(NetworkProfile::networkProfileArn)).setter(NetworkProfile.setter(Builder::networkProfileArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NetworkProfileArn").build()}).build();
    private static final SdkField<String> NETWORK_PROFILE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NetworkProfileName").getter(NetworkProfile.getter(NetworkProfile::networkProfileName)).setter(NetworkProfile.setter(Builder::networkProfileName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NetworkProfileName").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(NetworkProfile.getter(NetworkProfile::description)).setter(NetworkProfile.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<String> SSID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Ssid").getter(NetworkProfile.getter(NetworkProfile::ssid)).setter(NetworkProfile.setter(Builder::ssid)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Ssid").build()}).build();
    private static final SdkField<String> SECURITY_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SecurityType").getter(NetworkProfile.getter(NetworkProfile::securityTypeAsString)).setter(NetworkProfile.setter(Builder::securityType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecurityType").build()}).build();
    private static final SdkField<String> EAP_METHOD_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EapMethod").getter(NetworkProfile.getter(NetworkProfile::eapMethodAsString)).setter(NetworkProfile.setter(Builder::eapMethod)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EapMethod").build()}).build();
    private static final SdkField<String> CURRENT_PASSWORD_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CurrentPassword").getter(NetworkProfile.getter(NetworkProfile::currentPassword)).setter(NetworkProfile.setter(Builder::currentPassword)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CurrentPassword").build()}).build();
    private static final SdkField<String> NEXT_PASSWORD_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextPassword").getter(NetworkProfile.getter(NetworkProfile::nextPassword)).setter(NetworkProfile.setter(Builder::nextPassword)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextPassword").build()}).build();
    private static final SdkField<String> CERTIFICATE_AUTHORITY_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CertificateAuthorityArn").getter(NetworkProfile.getter(NetworkProfile::certificateAuthorityArn)).setter(NetworkProfile.setter(Builder::certificateAuthorityArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CertificateAuthorityArn").build()}).build();
    private static final SdkField<List<String>> TRUST_ANCHORS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("TrustAnchors").getter(NetworkProfile.getter(NetworkProfile::trustAnchors)).setter(NetworkProfile.setter(Builder::trustAnchors)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TrustAnchors").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NETWORK_PROFILE_ARN_FIELD, NETWORK_PROFILE_NAME_FIELD, DESCRIPTION_FIELD, SSID_FIELD, SECURITY_TYPE_FIELD, EAP_METHOD_FIELD, CURRENT_PASSWORD_FIELD, NEXT_PASSWORD_FIELD, CERTIFICATE_AUTHORITY_ARN_FIELD, TRUST_ANCHORS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String networkProfileArn;
    private final String networkProfileName;
    private final String description;
    private final String ssid;
    private final String securityType;
    private final String eapMethod;
    private final String currentPassword;
    private final String nextPassword;
    private final String certificateAuthorityArn;
    private final List<String> trustAnchors;

    private NetworkProfile(BuilderImpl builder) {
        this.networkProfileArn = builder.networkProfileArn;
        this.networkProfileName = builder.networkProfileName;
        this.description = builder.description;
        this.ssid = builder.ssid;
        this.securityType = builder.securityType;
        this.eapMethod = builder.eapMethod;
        this.currentPassword = builder.currentPassword;
        this.nextPassword = builder.nextPassword;
        this.certificateAuthorityArn = builder.certificateAuthorityArn;
        this.trustAnchors = builder.trustAnchors;
    }

    public final String networkProfileArn() {
        return this.networkProfileArn;
    }

    public final String networkProfileName() {
        return this.networkProfileName;
    }

    public final String description() {
        return this.description;
    }

    public final String ssid() {
        return this.ssid;
    }

    public final NetworkSecurityType securityType() {
        return NetworkSecurityType.fromValue(this.securityType);
    }

    public final String securityTypeAsString() {
        return this.securityType;
    }

    public final NetworkEapMethod eapMethod() {
        return NetworkEapMethod.fromValue(this.eapMethod);
    }

    public final String eapMethodAsString() {
        return this.eapMethod;
    }

    public final String currentPassword() {
        return this.currentPassword;
    }

    public final String nextPassword() {
        return this.nextPassword;
    }

    public final String certificateAuthorityArn() {
        return this.certificateAuthorityArn;
    }

    public final boolean hasTrustAnchors() {
        return this.trustAnchors != null && !(this.trustAnchors instanceof SdkAutoConstructList);
    }

    public final List<String> trustAnchors() {
        return this.trustAnchors;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.networkProfileArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.networkProfileName());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.ssid());
        hashCode = 31 * hashCode + Objects.hashCode(this.securityTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.eapMethodAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.currentPassword());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextPassword());
        hashCode = 31 * hashCode + Objects.hashCode(this.certificateAuthorityArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTrustAnchors() ? this.trustAnchors() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof NetworkProfile)) {
            return false;
        }
        NetworkProfile other = (NetworkProfile)obj;
        return Objects.equals(this.networkProfileArn(), other.networkProfileArn()) && Objects.equals(this.networkProfileName(), other.networkProfileName()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.ssid(), other.ssid()) && Objects.equals(this.securityTypeAsString(), other.securityTypeAsString()) && Objects.equals(this.eapMethodAsString(), other.eapMethodAsString()) && Objects.equals(this.currentPassword(), other.currentPassword()) && Objects.equals(this.nextPassword(), other.nextPassword()) && Objects.equals(this.certificateAuthorityArn(), other.certificateAuthorityArn()) && this.hasTrustAnchors() == other.hasTrustAnchors() && Objects.equals(this.trustAnchors(), other.trustAnchors());
    }

    public final String toString() {
        return ToString.builder((String)"NetworkProfile").add("NetworkProfileArn", (Object)this.networkProfileArn()).add("NetworkProfileName", (Object)this.networkProfileName()).add("Description", (Object)this.description()).add("Ssid", (Object)this.ssid()).add("SecurityType", (Object)this.securityTypeAsString()).add("EapMethod", (Object)this.eapMethodAsString()).add("CurrentPassword", (Object)(this.currentPassword() == null ? null : "*** Sensitive Data Redacted ***")).add("NextPassword", (Object)(this.nextPassword() == null ? null : "*** Sensitive Data Redacted ***")).add("CertificateAuthorityArn", (Object)this.certificateAuthorityArn()).add("TrustAnchors", this.hasTrustAnchors() ? this.trustAnchors() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "NetworkProfileArn": {
                return Optional.ofNullable(clazz.cast(this.networkProfileArn()));
            }
            case "NetworkProfileName": {
                return Optional.ofNullable(clazz.cast(this.networkProfileName()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "Ssid": {
                return Optional.ofNullable(clazz.cast(this.ssid()));
            }
            case "SecurityType": {
                return Optional.ofNullable(clazz.cast(this.securityTypeAsString()));
            }
            case "EapMethod": {
                return Optional.ofNullable(clazz.cast(this.eapMethodAsString()));
            }
            case "CurrentPassword": {
                return Optional.ofNullable(clazz.cast(this.currentPassword()));
            }
            case "NextPassword": {
                return Optional.ofNullable(clazz.cast(this.nextPassword()));
            }
            case "CertificateAuthorityArn": {
                return Optional.ofNullable(clazz.cast(this.certificateAuthorityArn()));
            }
            case "TrustAnchors": {
                return Optional.ofNullable(clazz.cast(this.trustAnchors()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<NetworkProfile, T> g) {
        return obj -> g.apply((NetworkProfile)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String networkProfileArn;
        private String networkProfileName;
        private String description;
        private String ssid;
        private String securityType;
        private String eapMethod;
        private String currentPassword;
        private String nextPassword;
        private String certificateAuthorityArn;
        private List<String> trustAnchors = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(NetworkProfile model) {
            this.networkProfileArn(model.networkProfileArn);
            this.networkProfileName(model.networkProfileName);
            this.description(model.description);
            this.ssid(model.ssid);
            this.securityType(model.securityType);
            this.eapMethod(model.eapMethod);
            this.currentPassword(model.currentPassword);
            this.nextPassword(model.nextPassword);
            this.certificateAuthorityArn(model.certificateAuthorityArn);
            this.trustAnchors(model.trustAnchors);
        }

        public final String getNetworkProfileArn() {
            return this.networkProfileArn;
        }

        public final void setNetworkProfileArn(String networkProfileArn) {
            this.networkProfileArn = networkProfileArn;
        }

        @Override
        @Transient
        public final Builder networkProfileArn(String networkProfileArn) {
            this.networkProfileArn = networkProfileArn;
            return this;
        }

        public final String getNetworkProfileName() {
            return this.networkProfileName;
        }

        public final void setNetworkProfileName(String networkProfileName) {
            this.networkProfileName = networkProfileName;
        }

        @Override
        @Transient
        public final Builder networkProfileName(String networkProfileName) {
            this.networkProfileName = networkProfileName;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        @Transient
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getSsid() {
            return this.ssid;
        }

        public final void setSsid(String ssid) {
            this.ssid = ssid;
        }

        @Override
        @Transient
        public final Builder ssid(String ssid) {
            this.ssid = ssid;
            return this;
        }

        public final String getSecurityType() {
            return this.securityType;
        }

        public final void setSecurityType(String securityType) {
            this.securityType = securityType;
        }

        @Override
        @Transient
        public final Builder securityType(String securityType) {
            this.securityType = securityType;
            return this;
        }

        @Override
        @Transient
        public final Builder securityType(NetworkSecurityType securityType) {
            this.securityType(securityType == null ? null : securityType.toString());
            return this;
        }

        public final String getEapMethod() {
            return this.eapMethod;
        }

        public final void setEapMethod(String eapMethod) {
            this.eapMethod = eapMethod;
        }

        @Override
        @Transient
        public final Builder eapMethod(String eapMethod) {
            this.eapMethod = eapMethod;
            return this;
        }

        @Override
        @Transient
        public final Builder eapMethod(NetworkEapMethod eapMethod) {
            this.eapMethod(eapMethod == null ? null : eapMethod.toString());
            return this;
        }

        public final String getCurrentPassword() {
            return this.currentPassword;
        }

        public final void setCurrentPassword(String currentPassword) {
            this.currentPassword = currentPassword;
        }

        @Override
        @Transient
        public final Builder currentPassword(String currentPassword) {
            this.currentPassword = currentPassword;
            return this;
        }

        public final String getNextPassword() {
            return this.nextPassword;
        }

        public final void setNextPassword(String nextPassword) {
            this.nextPassword = nextPassword;
        }

        @Override
        @Transient
        public final Builder nextPassword(String nextPassword) {
            this.nextPassword = nextPassword;
            return this;
        }

        public final String getCertificateAuthorityArn() {
            return this.certificateAuthorityArn;
        }

        public final void setCertificateAuthorityArn(String certificateAuthorityArn) {
            this.certificateAuthorityArn = certificateAuthorityArn;
        }

        @Override
        @Transient
        public final Builder certificateAuthorityArn(String certificateAuthorityArn) {
            this.certificateAuthorityArn = certificateAuthorityArn;
            return this;
        }

        public final Collection<String> getTrustAnchors() {
            if (this.trustAnchors instanceof SdkAutoConstructList) {
                return null;
            }
            return this.trustAnchors;
        }

        public final void setTrustAnchors(Collection<String> trustAnchors) {
            this.trustAnchors = TrustAnchorListCopier.copy(trustAnchors);
        }

        @Override
        @Transient
        public final Builder trustAnchors(Collection<String> trustAnchors) {
            this.trustAnchors = TrustAnchorListCopier.copy(trustAnchors);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder trustAnchors(String ... trustAnchors) {
            this.trustAnchors(Arrays.asList(trustAnchors));
            return this;
        }

        public NetworkProfile build() {
            return new NetworkProfile(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, NetworkProfile> {
        public Builder networkProfileArn(String var1);

        public Builder networkProfileName(String var1);

        public Builder description(String var1);

        public Builder ssid(String var1);

        public Builder securityType(String var1);

        public Builder securityType(NetworkSecurityType var1);

        public Builder eapMethod(String var1);

        public Builder eapMethod(NetworkEapMethod var1);

        public Builder currentPassword(String var1);

        public Builder nextPassword(String var1);

        public Builder certificateAuthorityArn(String var1);

        public Builder trustAnchors(Collection<String> var1);

        public Builder trustAnchors(String ... var1);
    }
}

