/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.alexaforbusiness.model;

import java.beans.Transient;
import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Device attributes.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DeviceData implements SdkPojo, Serializable, ToCopyableBuilder<DeviceData.Builder, DeviceData> {
    private static final SdkField<String> DEVICE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DeviceArn").getter(getter(DeviceData::deviceArn)).setter(setter(Builder::deviceArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeviceArn").build()).build();

    private static final SdkField<String> DEVICE_SERIAL_NUMBER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DeviceSerialNumber").getter(getter(DeviceData::deviceSerialNumber))
            .setter(setter(Builder::deviceSerialNumber))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeviceSerialNumber").build())
            .build();

    private static final SdkField<String> DEVICE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DeviceType").getter(getter(DeviceData::deviceType)).setter(setter(Builder::deviceType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeviceType").build()).build();

    private static final SdkField<String> DEVICE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DeviceName").getter(getter(DeviceData::deviceName)).setter(setter(Builder::deviceName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeviceName").build()).build();

    private static final SdkField<String> SOFTWARE_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SoftwareVersion").getter(getter(DeviceData::softwareVersion)).setter(setter(Builder::softwareVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SoftwareVersion").build()).build();

    private static final SdkField<String> MAC_ADDRESS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("MacAddress").getter(getter(DeviceData::macAddress)).setter(setter(Builder::macAddress))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MacAddress").build()).build();

    private static final SdkField<String> DEVICE_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DeviceStatus").getter(getter(DeviceData::deviceStatusAsString)).setter(setter(Builder::deviceStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeviceStatus").build()).build();

    private static final SdkField<String> NETWORK_PROFILE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NetworkProfileArn").getter(getter(DeviceData::networkProfileArn))
            .setter(setter(Builder::networkProfileArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NetworkProfileArn").build()).build();

    private static final SdkField<String> NETWORK_PROFILE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NetworkProfileName").getter(getter(DeviceData::networkProfileName))
            .setter(setter(Builder::networkProfileName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NetworkProfileName").build())
            .build();

    private static final SdkField<String> ROOM_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RoomArn").getter(getter(DeviceData::roomArn)).setter(setter(Builder::roomArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoomArn").build()).build();

    private static final SdkField<String> ROOM_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RoomName").getter(getter(DeviceData::roomName)).setter(setter(Builder::roomName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoomName").build()).build();

    private static final SdkField<DeviceStatusInfo> DEVICE_STATUS_INFO_FIELD = SdkField
            .<DeviceStatusInfo> builder(MarshallingType.SDK_POJO).memberName("DeviceStatusInfo")
            .getter(getter(DeviceData::deviceStatusInfo)).setter(setter(Builder::deviceStatusInfo))
            .constructor(DeviceStatusInfo::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeviceStatusInfo").build()).build();

    private static final SdkField<Instant> CREATED_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreatedTime").getter(getter(DeviceData::createdTime)).setter(setter(Builder::createdTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedTime").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DEVICE_ARN_FIELD,
            DEVICE_SERIAL_NUMBER_FIELD, DEVICE_TYPE_FIELD, DEVICE_NAME_FIELD, SOFTWARE_VERSION_FIELD, MAC_ADDRESS_FIELD,
            DEVICE_STATUS_FIELD, NETWORK_PROFILE_ARN_FIELD, NETWORK_PROFILE_NAME_FIELD, ROOM_ARN_FIELD, ROOM_NAME_FIELD,
            DEVICE_STATUS_INFO_FIELD, CREATED_TIME_FIELD));

    private static final long serialVersionUID = 1L;

    private final String deviceArn;

    private final String deviceSerialNumber;

    private final String deviceType;

    private final String deviceName;

    private final String softwareVersion;

    private final String macAddress;

    private final String deviceStatus;

    private final String networkProfileArn;

    private final String networkProfileName;

    private final String roomArn;

    private final String roomName;

    private final DeviceStatusInfo deviceStatusInfo;

    private final Instant createdTime;

    private DeviceData(BuilderImpl builder) {
        this.deviceArn = builder.deviceArn;
        this.deviceSerialNumber = builder.deviceSerialNumber;
        this.deviceType = builder.deviceType;
        this.deviceName = builder.deviceName;
        this.softwareVersion = builder.softwareVersion;
        this.macAddress = builder.macAddress;
        this.deviceStatus = builder.deviceStatus;
        this.networkProfileArn = builder.networkProfileArn;
        this.networkProfileName = builder.networkProfileName;
        this.roomArn = builder.roomArn;
        this.roomName = builder.roomName;
        this.deviceStatusInfo = builder.deviceStatusInfo;
        this.createdTime = builder.createdTime;
    }

    /**
     * <p>
     * The ARN of a device.
     * </p>
     * 
     * @return The ARN of a device.
     */
    public final String deviceArn() {
        return deviceArn;
    }

    /**
     * <p>
     * The serial number of a device.
     * </p>
     * 
     * @return The serial number of a device.
     */
    public final String deviceSerialNumber() {
        return deviceSerialNumber;
    }

    /**
     * <p>
     * The type of a device.
     * </p>
     * 
     * @return The type of a device.
     */
    public final String deviceType() {
        return deviceType;
    }

    /**
     * <p>
     * The name of a device.
     * </p>
     * 
     * @return The name of a device.
     */
    public final String deviceName() {
        return deviceName;
    }

    /**
     * <p>
     * The software version of a device.
     * </p>
     * 
     * @return The software version of a device.
     */
    public final String softwareVersion() {
        return softwareVersion;
    }

    /**
     * <p>
     * The MAC address of a device.
     * </p>
     * 
     * @return The MAC address of a device.
     */
    public final String macAddress() {
        return macAddress;
    }

    /**
     * <p>
     * The status of a device.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #deviceStatus} will
     * return {@link DeviceStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #deviceStatusAsString}.
     * </p>
     * 
     * @return The status of a device.
     * @see DeviceStatus
     */
    public final DeviceStatus deviceStatus() {
        return DeviceStatus.fromValue(deviceStatus);
    }

    /**
     * <p>
     * The status of a device.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #deviceStatus} will
     * return {@link DeviceStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #deviceStatusAsString}.
     * </p>
     * 
     * @return The status of a device.
     * @see DeviceStatus
     */
    public final String deviceStatusAsString() {
        return deviceStatus;
    }

    /**
     * <p>
     * The ARN of the network profile associated with a device.
     * </p>
     * 
     * @return The ARN of the network profile associated with a device.
     */
    public final String networkProfileArn() {
        return networkProfileArn;
    }

    /**
     * <p>
     * The name of the network profile associated with a device.
     * </p>
     * 
     * @return The name of the network profile associated with a device.
     */
    public final String networkProfileName() {
        return networkProfileName;
    }

    /**
     * <p>
     * The room ARN associated with a device.
     * </p>
     * 
     * @return The room ARN associated with a device.
     */
    public final String roomArn() {
        return roomArn;
    }

    /**
     * <p>
     * The name of the room associated with a device.
     * </p>
     * 
     * @return The name of the room associated with a device.
     */
    public final String roomName() {
        return roomName;
    }

    /**
     * <p>
     * Detailed information about a device's status.
     * </p>
     * 
     * @return Detailed information about a device's status.
     */
    public final DeviceStatusInfo deviceStatusInfo() {
        return deviceStatusInfo;
    }

    /**
     * <p>
     * The time (in epoch) when the device data was created.
     * </p>
     * 
     * @return The time (in epoch) when the device data was created.
     */
    public final Instant createdTime() {
        return createdTime;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(deviceArn());
        hashCode = 31 * hashCode + Objects.hashCode(deviceSerialNumber());
        hashCode = 31 * hashCode + Objects.hashCode(deviceType());
        hashCode = 31 * hashCode + Objects.hashCode(deviceName());
        hashCode = 31 * hashCode + Objects.hashCode(softwareVersion());
        hashCode = 31 * hashCode + Objects.hashCode(macAddress());
        hashCode = 31 * hashCode + Objects.hashCode(deviceStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(networkProfileArn());
        hashCode = 31 * hashCode + Objects.hashCode(networkProfileName());
        hashCode = 31 * hashCode + Objects.hashCode(roomArn());
        hashCode = 31 * hashCode + Objects.hashCode(roomName());
        hashCode = 31 * hashCode + Objects.hashCode(deviceStatusInfo());
        hashCode = 31 * hashCode + Objects.hashCode(createdTime());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeviceData)) {
            return false;
        }
        DeviceData other = (DeviceData) obj;
        return Objects.equals(deviceArn(), other.deviceArn()) && Objects.equals(deviceSerialNumber(), other.deviceSerialNumber())
                && Objects.equals(deviceType(), other.deviceType()) && Objects.equals(deviceName(), other.deviceName())
                && Objects.equals(softwareVersion(), other.softwareVersion()) && Objects.equals(macAddress(), other.macAddress())
                && Objects.equals(deviceStatusAsString(), other.deviceStatusAsString())
                && Objects.equals(networkProfileArn(), other.networkProfileArn())
                && Objects.equals(networkProfileName(), other.networkProfileName()) && Objects.equals(roomArn(), other.roomArn())
                && Objects.equals(roomName(), other.roomName()) && Objects.equals(deviceStatusInfo(), other.deviceStatusInfo())
                && Objects.equals(createdTime(), other.createdTime());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DeviceData").add("DeviceArn", deviceArn()).add("DeviceSerialNumber", deviceSerialNumber())
                .add("DeviceType", deviceType()).add("DeviceName", deviceName()).add("SoftwareVersion", softwareVersion())
                .add("MacAddress", macAddress()).add("DeviceStatus", deviceStatusAsString())
                .add("NetworkProfileArn", networkProfileArn()).add("NetworkProfileName", networkProfileName())
                .add("RoomArn", roomArn()).add("RoomName", roomName()).add("DeviceStatusInfo", deviceStatusInfo())
                .add("CreatedTime", createdTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DeviceArn":
            return Optional.ofNullable(clazz.cast(deviceArn()));
        case "DeviceSerialNumber":
            return Optional.ofNullable(clazz.cast(deviceSerialNumber()));
        case "DeviceType":
            return Optional.ofNullable(clazz.cast(deviceType()));
        case "DeviceName":
            return Optional.ofNullable(clazz.cast(deviceName()));
        case "SoftwareVersion":
            return Optional.ofNullable(clazz.cast(softwareVersion()));
        case "MacAddress":
            return Optional.ofNullable(clazz.cast(macAddress()));
        case "DeviceStatus":
            return Optional.ofNullable(clazz.cast(deviceStatusAsString()));
        case "NetworkProfileArn":
            return Optional.ofNullable(clazz.cast(networkProfileArn()));
        case "NetworkProfileName":
            return Optional.ofNullable(clazz.cast(networkProfileName()));
        case "RoomArn":
            return Optional.ofNullable(clazz.cast(roomArn()));
        case "RoomName":
            return Optional.ofNullable(clazz.cast(roomName()));
        case "DeviceStatusInfo":
            return Optional.ofNullable(clazz.cast(deviceStatusInfo()));
        case "CreatedTime":
            return Optional.ofNullable(clazz.cast(createdTime()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DeviceData, T> g) {
        return obj -> g.apply((DeviceData) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DeviceData> {
        /**
         * <p>
         * The ARN of a device.
         * </p>
         * 
         * @param deviceArn
         *        The ARN of a device.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deviceArn(String deviceArn);

        /**
         * <p>
         * The serial number of a device.
         * </p>
         * 
         * @param deviceSerialNumber
         *        The serial number of a device.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deviceSerialNumber(String deviceSerialNumber);

        /**
         * <p>
         * The type of a device.
         * </p>
         * 
         * @param deviceType
         *        The type of a device.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deviceType(String deviceType);

        /**
         * <p>
         * The name of a device.
         * </p>
         * 
         * @param deviceName
         *        The name of a device.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deviceName(String deviceName);

        /**
         * <p>
         * The software version of a device.
         * </p>
         * 
         * @param softwareVersion
         *        The software version of a device.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder softwareVersion(String softwareVersion);

        /**
         * <p>
         * The MAC address of a device.
         * </p>
         * 
         * @param macAddress
         *        The MAC address of a device.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder macAddress(String macAddress);

        /**
         * <p>
         * The status of a device.
         * </p>
         * 
         * @param deviceStatus
         *        The status of a device.
         * @see DeviceStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DeviceStatus
         */
        Builder deviceStatus(String deviceStatus);

        /**
         * <p>
         * The status of a device.
         * </p>
         * 
         * @param deviceStatus
         *        The status of a device.
         * @see DeviceStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DeviceStatus
         */
        Builder deviceStatus(DeviceStatus deviceStatus);

        /**
         * <p>
         * The ARN of the network profile associated with a device.
         * </p>
         * 
         * @param networkProfileArn
         *        The ARN of the network profile associated with a device.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder networkProfileArn(String networkProfileArn);

        /**
         * <p>
         * The name of the network profile associated with a device.
         * </p>
         * 
         * @param networkProfileName
         *        The name of the network profile associated with a device.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder networkProfileName(String networkProfileName);

        /**
         * <p>
         * The room ARN associated with a device.
         * </p>
         * 
         * @param roomArn
         *        The room ARN associated with a device.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roomArn(String roomArn);

        /**
         * <p>
         * The name of the room associated with a device.
         * </p>
         * 
         * @param roomName
         *        The name of the room associated with a device.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roomName(String roomName);

        /**
         * <p>
         * Detailed information about a device's status.
         * </p>
         * 
         * @param deviceStatusInfo
         *        Detailed information about a device's status.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deviceStatusInfo(DeviceStatusInfo deviceStatusInfo);

        /**
         * <p>
         * Detailed information about a device's status.
         * </p>
         * This is a convenience that creates an instance of the {@link DeviceStatusInfo.Builder} avoiding the need to
         * create one manually via {@link DeviceStatusInfo#builder()}.
         *
         * When the {@link Consumer} completes, {@link DeviceStatusInfo.Builder#build()} is called immediately and its
         * result is passed to {@link #deviceStatusInfo(DeviceStatusInfo)}.
         * 
         * @param deviceStatusInfo
         *        a consumer that will call methods on {@link DeviceStatusInfo.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #deviceStatusInfo(DeviceStatusInfo)
         */
        default Builder deviceStatusInfo(Consumer<DeviceStatusInfo.Builder> deviceStatusInfo) {
            return deviceStatusInfo(DeviceStatusInfo.builder().applyMutation(deviceStatusInfo).build());
        }

        /**
         * <p>
         * The time (in epoch) when the device data was created.
         * </p>
         * 
         * @param createdTime
         *        The time (in epoch) when the device data was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdTime(Instant createdTime);
    }

    static final class BuilderImpl implements Builder {
        private String deviceArn;

        private String deviceSerialNumber;

        private String deviceType;

        private String deviceName;

        private String softwareVersion;

        private String macAddress;

        private String deviceStatus;

        private String networkProfileArn;

        private String networkProfileName;

        private String roomArn;

        private String roomName;

        private DeviceStatusInfo deviceStatusInfo;

        private Instant createdTime;

        private BuilderImpl() {
        }

        private BuilderImpl(DeviceData model) {
            deviceArn(model.deviceArn);
            deviceSerialNumber(model.deviceSerialNumber);
            deviceType(model.deviceType);
            deviceName(model.deviceName);
            softwareVersion(model.softwareVersion);
            macAddress(model.macAddress);
            deviceStatus(model.deviceStatus);
            networkProfileArn(model.networkProfileArn);
            networkProfileName(model.networkProfileName);
            roomArn(model.roomArn);
            roomName(model.roomName);
            deviceStatusInfo(model.deviceStatusInfo);
            createdTime(model.createdTime);
        }

        public final String getDeviceArn() {
            return deviceArn;
        }

        public final void setDeviceArn(String deviceArn) {
            this.deviceArn = deviceArn;
        }

        @Override
        @Transient
        public final Builder deviceArn(String deviceArn) {
            this.deviceArn = deviceArn;
            return this;
        }

        public final String getDeviceSerialNumber() {
            return deviceSerialNumber;
        }

        public final void setDeviceSerialNumber(String deviceSerialNumber) {
            this.deviceSerialNumber = deviceSerialNumber;
        }

        @Override
        @Transient
        public final Builder deviceSerialNumber(String deviceSerialNumber) {
            this.deviceSerialNumber = deviceSerialNumber;
            return this;
        }

        public final String getDeviceType() {
            return deviceType;
        }

        public final void setDeviceType(String deviceType) {
            this.deviceType = deviceType;
        }

        @Override
        @Transient
        public final Builder deviceType(String deviceType) {
            this.deviceType = deviceType;
            return this;
        }

        public final String getDeviceName() {
            return deviceName;
        }

        public final void setDeviceName(String deviceName) {
            this.deviceName = deviceName;
        }

        @Override
        @Transient
        public final Builder deviceName(String deviceName) {
            this.deviceName = deviceName;
            return this;
        }

        public final String getSoftwareVersion() {
            return softwareVersion;
        }

        public final void setSoftwareVersion(String softwareVersion) {
            this.softwareVersion = softwareVersion;
        }

        @Override
        @Transient
        public final Builder softwareVersion(String softwareVersion) {
            this.softwareVersion = softwareVersion;
            return this;
        }

        public final String getMacAddress() {
            return macAddress;
        }

        public final void setMacAddress(String macAddress) {
            this.macAddress = macAddress;
        }

        @Override
        @Transient
        public final Builder macAddress(String macAddress) {
            this.macAddress = macAddress;
            return this;
        }

        public final String getDeviceStatus() {
            return deviceStatus;
        }

        public final void setDeviceStatus(String deviceStatus) {
            this.deviceStatus = deviceStatus;
        }

        @Override
        @Transient
        public final Builder deviceStatus(String deviceStatus) {
            this.deviceStatus = deviceStatus;
            return this;
        }

        @Override
        @Transient
        public final Builder deviceStatus(DeviceStatus deviceStatus) {
            this.deviceStatus(deviceStatus == null ? null : deviceStatus.toString());
            return this;
        }

        public final String getNetworkProfileArn() {
            return networkProfileArn;
        }

        public final void setNetworkProfileArn(String networkProfileArn) {
            this.networkProfileArn = networkProfileArn;
        }

        @Override
        @Transient
        public final Builder networkProfileArn(String networkProfileArn) {
            this.networkProfileArn = networkProfileArn;
            return this;
        }

        public final String getNetworkProfileName() {
            return networkProfileName;
        }

        public final void setNetworkProfileName(String networkProfileName) {
            this.networkProfileName = networkProfileName;
        }

        @Override
        @Transient
        public final Builder networkProfileName(String networkProfileName) {
            this.networkProfileName = networkProfileName;
            return this;
        }

        public final String getRoomArn() {
            return roomArn;
        }

        public final void setRoomArn(String roomArn) {
            this.roomArn = roomArn;
        }

        @Override
        @Transient
        public final Builder roomArn(String roomArn) {
            this.roomArn = roomArn;
            return this;
        }

        public final String getRoomName() {
            return roomName;
        }

        public final void setRoomName(String roomName) {
            this.roomName = roomName;
        }

        @Override
        @Transient
        public final Builder roomName(String roomName) {
            this.roomName = roomName;
            return this;
        }

        public final DeviceStatusInfo.Builder getDeviceStatusInfo() {
            return deviceStatusInfo != null ? deviceStatusInfo.toBuilder() : null;
        }

        public final void setDeviceStatusInfo(DeviceStatusInfo.BuilderImpl deviceStatusInfo) {
            this.deviceStatusInfo = deviceStatusInfo != null ? deviceStatusInfo.build() : null;
        }

        @Override
        @Transient
        public final Builder deviceStatusInfo(DeviceStatusInfo deviceStatusInfo) {
            this.deviceStatusInfo = deviceStatusInfo;
            return this;
        }

        public final Instant getCreatedTime() {
            return createdTime;
        }

        public final void setCreatedTime(Instant createdTime) {
            this.createdTime = createdTime;
        }

        @Override
        @Transient
        public final Builder createdTime(Instant createdTime) {
            this.createdTime = createdTime;
            return this;
        }

        @Override
        public DeviceData build() {
            return new DeviceData(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
