/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.alexaforbusiness.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SmartHomeAppliance
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, SmartHomeAppliance> {
    private static final SdkField<String> FRIENDLY_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FriendlyName").getter(SmartHomeAppliance.getter(SmartHomeAppliance::friendlyName)).setter(SmartHomeAppliance.setter(Builder::friendlyName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FriendlyName").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(SmartHomeAppliance.getter(SmartHomeAppliance::description)).setter(SmartHomeAppliance.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<String> MANUFACTURER_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ManufacturerName").getter(SmartHomeAppliance.getter(SmartHomeAppliance::manufacturerName)).setter(SmartHomeAppliance.setter(Builder::manufacturerName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ManufacturerName").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FRIENDLY_NAME_FIELD, DESCRIPTION_FIELD, MANUFACTURER_NAME_FIELD));
    private static final long serialVersionUID = 1L;
    private final String friendlyName;
    private final String description;
    private final String manufacturerName;

    private SmartHomeAppliance(BuilderImpl builder) {
        this.friendlyName = builder.friendlyName;
        this.description = builder.description;
        this.manufacturerName = builder.manufacturerName;
    }

    public final String friendlyName() {
        return this.friendlyName;
    }

    public final String description() {
        return this.description;
    }

    public final String manufacturerName() {
        return this.manufacturerName;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.friendlyName());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.manufacturerName());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SmartHomeAppliance)) {
            return false;
        }
        SmartHomeAppliance other = (SmartHomeAppliance)obj;
        return Objects.equals(this.friendlyName(), other.friendlyName()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.manufacturerName(), other.manufacturerName());
    }

    public final String toString() {
        return ToString.builder((String)"SmartHomeAppliance").add("FriendlyName", (Object)this.friendlyName()).add("Description", (Object)this.description()).add("ManufacturerName", (Object)this.manufacturerName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "FriendlyName": {
                return Optional.ofNullable(clazz.cast(this.friendlyName()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "ManufacturerName": {
                return Optional.ofNullable(clazz.cast(this.manufacturerName()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SmartHomeAppliance, T> g) {
        return obj -> g.apply((SmartHomeAppliance)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String friendlyName;
        private String description;
        private String manufacturerName;

        private BuilderImpl() {
        }

        private BuilderImpl(SmartHomeAppliance model) {
            this.friendlyName(model.friendlyName);
            this.description(model.description);
            this.manufacturerName(model.manufacturerName);
        }

        public final String getFriendlyName() {
            return this.friendlyName;
        }

        public final void setFriendlyName(String friendlyName) {
            this.friendlyName = friendlyName;
        }

        @Override
        @Transient
        public final Builder friendlyName(String friendlyName) {
            this.friendlyName = friendlyName;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        @Transient
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getManufacturerName() {
            return this.manufacturerName;
        }

        public final void setManufacturerName(String manufacturerName) {
            this.manufacturerName = manufacturerName;
        }

        @Override
        @Transient
        public final Builder manufacturerName(String manufacturerName) {
            this.manufacturerName = manufacturerName;
            return this;
        }

        public SmartHomeAppliance build() {
            return new SmartHomeAppliance(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, SmartHomeAppliance> {
        public Builder friendlyName(String var1);

        public Builder description(String var1);

        public Builder manufacturerName(String var1);
    }
}

