/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.alexaforbusiness.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DeveloperInfo
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DeveloperInfo> {
    private static final SdkField<String> DEVELOPER_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DeveloperName").getter(DeveloperInfo.getter(DeveloperInfo::developerName)).setter(DeveloperInfo.setter(Builder::developerName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeveloperName").build()}).build();
    private static final SdkField<String> PRIVACY_POLICY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PrivacyPolicy").getter(DeveloperInfo.getter(DeveloperInfo::privacyPolicy)).setter(DeveloperInfo.setter(Builder::privacyPolicy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PrivacyPolicy").build()}).build();
    private static final SdkField<String> EMAIL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Email").getter(DeveloperInfo.getter(DeveloperInfo::email)).setter(DeveloperInfo.setter(Builder::email)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Email").build()}).build();
    private static final SdkField<String> URL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Url").getter(DeveloperInfo.getter(DeveloperInfo::url)).setter(DeveloperInfo.setter(Builder::url)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Url").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DEVELOPER_NAME_FIELD, PRIVACY_POLICY_FIELD, EMAIL_FIELD, URL_FIELD));
    private static final long serialVersionUID = 1L;
    private final String developerName;
    private final String privacyPolicy;
    private final String email;
    private final String url;

    private DeveloperInfo(BuilderImpl builder) {
        this.developerName = builder.developerName;
        this.privacyPolicy = builder.privacyPolicy;
        this.email = builder.email;
        this.url = builder.url;
    }

    public final String developerName() {
        return this.developerName;
    }

    public final String privacyPolicy() {
        return this.privacyPolicy;
    }

    public final String email() {
        return this.email;
    }

    public final String url() {
        return this.url;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.developerName());
        hashCode = 31 * hashCode + Objects.hashCode(this.privacyPolicy());
        hashCode = 31 * hashCode + Objects.hashCode(this.email());
        hashCode = 31 * hashCode + Objects.hashCode(this.url());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeveloperInfo)) {
            return false;
        }
        DeveloperInfo other = (DeveloperInfo)obj;
        return Objects.equals(this.developerName(), other.developerName()) && Objects.equals(this.privacyPolicy(), other.privacyPolicy()) && Objects.equals(this.email(), other.email()) && Objects.equals(this.url(), other.url());
    }

    public final String toString() {
        return ToString.builder((String)"DeveloperInfo").add("DeveloperName", (Object)this.developerName()).add("PrivacyPolicy", (Object)this.privacyPolicy()).add("Email", (Object)this.email()).add("Url", (Object)this.url()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DeveloperName": {
                return Optional.ofNullable(clazz.cast(this.developerName()));
            }
            case "PrivacyPolicy": {
                return Optional.ofNullable(clazz.cast(this.privacyPolicy()));
            }
            case "Email": {
                return Optional.ofNullable(clazz.cast(this.email()));
            }
            case "Url": {
                return Optional.ofNullable(clazz.cast(this.url()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DeveloperInfo, T> g) {
        return obj -> g.apply((DeveloperInfo)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String developerName;
        private String privacyPolicy;
        private String email;
        private String url;

        private BuilderImpl() {
        }

        private BuilderImpl(DeveloperInfo model) {
            this.developerName(model.developerName);
            this.privacyPolicy(model.privacyPolicy);
            this.email(model.email);
            this.url(model.url);
        }

        public final String getDeveloperName() {
            return this.developerName;
        }

        public final void setDeveloperName(String developerName) {
            this.developerName = developerName;
        }

        @Override
        @Transient
        public final Builder developerName(String developerName) {
            this.developerName = developerName;
            return this;
        }

        public final String getPrivacyPolicy() {
            return this.privacyPolicy;
        }

        public final void setPrivacyPolicy(String privacyPolicy) {
            this.privacyPolicy = privacyPolicy;
        }

        @Override
        @Transient
        public final Builder privacyPolicy(String privacyPolicy) {
            this.privacyPolicy = privacyPolicy;
            return this;
        }

        public final String getEmail() {
            return this.email;
        }

        public final void setEmail(String email) {
            this.email = email;
        }

        @Override
        @Transient
        public final Builder email(String email) {
            this.email = email;
            return this;
        }

        public final String getUrl() {
            return this.url;
        }

        public final void setUrl(String url) {
            this.url = url;
        }

        @Override
        @Transient
        public final Builder url(String url) {
            this.url = url;
            return this;
        }

        public DeveloperInfo build() {
            return new DeveloperInfo(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DeveloperInfo> {
        public Builder developerName(String var1);

        public Builder privacyPolicy(String var1);

        public Builder email(String var1);

        public Builder url(String var1);
    }
}

