/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.alexaforbusiness.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Meeting room settings of a room profile.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class MeetingRoomConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<MeetingRoomConfiguration.Builder, MeetingRoomConfiguration> {
    private static final SdkField<Boolean> ROOM_UTILIZATION_METRICS_ENABLED_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("RoomUtilizationMetricsEnabled")
            .getter(getter(MeetingRoomConfiguration::roomUtilizationMetricsEnabled))
            .setter(setter(Builder::roomUtilizationMetricsEnabled))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoomUtilizationMetricsEnabled")
                    .build()).build();

    private static final SdkField<EndOfMeetingReminder> END_OF_MEETING_REMINDER_FIELD = SdkField
            .<EndOfMeetingReminder> builder(MarshallingType.SDK_POJO).memberName("EndOfMeetingReminder")
            .getter(getter(MeetingRoomConfiguration::endOfMeetingReminder)).setter(setter(Builder::endOfMeetingReminder))
            .constructor(EndOfMeetingReminder::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndOfMeetingReminder").build())
            .build();

    private static final SdkField<InstantBooking> INSTANT_BOOKING_FIELD = SdkField
            .<InstantBooking> builder(MarshallingType.SDK_POJO).memberName("InstantBooking")
            .getter(getter(MeetingRoomConfiguration::instantBooking)).setter(setter(Builder::instantBooking))
            .constructor(InstantBooking::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstantBooking").build()).build();

    private static final SdkField<RequireCheckIn> REQUIRE_CHECK_IN_FIELD = SdkField
            .<RequireCheckIn> builder(MarshallingType.SDK_POJO).memberName("RequireCheckIn")
            .getter(getter(MeetingRoomConfiguration::requireCheckIn)).setter(setter(Builder::requireCheckIn))
            .constructor(RequireCheckIn::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RequireCheckIn").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections
            .unmodifiableList(Arrays.asList(ROOM_UTILIZATION_METRICS_ENABLED_FIELD, END_OF_MEETING_REMINDER_FIELD,
                    INSTANT_BOOKING_FIELD, REQUIRE_CHECK_IN_FIELD));

    private static final long serialVersionUID = 1L;

    private final Boolean roomUtilizationMetricsEnabled;

    private final EndOfMeetingReminder endOfMeetingReminder;

    private final InstantBooking instantBooking;

    private final RequireCheckIn requireCheckIn;

    private MeetingRoomConfiguration(BuilderImpl builder) {
        this.roomUtilizationMetricsEnabled = builder.roomUtilizationMetricsEnabled;
        this.endOfMeetingReminder = builder.endOfMeetingReminder;
        this.instantBooking = builder.instantBooking;
        this.requireCheckIn = builder.requireCheckIn;
    }

    /**
     * <p>
     * Whether room utilization metrics are enabled or not.
     * </p>
     * 
     * @return Whether room utilization metrics are enabled or not.
     */
    public final Boolean roomUtilizationMetricsEnabled() {
        return roomUtilizationMetricsEnabled;
    }

    /**
     * <p>
     * Settings for the end of meeting reminder feature that are applied to a room profile. The end of meeting reminder
     * enables Alexa to remind users when a meeting is ending.
     * </p>
     * 
     * @return Settings for the end of meeting reminder feature that are applied to a room profile. The end of meeting
     *         reminder enables Alexa to remind users when a meeting is ending.
     */
    public final EndOfMeetingReminder endOfMeetingReminder() {
        return endOfMeetingReminder;
    }

    /**
     * <p>
     * Settings to automatically book the room if available for a configured duration when joining a meeting with Alexa.
     * </p>
     * 
     * @return Settings to automatically book the room if available for a configured duration when joining a meeting
     *         with Alexa.
     */
    public final InstantBooking instantBooking() {
        return instantBooking;
    }

    /**
     * <p>
     * Settings for requiring a check in when a room is reserved. Alexa can cancel a room reservation if it's not
     * checked into. This makes the room available for others. Users can check in by joining the meeting with Alexa or
     * an AVS device, or by saying “Alexa, check in.”
     * </p>
     * 
     * @return Settings for requiring a check in when a room is reserved. Alexa can cancel a room reservation if it's
     *         not checked into. This makes the room available for others. Users can check in by joining the meeting
     *         with Alexa or an AVS device, or by saying “Alexa, check in.”
     */
    public final RequireCheckIn requireCheckIn() {
        return requireCheckIn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(roomUtilizationMetricsEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(endOfMeetingReminder());
        hashCode = 31 * hashCode + Objects.hashCode(instantBooking());
        hashCode = 31 * hashCode + Objects.hashCode(requireCheckIn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MeetingRoomConfiguration)) {
            return false;
        }
        MeetingRoomConfiguration other = (MeetingRoomConfiguration) obj;
        return Objects.equals(roomUtilizationMetricsEnabled(), other.roomUtilizationMetricsEnabled())
                && Objects.equals(endOfMeetingReminder(), other.endOfMeetingReminder())
                && Objects.equals(instantBooking(), other.instantBooking())
                && Objects.equals(requireCheckIn(), other.requireCheckIn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("MeetingRoomConfiguration").add("RoomUtilizationMetricsEnabled", roomUtilizationMetricsEnabled())
                .add("EndOfMeetingReminder", endOfMeetingReminder()).add("InstantBooking", instantBooking())
                .add("RequireCheckIn", requireCheckIn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "RoomUtilizationMetricsEnabled":
            return Optional.ofNullable(clazz.cast(roomUtilizationMetricsEnabled()));
        case "EndOfMeetingReminder":
            return Optional.ofNullable(clazz.cast(endOfMeetingReminder()));
        case "InstantBooking":
            return Optional.ofNullable(clazz.cast(instantBooking()));
        case "RequireCheckIn":
            return Optional.ofNullable(clazz.cast(requireCheckIn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<MeetingRoomConfiguration, T> g) {
        return obj -> g.apply((MeetingRoomConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, MeetingRoomConfiguration> {
        /**
         * <p>
         * Whether room utilization metrics are enabled or not.
         * </p>
         * 
         * @param roomUtilizationMetricsEnabled
         *        Whether room utilization metrics are enabled or not.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roomUtilizationMetricsEnabled(Boolean roomUtilizationMetricsEnabled);

        /**
         * <p>
         * Settings for the end of meeting reminder feature that are applied to a room profile. The end of meeting
         * reminder enables Alexa to remind users when a meeting is ending.
         * </p>
         * 
         * @param endOfMeetingReminder
         *        Settings for the end of meeting reminder feature that are applied to a room profile. The end of
         *        meeting reminder enables Alexa to remind users when a meeting is ending.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endOfMeetingReminder(EndOfMeetingReminder endOfMeetingReminder);

        /**
         * <p>
         * Settings for the end of meeting reminder feature that are applied to a room profile. The end of meeting
         * reminder enables Alexa to remind users when a meeting is ending.
         * </p>
         * This is a convenience method that creates an instance of the {@link EndOfMeetingReminder.Builder} avoiding
         * the need to create one manually via {@link EndOfMeetingReminder#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link EndOfMeetingReminder.Builder#build()} is called immediately and
         * its result is passed to {@link #endOfMeetingReminder(EndOfMeetingReminder)}.
         * 
         * @param endOfMeetingReminder
         *        a consumer that will call methods on {@link EndOfMeetingReminder.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #endOfMeetingReminder(EndOfMeetingReminder)
         */
        default Builder endOfMeetingReminder(Consumer<EndOfMeetingReminder.Builder> endOfMeetingReminder) {
            return endOfMeetingReminder(EndOfMeetingReminder.builder().applyMutation(endOfMeetingReminder).build());
        }

        /**
         * <p>
         * Settings to automatically book the room if available for a configured duration when joining a meeting with
         * Alexa.
         * </p>
         * 
         * @param instantBooking
         *        Settings to automatically book the room if available for a configured duration when joining a meeting
         *        with Alexa.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instantBooking(InstantBooking instantBooking);

        /**
         * <p>
         * Settings to automatically book the room if available for a configured duration when joining a meeting with
         * Alexa.
         * </p>
         * This is a convenience method that creates an instance of the {@link InstantBooking.Builder} avoiding the need
         * to create one manually via {@link InstantBooking#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link InstantBooking.Builder#build()} is called immediately and its
         * result is passed to {@link #instantBooking(InstantBooking)}.
         * 
         * @param instantBooking
         *        a consumer that will call methods on {@link InstantBooking.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #instantBooking(InstantBooking)
         */
        default Builder instantBooking(Consumer<InstantBooking.Builder> instantBooking) {
            return instantBooking(InstantBooking.builder().applyMutation(instantBooking).build());
        }

        /**
         * <p>
         * Settings for requiring a check in when a room is reserved. Alexa can cancel a room reservation if it's not
         * checked into. This makes the room available for others. Users can check in by joining the meeting with Alexa
         * or an AVS device, or by saying “Alexa, check in.”
         * </p>
         * 
         * @param requireCheckIn
         *        Settings for requiring a check in when a room is reserved. Alexa can cancel a room reservation if it's
         *        not checked into. This makes the room available for others. Users can check in by joining the meeting
         *        with Alexa or an AVS device, or by saying “Alexa, check in.”
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder requireCheckIn(RequireCheckIn requireCheckIn);

        /**
         * <p>
         * Settings for requiring a check in when a room is reserved. Alexa can cancel a room reservation if it's not
         * checked into. This makes the room available for others. Users can check in by joining the meeting with Alexa
         * or an AVS device, or by saying “Alexa, check in.”
         * </p>
         * This is a convenience method that creates an instance of the {@link RequireCheckIn.Builder} avoiding the need
         * to create one manually via {@link RequireCheckIn#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link RequireCheckIn.Builder#build()} is called immediately and its
         * result is passed to {@link #requireCheckIn(RequireCheckIn)}.
         * 
         * @param requireCheckIn
         *        a consumer that will call methods on {@link RequireCheckIn.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #requireCheckIn(RequireCheckIn)
         */
        default Builder requireCheckIn(Consumer<RequireCheckIn.Builder> requireCheckIn) {
            return requireCheckIn(RequireCheckIn.builder().applyMutation(requireCheckIn).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private Boolean roomUtilizationMetricsEnabled;

        private EndOfMeetingReminder endOfMeetingReminder;

        private InstantBooking instantBooking;

        private RequireCheckIn requireCheckIn;

        private BuilderImpl() {
        }

        private BuilderImpl(MeetingRoomConfiguration model) {
            roomUtilizationMetricsEnabled(model.roomUtilizationMetricsEnabled);
            endOfMeetingReminder(model.endOfMeetingReminder);
            instantBooking(model.instantBooking);
            requireCheckIn(model.requireCheckIn);
        }

        public final Boolean getRoomUtilizationMetricsEnabled() {
            return roomUtilizationMetricsEnabled;
        }

        public final void setRoomUtilizationMetricsEnabled(Boolean roomUtilizationMetricsEnabled) {
            this.roomUtilizationMetricsEnabled = roomUtilizationMetricsEnabled;
        }

        @Override
        public final Builder roomUtilizationMetricsEnabled(Boolean roomUtilizationMetricsEnabled) {
            this.roomUtilizationMetricsEnabled = roomUtilizationMetricsEnabled;
            return this;
        }

        public final EndOfMeetingReminder.Builder getEndOfMeetingReminder() {
            return endOfMeetingReminder != null ? endOfMeetingReminder.toBuilder() : null;
        }

        public final void setEndOfMeetingReminder(EndOfMeetingReminder.BuilderImpl endOfMeetingReminder) {
            this.endOfMeetingReminder = endOfMeetingReminder != null ? endOfMeetingReminder.build() : null;
        }

        @Override
        public final Builder endOfMeetingReminder(EndOfMeetingReminder endOfMeetingReminder) {
            this.endOfMeetingReminder = endOfMeetingReminder;
            return this;
        }

        public final InstantBooking.Builder getInstantBooking() {
            return instantBooking != null ? instantBooking.toBuilder() : null;
        }

        public final void setInstantBooking(InstantBooking.BuilderImpl instantBooking) {
            this.instantBooking = instantBooking != null ? instantBooking.build() : null;
        }

        @Override
        public final Builder instantBooking(InstantBooking instantBooking) {
            this.instantBooking = instantBooking;
            return this;
        }

        public final RequireCheckIn.Builder getRequireCheckIn() {
            return requireCheckIn != null ? requireCheckIn.toBuilder() : null;
        }

        public final void setRequireCheckIn(RequireCheckIn.BuilderImpl requireCheckIn) {
            this.requireCheckIn = requireCheckIn != null ? requireCheckIn.build() : null;
        }

        @Override
        public final Builder requireCheckIn(RequireCheckIn requireCheckIn) {
            this.requireCheckIn = requireCheckIn;
            return this;
        }

        @Override
        public MeetingRoomConfiguration build() {
            return new MeetingRoomConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
