/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.alexaforbusiness.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.alexaforbusiness.AlexaForBusinessClient;
import software.amazon.awssdk.services.alexaforbusiness.internal.UserAgentUtils;
import software.amazon.awssdk.services.alexaforbusiness.model.ListGatewayGroupsRequest;
import software.amazon.awssdk.services.alexaforbusiness.model.ListGatewayGroupsResponse;

public class ListGatewayGroupsIterable
implements SdkIterable<ListGatewayGroupsResponse> {
    private final AlexaForBusinessClient client;
    private final ListGatewayGroupsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListGatewayGroupsIterable(AlexaForBusinessClient client, ListGatewayGroupsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListGatewayGroupsResponseFetcher();
    }

    public Iterator<ListGatewayGroupsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class ListGatewayGroupsResponseFetcher
    implements SyncPageFetcher<ListGatewayGroupsResponse> {
        private ListGatewayGroupsResponseFetcher() {
        }

        public boolean hasNextPage(ListGatewayGroupsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListGatewayGroupsResponse nextPage(ListGatewayGroupsResponse previousPage) {
            if (previousPage == null) {
                return ListGatewayGroupsIterable.this.client.listGatewayGroups(ListGatewayGroupsIterable.this.firstRequest);
            }
            return ListGatewayGroupsIterable.this.client.listGatewayGroups((ListGatewayGroupsRequest)((Object)ListGatewayGroupsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

