/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.alexaforbusiness;

import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.AwsClient;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.regions.ServiceMetadata;
import software.amazon.awssdk.services.alexaforbusiness.model.AlexaForBusinessException;
import software.amazon.awssdk.services.alexaforbusiness.model.AlreadyExistsException;
import software.amazon.awssdk.services.alexaforbusiness.model.ApproveSkillRequest;
import software.amazon.awssdk.services.alexaforbusiness.model.ApproveSkillResponse;
import software.amazon.awssdk.services.alexaforbusiness.model.AssociateContactWithAddressBookRequest;
import software.amazon.awssdk.services.alexaforbusiness.model.AssociateContactWithAddressBookResponse;
import software.amazon.awssdk.services.alexaforbusiness.model.AssociateDeviceWithNetworkProfileRequest;
import software.amazon.awssdk.services.alexaforbusiness.model.AssociateDeviceWithNetworkProfileResponse;
import software.amazon.awssdk.services.alexaforbusiness.model.AssociateDeviceWithRoomRequest;
import software.amazon.awssdk.services.alexaforbusiness.model.AssociateDeviceWithRoomResponse;
import software.amazon.awssdk.services.alexaforbusiness.model.AssociateSkillGroupWithRoomRequest;
import software.amazon.awssdk.services.alexaforbusiness.model.AssociateSkillGroupWithRoomResponse;
import software.amazon.awssdk.services.alexaforbusiness.model.AssociateSkillWithSkillGroupRequest;
import software.amazon.awssdk.services.alexaforbusiness.model.AssociateSkillWithSkillGroupResponse;
import software.amazon.awssdk.services.alexaforbusiness.model.AssociateSkillWithUsersRequest;
import software.amazon.awssdk.services.alexaforbusiness.model.AssociateSkillWithUsersResponse;
import software.amazon.awssdk.services.alexaforbusiness.model.ConcurrentModificationException;
import software.amazon.awssdk.services.alexaforbusiness.model.CreateAddressBookRequest;
import software.amazon.awssdk.services.alexaforbusiness.model.CreateAddressBookResponse;
import software.amazon.awssdk.services.alexaforbusiness.model.CreateBusinessReportScheduleRequest;
import software.amazon.awssdk.services.alexaforbusiness.model.CreateBusinessReportScheduleResponse;
import software.amazon.awssdk.services.alexaforbusiness.model.CreateConferenceProviderRequest;
import software.amazon.awssdk.services.alexaforbusiness.model.CreateConferenceProviderResponse;
import software.amazon.awssdk.services.alexaforbusiness.model.CreateContactRequest;
import software.amazon.awssdk.services.alexaforbusiness.model.CreateContactResponse;
import software.amazon.awssdk.services.alexaforbusiness.model.CreateGatewayGroupRequest;
import software.amazon.awssdk.services.alexaforbusiness.model.CreateGatewayGroupResponse;
import software.amazon.awssdk.services.alexaforbusiness.model.CreateNetworkProfileRequest;
import software.amazon.awssdk.services.alexaforbusiness.model.CreateNetworkProfileResponse;
import software.amazon.awssdk.services.alexaforbusiness.model.CreateProfileRequest;
import software.amazon.awssdk.services.alexaforbusiness.model.CreateProfileResponse;
import software.amazon.awssdk.services.alexaforbusiness.model.CreateRoomRequest;
import software.amazon.awssdk.services.alexaforbusiness.model.CreateRoomResponse;
import software.amazon.awssdk.services.alexaforbusiness.model.CreateSkillGroupRequest;
import software.amazon.awssdk.services.alexaforbusiness.model.CreateSkillGroupResponse;
import software.amazon.awssdk.services.alexaforbusiness.model.CreateUserRequest;
import software.amazon.awssdk.services.alexaforbusiness.model.CreateUserResponse;
import software.amazon.awssdk.services.alexaforbusiness.model.DeleteAddressBookRequest;
import software.amazon.awssdk.services.alexaforbusiness.model.DeleteAddressBookResponse;
import software.amazon.awssdk.services.alexaforbusiness.model.DeleteBusinessReportScheduleRequest;
import software.amazon.awssdk.services.alexaforbusiness.model.DeleteBusinessReportScheduleResponse;
import software.amazon.awssdk.services.alexaforbusiness.model.DeleteConferenceProviderRequest;
import software.amazon.awssdk.services.alexaforbusiness.model.DeleteConferenceProviderResponse;
import software.amazon.awssdk.services.alexaforbusiness.model.DeleteContactRequest;
import software.amazon.awssdk.services.alexaforbusiness.model.DeleteContactResponse;
import software.amazon.awssdk.services.alexaforbusiness.model.DeleteDeviceRequest;
import software.amazon.awssdk.services.alexaforbusiness.model.DeleteDeviceResponse;
import software.amazon.awssdk.services.alexaforbusiness.model.DeleteDeviceUsageDataRequest;
import software.amazon.awssdk.services.alexaforbusiness.model.DeleteDeviceUsageDataResponse;
import software.amazon.awssdk.services.alexaforbusiness.model.DeleteGatewayGroupRequest;
import software.amazon.awssdk.services.alexaforbusiness.model.DeleteGatewayGroupResponse;
import software.amazon.awssdk.services.alexaforbusiness.model.DeleteNetworkProfileRequest;
import software.amazon.awssdk.services.alexaforbusiness.model.DeleteNetworkProfileResponse;
import software.amazon.awssdk.services.alexaforbusiness.model.DeleteProfileRequest;
import software.amazon.awssdk.services.alexaforbusiness.model.DeleteProfileResponse;
import software.amazon.awssdk.services.alexaforbusiness.model.DeleteRoomRequest;
import software.amazon.awssdk.services.alexaforbusiness.model.DeleteRoomResponse;
import software.amazon.awssdk.services.alexaforbusiness.model.DeleteRoomSkillParameterRequest;
import software.amazon.awssdk.services.alexaforbusiness.model.DeleteRoomSkillParameterResponse;
import software.amazon.awssdk.services.alexaforbusiness.model.DeleteSkillAuthorizationRequest;
import software.amazon.awssdk.services.alexaforbusiness.model.DeleteSkillAuthorizationResponse;
import software.amazon.awssdk.services.alexaforbusiness.model.DeleteSkillGroupRequest;
import software.amazon.awssdk.services.alexaforbusiness.model.DeleteSkillGroupResponse;
import software.amazon.awssdk.services.alexaforbusiness.model.DeleteUserRequest;
import software.amazon.awssdk.services.alexaforbusiness.model.DeleteUserResponse;
import software.amazon.awssdk.services.alexaforbusiness.model.DeviceNotRegisteredException;
import software.amazon.awssdk.services.alexaforbusiness.model.DisassociateContactFromAddressBookRequest;
import software.amazon.awssdk.services.alexaforbusiness.model.DisassociateContactFromAddressBookResponse;
import software.amazon.awssdk.services.alexaforbusiness.model.DisassociateDeviceFromRoomRequest;
import software.amazon.awssdk.services.alexaforbusiness.model.DisassociateDeviceFromRoomResponse;
import software.amazon.awssdk.services.alexaforbusiness.model.DisassociateSkillFromSkillGroupRequest;
import software.amazon.awssdk.services.alexaforbusiness.model.DisassociateSkillFromSkillGroupResponse;
import software.amazon.awssdk.services.alexaforbusiness.model.DisassociateSkillFromUsersRequest;
import software.amazon.awssdk.services.alexaforbusiness.model.DisassociateSkillFromUsersResponse;
import software.amazon.awssdk.services.alexaforbusiness.model.DisassociateSkillGroupFromRoomRequest;
import software.amazon.awssdk.services.alexaforbusiness.model.DisassociateSkillGroupFromRoomResponse;
import software.amazon.awssdk.services.alexaforbusiness.model.ForgetSmartHomeAppliancesRequest;
import software.amazon.awssdk.services.alexaforbusiness.model.ForgetSmartHomeAppliancesResponse;
import software.amazon.awssdk.services.alexaforbusiness.model.GetAddressBookRequest;
import software.amazon.awssdk.services.alexaforbusiness.model.GetAddressBookResponse;
import software.amazon.awssdk.services.alexaforbusiness.model.GetConferencePreferenceRequest;
import software.amazon.awssdk.services.alexaforbusiness.model.GetConferencePreferenceResponse;
import software.amazon.awssdk.services.alexaforbusiness.model.GetConferenceProviderRequest;
import software.amazon.awssdk.services.alexaforbusiness.model.GetConferenceProviderResponse;
import software.amazon.awssdk.services.alexaforbusiness.model.GetContactRequest;
import software.amazon.awssdk.services.alexaforbusiness.model.GetContactResponse;
import software.amazon.awssdk.services.alexaforbusiness.model.GetDeviceRequest;
import software.amazon.awssdk.services.alexaforbusiness.model.GetDeviceResponse;
import software.amazon.awssdk.services.alexaforbusiness.model.GetGatewayGroupRequest;
import software.amazon.awssdk.services.alexaforbusiness.model.GetGatewayGroupResponse;
import software.amazon.awssdk.services.alexaforbusiness.model.GetGatewayRequest;
import software.amazon.awssdk.services.alexaforbusiness.model.GetGatewayResponse;
import software.amazon.awssdk.services.alexaforbusiness.model.GetInvitationConfigurationRequest;
import software.amazon.awssdk.services.alexaforbusiness.model.GetInvitationConfigurationResponse;
import software.amazon.awssdk.services.alexaforbusiness.model.GetNetworkProfileRequest;
import software.amazon.awssdk.services.alexaforbusiness.model.GetNetworkProfileResponse;
import software.amazon.awssdk.services.alexaforbusiness.model.GetProfileRequest;
import software.amazon.awssdk.services.alexaforbusiness.model.GetProfileResponse;
import software.amazon.awssdk.services.alexaforbusiness.model.GetRoomRequest;
import software.amazon.awssdk.services.alexaforbusiness.model.GetRoomResponse;
import software.amazon.awssdk.services.alexaforbusiness.model.GetRoomSkillParameterRequest;
import software.amazon.awssdk.services.alexaforbusiness.model.GetRoomSkillParameterResponse;
import software.amazon.awssdk.services.alexaforbusiness.model.GetSkillGroupRequest;
import software.amazon.awssdk.services.alexaforbusiness.model.GetSkillGroupResponse;
import software.amazon.awssdk.services.alexaforbusiness.model.InvalidCertificateAuthorityException;
import software.amazon.awssdk.services.alexaforbusiness.model.InvalidDeviceException;
import software.amazon.awssdk.services.alexaforbusiness.model.InvalidSecretsManagerResourceException;
import software.amazon.awssdk.services.alexaforbusiness.model.InvalidServiceLinkedRoleStateException;
import software.amazon.awssdk.services.alexaforbusiness.model.InvalidUserStatusException;
import software.amazon.awssdk.services.alexaforbusiness.model.LimitExceededException;
import software.amazon.awssdk.services.alexaforbusiness.model.ListBusinessReportSchedulesRequest;
import software.amazon.awssdk.services.alexaforbusiness.model.ListBusinessReportSchedulesResponse;
import software.amazon.awssdk.services.alexaforbusiness.model.ListConferenceProvidersRequest;
import software.amazon.awssdk.services.alexaforbusiness.model.ListConferenceProvidersResponse;
import software.amazon.awssdk.services.alexaforbusiness.model.ListDeviceEventsRequest;
import software.amazon.awssdk.services.alexaforbusiness.model.ListDeviceEventsResponse;
import software.amazon.awssdk.services.alexaforbusiness.model.ListGatewayGroupsRequest;
import software.amazon.awssdk.services.alexaforbusiness.model.ListGatewayGroupsResponse;
import software.amazon.awssdk.services.alexaforbusiness.model.ListGatewaysRequest;
import software.amazon.awssdk.services.alexaforbusiness.model.ListGatewaysResponse;
import software.amazon.awssdk.services.alexaforbusiness.model.ListSkillsRequest;
import software.amazon.awssdk.services.alexaforbusiness.model.ListSkillsResponse;
import software.amazon.awssdk.services.alexaforbusiness.model.ListSkillsStoreCategoriesRequest;
import software.amazon.awssdk.services.alexaforbusiness.model.ListSkillsStoreCategoriesResponse;
import software.amazon.awssdk.services.alexaforbusiness.model.ListSkillsStoreSkillsByCategoryRequest;
import software.amazon.awssdk.services.alexaforbusiness.model.ListSkillsStoreSkillsByCategoryResponse;
import software.amazon.awssdk.services.alexaforbusiness.model.ListSmartHomeAppliancesRequest;
import software.amazon.awssdk.services.alexaforbusiness.model.ListSmartHomeAppliancesResponse;
import software.amazon.awssdk.services.alexaforbusiness.model.ListTagsRequest;
import software.amazon.awssdk.services.alexaforbusiness.model.ListTagsResponse;
import software.amazon.awssdk.services.alexaforbusiness.model.NameInUseException;
import software.amazon.awssdk.services.alexaforbusiness.model.NotFoundException;
import software.amazon.awssdk.services.alexaforbusiness.model.PutConferencePreferenceRequest;
import software.amazon.awssdk.services.alexaforbusiness.model.PutConferencePreferenceResponse;
import software.amazon.awssdk.services.alexaforbusiness.model.PutInvitationConfigurationRequest;
import software.amazon.awssdk.services.alexaforbusiness.model.PutInvitationConfigurationResponse;
import software.amazon.awssdk.services.alexaforbusiness.model.PutRoomSkillParameterRequest;
import software.amazon.awssdk.services.alexaforbusiness.model.PutRoomSkillParameterResponse;
import software.amazon.awssdk.services.alexaforbusiness.model.PutSkillAuthorizationRequest;
import software.amazon.awssdk.services.alexaforbusiness.model.PutSkillAuthorizationResponse;
import software.amazon.awssdk.services.alexaforbusiness.model.RegisterAvsDeviceRequest;
import software.amazon.awssdk.services.alexaforbusiness.model.RegisterAvsDeviceResponse;
import software.amazon.awssdk.services.alexaforbusiness.model.RejectSkillRequest;
import software.amazon.awssdk.services.alexaforbusiness.model.RejectSkillResponse;
import software.amazon.awssdk.services.alexaforbusiness.model.ResolveRoomRequest;
import software.amazon.awssdk.services.alexaforbusiness.model.ResolveRoomResponse;
import software.amazon.awssdk.services.alexaforbusiness.model.ResourceAssociatedException;
import software.amazon.awssdk.services.alexaforbusiness.model.ResourceInUseException;
import software.amazon.awssdk.services.alexaforbusiness.model.RevokeInvitationRequest;
import software.amazon.awssdk.services.alexaforbusiness.model.RevokeInvitationResponse;
import software.amazon.awssdk.services.alexaforbusiness.model.SearchAddressBooksRequest;
import software.amazon.awssdk.services.alexaforbusiness.model.SearchAddressBooksResponse;
import software.amazon.awssdk.services.alexaforbusiness.model.SearchContactsRequest;
import software.amazon.awssdk.services.alexaforbusiness.model.SearchContactsResponse;
import software.amazon.awssdk.services.alexaforbusiness.model.SearchDevicesRequest;
import software.amazon.awssdk.services.alexaforbusiness.model.SearchDevicesResponse;
import software.amazon.awssdk.services.alexaforbusiness.model.SearchNetworkProfilesRequest;
import software.amazon.awssdk.services.alexaforbusiness.model.SearchNetworkProfilesResponse;
import software.amazon.awssdk.services.alexaforbusiness.model.SearchProfilesRequest;
import software.amazon.awssdk.services.alexaforbusiness.model.SearchProfilesResponse;
import software.amazon.awssdk.services.alexaforbusiness.model.SearchRoomsRequest;
import software.amazon.awssdk.services.alexaforbusiness.model.SearchRoomsResponse;
import software.amazon.awssdk.services.alexaforbusiness.model.SearchSkillGroupsRequest;
import software.amazon.awssdk.services.alexaforbusiness.model.SearchSkillGroupsResponse;
import software.amazon.awssdk.services.alexaforbusiness.model.SearchUsersRequest;
import software.amazon.awssdk.services.alexaforbusiness.model.SearchUsersResponse;
import software.amazon.awssdk.services.alexaforbusiness.model.SendAnnouncementRequest;
import software.amazon.awssdk.services.alexaforbusiness.model.SendAnnouncementResponse;
import software.amazon.awssdk.services.alexaforbusiness.model.SendInvitationRequest;
import software.amazon.awssdk.services.alexaforbusiness.model.SendInvitationResponse;
import software.amazon.awssdk.services.alexaforbusiness.model.SkillNotLinkedException;
import software.amazon.awssdk.services.alexaforbusiness.model.StartDeviceSyncRequest;
import software.amazon.awssdk.services.alexaforbusiness.model.StartDeviceSyncResponse;
import software.amazon.awssdk.services.alexaforbusiness.model.StartSmartHomeApplianceDiscoveryRequest;
import software.amazon.awssdk.services.alexaforbusiness.model.StartSmartHomeApplianceDiscoveryResponse;
import software.amazon.awssdk.services.alexaforbusiness.model.TagResourceRequest;
import software.amazon.awssdk.services.alexaforbusiness.model.TagResourceResponse;
import software.amazon.awssdk.services.alexaforbusiness.model.UnauthorizedException;
import software.amazon.awssdk.services.alexaforbusiness.model.UntagResourceRequest;
import software.amazon.awssdk.services.alexaforbusiness.model.UntagResourceResponse;
import software.amazon.awssdk.services.alexaforbusiness.model.UpdateAddressBookRequest;
import software.amazon.awssdk.services.alexaforbusiness.model.UpdateAddressBookResponse;
import software.amazon.awssdk.services.alexaforbusiness.model.UpdateBusinessReportScheduleRequest;
import software.amazon.awssdk.services.alexaforbusiness.model.UpdateBusinessReportScheduleResponse;
import software.amazon.awssdk.services.alexaforbusiness.model.UpdateConferenceProviderRequest;
import software.amazon.awssdk.services.alexaforbusiness.model.UpdateConferenceProviderResponse;
import software.amazon.awssdk.services.alexaforbusiness.model.UpdateContactRequest;
import software.amazon.awssdk.services.alexaforbusiness.model.UpdateContactResponse;
import software.amazon.awssdk.services.alexaforbusiness.model.UpdateDeviceRequest;
import software.amazon.awssdk.services.alexaforbusiness.model.UpdateDeviceResponse;
import software.amazon.awssdk.services.alexaforbusiness.model.UpdateGatewayGroupRequest;
import software.amazon.awssdk.services.alexaforbusiness.model.UpdateGatewayGroupResponse;
import software.amazon.awssdk.services.alexaforbusiness.model.UpdateGatewayRequest;
import software.amazon.awssdk.services.alexaforbusiness.model.UpdateGatewayResponse;
import software.amazon.awssdk.services.alexaforbusiness.model.UpdateNetworkProfileRequest;
import software.amazon.awssdk.services.alexaforbusiness.model.UpdateNetworkProfileResponse;
import software.amazon.awssdk.services.alexaforbusiness.model.UpdateProfileRequest;
import software.amazon.awssdk.services.alexaforbusiness.model.UpdateProfileResponse;
import software.amazon.awssdk.services.alexaforbusiness.model.UpdateRoomRequest;
import software.amazon.awssdk.services.alexaforbusiness.model.UpdateRoomResponse;
import software.amazon.awssdk.services.alexaforbusiness.model.UpdateSkillGroupRequest;
import software.amazon.awssdk.services.alexaforbusiness.model.UpdateSkillGroupResponse;
import software.amazon.awssdk.services.alexaforbusiness.paginators.ListBusinessReportSchedulesIterable;
import software.amazon.awssdk.services.alexaforbusiness.paginators.ListConferenceProvidersIterable;
import software.amazon.awssdk.services.alexaforbusiness.paginators.ListDeviceEventsIterable;
import software.amazon.awssdk.services.alexaforbusiness.paginators.ListGatewayGroupsIterable;
import software.amazon.awssdk.services.alexaforbusiness.paginators.ListGatewaysIterable;
import software.amazon.awssdk.services.alexaforbusiness.paginators.ListSkillsIterable;
import software.amazon.awssdk.services.alexaforbusiness.paginators.ListSkillsStoreCategoriesIterable;
import software.amazon.awssdk.services.alexaforbusiness.paginators.ListSkillsStoreSkillsByCategoryIterable;
import software.amazon.awssdk.services.alexaforbusiness.paginators.ListSmartHomeAppliancesIterable;
import software.amazon.awssdk.services.alexaforbusiness.paginators.ListTagsIterable;
import software.amazon.awssdk.services.alexaforbusiness.paginators.SearchAddressBooksIterable;
import software.amazon.awssdk.services.alexaforbusiness.paginators.SearchContactsIterable;
import software.amazon.awssdk.services.alexaforbusiness.paginators.SearchDevicesIterable;
import software.amazon.awssdk.services.alexaforbusiness.paginators.SearchNetworkProfilesIterable;
import software.amazon.awssdk.services.alexaforbusiness.paginators.SearchProfilesIterable;
import software.amazon.awssdk.services.alexaforbusiness.paginators.SearchRoomsIterable;
import software.amazon.awssdk.services.alexaforbusiness.paginators.SearchSkillGroupsIterable;
import software.amazon.awssdk.services.alexaforbusiness.paginators.SearchUsersIterable;

/**
 * Service client for accessing Alexa For Business. This can be created using the static {@link #builder()} method.
 *
 * <p>
 * Alexa for Business helps you use Alexa in your organization. Alexa for Business provides you with the tools to manage
 * Alexa devices, enroll your users, and assign skills, at scale. You can build your own context-aware voice skills
 * using the Alexa Skills Kit and the Alexa for Business API operations. You can also make these available as private
 * skills for your organization. Alexa for Business makes it efficient to voice-enable your products and services, thus
 * providing context-aware voice experiences for your customers. Device makers building with the Alexa Voice Service
 * (AVS) can create fully integrated solutions, register their products with Alexa for Business, and manage them as
 * shared devices in their organization.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
@SdkPublicApi
@ThreadSafe
public interface AlexaForBusinessClient extends AwsClient {
    String SERVICE_NAME = "a4b";

    /**
     * Value for looking up the service's metadata from the
     * {@link software.amazon.awssdk.regions.ServiceMetadataProvider}.
     */
    String SERVICE_METADATA_ID = "a4b";

    /**
     * <p>
     * Associates a skill with the organization under the customer's AWS account. If a skill is private, the user
     * implicitly accepts access to this skill during enablement.
     * </p>
     *
     * @param approveSkillRequest
     * @return Result of the ApproveSkill operation returned by the service.
     * @throws LimitExceededException
     *         You are performing an action that would put you beyond your account's limits.
     * @throws NotFoundException
     *         The resource is not found.
     * @throws ConcurrentModificationException
     *         There is a concurrent modification of resources.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AlexaForBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AlexaForBusinessClient.ApproveSkill
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/ApproveSkill" target="_top">AWS
     *      API Documentation</a>
     */
    default ApproveSkillResponse approveSkill(ApproveSkillRequest approveSkillRequest) throws LimitExceededException,
            NotFoundException, ConcurrentModificationException, AwsServiceException, SdkClientException,
            AlexaForBusinessException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Associates a skill with the organization under the customer's AWS account. If a skill is private, the user
     * implicitly accepts access to this skill during enablement.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ApproveSkillRequest.Builder} avoiding the need to
     * create one manually via {@link ApproveSkillRequest#builder()}
     * </p>
     *
     * @param approveSkillRequest
     *        A {@link Consumer} that will call methods on {@link ApproveSkillRequest.Builder} to create a request.
     * @return Result of the ApproveSkill operation returned by the service.
     * @throws LimitExceededException
     *         You are performing an action that would put you beyond your account's limits.
     * @throws NotFoundException
     *         The resource is not found.
     * @throws ConcurrentModificationException
     *         There is a concurrent modification of resources.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AlexaForBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AlexaForBusinessClient.ApproveSkill
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/ApproveSkill" target="_top">AWS
     *      API Documentation</a>
     */
    default ApproveSkillResponse approveSkill(Consumer<ApproveSkillRequest.Builder> approveSkillRequest)
            throws LimitExceededException, NotFoundException, ConcurrentModificationException, AwsServiceException,
            SdkClientException, AlexaForBusinessException {
        return approveSkill(ApproveSkillRequest.builder().applyMutation(approveSkillRequest).build());
    }

    /**
     * <p>
     * Associates a contact with a given address book.
     * </p>
     *
     * @param associateContactWithAddressBookRequest
     * @return Result of the AssociateContactWithAddressBook operation returned by the service.
     * @throws LimitExceededException
     *         You are performing an action that would put you beyond your account's limits.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AlexaForBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AlexaForBusinessClient.AssociateContactWithAddressBook
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/AssociateContactWithAddressBook"
     *      target="_top">AWS API Documentation</a>
     */
    default AssociateContactWithAddressBookResponse associateContactWithAddressBook(
            AssociateContactWithAddressBookRequest associateContactWithAddressBookRequest) throws LimitExceededException,
            AwsServiceException, SdkClientException, AlexaForBusinessException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Associates a contact with a given address book.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AssociateContactWithAddressBookRequest.Builder}
     * avoiding the need to create one manually via {@link AssociateContactWithAddressBookRequest#builder()}
     * </p>
     *
     * @param associateContactWithAddressBookRequest
     *        A {@link Consumer} that will call methods on {@link AssociateContactWithAddressBookRequest.Builder} to
     *        create a request.
     * @return Result of the AssociateContactWithAddressBook operation returned by the service.
     * @throws LimitExceededException
     *         You are performing an action that would put you beyond your account's limits.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AlexaForBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AlexaForBusinessClient.AssociateContactWithAddressBook
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/AssociateContactWithAddressBook"
     *      target="_top">AWS API Documentation</a>
     */
    default AssociateContactWithAddressBookResponse associateContactWithAddressBook(
            Consumer<AssociateContactWithAddressBookRequest.Builder> associateContactWithAddressBookRequest)
            throws LimitExceededException, AwsServiceException, SdkClientException, AlexaForBusinessException {
        return associateContactWithAddressBook(AssociateContactWithAddressBookRequest.builder()
                .applyMutation(associateContactWithAddressBookRequest).build());
    }

    /**
     * <p>
     * Associates a device with the specified network profile.
     * </p>
     *
     * @param associateDeviceWithNetworkProfileRequest
     * @return Result of the AssociateDeviceWithNetworkProfile operation returned by the service.
     * @throws NotFoundException
     *         The resource is not found.
     * @throws ConcurrentModificationException
     *         There is a concurrent modification of resources.
     * @throws DeviceNotRegisteredException
     *         The request failed because this device is no longer registered and therefore no longer managed by this
     *         account.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AlexaForBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AlexaForBusinessClient.AssociateDeviceWithNetworkProfile
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/AssociateDeviceWithNetworkProfile"
     *      target="_top">AWS API Documentation</a>
     */
    default AssociateDeviceWithNetworkProfileResponse associateDeviceWithNetworkProfile(
            AssociateDeviceWithNetworkProfileRequest associateDeviceWithNetworkProfileRequest) throws NotFoundException,
            ConcurrentModificationException, DeviceNotRegisteredException, AwsServiceException, SdkClientException,
            AlexaForBusinessException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Associates a device with the specified network profile.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AssociateDeviceWithNetworkProfileRequest.Builder}
     * avoiding the need to create one manually via {@link AssociateDeviceWithNetworkProfileRequest#builder()}
     * </p>
     *
     * @param associateDeviceWithNetworkProfileRequest
     *        A {@link Consumer} that will call methods on {@link AssociateDeviceWithNetworkProfileRequest.Builder} to
     *        create a request.
     * @return Result of the AssociateDeviceWithNetworkProfile operation returned by the service.
     * @throws NotFoundException
     *         The resource is not found.
     * @throws ConcurrentModificationException
     *         There is a concurrent modification of resources.
     * @throws DeviceNotRegisteredException
     *         The request failed because this device is no longer registered and therefore no longer managed by this
     *         account.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AlexaForBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AlexaForBusinessClient.AssociateDeviceWithNetworkProfile
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/AssociateDeviceWithNetworkProfile"
     *      target="_top">AWS API Documentation</a>
     */
    default AssociateDeviceWithNetworkProfileResponse associateDeviceWithNetworkProfile(
            Consumer<AssociateDeviceWithNetworkProfileRequest.Builder> associateDeviceWithNetworkProfileRequest)
            throws NotFoundException, ConcurrentModificationException, DeviceNotRegisteredException, AwsServiceException,
            SdkClientException, AlexaForBusinessException {
        return associateDeviceWithNetworkProfile(AssociateDeviceWithNetworkProfileRequest.builder()
                .applyMutation(associateDeviceWithNetworkProfileRequest).build());
    }

    /**
     * <p>
     * Associates a device with a given room. This applies all the settings from the room profile to the device, and all
     * the skills in any skill groups added to that room. This operation requires the device to be online, or else a
     * manual sync is required.
     * </p>
     *
     * @param associateDeviceWithRoomRequest
     * @return Result of the AssociateDeviceWithRoom operation returned by the service.
     * @throws LimitExceededException
     *         You are performing an action that would put you beyond your account's limits.
     * @throws ConcurrentModificationException
     *         There is a concurrent modification of resources.
     * @throws DeviceNotRegisteredException
     *         The request failed because this device is no longer registered and therefore no longer managed by this
     *         account.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AlexaForBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AlexaForBusinessClient.AssociateDeviceWithRoom
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/AssociateDeviceWithRoom"
     *      target="_top">AWS API Documentation</a>
     */
    default AssociateDeviceWithRoomResponse associateDeviceWithRoom(AssociateDeviceWithRoomRequest associateDeviceWithRoomRequest)
            throws LimitExceededException, ConcurrentModificationException, DeviceNotRegisteredException, AwsServiceException,
            SdkClientException, AlexaForBusinessException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Associates a device with a given room. This applies all the settings from the room profile to the device, and all
     * the skills in any skill groups added to that room. This operation requires the device to be online, or else a
     * manual sync is required.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AssociateDeviceWithRoomRequest.Builder} avoiding
     * the need to create one manually via {@link AssociateDeviceWithRoomRequest#builder()}
     * </p>
     *
     * @param associateDeviceWithRoomRequest
     *        A {@link Consumer} that will call methods on {@link AssociateDeviceWithRoomRequest.Builder} to create a
     *        request.
     * @return Result of the AssociateDeviceWithRoom operation returned by the service.
     * @throws LimitExceededException
     *         You are performing an action that would put you beyond your account's limits.
     * @throws ConcurrentModificationException
     *         There is a concurrent modification of resources.
     * @throws DeviceNotRegisteredException
     *         The request failed because this device is no longer registered and therefore no longer managed by this
     *         account.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AlexaForBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AlexaForBusinessClient.AssociateDeviceWithRoom
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/AssociateDeviceWithRoom"
     *      target="_top">AWS API Documentation</a>
     */
    default AssociateDeviceWithRoomResponse associateDeviceWithRoom(
            Consumer<AssociateDeviceWithRoomRequest.Builder> associateDeviceWithRoomRequest) throws LimitExceededException,
            ConcurrentModificationException, DeviceNotRegisteredException, AwsServiceException, SdkClientException,
            AlexaForBusinessException {
        return associateDeviceWithRoom(AssociateDeviceWithRoomRequest.builder().applyMutation(associateDeviceWithRoomRequest)
                .build());
    }

    /**
     * <p>
     * Associates a skill group with a given room. This enables all skills in the associated skill group on all devices
     * in the room.
     * </p>
     *
     * @param associateSkillGroupWithRoomRequest
     * @return Result of the AssociateSkillGroupWithRoom operation returned by the service.
     * @throws ConcurrentModificationException
     *         There is a concurrent modification of resources.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AlexaForBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AlexaForBusinessClient.AssociateSkillGroupWithRoom
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/AssociateSkillGroupWithRoom"
     *      target="_top">AWS API Documentation</a>
     */
    default AssociateSkillGroupWithRoomResponse associateSkillGroupWithRoom(
            AssociateSkillGroupWithRoomRequest associateSkillGroupWithRoomRequest) throws ConcurrentModificationException,
            AwsServiceException, SdkClientException, AlexaForBusinessException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Associates a skill group with a given room. This enables all skills in the associated skill group on all devices
     * in the room.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AssociateSkillGroupWithRoomRequest.Builder}
     * avoiding the need to create one manually via {@link AssociateSkillGroupWithRoomRequest#builder()}
     * </p>
     *
     * @param associateSkillGroupWithRoomRequest
     *        A {@link Consumer} that will call methods on {@link AssociateSkillGroupWithRoomRequest.Builder} to create
     *        a request.
     * @return Result of the AssociateSkillGroupWithRoom operation returned by the service.
     * @throws ConcurrentModificationException
     *         There is a concurrent modification of resources.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AlexaForBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AlexaForBusinessClient.AssociateSkillGroupWithRoom
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/AssociateSkillGroupWithRoom"
     *      target="_top">AWS API Documentation</a>
     */
    default AssociateSkillGroupWithRoomResponse associateSkillGroupWithRoom(
            Consumer<AssociateSkillGroupWithRoomRequest.Builder> associateSkillGroupWithRoomRequest)
            throws ConcurrentModificationException, AwsServiceException, SdkClientException, AlexaForBusinessException {
        return associateSkillGroupWithRoom(AssociateSkillGroupWithRoomRequest.builder()
                .applyMutation(associateSkillGroupWithRoomRequest).build());
    }

    /**
     * <p>
     * Associates a skill with a skill group.
     * </p>
     *
     * @param associateSkillWithSkillGroupRequest
     * @return Result of the AssociateSkillWithSkillGroup operation returned by the service.
     * @throws ConcurrentModificationException
     *         There is a concurrent modification of resources.
     * @throws NotFoundException
     *         The resource is not found.
     * @throws SkillNotLinkedException
     *         The skill must be linked to a third-party account.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AlexaForBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AlexaForBusinessClient.AssociateSkillWithSkillGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/AssociateSkillWithSkillGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default AssociateSkillWithSkillGroupResponse associateSkillWithSkillGroup(
            AssociateSkillWithSkillGroupRequest associateSkillWithSkillGroupRequest) throws ConcurrentModificationException,
            NotFoundException, SkillNotLinkedException, AwsServiceException, SdkClientException, AlexaForBusinessException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Associates a skill with a skill group.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AssociateSkillWithSkillGroupRequest.Builder}
     * avoiding the need to create one manually via {@link AssociateSkillWithSkillGroupRequest#builder()}
     * </p>
     *
     * @param associateSkillWithSkillGroupRequest
     *        A {@link Consumer} that will call methods on {@link AssociateSkillWithSkillGroupRequest.Builder} to create
     *        a request.
     * @return Result of the AssociateSkillWithSkillGroup operation returned by the service.
     * @throws ConcurrentModificationException
     *         There is a concurrent modification of resources.
     * @throws NotFoundException
     *         The resource is not found.
     * @throws SkillNotLinkedException
     *         The skill must be linked to a third-party account.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AlexaForBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AlexaForBusinessClient.AssociateSkillWithSkillGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/AssociateSkillWithSkillGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default AssociateSkillWithSkillGroupResponse associateSkillWithSkillGroup(
            Consumer<AssociateSkillWithSkillGroupRequest.Builder> associateSkillWithSkillGroupRequest)
            throws ConcurrentModificationException, NotFoundException, SkillNotLinkedException, AwsServiceException,
            SdkClientException, AlexaForBusinessException {
        return associateSkillWithSkillGroup(AssociateSkillWithSkillGroupRequest.builder()
                .applyMutation(associateSkillWithSkillGroupRequest).build());
    }

    /**
     * <p>
     * Makes a private skill available for enrolled users to enable on their devices.
     * </p>
     *
     * @param associateSkillWithUsersRequest
     * @return Result of the AssociateSkillWithUsers operation returned by the service.
     * @throws ConcurrentModificationException
     *         There is a concurrent modification of resources.
     * @throws NotFoundException
     *         The resource is not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AlexaForBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AlexaForBusinessClient.AssociateSkillWithUsers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/AssociateSkillWithUsers"
     *      target="_top">AWS API Documentation</a>
     */
    default AssociateSkillWithUsersResponse associateSkillWithUsers(AssociateSkillWithUsersRequest associateSkillWithUsersRequest)
            throws ConcurrentModificationException, NotFoundException, AwsServiceException, SdkClientException,
            AlexaForBusinessException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Makes a private skill available for enrolled users to enable on their devices.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AssociateSkillWithUsersRequest.Builder} avoiding
     * the need to create one manually via {@link AssociateSkillWithUsersRequest#builder()}
     * </p>
     *
     * @param associateSkillWithUsersRequest
     *        A {@link Consumer} that will call methods on {@link AssociateSkillWithUsersRequest.Builder} to create a
     *        request.
     * @return Result of the AssociateSkillWithUsers operation returned by the service.
     * @throws ConcurrentModificationException
     *         There is a concurrent modification of resources.
     * @throws NotFoundException
     *         The resource is not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AlexaForBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AlexaForBusinessClient.AssociateSkillWithUsers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/AssociateSkillWithUsers"
     *      target="_top">AWS API Documentation</a>
     */
    default AssociateSkillWithUsersResponse associateSkillWithUsers(
            Consumer<AssociateSkillWithUsersRequest.Builder> associateSkillWithUsersRequest)
            throws ConcurrentModificationException, NotFoundException, AwsServiceException, SdkClientException,
            AlexaForBusinessException {
        return associateSkillWithUsers(AssociateSkillWithUsersRequest.builder().applyMutation(associateSkillWithUsersRequest)
                .build());
    }

    /**
     * <p>
     * Creates an address book with the specified details.
     * </p>
     *
     * @param createAddressBookRequest
     * @return Result of the CreateAddressBook operation returned by the service.
     * @throws AlreadyExistsException
     *         The resource being created already exists.
     * @throws LimitExceededException
     *         You are performing an action that would put you beyond your account's limits.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AlexaForBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AlexaForBusinessClient.CreateAddressBook
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/CreateAddressBook"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateAddressBookResponse createAddressBook(CreateAddressBookRequest createAddressBookRequest)
            throws AlreadyExistsException, LimitExceededException, AwsServiceException, SdkClientException,
            AlexaForBusinessException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates an address book with the specified details.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateAddressBookRequest.Builder} avoiding the need
     * to create one manually via {@link CreateAddressBookRequest#builder()}
     * </p>
     *
     * @param createAddressBookRequest
     *        A {@link Consumer} that will call methods on {@link CreateAddressBookRequest.Builder} to create a request.
     * @return Result of the CreateAddressBook operation returned by the service.
     * @throws AlreadyExistsException
     *         The resource being created already exists.
     * @throws LimitExceededException
     *         You are performing an action that would put you beyond your account's limits.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AlexaForBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AlexaForBusinessClient.CreateAddressBook
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/CreateAddressBook"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateAddressBookResponse createAddressBook(Consumer<CreateAddressBookRequest.Builder> createAddressBookRequest)
            throws AlreadyExistsException, LimitExceededException, AwsServiceException, SdkClientException,
            AlexaForBusinessException {
        return createAddressBook(CreateAddressBookRequest.builder().applyMutation(createAddressBookRequest).build());
    }

    /**
     * <p>
     * Creates a recurring schedule for usage reports to deliver to the specified S3 location with a specified daily or
     * weekly interval.
     * </p>
     *
     * @param createBusinessReportScheduleRequest
     * @return Result of the CreateBusinessReportSchedule operation returned by the service.
     * @throws AlreadyExistsException
     *         The resource being created already exists.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AlexaForBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AlexaForBusinessClient.CreateBusinessReportSchedule
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/CreateBusinessReportSchedule"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateBusinessReportScheduleResponse createBusinessReportSchedule(
            CreateBusinessReportScheduleRequest createBusinessReportScheduleRequest) throws AlreadyExistsException,
            AwsServiceException, SdkClientException, AlexaForBusinessException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a recurring schedule for usage reports to deliver to the specified S3 location with a specified daily or
     * weekly interval.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateBusinessReportScheduleRequest.Builder}
     * avoiding the need to create one manually via {@link CreateBusinessReportScheduleRequest#builder()}
     * </p>
     *
     * @param createBusinessReportScheduleRequest
     *        A {@link Consumer} that will call methods on {@link CreateBusinessReportScheduleRequest.Builder} to create
     *        a request.
     * @return Result of the CreateBusinessReportSchedule operation returned by the service.
     * @throws AlreadyExistsException
     *         The resource being created already exists.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AlexaForBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AlexaForBusinessClient.CreateBusinessReportSchedule
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/CreateBusinessReportSchedule"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateBusinessReportScheduleResponse createBusinessReportSchedule(
            Consumer<CreateBusinessReportScheduleRequest.Builder> createBusinessReportScheduleRequest)
            throws AlreadyExistsException, AwsServiceException, SdkClientException, AlexaForBusinessException {
        return createBusinessReportSchedule(CreateBusinessReportScheduleRequest.builder()
                .applyMutation(createBusinessReportScheduleRequest).build());
    }

    /**
     * <p>
     * Adds a new conference provider under the user's AWS account.
     * </p>
     *
     * @param createConferenceProviderRequest
     * @return Result of the CreateConferenceProvider operation returned by the service.
     * @throws AlreadyExistsException
     *         The resource being created already exists.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AlexaForBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AlexaForBusinessClient.CreateConferenceProvider
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/CreateConferenceProvider"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateConferenceProviderResponse createConferenceProvider(
            CreateConferenceProviderRequest createConferenceProviderRequest) throws AlreadyExistsException, AwsServiceException,
            SdkClientException, AlexaForBusinessException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Adds a new conference provider under the user's AWS account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateConferenceProviderRequest.Builder} avoiding
     * the need to create one manually via {@link CreateConferenceProviderRequest#builder()}
     * </p>
     *
     * @param createConferenceProviderRequest
     *        A {@link Consumer} that will call methods on {@link CreateConferenceProviderRequest.Builder} to create a
     *        request.
     * @return Result of the CreateConferenceProvider operation returned by the service.
     * @throws AlreadyExistsException
     *         The resource being created already exists.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AlexaForBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AlexaForBusinessClient.CreateConferenceProvider
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/CreateConferenceProvider"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateConferenceProviderResponse createConferenceProvider(
            Consumer<CreateConferenceProviderRequest.Builder> createConferenceProviderRequest) throws AlreadyExistsException,
            AwsServiceException, SdkClientException, AlexaForBusinessException {
        return createConferenceProvider(CreateConferenceProviderRequest.builder().applyMutation(createConferenceProviderRequest)
                .build());
    }

    /**
     * <p>
     * Creates a contact with the specified details.
     * </p>
     *
     * @param createContactRequest
     * @return Result of the CreateContact operation returned by the service.
     * @throws AlreadyExistsException
     *         The resource being created already exists.
     * @throws LimitExceededException
     *         You are performing an action that would put you beyond your account's limits.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AlexaForBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AlexaForBusinessClient.CreateContact
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/CreateContact"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateContactResponse createContact(CreateContactRequest createContactRequest) throws AlreadyExistsException,
            LimitExceededException, AwsServiceException, SdkClientException, AlexaForBusinessException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a contact with the specified details.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateContactRequest.Builder} avoiding the need to
     * create one manually via {@link CreateContactRequest#builder()}
     * </p>
     *
     * @param createContactRequest
     *        A {@link Consumer} that will call methods on {@link CreateContactRequest.Builder} to create a request.
     * @return Result of the CreateContact operation returned by the service.
     * @throws AlreadyExistsException
     *         The resource being created already exists.
     * @throws LimitExceededException
     *         You are performing an action that would put you beyond your account's limits.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AlexaForBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AlexaForBusinessClient.CreateContact
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/CreateContact"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateContactResponse createContact(Consumer<CreateContactRequest.Builder> createContactRequest)
            throws AlreadyExistsException, LimitExceededException, AwsServiceException, SdkClientException,
            AlexaForBusinessException {
        return createContact(CreateContactRequest.builder().applyMutation(createContactRequest).build());
    }

    /**
     * <p>
     * Creates a gateway group with the specified details.
     * </p>
     *
     * @param createGatewayGroupRequest
     * @return Result of the CreateGatewayGroup operation returned by the service.
     * @throws AlreadyExistsException
     *         The resource being created already exists.
     * @throws LimitExceededException
     *         You are performing an action that would put you beyond your account's limits.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AlexaForBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AlexaForBusinessClient.CreateGatewayGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/CreateGatewayGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateGatewayGroupResponse createGatewayGroup(CreateGatewayGroupRequest createGatewayGroupRequest)
            throws AlreadyExistsException, LimitExceededException, AwsServiceException, SdkClientException,
            AlexaForBusinessException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a gateway group with the specified details.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateGatewayGroupRequest.Builder} avoiding the
     * need to create one manually via {@link CreateGatewayGroupRequest#builder()}
     * </p>
     *
     * @param createGatewayGroupRequest
     *        A {@link Consumer} that will call methods on {@link CreateGatewayGroupRequest.Builder} to create a
     *        request.
     * @return Result of the CreateGatewayGroup operation returned by the service.
     * @throws AlreadyExistsException
     *         The resource being created already exists.
     * @throws LimitExceededException
     *         You are performing an action that would put you beyond your account's limits.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AlexaForBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AlexaForBusinessClient.CreateGatewayGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/CreateGatewayGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateGatewayGroupResponse createGatewayGroup(Consumer<CreateGatewayGroupRequest.Builder> createGatewayGroupRequest)
            throws AlreadyExistsException, LimitExceededException, AwsServiceException, SdkClientException,
            AlexaForBusinessException {
        return createGatewayGroup(CreateGatewayGroupRequest.builder().applyMutation(createGatewayGroupRequest).build());
    }

    /**
     * <p>
     * Creates a network profile with the specified details.
     * </p>
     *
     * @param createNetworkProfileRequest
     * @return Result of the CreateNetworkProfile operation returned by the service.
     * @throws AlreadyExistsException
     *         The resource being created already exists.
     * @throws LimitExceededException
     *         You are performing an action that would put you beyond your account's limits.
     * @throws ConcurrentModificationException
     *         There is a concurrent modification of resources.
     * @throws InvalidCertificateAuthorityException
     *         The Certificate Authority can't issue or revoke a certificate.
     * @throws InvalidServiceLinkedRoleStateException
     *         The service linked role is locked for deletion.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AlexaForBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AlexaForBusinessClient.CreateNetworkProfile
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/CreateNetworkProfile"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateNetworkProfileResponse createNetworkProfile(CreateNetworkProfileRequest createNetworkProfileRequest)
            throws AlreadyExistsException, LimitExceededException, ConcurrentModificationException,
            InvalidCertificateAuthorityException, InvalidServiceLinkedRoleStateException, AwsServiceException,
            SdkClientException, AlexaForBusinessException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a network profile with the specified details.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateNetworkProfileRequest.Builder} avoiding the
     * need to create one manually via {@link CreateNetworkProfileRequest#builder()}
     * </p>
     *
     * @param createNetworkProfileRequest
     *        A {@link Consumer} that will call methods on {@link CreateNetworkProfileRequest.Builder} to create a
     *        request.
     * @return Result of the CreateNetworkProfile operation returned by the service.
     * @throws AlreadyExistsException
     *         The resource being created already exists.
     * @throws LimitExceededException
     *         You are performing an action that would put you beyond your account's limits.
     * @throws ConcurrentModificationException
     *         There is a concurrent modification of resources.
     * @throws InvalidCertificateAuthorityException
     *         The Certificate Authority can't issue or revoke a certificate.
     * @throws InvalidServiceLinkedRoleStateException
     *         The service linked role is locked for deletion.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AlexaForBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AlexaForBusinessClient.CreateNetworkProfile
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/CreateNetworkProfile"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateNetworkProfileResponse createNetworkProfile(
            Consumer<CreateNetworkProfileRequest.Builder> createNetworkProfileRequest) throws AlreadyExistsException,
            LimitExceededException, ConcurrentModificationException, InvalidCertificateAuthorityException,
            InvalidServiceLinkedRoleStateException, AwsServiceException, SdkClientException, AlexaForBusinessException {
        return createNetworkProfile(CreateNetworkProfileRequest.builder().applyMutation(createNetworkProfileRequest).build());
    }

    /**
     * <p>
     * Creates a new room profile with the specified details.
     * </p>
     *
     * @param createProfileRequest
     * @return Result of the CreateProfile operation returned by the service.
     * @throws LimitExceededException
     *         You are performing an action that would put you beyond your account's limits.
     * @throws AlreadyExistsException
     *         The resource being created already exists.
     * @throws ConcurrentModificationException
     *         There is a concurrent modification of resources.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AlexaForBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AlexaForBusinessClient.CreateProfile
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/CreateProfile"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateProfileResponse createProfile(CreateProfileRequest createProfileRequest) throws LimitExceededException,
            AlreadyExistsException, ConcurrentModificationException, AwsServiceException, SdkClientException,
            AlexaForBusinessException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a new room profile with the specified details.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateProfileRequest.Builder} avoiding the need to
     * create one manually via {@link CreateProfileRequest#builder()}
     * </p>
     *
     * @param createProfileRequest
     *        A {@link Consumer} that will call methods on {@link CreateProfileRequest.Builder} to create a request.
     * @return Result of the CreateProfile operation returned by the service.
     * @throws LimitExceededException
     *         You are performing an action that would put you beyond your account's limits.
     * @throws AlreadyExistsException
     *         The resource being created already exists.
     * @throws ConcurrentModificationException
     *         There is a concurrent modification of resources.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AlexaForBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AlexaForBusinessClient.CreateProfile
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/CreateProfile"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateProfileResponse createProfile(Consumer<CreateProfileRequest.Builder> createProfileRequest)
            throws LimitExceededException, AlreadyExistsException, ConcurrentModificationException, AwsServiceException,
            SdkClientException, AlexaForBusinessException {
        return createProfile(CreateProfileRequest.builder().applyMutation(createProfileRequest).build());
    }

    /**
     * <p>
     * Creates a room with the specified details.
     * </p>
     *
     * @param createRoomRequest
     * @return Result of the CreateRoom operation returned by the service.
     * @throws AlreadyExistsException
     *         The resource being created already exists.
     * @throws LimitExceededException
     *         You are performing an action that would put you beyond your account's limits.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AlexaForBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AlexaForBusinessClient.CreateRoom
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/CreateRoom" target="_top">AWS
     *      API Documentation</a>
     */
    default CreateRoomResponse createRoom(CreateRoomRequest createRoomRequest) throws AlreadyExistsException,
            LimitExceededException, AwsServiceException, SdkClientException, AlexaForBusinessException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a room with the specified details.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateRoomRequest.Builder} avoiding the need to
     * create one manually via {@link CreateRoomRequest#builder()}
     * </p>
     *
     * @param createRoomRequest
     *        A {@link Consumer} that will call methods on {@link CreateRoomRequest.Builder} to create a request.
     * @return Result of the CreateRoom operation returned by the service.
     * @throws AlreadyExistsException
     *         The resource being created already exists.
     * @throws LimitExceededException
     *         You are performing an action that would put you beyond your account's limits.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AlexaForBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AlexaForBusinessClient.CreateRoom
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/CreateRoom" target="_top">AWS
     *      API Documentation</a>
     */
    default CreateRoomResponse createRoom(Consumer<CreateRoomRequest.Builder> createRoomRequest) throws AlreadyExistsException,
            LimitExceededException, AwsServiceException, SdkClientException, AlexaForBusinessException {
        return createRoom(CreateRoomRequest.builder().applyMutation(createRoomRequest).build());
    }

    /**
     * <p>
     * Creates a skill group with a specified name and description.
     * </p>
     *
     * @param createSkillGroupRequest
     * @return Result of the CreateSkillGroup operation returned by the service.
     * @throws AlreadyExistsException
     *         The resource being created already exists.
     * @throws LimitExceededException
     *         You are performing an action that would put you beyond your account's limits.
     * @throws ConcurrentModificationException
     *         There is a concurrent modification of resources.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AlexaForBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AlexaForBusinessClient.CreateSkillGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/CreateSkillGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateSkillGroupResponse createSkillGroup(CreateSkillGroupRequest createSkillGroupRequest)
            throws AlreadyExistsException, LimitExceededException, ConcurrentModificationException, AwsServiceException,
            SdkClientException, AlexaForBusinessException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a skill group with a specified name and description.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateSkillGroupRequest.Builder} avoiding the need
     * to create one manually via {@link CreateSkillGroupRequest#builder()}
     * </p>
     *
     * @param createSkillGroupRequest
     *        A {@link Consumer} that will call methods on {@link CreateSkillGroupRequest.Builder} to create a request.
     * @return Result of the CreateSkillGroup operation returned by the service.
     * @throws AlreadyExistsException
     *         The resource being created already exists.
     * @throws LimitExceededException
     *         You are performing an action that would put you beyond your account's limits.
     * @throws ConcurrentModificationException
     *         There is a concurrent modification of resources.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AlexaForBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AlexaForBusinessClient.CreateSkillGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/CreateSkillGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateSkillGroupResponse createSkillGroup(Consumer<CreateSkillGroupRequest.Builder> createSkillGroupRequest)
            throws AlreadyExistsException, LimitExceededException, ConcurrentModificationException, AwsServiceException,
            SdkClientException, AlexaForBusinessException {
        return createSkillGroup(CreateSkillGroupRequest.builder().applyMutation(createSkillGroupRequest).build());
    }

    /**
     * <p>
     * Creates a user.
     * </p>
     *
     * @param createUserRequest
     * @return Result of the CreateUser operation returned by the service.
     * @throws ResourceInUseException
     *         The resource in the request is already in use.
     * @throws LimitExceededException
     *         You are performing an action that would put you beyond your account's limits.
     * @throws ConcurrentModificationException
     *         There is a concurrent modification of resources.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AlexaForBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AlexaForBusinessClient.CreateUser
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/CreateUser" target="_top">AWS
     *      API Documentation</a>
     */
    default CreateUserResponse createUser(CreateUserRequest createUserRequest) throws ResourceInUseException,
            LimitExceededException, ConcurrentModificationException, AwsServiceException, SdkClientException,
            AlexaForBusinessException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a user.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateUserRequest.Builder} avoiding the need to
     * create one manually via {@link CreateUserRequest#builder()}
     * </p>
     *
     * @param createUserRequest
     *        A {@link Consumer} that will call methods on {@link CreateUserRequest.Builder} to create a request.
     * @return Result of the CreateUser operation returned by the service.
     * @throws ResourceInUseException
     *         The resource in the request is already in use.
     * @throws LimitExceededException
     *         You are performing an action that would put you beyond your account's limits.
     * @throws ConcurrentModificationException
     *         There is a concurrent modification of resources.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AlexaForBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AlexaForBusinessClient.CreateUser
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/CreateUser" target="_top">AWS
     *      API Documentation</a>
     */
    default CreateUserResponse createUser(Consumer<CreateUserRequest.Builder> createUserRequest) throws ResourceInUseException,
            LimitExceededException, ConcurrentModificationException, AwsServiceException, SdkClientException,
            AlexaForBusinessException {
        return createUser(CreateUserRequest.builder().applyMutation(createUserRequest).build());
    }

    /**
     * <p>
     * Deletes an address book by the address book ARN.
     * </p>
     *
     * @param deleteAddressBookRequest
     * @return Result of the DeleteAddressBook operation returned by the service.
     * @throws NotFoundException
     *         The resource is not found.
     * @throws ConcurrentModificationException
     *         There is a concurrent modification of resources.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AlexaForBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AlexaForBusinessClient.DeleteAddressBook
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/DeleteAddressBook"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteAddressBookResponse deleteAddressBook(DeleteAddressBookRequest deleteAddressBookRequest)
            throws NotFoundException, ConcurrentModificationException, AwsServiceException, SdkClientException,
            AlexaForBusinessException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes an address book by the address book ARN.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteAddressBookRequest.Builder} avoiding the need
     * to create one manually via {@link DeleteAddressBookRequest#builder()}
     * </p>
     *
     * @param deleteAddressBookRequest
     *        A {@link Consumer} that will call methods on {@link DeleteAddressBookRequest.Builder} to create a request.
     * @return Result of the DeleteAddressBook operation returned by the service.
     * @throws NotFoundException
     *         The resource is not found.
     * @throws ConcurrentModificationException
     *         There is a concurrent modification of resources.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AlexaForBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AlexaForBusinessClient.DeleteAddressBook
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/DeleteAddressBook"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteAddressBookResponse deleteAddressBook(Consumer<DeleteAddressBookRequest.Builder> deleteAddressBookRequest)
            throws NotFoundException, ConcurrentModificationException, AwsServiceException, SdkClientException,
            AlexaForBusinessException {
        return deleteAddressBook(DeleteAddressBookRequest.builder().applyMutation(deleteAddressBookRequest).build());
    }

    /**
     * <p>
     * Deletes the recurring report delivery schedule with the specified schedule ARN.
     * </p>
     *
     * @param deleteBusinessReportScheduleRequest
     * @return Result of the DeleteBusinessReportSchedule operation returned by the service.
     * @throws NotFoundException
     *         The resource is not found.
     * @throws ConcurrentModificationException
     *         There is a concurrent modification of resources.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AlexaForBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AlexaForBusinessClient.DeleteBusinessReportSchedule
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/DeleteBusinessReportSchedule"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteBusinessReportScheduleResponse deleteBusinessReportSchedule(
            DeleteBusinessReportScheduleRequest deleteBusinessReportScheduleRequest) throws NotFoundException,
            ConcurrentModificationException, AwsServiceException, SdkClientException, AlexaForBusinessException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the recurring report delivery schedule with the specified schedule ARN.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteBusinessReportScheduleRequest.Builder}
     * avoiding the need to create one manually via {@link DeleteBusinessReportScheduleRequest#builder()}
     * </p>
     *
     * @param deleteBusinessReportScheduleRequest
     *        A {@link Consumer} that will call methods on {@link DeleteBusinessReportScheduleRequest.Builder} to create
     *        a request.
     * @return Result of the DeleteBusinessReportSchedule operation returned by the service.
     * @throws NotFoundException
     *         The resource is not found.
     * @throws ConcurrentModificationException
     *         There is a concurrent modification of resources.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AlexaForBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AlexaForBusinessClient.DeleteBusinessReportSchedule
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/DeleteBusinessReportSchedule"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteBusinessReportScheduleResponse deleteBusinessReportSchedule(
            Consumer<DeleteBusinessReportScheduleRequest.Builder> deleteBusinessReportScheduleRequest) throws NotFoundException,
            ConcurrentModificationException, AwsServiceException, SdkClientException, AlexaForBusinessException {
        return deleteBusinessReportSchedule(DeleteBusinessReportScheduleRequest.builder()
                .applyMutation(deleteBusinessReportScheduleRequest).build());
    }

    /**
     * <p>
     * Deletes a conference provider.
     * </p>
     *
     * @param deleteConferenceProviderRequest
     * @return Result of the DeleteConferenceProvider operation returned by the service.
     * @throws NotFoundException
     *         The resource is not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AlexaForBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AlexaForBusinessClient.DeleteConferenceProvider
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/DeleteConferenceProvider"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteConferenceProviderResponse deleteConferenceProvider(
            DeleteConferenceProviderRequest deleteConferenceProviderRequest) throws NotFoundException, AwsServiceException,
            SdkClientException, AlexaForBusinessException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a conference provider.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteConferenceProviderRequest.Builder} avoiding
     * the need to create one manually via {@link DeleteConferenceProviderRequest#builder()}
     * </p>
     *
     * @param deleteConferenceProviderRequest
     *        A {@link Consumer} that will call methods on {@link DeleteConferenceProviderRequest.Builder} to create a
     *        request.
     * @return Result of the DeleteConferenceProvider operation returned by the service.
     * @throws NotFoundException
     *         The resource is not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AlexaForBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AlexaForBusinessClient.DeleteConferenceProvider
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/DeleteConferenceProvider"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteConferenceProviderResponse deleteConferenceProvider(
            Consumer<DeleteConferenceProviderRequest.Builder> deleteConferenceProviderRequest) throws NotFoundException,
            AwsServiceException, SdkClientException, AlexaForBusinessException {
        return deleteConferenceProvider(DeleteConferenceProviderRequest.builder().applyMutation(deleteConferenceProviderRequest)
                .build());
    }

    /**
     * <p>
     * Deletes a contact by the contact ARN.
     * </p>
     *
     * @param deleteContactRequest
     * @return Result of the DeleteContact operation returned by the service.
     * @throws NotFoundException
     *         The resource is not found.
     * @throws ConcurrentModificationException
     *         There is a concurrent modification of resources.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AlexaForBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AlexaForBusinessClient.DeleteContact
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/DeleteContact"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteContactResponse deleteContact(DeleteContactRequest deleteContactRequest) throws NotFoundException,
            ConcurrentModificationException, AwsServiceException, SdkClientException, AlexaForBusinessException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a contact by the contact ARN.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteContactRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteContactRequest#builder()}
     * </p>
     *
     * @param deleteContactRequest
     *        A {@link Consumer} that will call methods on {@link DeleteContactRequest.Builder} to create a request.
     * @return Result of the DeleteContact operation returned by the service.
     * @throws NotFoundException
     *         The resource is not found.
     * @throws ConcurrentModificationException
     *         There is a concurrent modification of resources.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AlexaForBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AlexaForBusinessClient.DeleteContact
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/DeleteContact"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteContactResponse deleteContact(Consumer<DeleteContactRequest.Builder> deleteContactRequest)
            throws NotFoundException, ConcurrentModificationException, AwsServiceException, SdkClientException,
            AlexaForBusinessException {
        return deleteContact(DeleteContactRequest.builder().applyMutation(deleteContactRequest).build());
    }

    /**
     * <p>
     * Removes a device from Alexa For Business.
     * </p>
     *
     * @param deleteDeviceRequest
     * @return Result of the DeleteDevice operation returned by the service.
     * @throws NotFoundException
     *         The resource is not found.
     * @throws ConcurrentModificationException
     *         There is a concurrent modification of resources.
     * @throws InvalidCertificateAuthorityException
     *         The Certificate Authority can't issue or revoke a certificate.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AlexaForBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AlexaForBusinessClient.DeleteDevice
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/DeleteDevice" target="_top">AWS
     *      API Documentation</a>
     */
    default DeleteDeviceResponse deleteDevice(DeleteDeviceRequest deleteDeviceRequest) throws NotFoundException,
            ConcurrentModificationException, InvalidCertificateAuthorityException, AwsServiceException, SdkClientException,
            AlexaForBusinessException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Removes a device from Alexa For Business.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteDeviceRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteDeviceRequest#builder()}
     * </p>
     *
     * @param deleteDeviceRequest
     *        A {@link Consumer} that will call methods on {@link DeleteDeviceRequest.Builder} to create a request.
     * @return Result of the DeleteDevice operation returned by the service.
     * @throws NotFoundException
     *         The resource is not found.
     * @throws ConcurrentModificationException
     *         There is a concurrent modification of resources.
     * @throws InvalidCertificateAuthorityException
     *         The Certificate Authority can't issue or revoke a certificate.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AlexaForBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AlexaForBusinessClient.DeleteDevice
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/DeleteDevice" target="_top">AWS
     *      API Documentation</a>
     */
    default DeleteDeviceResponse deleteDevice(Consumer<DeleteDeviceRequest.Builder> deleteDeviceRequest)
            throws NotFoundException, ConcurrentModificationException, InvalidCertificateAuthorityException, AwsServiceException,
            SdkClientException, AlexaForBusinessException {
        return deleteDevice(DeleteDeviceRequest.builder().applyMutation(deleteDeviceRequest).build());
    }

    /**
     * <p>
     * When this action is called for a specified shared device, it allows authorized users to delete the device's
     * entire previous history of voice input data and associated response data. This action can be called once every 24
     * hours for a specific shared device.
     * </p>
     *
     * @param deleteDeviceUsageDataRequest
     * @return Result of the DeleteDeviceUsageData operation returned by the service.
     * @throws NotFoundException
     *         The resource is not found.
     * @throws DeviceNotRegisteredException
     *         The request failed because this device is no longer registered and therefore no longer managed by this
     *         account.
     * @throws LimitExceededException
     *         You are performing an action that would put you beyond your account's limits.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AlexaForBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AlexaForBusinessClient.DeleteDeviceUsageData
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/DeleteDeviceUsageData"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteDeviceUsageDataResponse deleteDeviceUsageData(DeleteDeviceUsageDataRequest deleteDeviceUsageDataRequest)
            throws NotFoundException, DeviceNotRegisteredException, LimitExceededException, AwsServiceException,
            SdkClientException, AlexaForBusinessException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * When this action is called for a specified shared device, it allows authorized users to delete the device's
     * entire previous history of voice input data and associated response data. This action can be called once every 24
     * hours for a specific shared device.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteDeviceUsageDataRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteDeviceUsageDataRequest#builder()}
     * </p>
     *
     * @param deleteDeviceUsageDataRequest
     *        A {@link Consumer} that will call methods on {@link DeleteDeviceUsageDataRequest.Builder} to create a
     *        request.
     * @return Result of the DeleteDeviceUsageData operation returned by the service.
     * @throws NotFoundException
     *         The resource is not found.
     * @throws DeviceNotRegisteredException
     *         The request failed because this device is no longer registered and therefore no longer managed by this
     *         account.
     * @throws LimitExceededException
     *         You are performing an action that would put you beyond your account's limits.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AlexaForBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AlexaForBusinessClient.DeleteDeviceUsageData
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/DeleteDeviceUsageData"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteDeviceUsageDataResponse deleteDeviceUsageData(
            Consumer<DeleteDeviceUsageDataRequest.Builder> deleteDeviceUsageDataRequest) throws NotFoundException,
            DeviceNotRegisteredException, LimitExceededException, AwsServiceException, SdkClientException,
            AlexaForBusinessException {
        return deleteDeviceUsageData(DeleteDeviceUsageDataRequest.builder().applyMutation(deleteDeviceUsageDataRequest).build());
    }

    /**
     * <p>
     * Deletes a gateway group.
     * </p>
     *
     * @param deleteGatewayGroupRequest
     * @return Result of the DeleteGatewayGroup operation returned by the service.
     * @throws ResourceAssociatedException
     *         Another resource is associated with the resource in the request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AlexaForBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AlexaForBusinessClient.DeleteGatewayGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/DeleteGatewayGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteGatewayGroupResponse deleteGatewayGroup(DeleteGatewayGroupRequest deleteGatewayGroupRequest)
            throws ResourceAssociatedException, AwsServiceException, SdkClientException, AlexaForBusinessException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a gateway group.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteGatewayGroupRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteGatewayGroupRequest#builder()}
     * </p>
     *
     * @param deleteGatewayGroupRequest
     *        A {@link Consumer} that will call methods on {@link DeleteGatewayGroupRequest.Builder} to create a
     *        request.
     * @return Result of the DeleteGatewayGroup operation returned by the service.
     * @throws ResourceAssociatedException
     *         Another resource is associated with the resource in the request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AlexaForBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AlexaForBusinessClient.DeleteGatewayGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/DeleteGatewayGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteGatewayGroupResponse deleteGatewayGroup(Consumer<DeleteGatewayGroupRequest.Builder> deleteGatewayGroupRequest)
            throws ResourceAssociatedException, AwsServiceException, SdkClientException, AlexaForBusinessException {
        return deleteGatewayGroup(DeleteGatewayGroupRequest.builder().applyMutation(deleteGatewayGroupRequest).build());
    }

    /**
     * <p>
     * Deletes a network profile by the network profile ARN.
     * </p>
     *
     * @param deleteNetworkProfileRequest
     * @return Result of the DeleteNetworkProfile operation returned by the service.
     * @throws ResourceInUseException
     *         The resource in the request is already in use.
     * @throws ConcurrentModificationException
     *         There is a concurrent modification of resources.
     * @throws NotFoundException
     *         The resource is not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AlexaForBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AlexaForBusinessClient.DeleteNetworkProfile
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/DeleteNetworkProfile"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteNetworkProfileResponse deleteNetworkProfile(DeleteNetworkProfileRequest deleteNetworkProfileRequest)
            throws ResourceInUseException, ConcurrentModificationException, NotFoundException, AwsServiceException,
            SdkClientException, AlexaForBusinessException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a network profile by the network profile ARN.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteNetworkProfileRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteNetworkProfileRequest#builder()}
     * </p>
     *
     * @param deleteNetworkProfileRequest
     *        A {@link Consumer} that will call methods on {@link DeleteNetworkProfileRequest.Builder} to create a
     *        request.
     * @return Result of the DeleteNetworkProfile operation returned by the service.
     * @throws ResourceInUseException
     *         The resource in the request is already in use.
     * @throws ConcurrentModificationException
     *         There is a concurrent modification of resources.
     * @throws NotFoundException
     *         The resource is not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AlexaForBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AlexaForBusinessClient.DeleteNetworkProfile
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/DeleteNetworkProfile"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteNetworkProfileResponse deleteNetworkProfile(
            Consumer<DeleteNetworkProfileRequest.Builder> deleteNetworkProfileRequest) throws ResourceInUseException,
            ConcurrentModificationException, NotFoundException, AwsServiceException, SdkClientException,
            AlexaForBusinessException {
        return deleteNetworkProfile(DeleteNetworkProfileRequest.builder().applyMutation(deleteNetworkProfileRequest).build());
    }

    /**
     * <p>
     * Deletes a room profile by the profile ARN.
     * </p>
     *
     * @param deleteProfileRequest
     * @return Result of the DeleteProfile operation returned by the service.
     * @throws NotFoundException
     *         The resource is not found.
     * @throws ConcurrentModificationException
     *         There is a concurrent modification of resources.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AlexaForBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AlexaForBusinessClient.DeleteProfile
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/DeleteProfile"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteProfileResponse deleteProfile(DeleteProfileRequest deleteProfileRequest) throws NotFoundException,
            ConcurrentModificationException, AwsServiceException, SdkClientException, AlexaForBusinessException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a room profile by the profile ARN.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteProfileRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteProfileRequest#builder()}
     * </p>
     *
     * @param deleteProfileRequest
     *        A {@link Consumer} that will call methods on {@link DeleteProfileRequest.Builder} to create a request.
     * @return Result of the DeleteProfile operation returned by the service.
     * @throws NotFoundException
     *         The resource is not found.
     * @throws ConcurrentModificationException
     *         There is a concurrent modification of resources.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AlexaForBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AlexaForBusinessClient.DeleteProfile
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/DeleteProfile"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteProfileResponse deleteProfile(Consumer<DeleteProfileRequest.Builder> deleteProfileRequest)
            throws NotFoundException, ConcurrentModificationException, AwsServiceException, SdkClientException,
            AlexaForBusinessException {
        return deleteProfile(DeleteProfileRequest.builder().applyMutation(deleteProfileRequest).build());
    }

    /**
     * <p>
     * Deletes a room by the room ARN.
     * </p>
     *
     * @param deleteRoomRequest
     * @return Result of the DeleteRoom operation returned by the service.
     * @throws NotFoundException
     *         The resource is not found.
     * @throws ConcurrentModificationException
     *         There is a concurrent modification of resources.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AlexaForBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AlexaForBusinessClient.DeleteRoom
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/DeleteRoom" target="_top">AWS
     *      API Documentation</a>
     */
    default DeleteRoomResponse deleteRoom(DeleteRoomRequest deleteRoomRequest) throws NotFoundException,
            ConcurrentModificationException, AwsServiceException, SdkClientException, AlexaForBusinessException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a room by the room ARN.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteRoomRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteRoomRequest#builder()}
     * </p>
     *
     * @param deleteRoomRequest
     *        A {@link Consumer} that will call methods on {@link DeleteRoomRequest.Builder} to create a request.
     * @return Result of the DeleteRoom operation returned by the service.
     * @throws NotFoundException
     *         The resource is not found.
     * @throws ConcurrentModificationException
     *         There is a concurrent modification of resources.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AlexaForBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AlexaForBusinessClient.DeleteRoom
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/DeleteRoom" target="_top">AWS
     *      API Documentation</a>
     */
    default DeleteRoomResponse deleteRoom(Consumer<DeleteRoomRequest.Builder> deleteRoomRequest) throws NotFoundException,
            ConcurrentModificationException, AwsServiceException, SdkClientException, AlexaForBusinessException {
        return deleteRoom(DeleteRoomRequest.builder().applyMutation(deleteRoomRequest).build());
    }

    /**
     * <p>
     * Deletes room skill parameter details by room, skill, and parameter key ID.
     * </p>
     *
     * @param deleteRoomSkillParameterRequest
     * @return Result of the DeleteRoomSkillParameter operation returned by the service.
     * @throws ConcurrentModificationException
     *         There is a concurrent modification of resources.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AlexaForBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AlexaForBusinessClient.DeleteRoomSkillParameter
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/DeleteRoomSkillParameter"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteRoomSkillParameterResponse deleteRoomSkillParameter(
            DeleteRoomSkillParameterRequest deleteRoomSkillParameterRequest) throws ConcurrentModificationException,
            AwsServiceException, SdkClientException, AlexaForBusinessException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes room skill parameter details by room, skill, and parameter key ID.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteRoomSkillParameterRequest.Builder} avoiding
     * the need to create one manually via {@link DeleteRoomSkillParameterRequest#builder()}
     * </p>
     *
     * @param deleteRoomSkillParameterRequest
     *        A {@link Consumer} that will call methods on {@link DeleteRoomSkillParameterRequest.Builder} to create a
     *        request.
     * @return Result of the DeleteRoomSkillParameter operation returned by the service.
     * @throws ConcurrentModificationException
     *         There is a concurrent modification of resources.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AlexaForBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AlexaForBusinessClient.DeleteRoomSkillParameter
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/DeleteRoomSkillParameter"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteRoomSkillParameterResponse deleteRoomSkillParameter(
            Consumer<DeleteRoomSkillParameterRequest.Builder> deleteRoomSkillParameterRequest)
            throws ConcurrentModificationException, AwsServiceException, SdkClientException, AlexaForBusinessException {
        return deleteRoomSkillParameter(DeleteRoomSkillParameterRequest.builder().applyMutation(deleteRoomSkillParameterRequest)
                .build());
    }

    /**
     * <p>
     * Unlinks a third-party account from a skill.
     * </p>
     *
     * @param deleteSkillAuthorizationRequest
     * @return Result of the DeleteSkillAuthorization operation returned by the service.
     * @throws NotFoundException
     *         The resource is not found.
     * @throws ConcurrentModificationException
     *         There is a concurrent modification of resources.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AlexaForBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AlexaForBusinessClient.DeleteSkillAuthorization
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/DeleteSkillAuthorization"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteSkillAuthorizationResponse deleteSkillAuthorization(
            DeleteSkillAuthorizationRequest deleteSkillAuthorizationRequest) throws NotFoundException,
            ConcurrentModificationException, AwsServiceException, SdkClientException, AlexaForBusinessException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Unlinks a third-party account from a skill.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteSkillAuthorizationRequest.Builder} avoiding
     * the need to create one manually via {@link DeleteSkillAuthorizationRequest#builder()}
     * </p>
     *
     * @param deleteSkillAuthorizationRequest
     *        A {@link Consumer} that will call methods on {@link DeleteSkillAuthorizationRequest.Builder} to create a
     *        request.
     * @return Result of the DeleteSkillAuthorization operation returned by the service.
     * @throws NotFoundException
     *         The resource is not found.
     * @throws ConcurrentModificationException
     *         There is a concurrent modification of resources.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AlexaForBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AlexaForBusinessClient.DeleteSkillAuthorization
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/DeleteSkillAuthorization"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteSkillAuthorizationResponse deleteSkillAuthorization(
            Consumer<DeleteSkillAuthorizationRequest.Builder> deleteSkillAuthorizationRequest) throws NotFoundException,
            ConcurrentModificationException, AwsServiceException, SdkClientException, AlexaForBusinessException {
        return deleteSkillAuthorization(DeleteSkillAuthorizationRequest.builder().applyMutation(deleteSkillAuthorizationRequest)
                .build());
    }

    /**
     * <p>
     * Deletes a skill group by skill group ARN.
     * </p>
     *
     * @param deleteSkillGroupRequest
     * @return Result of the DeleteSkillGroup operation returned by the service.
     * @throws NotFoundException
     *         The resource is not found.
     * @throws ConcurrentModificationException
     *         There is a concurrent modification of resources.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AlexaForBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AlexaForBusinessClient.DeleteSkillGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/DeleteSkillGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteSkillGroupResponse deleteSkillGroup(DeleteSkillGroupRequest deleteSkillGroupRequest) throws NotFoundException,
            ConcurrentModificationException, AwsServiceException, SdkClientException, AlexaForBusinessException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a skill group by skill group ARN.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteSkillGroupRequest.Builder} avoiding the need
     * to create one manually via {@link DeleteSkillGroupRequest#builder()}
     * </p>
     *
     * @param deleteSkillGroupRequest
     *        A {@link Consumer} that will call methods on {@link DeleteSkillGroupRequest.Builder} to create a request.
     * @return Result of the DeleteSkillGroup operation returned by the service.
     * @throws NotFoundException
     *         The resource is not found.
     * @throws ConcurrentModificationException
     *         There is a concurrent modification of resources.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AlexaForBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AlexaForBusinessClient.DeleteSkillGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/DeleteSkillGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteSkillGroupResponse deleteSkillGroup(Consumer<DeleteSkillGroupRequest.Builder> deleteSkillGroupRequest)
            throws NotFoundException, ConcurrentModificationException, AwsServiceException, SdkClientException,
            AlexaForBusinessException {
        return deleteSkillGroup(DeleteSkillGroupRequest.builder().applyMutation(deleteSkillGroupRequest).build());
    }

    /**
     * <p>
     * Deletes a specified user by user ARN and enrollment ARN.
     * </p>
     *
     * @param deleteUserRequest
     * @return Result of the DeleteUser operation returned by the service.
     * @throws NotFoundException
     *         The resource is not found.
     * @throws ConcurrentModificationException
     *         There is a concurrent modification of resources.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AlexaForBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AlexaForBusinessClient.DeleteUser
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/DeleteUser" target="_top">AWS
     *      API Documentation</a>
     */
    default DeleteUserResponse deleteUser(DeleteUserRequest deleteUserRequest) throws NotFoundException,
            ConcurrentModificationException, AwsServiceException, SdkClientException, AlexaForBusinessException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a specified user by user ARN and enrollment ARN.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteUserRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteUserRequest#builder()}
     * </p>
     *
     * @param deleteUserRequest
     *        A {@link Consumer} that will call methods on {@link DeleteUserRequest.Builder} to create a request.
     * @return Result of the DeleteUser operation returned by the service.
     * @throws NotFoundException
     *         The resource is not found.
     * @throws ConcurrentModificationException
     *         There is a concurrent modification of resources.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AlexaForBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AlexaForBusinessClient.DeleteUser
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/DeleteUser" target="_top">AWS
     *      API Documentation</a>
     */
    default DeleteUserResponse deleteUser(Consumer<DeleteUserRequest.Builder> deleteUserRequest) throws NotFoundException,
            ConcurrentModificationException, AwsServiceException, SdkClientException, AlexaForBusinessException {
        return deleteUser(DeleteUserRequest.builder().applyMutation(deleteUserRequest).build());
    }

    /**
     * <p>
     * Disassociates a contact from a given address book.
     * </p>
     *
     * @param disassociateContactFromAddressBookRequest
     * @return Result of the DisassociateContactFromAddressBook operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AlexaForBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AlexaForBusinessClient.DisassociateContactFromAddressBook
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/DisassociateContactFromAddressBook"
     *      target="_top">AWS API Documentation</a>
     */
    default DisassociateContactFromAddressBookResponse disassociateContactFromAddressBook(
            DisassociateContactFromAddressBookRequest disassociateContactFromAddressBookRequest) throws AwsServiceException,
            SdkClientException, AlexaForBusinessException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Disassociates a contact from a given address book.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DisassociateContactFromAddressBookRequest.Builder}
     * avoiding the need to create one manually via {@link DisassociateContactFromAddressBookRequest#builder()}
     * </p>
     *
     * @param disassociateContactFromAddressBookRequest
     *        A {@link Consumer} that will call methods on {@link DisassociateContactFromAddressBookRequest.Builder} to
     *        create a request.
     * @return Result of the DisassociateContactFromAddressBook operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AlexaForBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AlexaForBusinessClient.DisassociateContactFromAddressBook
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/DisassociateContactFromAddressBook"
     *      target="_top">AWS API Documentation</a>
     */
    default DisassociateContactFromAddressBookResponse disassociateContactFromAddressBook(
            Consumer<DisassociateContactFromAddressBookRequest.Builder> disassociateContactFromAddressBookRequest)
            throws AwsServiceException, SdkClientException, AlexaForBusinessException {
        return disassociateContactFromAddressBook(DisassociateContactFromAddressBookRequest.builder()
                .applyMutation(disassociateContactFromAddressBookRequest).build());
    }

    /**
     * <p>
     * Disassociates a device from its current room. The device continues to be connected to the Wi-Fi network and is
     * still registered to the account. The device settings and skills are removed from the room.
     * </p>
     *
     * @param disassociateDeviceFromRoomRequest
     * @return Result of the DisassociateDeviceFromRoom operation returned by the service.
     * @throws ConcurrentModificationException
     *         There is a concurrent modification of resources.
     * @throws DeviceNotRegisteredException
     *         The request failed because this device is no longer registered and therefore no longer managed by this
     *         account.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AlexaForBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AlexaForBusinessClient.DisassociateDeviceFromRoom
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/DisassociateDeviceFromRoom"
     *      target="_top">AWS API Documentation</a>
     */
    default DisassociateDeviceFromRoomResponse disassociateDeviceFromRoom(
            DisassociateDeviceFromRoomRequest disassociateDeviceFromRoomRequest) throws ConcurrentModificationException,
            DeviceNotRegisteredException, AwsServiceException, SdkClientException, AlexaForBusinessException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Disassociates a device from its current room. The device continues to be connected to the Wi-Fi network and is
     * still registered to the account. The device settings and skills are removed from the room.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DisassociateDeviceFromRoomRequest.Builder} avoiding
     * the need to create one manually via {@link DisassociateDeviceFromRoomRequest#builder()}
     * </p>
     *
     * @param disassociateDeviceFromRoomRequest
     *        A {@link Consumer} that will call methods on {@link DisassociateDeviceFromRoomRequest.Builder} to create a
     *        request.
     * @return Result of the DisassociateDeviceFromRoom operation returned by the service.
     * @throws ConcurrentModificationException
     *         There is a concurrent modification of resources.
     * @throws DeviceNotRegisteredException
     *         The request failed because this device is no longer registered and therefore no longer managed by this
     *         account.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AlexaForBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AlexaForBusinessClient.DisassociateDeviceFromRoom
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/DisassociateDeviceFromRoom"
     *      target="_top">AWS API Documentation</a>
     */
    default DisassociateDeviceFromRoomResponse disassociateDeviceFromRoom(
            Consumer<DisassociateDeviceFromRoomRequest.Builder> disassociateDeviceFromRoomRequest)
            throws ConcurrentModificationException, DeviceNotRegisteredException, AwsServiceException, SdkClientException,
            AlexaForBusinessException {
        return disassociateDeviceFromRoom(DisassociateDeviceFromRoomRequest.builder()
                .applyMutation(disassociateDeviceFromRoomRequest).build());
    }

    /**
     * <p>
     * Disassociates a skill from a skill group.
     * </p>
     *
     * @param disassociateSkillFromSkillGroupRequest
     * @return Result of the DisassociateSkillFromSkillGroup operation returned by the service.
     * @throws ConcurrentModificationException
     *         There is a concurrent modification of resources.
     * @throws NotFoundException
     *         The resource is not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AlexaForBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AlexaForBusinessClient.DisassociateSkillFromSkillGroup
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/DisassociateSkillFromSkillGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default DisassociateSkillFromSkillGroupResponse disassociateSkillFromSkillGroup(
            DisassociateSkillFromSkillGroupRequest disassociateSkillFromSkillGroupRequest)
            throws ConcurrentModificationException, NotFoundException, AwsServiceException, SdkClientException,
            AlexaForBusinessException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Disassociates a skill from a skill group.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DisassociateSkillFromSkillGroupRequest.Builder}
     * avoiding the need to create one manually via {@link DisassociateSkillFromSkillGroupRequest#builder()}
     * </p>
     *
     * @param disassociateSkillFromSkillGroupRequest
     *        A {@link Consumer} that will call methods on {@link DisassociateSkillFromSkillGroupRequest.Builder} to
     *        create a request.
     * @return Result of the DisassociateSkillFromSkillGroup operation returned by the service.
     * @throws ConcurrentModificationException
     *         There is a concurrent modification of resources.
     * @throws NotFoundException
     *         The resource is not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AlexaForBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AlexaForBusinessClient.DisassociateSkillFromSkillGroup
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/DisassociateSkillFromSkillGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default DisassociateSkillFromSkillGroupResponse disassociateSkillFromSkillGroup(
            Consumer<DisassociateSkillFromSkillGroupRequest.Builder> disassociateSkillFromSkillGroupRequest)
            throws ConcurrentModificationException, NotFoundException, AwsServiceException, SdkClientException,
            AlexaForBusinessException {
        return disassociateSkillFromSkillGroup(DisassociateSkillFromSkillGroupRequest.builder()
                .applyMutation(disassociateSkillFromSkillGroupRequest).build());
    }

    /**
     * <p>
     * Makes a private skill unavailable for enrolled users and prevents them from enabling it on their devices.
     * </p>
     *
     * @param disassociateSkillFromUsersRequest
     * @return Result of the DisassociateSkillFromUsers operation returned by the service.
     * @throws ConcurrentModificationException
     *         There is a concurrent modification of resources.
     * @throws NotFoundException
     *         The resource is not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AlexaForBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AlexaForBusinessClient.DisassociateSkillFromUsers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/DisassociateSkillFromUsers"
     *      target="_top">AWS API Documentation</a>
     */
    default DisassociateSkillFromUsersResponse disassociateSkillFromUsers(
            DisassociateSkillFromUsersRequest disassociateSkillFromUsersRequest) throws ConcurrentModificationException,
            NotFoundException, AwsServiceException, SdkClientException, AlexaForBusinessException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Makes a private skill unavailable for enrolled users and prevents them from enabling it on their devices.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DisassociateSkillFromUsersRequest.Builder} avoiding
     * the need to create one manually via {@link DisassociateSkillFromUsersRequest#builder()}
     * </p>
     *
     * @param disassociateSkillFromUsersRequest
     *        A {@link Consumer} that will call methods on {@link DisassociateSkillFromUsersRequest.Builder} to create a
     *        request.
     * @return Result of the DisassociateSkillFromUsers operation returned by the service.
     * @throws ConcurrentModificationException
     *         There is a concurrent modification of resources.
     * @throws NotFoundException
     *         The resource is not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AlexaForBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AlexaForBusinessClient.DisassociateSkillFromUsers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/DisassociateSkillFromUsers"
     *      target="_top">AWS API Documentation</a>
     */
    default DisassociateSkillFromUsersResponse disassociateSkillFromUsers(
            Consumer<DisassociateSkillFromUsersRequest.Builder> disassociateSkillFromUsersRequest)
            throws ConcurrentModificationException, NotFoundException, AwsServiceException, SdkClientException,
            AlexaForBusinessException {
        return disassociateSkillFromUsers(DisassociateSkillFromUsersRequest.builder()
                .applyMutation(disassociateSkillFromUsersRequest).build());
    }

    /**
     * <p>
     * Disassociates a skill group from a specified room. This disables all skills in the skill group on all devices in
     * the room.
     * </p>
     *
     * @param disassociateSkillGroupFromRoomRequest
     * @return Result of the DisassociateSkillGroupFromRoom operation returned by the service.
     * @throws ConcurrentModificationException
     *         There is a concurrent modification of resources.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AlexaForBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AlexaForBusinessClient.DisassociateSkillGroupFromRoom
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/DisassociateSkillGroupFromRoom"
     *      target="_top">AWS API Documentation</a>
     */
    default DisassociateSkillGroupFromRoomResponse disassociateSkillGroupFromRoom(
            DisassociateSkillGroupFromRoomRequest disassociateSkillGroupFromRoomRequest) throws ConcurrentModificationException,
            AwsServiceException, SdkClientException, AlexaForBusinessException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Disassociates a skill group from a specified room. This disables all skills in the skill group on all devices in
     * the room.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DisassociateSkillGroupFromRoomRequest.Builder}
     * avoiding the need to create one manually via {@link DisassociateSkillGroupFromRoomRequest#builder()}
     * </p>
     *
     * @param disassociateSkillGroupFromRoomRequest
     *        A {@link Consumer} that will call methods on {@link DisassociateSkillGroupFromRoomRequest.Builder} to
     *        create a request.
     * @return Result of the DisassociateSkillGroupFromRoom operation returned by the service.
     * @throws ConcurrentModificationException
     *         There is a concurrent modification of resources.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AlexaForBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AlexaForBusinessClient.DisassociateSkillGroupFromRoom
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/DisassociateSkillGroupFromRoom"
     *      target="_top">AWS API Documentation</a>
     */
    default DisassociateSkillGroupFromRoomResponse disassociateSkillGroupFromRoom(
            Consumer<DisassociateSkillGroupFromRoomRequest.Builder> disassociateSkillGroupFromRoomRequest)
            throws ConcurrentModificationException, AwsServiceException, SdkClientException, AlexaForBusinessException {
        return disassociateSkillGroupFromRoom(DisassociateSkillGroupFromRoomRequest.builder()
                .applyMutation(disassociateSkillGroupFromRoomRequest).build());
    }

    /**
     * <p>
     * Forgets smart home appliances associated to a room.
     * </p>
     *
     * @param forgetSmartHomeAppliancesRequest
     * @return Result of the ForgetSmartHomeAppliances operation returned by the service.
     * @throws NotFoundException
     *         The resource is not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AlexaForBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AlexaForBusinessClient.ForgetSmartHomeAppliances
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/ForgetSmartHomeAppliances"
     *      target="_top">AWS API Documentation</a>
     */
    default ForgetSmartHomeAppliancesResponse forgetSmartHomeAppliances(
            ForgetSmartHomeAppliancesRequest forgetSmartHomeAppliancesRequest) throws NotFoundException, AwsServiceException,
            SdkClientException, AlexaForBusinessException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Forgets smart home appliances associated to a room.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ForgetSmartHomeAppliancesRequest.Builder} avoiding
     * the need to create one manually via {@link ForgetSmartHomeAppliancesRequest#builder()}
     * </p>
     *
     * @param forgetSmartHomeAppliancesRequest
     *        A {@link Consumer} that will call methods on {@link ForgetSmartHomeAppliancesRequest.Builder} to create a
     *        request.
     * @return Result of the ForgetSmartHomeAppliances operation returned by the service.
     * @throws NotFoundException
     *         The resource is not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AlexaForBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AlexaForBusinessClient.ForgetSmartHomeAppliances
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/ForgetSmartHomeAppliances"
     *      target="_top">AWS API Documentation</a>
     */
    default ForgetSmartHomeAppliancesResponse forgetSmartHomeAppliances(
            Consumer<ForgetSmartHomeAppliancesRequest.Builder> forgetSmartHomeAppliancesRequest) throws NotFoundException,
            AwsServiceException, SdkClientException, AlexaForBusinessException {
        return forgetSmartHomeAppliances(ForgetSmartHomeAppliancesRequest.builder()
                .applyMutation(forgetSmartHomeAppliancesRequest).build());
    }

    /**
     * <p>
     * Gets address the book details by the address book ARN.
     * </p>
     *
     * @param getAddressBookRequest
     * @return Result of the GetAddressBook operation returned by the service.
     * @throws NotFoundException
     *         The resource is not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AlexaForBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AlexaForBusinessClient.GetAddressBook
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/GetAddressBook"
     *      target="_top">AWS API Documentation</a>
     */
    default GetAddressBookResponse getAddressBook(GetAddressBookRequest getAddressBookRequest) throws NotFoundException,
            AwsServiceException, SdkClientException, AlexaForBusinessException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets address the book details by the address book ARN.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetAddressBookRequest.Builder} avoiding the need to
     * create one manually via {@link GetAddressBookRequest#builder()}
     * </p>
     *
     * @param getAddressBookRequest
     *        A {@link Consumer} that will call methods on {@link GetAddressBookRequest.Builder} to create a request.
     * @return Result of the GetAddressBook operation returned by the service.
     * @throws NotFoundException
     *         The resource is not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AlexaForBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AlexaForBusinessClient.GetAddressBook
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/GetAddressBook"
     *      target="_top">AWS API Documentation</a>
     */
    default GetAddressBookResponse getAddressBook(Consumer<GetAddressBookRequest.Builder> getAddressBookRequest)
            throws NotFoundException, AwsServiceException, SdkClientException, AlexaForBusinessException {
        return getAddressBook(GetAddressBookRequest.builder().applyMutation(getAddressBookRequest).build());
    }

    /**
     * <p>
     * Retrieves the existing conference preferences.
     * </p>
     *
     * @param getConferencePreferenceRequest
     * @return Result of the GetConferencePreference operation returned by the service.
     * @throws NotFoundException
     *         The resource is not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AlexaForBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AlexaForBusinessClient.GetConferencePreference
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/GetConferencePreference"
     *      target="_top">AWS API Documentation</a>
     */
    default GetConferencePreferenceResponse getConferencePreference(GetConferencePreferenceRequest getConferencePreferenceRequest)
            throws NotFoundException, AwsServiceException, SdkClientException, AlexaForBusinessException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves the existing conference preferences.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetConferencePreferenceRequest.Builder} avoiding
     * the need to create one manually via {@link GetConferencePreferenceRequest#builder()}
     * </p>
     *
     * @param getConferencePreferenceRequest
     *        A {@link Consumer} that will call methods on {@link GetConferencePreferenceRequest.Builder} to create a
     *        request.
     * @return Result of the GetConferencePreference operation returned by the service.
     * @throws NotFoundException
     *         The resource is not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AlexaForBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AlexaForBusinessClient.GetConferencePreference
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/GetConferencePreference"
     *      target="_top">AWS API Documentation</a>
     */
    default GetConferencePreferenceResponse getConferencePreference(
            Consumer<GetConferencePreferenceRequest.Builder> getConferencePreferenceRequest) throws NotFoundException,
            AwsServiceException, SdkClientException, AlexaForBusinessException {
        return getConferencePreference(GetConferencePreferenceRequest.builder().applyMutation(getConferencePreferenceRequest)
                .build());
    }

    /**
     * <p>
     * Gets details about a specific conference provider.
     * </p>
     *
     * @param getConferenceProviderRequest
     * @return Result of the GetConferenceProvider operation returned by the service.
     * @throws NotFoundException
     *         The resource is not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AlexaForBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AlexaForBusinessClient.GetConferenceProvider
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/GetConferenceProvider"
     *      target="_top">AWS API Documentation</a>
     */
    default GetConferenceProviderResponse getConferenceProvider(GetConferenceProviderRequest getConferenceProviderRequest)
            throws NotFoundException, AwsServiceException, SdkClientException, AlexaForBusinessException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets details about a specific conference provider.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetConferenceProviderRequest.Builder} avoiding the
     * need to create one manually via {@link GetConferenceProviderRequest#builder()}
     * </p>
     *
     * @param getConferenceProviderRequest
     *        A {@link Consumer} that will call methods on {@link GetConferenceProviderRequest.Builder} to create a
     *        request.
     * @return Result of the GetConferenceProvider operation returned by the service.
     * @throws NotFoundException
     *         The resource is not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AlexaForBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AlexaForBusinessClient.GetConferenceProvider
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/GetConferenceProvider"
     *      target="_top">AWS API Documentation</a>
     */
    default GetConferenceProviderResponse getConferenceProvider(
            Consumer<GetConferenceProviderRequest.Builder> getConferenceProviderRequest) throws NotFoundException,
            AwsServiceException, SdkClientException, AlexaForBusinessException {
        return getConferenceProvider(GetConferenceProviderRequest.builder().applyMutation(getConferenceProviderRequest).build());
    }

    /**
     * <p>
     * Gets the contact details by the contact ARN.
     * </p>
     *
     * @param getContactRequest
     * @return Result of the GetContact operation returned by the service.
     * @throws NotFoundException
     *         The resource is not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AlexaForBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AlexaForBusinessClient.GetContact
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/GetContact" target="_top">AWS
     *      API Documentation</a>
     */
    default GetContactResponse getContact(GetContactRequest getContactRequest) throws NotFoundException, AwsServiceException,
            SdkClientException, AlexaForBusinessException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets the contact details by the contact ARN.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetContactRequest.Builder} avoiding the need to
     * create one manually via {@link GetContactRequest#builder()}
     * </p>
     *
     * @param getContactRequest
     *        A {@link Consumer} that will call methods on {@link GetContactRequest.Builder} to create a request.
     * @return Result of the GetContact operation returned by the service.
     * @throws NotFoundException
     *         The resource is not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AlexaForBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AlexaForBusinessClient.GetContact
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/GetContact" target="_top">AWS
     *      API Documentation</a>
     */
    default GetContactResponse getContact(Consumer<GetContactRequest.Builder> getContactRequest) throws NotFoundException,
            AwsServiceException, SdkClientException, AlexaForBusinessException {
        return getContact(GetContactRequest.builder().applyMutation(getContactRequest).build());
    }

    /**
     * <p>
     * Gets the details of a device by device ARN.
     * </p>
     *
     * @param getDeviceRequest
     * @return Result of the GetDevice operation returned by the service.
     * @throws NotFoundException
     *         The resource is not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AlexaForBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AlexaForBusinessClient.GetDevice
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/GetDevice" target="_top">AWS
     *      API Documentation</a>
     */
    default GetDeviceResponse getDevice(GetDeviceRequest getDeviceRequest) throws NotFoundException, AwsServiceException,
            SdkClientException, AlexaForBusinessException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets the details of a device by device ARN.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetDeviceRequest.Builder} avoiding the need to
     * create one manually via {@link GetDeviceRequest#builder()}
     * </p>
     *
     * @param getDeviceRequest
     *        A {@link Consumer} that will call methods on {@link GetDeviceRequest.Builder} to create a request.
     * @return Result of the GetDevice operation returned by the service.
     * @throws NotFoundException
     *         The resource is not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AlexaForBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AlexaForBusinessClient.GetDevice
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/GetDevice" target="_top">AWS
     *      API Documentation</a>
     */
    default GetDeviceResponse getDevice(Consumer<GetDeviceRequest.Builder> getDeviceRequest) throws NotFoundException,
            AwsServiceException, SdkClientException, AlexaForBusinessException {
        return getDevice(GetDeviceRequest.builder().applyMutation(getDeviceRequest).build());
    }

    /**
     * <p>
     * Retrieves the details of a gateway.
     * </p>
     *
     * @param getGatewayRequest
     * @return Result of the GetGateway operation returned by the service.
     * @throws NotFoundException
     *         The resource is not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AlexaForBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AlexaForBusinessClient.GetGateway
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/GetGateway" target="_top">AWS
     *      API Documentation</a>
     */
    default GetGatewayResponse getGateway(GetGatewayRequest getGatewayRequest) throws NotFoundException, AwsServiceException,
            SdkClientException, AlexaForBusinessException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves the details of a gateway.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetGatewayRequest.Builder} avoiding the need to
     * create one manually via {@link GetGatewayRequest#builder()}
     * </p>
     *
     * @param getGatewayRequest
     *        A {@link Consumer} that will call methods on {@link GetGatewayRequest.Builder} to create a request.
     * @return Result of the GetGateway operation returned by the service.
     * @throws NotFoundException
     *         The resource is not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AlexaForBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AlexaForBusinessClient.GetGateway
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/GetGateway" target="_top">AWS
     *      API Documentation</a>
     */
    default GetGatewayResponse getGateway(Consumer<GetGatewayRequest.Builder> getGatewayRequest) throws NotFoundException,
            AwsServiceException, SdkClientException, AlexaForBusinessException {
        return getGateway(GetGatewayRequest.builder().applyMutation(getGatewayRequest).build());
    }

    /**
     * <p>
     * Retrieves the details of a gateway group.
     * </p>
     *
     * @param getGatewayGroupRequest
     * @return Result of the GetGatewayGroup operation returned by the service.
     * @throws NotFoundException
     *         The resource is not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AlexaForBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AlexaForBusinessClient.GetGatewayGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/GetGatewayGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default GetGatewayGroupResponse getGatewayGroup(GetGatewayGroupRequest getGatewayGroupRequest) throws NotFoundException,
            AwsServiceException, SdkClientException, AlexaForBusinessException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves the details of a gateway group.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetGatewayGroupRequest.Builder} avoiding the need
     * to create one manually via {@link GetGatewayGroupRequest#builder()}
     * </p>
     *
     * @param getGatewayGroupRequest
     *        A {@link Consumer} that will call methods on {@link GetGatewayGroupRequest.Builder} to create a request.
     * @return Result of the GetGatewayGroup operation returned by the service.
     * @throws NotFoundException
     *         The resource is not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AlexaForBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AlexaForBusinessClient.GetGatewayGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/GetGatewayGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default GetGatewayGroupResponse getGatewayGroup(Consumer<GetGatewayGroupRequest.Builder> getGatewayGroupRequest)
            throws NotFoundException, AwsServiceException, SdkClientException, AlexaForBusinessException {
        return getGatewayGroup(GetGatewayGroupRequest.builder().applyMutation(getGatewayGroupRequest).build());
    }

    /**
     * <p>
     * Retrieves the configured values for the user enrollment invitation email template.
     * </p>
     *
     * @param getInvitationConfigurationRequest
     * @return Result of the GetInvitationConfiguration operation returned by the service.
     * @throws NotFoundException
     *         The resource is not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AlexaForBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AlexaForBusinessClient.GetInvitationConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/GetInvitationConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default GetInvitationConfigurationResponse getInvitationConfiguration(
            GetInvitationConfigurationRequest getInvitationConfigurationRequest) throws NotFoundException, AwsServiceException,
            SdkClientException, AlexaForBusinessException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves the configured values for the user enrollment invitation email template.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetInvitationConfigurationRequest.Builder} avoiding
     * the need to create one manually via {@link GetInvitationConfigurationRequest#builder()}
     * </p>
     *
     * @param getInvitationConfigurationRequest
     *        A {@link Consumer} that will call methods on {@link GetInvitationConfigurationRequest.Builder} to create a
     *        request.
     * @return Result of the GetInvitationConfiguration operation returned by the service.
     * @throws NotFoundException
     *         The resource is not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AlexaForBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AlexaForBusinessClient.GetInvitationConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/GetInvitationConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default GetInvitationConfigurationResponse getInvitationConfiguration(
            Consumer<GetInvitationConfigurationRequest.Builder> getInvitationConfigurationRequest) throws NotFoundException,
            AwsServiceException, SdkClientException, AlexaForBusinessException {
        return getInvitationConfiguration(GetInvitationConfigurationRequest.builder()
                .applyMutation(getInvitationConfigurationRequest).build());
    }

    /**
     * <p>
     * Gets the network profile details by the network profile ARN.
     * </p>
     *
     * @param getNetworkProfileRequest
     * @return Result of the GetNetworkProfile operation returned by the service.
     * @throws NotFoundException
     *         The resource is not found.
     * @throws InvalidSecretsManagerResourceException
     *         A password in SecretsManager is in an invalid state.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AlexaForBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AlexaForBusinessClient.GetNetworkProfile
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/GetNetworkProfile"
     *      target="_top">AWS API Documentation</a>
     */
    default GetNetworkProfileResponse getNetworkProfile(GetNetworkProfileRequest getNetworkProfileRequest)
            throws NotFoundException, InvalidSecretsManagerResourceException, AwsServiceException, SdkClientException,
            AlexaForBusinessException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets the network profile details by the network profile ARN.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetNetworkProfileRequest.Builder} avoiding the need
     * to create one manually via {@link GetNetworkProfileRequest#builder()}
     * </p>
     *
     * @param getNetworkProfileRequest
     *        A {@link Consumer} that will call methods on {@link GetNetworkProfileRequest.Builder} to create a request.
     * @return Result of the GetNetworkProfile operation returned by the service.
     * @throws NotFoundException
     *         The resource is not found.
     * @throws InvalidSecretsManagerResourceException
     *         A password in SecretsManager is in an invalid state.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AlexaForBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AlexaForBusinessClient.GetNetworkProfile
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/GetNetworkProfile"
     *      target="_top">AWS API Documentation</a>
     */
    default GetNetworkProfileResponse getNetworkProfile(Consumer<GetNetworkProfileRequest.Builder> getNetworkProfileRequest)
            throws NotFoundException, InvalidSecretsManagerResourceException, AwsServiceException, SdkClientException,
            AlexaForBusinessException {
        return getNetworkProfile(GetNetworkProfileRequest.builder().applyMutation(getNetworkProfileRequest).build());
    }

    /**
     * <p>
     * Gets the details of a room profile by profile ARN.
     * </p>
     *
     * @param getProfileRequest
     * @return Result of the GetProfile operation returned by the service.
     * @throws NotFoundException
     *         The resource is not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AlexaForBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AlexaForBusinessClient.GetProfile
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/GetProfile" target="_top">AWS
     *      API Documentation</a>
     */
    default GetProfileResponse getProfile(GetProfileRequest getProfileRequest) throws NotFoundException, AwsServiceException,
            SdkClientException, AlexaForBusinessException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets the details of a room profile by profile ARN.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetProfileRequest.Builder} avoiding the need to
     * create one manually via {@link GetProfileRequest#builder()}
     * </p>
     *
     * @param getProfileRequest
     *        A {@link Consumer} that will call methods on {@link GetProfileRequest.Builder} to create a request.
     * @return Result of the GetProfile operation returned by the service.
     * @throws NotFoundException
     *         The resource is not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AlexaForBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AlexaForBusinessClient.GetProfile
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/GetProfile" target="_top">AWS
     *      API Documentation</a>
     */
    default GetProfileResponse getProfile(Consumer<GetProfileRequest.Builder> getProfileRequest) throws NotFoundException,
            AwsServiceException, SdkClientException, AlexaForBusinessException {
        return getProfile(GetProfileRequest.builder().applyMutation(getProfileRequest).build());
    }

    /**
     * <p>
     * Gets room details by room ARN.
     * </p>
     *
     * @param getRoomRequest
     * @return Result of the GetRoom operation returned by the service.
     * @throws NotFoundException
     *         The resource is not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AlexaForBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AlexaForBusinessClient.GetRoom
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/GetRoom" target="_top">AWS API
     *      Documentation</a>
     */
    default GetRoomResponse getRoom(GetRoomRequest getRoomRequest) throws NotFoundException, AwsServiceException,
            SdkClientException, AlexaForBusinessException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets room details by room ARN.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetRoomRequest.Builder} avoiding the need to create
     * one manually via {@link GetRoomRequest#builder()}
     * </p>
     *
     * @param getRoomRequest
     *        A {@link Consumer} that will call methods on {@link GetRoomRequest.Builder} to create a request.
     * @return Result of the GetRoom operation returned by the service.
     * @throws NotFoundException
     *         The resource is not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AlexaForBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AlexaForBusinessClient.GetRoom
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/GetRoom" target="_top">AWS API
     *      Documentation</a>
     */
    default GetRoomResponse getRoom(Consumer<GetRoomRequest.Builder> getRoomRequest) throws NotFoundException,
            AwsServiceException, SdkClientException, AlexaForBusinessException {
        return getRoom(GetRoomRequest.builder().applyMutation(getRoomRequest).build());
    }

    /**
     * <p>
     * Gets room skill parameter details by room, skill, and parameter key ARN.
     * </p>
     *
     * @param getRoomSkillParameterRequest
     * @return Result of the GetRoomSkillParameter operation returned by the service.
     * @throws NotFoundException
     *         The resource is not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AlexaForBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AlexaForBusinessClient.GetRoomSkillParameter
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/GetRoomSkillParameter"
     *      target="_top">AWS API Documentation</a>
     */
    default GetRoomSkillParameterResponse getRoomSkillParameter(GetRoomSkillParameterRequest getRoomSkillParameterRequest)
            throws NotFoundException, AwsServiceException, SdkClientException, AlexaForBusinessException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets room skill parameter details by room, skill, and parameter key ARN.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetRoomSkillParameterRequest.Builder} avoiding the
     * need to create one manually via {@link GetRoomSkillParameterRequest#builder()}
     * </p>
     *
     * @param getRoomSkillParameterRequest
     *        A {@link Consumer} that will call methods on {@link GetRoomSkillParameterRequest.Builder} to create a
     *        request.
     * @return Result of the GetRoomSkillParameter operation returned by the service.
     * @throws NotFoundException
     *         The resource is not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AlexaForBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AlexaForBusinessClient.GetRoomSkillParameter
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/GetRoomSkillParameter"
     *      target="_top">AWS API Documentation</a>
     */
    default GetRoomSkillParameterResponse getRoomSkillParameter(
            Consumer<GetRoomSkillParameterRequest.Builder> getRoomSkillParameterRequest) throws NotFoundException,
            AwsServiceException, SdkClientException, AlexaForBusinessException {
        return getRoomSkillParameter(GetRoomSkillParameterRequest.builder().applyMutation(getRoomSkillParameterRequest).build());
    }

    /**
     * <p>
     * Gets skill group details by skill group ARN.
     * </p>
     *
     * @param getSkillGroupRequest
     * @return Result of the GetSkillGroup operation returned by the service.
     * @throws NotFoundException
     *         The resource is not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AlexaForBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AlexaForBusinessClient.GetSkillGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/GetSkillGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default GetSkillGroupResponse getSkillGroup(GetSkillGroupRequest getSkillGroupRequest) throws NotFoundException,
            AwsServiceException, SdkClientException, AlexaForBusinessException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets skill group details by skill group ARN.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetSkillGroupRequest.Builder} avoiding the need to
     * create one manually via {@link GetSkillGroupRequest#builder()}
     * </p>
     *
     * @param getSkillGroupRequest
     *        A {@link Consumer} that will call methods on {@link GetSkillGroupRequest.Builder} to create a request.
     * @return Result of the GetSkillGroup operation returned by the service.
     * @throws NotFoundException
     *         The resource is not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AlexaForBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AlexaForBusinessClient.GetSkillGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/GetSkillGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default GetSkillGroupResponse getSkillGroup(Consumer<GetSkillGroupRequest.Builder> getSkillGroupRequest)
            throws NotFoundException, AwsServiceException, SdkClientException, AlexaForBusinessException {
        return getSkillGroup(GetSkillGroupRequest.builder().applyMutation(getSkillGroupRequest).build());
    }

    /**
     * <p>
     * Lists the details of the schedules that a user configured. A download URL of the report associated with each
     * schedule is returned every time this action is called. A new download URL is returned each time, and is valid for
     * 24 hours.
     * </p>
     *
     * @param listBusinessReportSchedulesRequest
     * @return Result of the ListBusinessReportSchedules operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AlexaForBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AlexaForBusinessClient.ListBusinessReportSchedules
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/ListBusinessReportSchedules"
     *      target="_top">AWS API Documentation</a>
     */
    default ListBusinessReportSchedulesResponse listBusinessReportSchedules(
            ListBusinessReportSchedulesRequest listBusinessReportSchedulesRequest) throws AwsServiceException,
            SdkClientException, AlexaForBusinessException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the details of the schedules that a user configured. A download URL of the report associated with each
     * schedule is returned every time this action is called. A new download URL is returned each time, and is valid for
     * 24 hours.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListBusinessReportSchedulesRequest.Builder}
     * avoiding the need to create one manually via {@link ListBusinessReportSchedulesRequest#builder()}
     * </p>
     *
     * @param listBusinessReportSchedulesRequest
     *        A {@link Consumer} that will call methods on {@link ListBusinessReportSchedulesRequest.Builder} to create
     *        a request.
     * @return Result of the ListBusinessReportSchedules operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AlexaForBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AlexaForBusinessClient.ListBusinessReportSchedules
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/ListBusinessReportSchedules"
     *      target="_top">AWS API Documentation</a>
     */
    default ListBusinessReportSchedulesResponse listBusinessReportSchedules(
            Consumer<ListBusinessReportSchedulesRequest.Builder> listBusinessReportSchedulesRequest) throws AwsServiceException,
            SdkClientException, AlexaForBusinessException {
        return listBusinessReportSchedules(ListBusinessReportSchedulesRequest.builder()
                .applyMutation(listBusinessReportSchedulesRequest).build());
    }

    /**
     * <p>
     * Lists the details of the schedules that a user configured. A download URL of the report associated with each
     * schedule is returned every time this action is called. A new download URL is returned each time, and is valid for
     * 24 hours.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listBusinessReportSchedules(software.amazon.awssdk.services.alexaforbusiness.model.ListBusinessReportSchedulesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.alexaforbusiness.paginators.ListBusinessReportSchedulesIterable responses = client.listBusinessReportSchedulesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.alexaforbusiness.paginators.ListBusinessReportSchedulesIterable responses = client
     *             .listBusinessReportSchedulesPaginator(request);
     *     for (software.amazon.awssdk.services.alexaforbusiness.model.ListBusinessReportSchedulesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.alexaforbusiness.paginators.ListBusinessReportSchedulesIterable responses = client.listBusinessReportSchedulesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listBusinessReportSchedules(software.amazon.awssdk.services.alexaforbusiness.model.ListBusinessReportSchedulesRequest)}
     * operation.</b>
     * </p>
     *
     * @param listBusinessReportSchedulesRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AlexaForBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AlexaForBusinessClient.ListBusinessReportSchedules
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/ListBusinessReportSchedules"
     *      target="_top">AWS API Documentation</a>
     */
    default ListBusinessReportSchedulesIterable listBusinessReportSchedulesPaginator(
            ListBusinessReportSchedulesRequest listBusinessReportSchedulesRequest) throws AwsServiceException,
            SdkClientException, AlexaForBusinessException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the details of the schedules that a user configured. A download URL of the report associated with each
     * schedule is returned every time this action is called. A new download URL is returned each time, and is valid for
     * 24 hours.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listBusinessReportSchedules(software.amazon.awssdk.services.alexaforbusiness.model.ListBusinessReportSchedulesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.alexaforbusiness.paginators.ListBusinessReportSchedulesIterable responses = client.listBusinessReportSchedulesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.alexaforbusiness.paginators.ListBusinessReportSchedulesIterable responses = client
     *             .listBusinessReportSchedulesPaginator(request);
     *     for (software.amazon.awssdk.services.alexaforbusiness.model.ListBusinessReportSchedulesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.alexaforbusiness.paginators.ListBusinessReportSchedulesIterable responses = client.listBusinessReportSchedulesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listBusinessReportSchedules(software.amazon.awssdk.services.alexaforbusiness.model.ListBusinessReportSchedulesRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListBusinessReportSchedulesRequest.Builder}
     * avoiding the need to create one manually via {@link ListBusinessReportSchedulesRequest#builder()}
     * </p>
     *
     * @param listBusinessReportSchedulesRequest
     *        A {@link Consumer} that will call methods on {@link ListBusinessReportSchedulesRequest.Builder} to create
     *        a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AlexaForBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AlexaForBusinessClient.ListBusinessReportSchedules
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/ListBusinessReportSchedules"
     *      target="_top">AWS API Documentation</a>
     */
    default ListBusinessReportSchedulesIterable listBusinessReportSchedulesPaginator(
            Consumer<ListBusinessReportSchedulesRequest.Builder> listBusinessReportSchedulesRequest) throws AwsServiceException,
            SdkClientException, AlexaForBusinessException {
        return listBusinessReportSchedulesPaginator(ListBusinessReportSchedulesRequest.builder()
                .applyMutation(listBusinessReportSchedulesRequest).build());
    }

    /**
     * <p>
     * Lists conference providers under a specific AWS account.
     * </p>
     *
     * @param listConferenceProvidersRequest
     * @return Result of the ListConferenceProviders operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AlexaForBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AlexaForBusinessClient.ListConferenceProviders
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/ListConferenceProviders"
     *      target="_top">AWS API Documentation</a>
     */
    default ListConferenceProvidersResponse listConferenceProviders(ListConferenceProvidersRequest listConferenceProvidersRequest)
            throws AwsServiceException, SdkClientException, AlexaForBusinessException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists conference providers under a specific AWS account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListConferenceProvidersRequest.Builder} avoiding
     * the need to create one manually via {@link ListConferenceProvidersRequest#builder()}
     * </p>
     *
     * @param listConferenceProvidersRequest
     *        A {@link Consumer} that will call methods on {@link ListConferenceProvidersRequest.Builder} to create a
     *        request.
     * @return Result of the ListConferenceProviders operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AlexaForBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AlexaForBusinessClient.ListConferenceProviders
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/ListConferenceProviders"
     *      target="_top">AWS API Documentation</a>
     */
    default ListConferenceProvidersResponse listConferenceProviders(
            Consumer<ListConferenceProvidersRequest.Builder> listConferenceProvidersRequest) throws AwsServiceException,
            SdkClientException, AlexaForBusinessException {
        return listConferenceProviders(ListConferenceProvidersRequest.builder().applyMutation(listConferenceProvidersRequest)
                .build());
    }

    /**
     * <p>
     * Lists conference providers under a specific AWS account.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listConferenceProviders(software.amazon.awssdk.services.alexaforbusiness.model.ListConferenceProvidersRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.alexaforbusiness.paginators.ListConferenceProvidersIterable responses = client.listConferenceProvidersPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.alexaforbusiness.paginators.ListConferenceProvidersIterable responses = client
     *             .listConferenceProvidersPaginator(request);
     *     for (software.amazon.awssdk.services.alexaforbusiness.model.ListConferenceProvidersResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.alexaforbusiness.paginators.ListConferenceProvidersIterable responses = client.listConferenceProvidersPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listConferenceProviders(software.amazon.awssdk.services.alexaforbusiness.model.ListConferenceProvidersRequest)}
     * operation.</b>
     * </p>
     *
     * @param listConferenceProvidersRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AlexaForBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AlexaForBusinessClient.ListConferenceProviders
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/ListConferenceProviders"
     *      target="_top">AWS API Documentation</a>
     */
    default ListConferenceProvidersIterable listConferenceProvidersPaginator(
            ListConferenceProvidersRequest listConferenceProvidersRequest) throws AwsServiceException, SdkClientException,
            AlexaForBusinessException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists conference providers under a specific AWS account.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listConferenceProviders(software.amazon.awssdk.services.alexaforbusiness.model.ListConferenceProvidersRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.alexaforbusiness.paginators.ListConferenceProvidersIterable responses = client.listConferenceProvidersPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.alexaforbusiness.paginators.ListConferenceProvidersIterable responses = client
     *             .listConferenceProvidersPaginator(request);
     *     for (software.amazon.awssdk.services.alexaforbusiness.model.ListConferenceProvidersResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.alexaforbusiness.paginators.ListConferenceProvidersIterable responses = client.listConferenceProvidersPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listConferenceProviders(software.amazon.awssdk.services.alexaforbusiness.model.ListConferenceProvidersRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListConferenceProvidersRequest.Builder} avoiding
     * the need to create one manually via {@link ListConferenceProvidersRequest#builder()}
     * </p>
     *
     * @param listConferenceProvidersRequest
     *        A {@link Consumer} that will call methods on {@link ListConferenceProvidersRequest.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AlexaForBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AlexaForBusinessClient.ListConferenceProviders
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/ListConferenceProviders"
     *      target="_top">AWS API Documentation</a>
     */
    default ListConferenceProvidersIterable listConferenceProvidersPaginator(
            Consumer<ListConferenceProvidersRequest.Builder> listConferenceProvidersRequest) throws AwsServiceException,
            SdkClientException, AlexaForBusinessException {
        return listConferenceProvidersPaginator(ListConferenceProvidersRequest.builder()
                .applyMutation(listConferenceProvidersRequest).build());
    }

    /**
     * <p>
     * Lists the device event history, including device connection status, for up to 30 days.
     * </p>
     *
     * @param listDeviceEventsRequest
     * @return Result of the ListDeviceEvents operation returned by the service.
     * @throws NotFoundException
     *         The resource is not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AlexaForBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AlexaForBusinessClient.ListDeviceEvents
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/ListDeviceEvents"
     *      target="_top">AWS API Documentation</a>
     */
    default ListDeviceEventsResponse listDeviceEvents(ListDeviceEventsRequest listDeviceEventsRequest) throws NotFoundException,
            AwsServiceException, SdkClientException, AlexaForBusinessException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the device event history, including device connection status, for up to 30 days.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListDeviceEventsRequest.Builder} avoiding the need
     * to create one manually via {@link ListDeviceEventsRequest#builder()}
     * </p>
     *
     * @param listDeviceEventsRequest
     *        A {@link Consumer} that will call methods on {@link ListDeviceEventsRequest.Builder} to create a request.
     * @return Result of the ListDeviceEvents operation returned by the service.
     * @throws NotFoundException
     *         The resource is not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AlexaForBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AlexaForBusinessClient.ListDeviceEvents
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/ListDeviceEvents"
     *      target="_top">AWS API Documentation</a>
     */
    default ListDeviceEventsResponse listDeviceEvents(Consumer<ListDeviceEventsRequest.Builder> listDeviceEventsRequest)
            throws NotFoundException, AwsServiceException, SdkClientException, AlexaForBusinessException {
        return listDeviceEvents(ListDeviceEventsRequest.builder().applyMutation(listDeviceEventsRequest).build());
    }

    /**
     * <p>
     * Lists the device event history, including device connection status, for up to 30 days.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listDeviceEvents(software.amazon.awssdk.services.alexaforbusiness.model.ListDeviceEventsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.alexaforbusiness.paginators.ListDeviceEventsIterable responses = client.listDeviceEventsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.alexaforbusiness.paginators.ListDeviceEventsIterable responses = client
     *             .listDeviceEventsPaginator(request);
     *     for (software.amazon.awssdk.services.alexaforbusiness.model.ListDeviceEventsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.alexaforbusiness.paginators.ListDeviceEventsIterable responses = client.listDeviceEventsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listDeviceEvents(software.amazon.awssdk.services.alexaforbusiness.model.ListDeviceEventsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listDeviceEventsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws NotFoundException
     *         The resource is not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AlexaForBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AlexaForBusinessClient.ListDeviceEvents
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/ListDeviceEvents"
     *      target="_top">AWS API Documentation</a>
     */
    default ListDeviceEventsIterable listDeviceEventsPaginator(ListDeviceEventsRequest listDeviceEventsRequest)
            throws NotFoundException, AwsServiceException, SdkClientException, AlexaForBusinessException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the device event history, including device connection status, for up to 30 days.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listDeviceEvents(software.amazon.awssdk.services.alexaforbusiness.model.ListDeviceEventsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.alexaforbusiness.paginators.ListDeviceEventsIterable responses = client.listDeviceEventsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.alexaforbusiness.paginators.ListDeviceEventsIterable responses = client
     *             .listDeviceEventsPaginator(request);
     *     for (software.amazon.awssdk.services.alexaforbusiness.model.ListDeviceEventsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.alexaforbusiness.paginators.ListDeviceEventsIterable responses = client.listDeviceEventsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listDeviceEvents(software.amazon.awssdk.services.alexaforbusiness.model.ListDeviceEventsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListDeviceEventsRequest.Builder} avoiding the need
     * to create one manually via {@link ListDeviceEventsRequest#builder()}
     * </p>
     *
     * @param listDeviceEventsRequest
     *        A {@link Consumer} that will call methods on {@link ListDeviceEventsRequest.Builder} to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws NotFoundException
     *         The resource is not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AlexaForBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AlexaForBusinessClient.ListDeviceEvents
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/ListDeviceEvents"
     *      target="_top">AWS API Documentation</a>
     */
    default ListDeviceEventsIterable listDeviceEventsPaginator(Consumer<ListDeviceEventsRequest.Builder> listDeviceEventsRequest)
            throws NotFoundException, AwsServiceException, SdkClientException, AlexaForBusinessException {
        return listDeviceEventsPaginator(ListDeviceEventsRequest.builder().applyMutation(listDeviceEventsRequest).build());
    }

    /**
     * <p>
     * Retrieves a list of gateway group summaries. Use GetGatewayGroup to retrieve details of a specific gateway group.
     * </p>
     *
     * @param listGatewayGroupsRequest
     * @return Result of the ListGatewayGroups operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AlexaForBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AlexaForBusinessClient.ListGatewayGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/ListGatewayGroups"
     *      target="_top">AWS API Documentation</a>
     */
    default ListGatewayGroupsResponse listGatewayGroups(ListGatewayGroupsRequest listGatewayGroupsRequest)
            throws AwsServiceException, SdkClientException, AlexaForBusinessException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves a list of gateway group summaries. Use GetGatewayGroup to retrieve details of a specific gateway group.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListGatewayGroupsRequest.Builder} avoiding the need
     * to create one manually via {@link ListGatewayGroupsRequest#builder()}
     * </p>
     *
     * @param listGatewayGroupsRequest
     *        A {@link Consumer} that will call methods on {@link ListGatewayGroupsRequest.Builder} to create a request.
     * @return Result of the ListGatewayGroups operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AlexaForBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AlexaForBusinessClient.ListGatewayGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/ListGatewayGroups"
     *      target="_top">AWS API Documentation</a>
     */
    default ListGatewayGroupsResponse listGatewayGroups(Consumer<ListGatewayGroupsRequest.Builder> listGatewayGroupsRequest)
            throws AwsServiceException, SdkClientException, AlexaForBusinessException {
        return listGatewayGroups(ListGatewayGroupsRequest.builder().applyMutation(listGatewayGroupsRequest).build());
    }

    /**
     * <p>
     * Retrieves a list of gateway group summaries. Use GetGatewayGroup to retrieve details of a specific gateway group.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listGatewayGroups(software.amazon.awssdk.services.alexaforbusiness.model.ListGatewayGroupsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.alexaforbusiness.paginators.ListGatewayGroupsIterable responses = client.listGatewayGroupsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.alexaforbusiness.paginators.ListGatewayGroupsIterable responses = client
     *             .listGatewayGroupsPaginator(request);
     *     for (software.amazon.awssdk.services.alexaforbusiness.model.ListGatewayGroupsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.alexaforbusiness.paginators.ListGatewayGroupsIterable responses = client.listGatewayGroupsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listGatewayGroups(software.amazon.awssdk.services.alexaforbusiness.model.ListGatewayGroupsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listGatewayGroupsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AlexaForBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AlexaForBusinessClient.ListGatewayGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/ListGatewayGroups"
     *      target="_top">AWS API Documentation</a>
     */
    default ListGatewayGroupsIterable listGatewayGroupsPaginator(ListGatewayGroupsRequest listGatewayGroupsRequest)
            throws AwsServiceException, SdkClientException, AlexaForBusinessException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves a list of gateway group summaries. Use GetGatewayGroup to retrieve details of a specific gateway group.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listGatewayGroups(software.amazon.awssdk.services.alexaforbusiness.model.ListGatewayGroupsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.alexaforbusiness.paginators.ListGatewayGroupsIterable responses = client.listGatewayGroupsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.alexaforbusiness.paginators.ListGatewayGroupsIterable responses = client
     *             .listGatewayGroupsPaginator(request);
     *     for (software.amazon.awssdk.services.alexaforbusiness.model.ListGatewayGroupsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.alexaforbusiness.paginators.ListGatewayGroupsIterable responses = client.listGatewayGroupsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listGatewayGroups(software.amazon.awssdk.services.alexaforbusiness.model.ListGatewayGroupsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListGatewayGroupsRequest.Builder} avoiding the need
     * to create one manually via {@link ListGatewayGroupsRequest#builder()}
     * </p>
     *
     * @param listGatewayGroupsRequest
     *        A {@link Consumer} that will call methods on {@link ListGatewayGroupsRequest.Builder} to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AlexaForBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AlexaForBusinessClient.ListGatewayGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/ListGatewayGroups"
     *      target="_top">AWS API Documentation</a>
     */
    default ListGatewayGroupsIterable listGatewayGroupsPaginator(
            Consumer<ListGatewayGroupsRequest.Builder> listGatewayGroupsRequest) throws AwsServiceException, SdkClientException,
            AlexaForBusinessException {
        return listGatewayGroupsPaginator(ListGatewayGroupsRequest.builder().applyMutation(listGatewayGroupsRequest).build());
    }

    /**
     * <p>
     * Retrieves a list of gateway summaries. Use GetGateway to retrieve details of a specific gateway. An optional
     * gateway group ARN can be provided to only retrieve gateway summaries of gateways that are associated with that
     * gateway group ARN.
     * </p>
     *
     * @param listGatewaysRequest
     * @return Result of the ListGateways operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AlexaForBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AlexaForBusinessClient.ListGateways
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/ListGateways" target="_top">AWS
     *      API Documentation</a>
     */
    default ListGatewaysResponse listGateways(ListGatewaysRequest listGatewaysRequest) throws AwsServiceException,
            SdkClientException, AlexaForBusinessException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves a list of gateway summaries. Use GetGateway to retrieve details of a specific gateway. An optional
     * gateway group ARN can be provided to only retrieve gateway summaries of gateways that are associated with that
     * gateway group ARN.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListGatewaysRequest.Builder} avoiding the need to
     * create one manually via {@link ListGatewaysRequest#builder()}
     * </p>
     *
     * @param listGatewaysRequest
     *        A {@link Consumer} that will call methods on {@link ListGatewaysRequest.Builder} to create a request.
     * @return Result of the ListGateways operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AlexaForBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AlexaForBusinessClient.ListGateways
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/ListGateways" target="_top">AWS
     *      API Documentation</a>
     */
    default ListGatewaysResponse listGateways(Consumer<ListGatewaysRequest.Builder> listGatewaysRequest)
            throws AwsServiceException, SdkClientException, AlexaForBusinessException {
        return listGateways(ListGatewaysRequest.builder().applyMutation(listGatewaysRequest).build());
    }

    /**
     * <p>
     * Retrieves a list of gateway summaries. Use GetGateway to retrieve details of a specific gateway. An optional
     * gateway group ARN can be provided to only retrieve gateway summaries of gateways that are associated with that
     * gateway group ARN.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listGateways(software.amazon.awssdk.services.alexaforbusiness.model.ListGatewaysRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.alexaforbusiness.paginators.ListGatewaysIterable responses = client.listGatewaysPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.alexaforbusiness.paginators.ListGatewaysIterable responses = client
     *             .listGatewaysPaginator(request);
     *     for (software.amazon.awssdk.services.alexaforbusiness.model.ListGatewaysResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.alexaforbusiness.paginators.ListGatewaysIterable responses = client.listGatewaysPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listGateways(software.amazon.awssdk.services.alexaforbusiness.model.ListGatewaysRequest)} operation.</b>
     * </p>
     *
     * @param listGatewaysRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AlexaForBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AlexaForBusinessClient.ListGateways
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/ListGateways" target="_top">AWS
     *      API Documentation</a>
     */
    default ListGatewaysIterable listGatewaysPaginator(ListGatewaysRequest listGatewaysRequest) throws AwsServiceException,
            SdkClientException, AlexaForBusinessException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves a list of gateway summaries. Use GetGateway to retrieve details of a specific gateway. An optional
     * gateway group ARN can be provided to only retrieve gateway summaries of gateways that are associated with that
     * gateway group ARN.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listGateways(software.amazon.awssdk.services.alexaforbusiness.model.ListGatewaysRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.alexaforbusiness.paginators.ListGatewaysIterable responses = client.listGatewaysPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.alexaforbusiness.paginators.ListGatewaysIterable responses = client
     *             .listGatewaysPaginator(request);
     *     for (software.amazon.awssdk.services.alexaforbusiness.model.ListGatewaysResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.alexaforbusiness.paginators.ListGatewaysIterable responses = client.listGatewaysPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listGateways(software.amazon.awssdk.services.alexaforbusiness.model.ListGatewaysRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListGatewaysRequest.Builder} avoiding the need to
     * create one manually via {@link ListGatewaysRequest#builder()}
     * </p>
     *
     * @param listGatewaysRequest
     *        A {@link Consumer} that will call methods on {@link ListGatewaysRequest.Builder} to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AlexaForBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AlexaForBusinessClient.ListGateways
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/ListGateways" target="_top">AWS
     *      API Documentation</a>
     */
    default ListGatewaysIterable listGatewaysPaginator(Consumer<ListGatewaysRequest.Builder> listGatewaysRequest)
            throws AwsServiceException, SdkClientException, AlexaForBusinessException {
        return listGatewaysPaginator(ListGatewaysRequest.builder().applyMutation(listGatewaysRequest).build());
    }

    /**
     * <p>
     * Lists all enabled skills in a specific skill group.
     * </p>
     *
     * @param listSkillsRequest
     * @return Result of the ListSkills operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AlexaForBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AlexaForBusinessClient.ListSkills
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/ListSkills" target="_top">AWS
     *      API Documentation</a>
     */
    default ListSkillsResponse listSkills(ListSkillsRequest listSkillsRequest) throws AwsServiceException, SdkClientException,
            AlexaForBusinessException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all enabled skills in a specific skill group.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListSkillsRequest.Builder} avoiding the need to
     * create one manually via {@link ListSkillsRequest#builder()}
     * </p>
     *
     * @param listSkillsRequest
     *        A {@link Consumer} that will call methods on {@link ListSkillsRequest.Builder} to create a request.
     * @return Result of the ListSkills operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AlexaForBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AlexaForBusinessClient.ListSkills
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/ListSkills" target="_top">AWS
     *      API Documentation</a>
     */
    default ListSkillsResponse listSkills(Consumer<ListSkillsRequest.Builder> listSkillsRequest) throws AwsServiceException,
            SdkClientException, AlexaForBusinessException {
        return listSkills(ListSkillsRequest.builder().applyMutation(listSkillsRequest).build());
    }

    /**
     * <p>
     * Lists all enabled skills in a specific skill group.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listSkills(software.amazon.awssdk.services.alexaforbusiness.model.ListSkillsRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.alexaforbusiness.paginators.ListSkillsIterable responses = client.listSkillsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.alexaforbusiness.paginators.ListSkillsIterable responses = client
     *             .listSkillsPaginator(request);
     *     for (software.amazon.awssdk.services.alexaforbusiness.model.ListSkillsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.alexaforbusiness.paginators.ListSkillsIterable responses = client.listSkillsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listSkills(software.amazon.awssdk.services.alexaforbusiness.model.ListSkillsRequest)} operation.</b>
     * </p>
     *
     * @param listSkillsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AlexaForBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AlexaForBusinessClient.ListSkills
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/ListSkills" target="_top">AWS
     *      API Documentation</a>
     */
    default ListSkillsIterable listSkillsPaginator(ListSkillsRequest listSkillsRequest) throws AwsServiceException,
            SdkClientException, AlexaForBusinessException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all enabled skills in a specific skill group.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listSkills(software.amazon.awssdk.services.alexaforbusiness.model.ListSkillsRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.alexaforbusiness.paginators.ListSkillsIterable responses = client.listSkillsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.alexaforbusiness.paginators.ListSkillsIterable responses = client
     *             .listSkillsPaginator(request);
     *     for (software.amazon.awssdk.services.alexaforbusiness.model.ListSkillsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.alexaforbusiness.paginators.ListSkillsIterable responses = client.listSkillsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listSkills(software.amazon.awssdk.services.alexaforbusiness.model.ListSkillsRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListSkillsRequest.Builder} avoiding the need to
     * create one manually via {@link ListSkillsRequest#builder()}
     * </p>
     *
     * @param listSkillsRequest
     *        A {@link Consumer} that will call methods on {@link ListSkillsRequest.Builder} to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AlexaForBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AlexaForBusinessClient.ListSkills
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/ListSkills" target="_top">AWS
     *      API Documentation</a>
     */
    default ListSkillsIterable listSkillsPaginator(Consumer<ListSkillsRequest.Builder> listSkillsRequest)
            throws AwsServiceException, SdkClientException, AlexaForBusinessException {
        return listSkillsPaginator(ListSkillsRequest.builder().applyMutation(listSkillsRequest).build());
    }

    /**
     * <p>
     * Lists all categories in the Alexa skill store.
     * </p>
     *
     * @param listSkillsStoreCategoriesRequest
     * @return Result of the ListSkillsStoreCategories operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AlexaForBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AlexaForBusinessClient.ListSkillsStoreCategories
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/ListSkillsStoreCategories"
     *      target="_top">AWS API Documentation</a>
     */
    default ListSkillsStoreCategoriesResponse listSkillsStoreCategories(
            ListSkillsStoreCategoriesRequest listSkillsStoreCategoriesRequest) throws AwsServiceException, SdkClientException,
            AlexaForBusinessException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all categories in the Alexa skill store.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListSkillsStoreCategoriesRequest.Builder} avoiding
     * the need to create one manually via {@link ListSkillsStoreCategoriesRequest#builder()}
     * </p>
     *
     * @param listSkillsStoreCategoriesRequest
     *        A {@link Consumer} that will call methods on {@link ListSkillsStoreCategoriesRequest.Builder} to create a
     *        request.
     * @return Result of the ListSkillsStoreCategories operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AlexaForBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AlexaForBusinessClient.ListSkillsStoreCategories
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/ListSkillsStoreCategories"
     *      target="_top">AWS API Documentation</a>
     */
    default ListSkillsStoreCategoriesResponse listSkillsStoreCategories(
            Consumer<ListSkillsStoreCategoriesRequest.Builder> listSkillsStoreCategoriesRequest) throws AwsServiceException,
            SdkClientException, AlexaForBusinessException {
        return listSkillsStoreCategories(ListSkillsStoreCategoriesRequest.builder()
                .applyMutation(listSkillsStoreCategoriesRequest).build());
    }

    /**
     * <p>
     * Lists all categories in the Alexa skill store.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listSkillsStoreCategories(software.amazon.awssdk.services.alexaforbusiness.model.ListSkillsStoreCategoriesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.alexaforbusiness.paginators.ListSkillsStoreCategoriesIterable responses = client.listSkillsStoreCategoriesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.alexaforbusiness.paginators.ListSkillsStoreCategoriesIterable responses = client
     *             .listSkillsStoreCategoriesPaginator(request);
     *     for (software.amazon.awssdk.services.alexaforbusiness.model.ListSkillsStoreCategoriesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.alexaforbusiness.paginators.ListSkillsStoreCategoriesIterable responses = client.listSkillsStoreCategoriesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listSkillsStoreCategories(software.amazon.awssdk.services.alexaforbusiness.model.ListSkillsStoreCategoriesRequest)}
     * operation.</b>
     * </p>
     *
     * @param listSkillsStoreCategoriesRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AlexaForBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AlexaForBusinessClient.ListSkillsStoreCategories
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/ListSkillsStoreCategories"
     *      target="_top">AWS API Documentation</a>
     */
    default ListSkillsStoreCategoriesIterable listSkillsStoreCategoriesPaginator(
            ListSkillsStoreCategoriesRequest listSkillsStoreCategoriesRequest) throws AwsServiceException, SdkClientException,
            AlexaForBusinessException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all categories in the Alexa skill store.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listSkillsStoreCategories(software.amazon.awssdk.services.alexaforbusiness.model.ListSkillsStoreCategoriesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.alexaforbusiness.paginators.ListSkillsStoreCategoriesIterable responses = client.listSkillsStoreCategoriesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.alexaforbusiness.paginators.ListSkillsStoreCategoriesIterable responses = client
     *             .listSkillsStoreCategoriesPaginator(request);
     *     for (software.amazon.awssdk.services.alexaforbusiness.model.ListSkillsStoreCategoriesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.alexaforbusiness.paginators.ListSkillsStoreCategoriesIterable responses = client.listSkillsStoreCategoriesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listSkillsStoreCategories(software.amazon.awssdk.services.alexaforbusiness.model.ListSkillsStoreCategoriesRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListSkillsStoreCategoriesRequest.Builder} avoiding
     * the need to create one manually via {@link ListSkillsStoreCategoriesRequest#builder()}
     * </p>
     *
     * @param listSkillsStoreCategoriesRequest
     *        A {@link Consumer} that will call methods on {@link ListSkillsStoreCategoriesRequest.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AlexaForBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AlexaForBusinessClient.ListSkillsStoreCategories
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/ListSkillsStoreCategories"
     *      target="_top">AWS API Documentation</a>
     */
    default ListSkillsStoreCategoriesIterable listSkillsStoreCategoriesPaginator(
            Consumer<ListSkillsStoreCategoriesRequest.Builder> listSkillsStoreCategoriesRequest) throws AwsServiceException,
            SdkClientException, AlexaForBusinessException {
        return listSkillsStoreCategoriesPaginator(ListSkillsStoreCategoriesRequest.builder()
                .applyMutation(listSkillsStoreCategoriesRequest).build());
    }

    /**
     * <p>
     * Lists all skills in the Alexa skill store by category.
     * </p>
     *
     * @param listSkillsStoreSkillsByCategoryRequest
     * @return Result of the ListSkillsStoreSkillsByCategory operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AlexaForBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AlexaForBusinessClient.ListSkillsStoreSkillsByCategory
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/ListSkillsStoreSkillsByCategory"
     *      target="_top">AWS API Documentation</a>
     */
    default ListSkillsStoreSkillsByCategoryResponse listSkillsStoreSkillsByCategory(
            ListSkillsStoreSkillsByCategoryRequest listSkillsStoreSkillsByCategoryRequest) throws AwsServiceException,
            SdkClientException, AlexaForBusinessException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all skills in the Alexa skill store by category.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListSkillsStoreSkillsByCategoryRequest.Builder}
     * avoiding the need to create one manually via {@link ListSkillsStoreSkillsByCategoryRequest#builder()}
     * </p>
     *
     * @param listSkillsStoreSkillsByCategoryRequest
     *        A {@link Consumer} that will call methods on {@link ListSkillsStoreSkillsByCategoryRequest.Builder} to
     *        create a request.
     * @return Result of the ListSkillsStoreSkillsByCategory operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AlexaForBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AlexaForBusinessClient.ListSkillsStoreSkillsByCategory
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/ListSkillsStoreSkillsByCategory"
     *      target="_top">AWS API Documentation</a>
     */
    default ListSkillsStoreSkillsByCategoryResponse listSkillsStoreSkillsByCategory(
            Consumer<ListSkillsStoreSkillsByCategoryRequest.Builder> listSkillsStoreSkillsByCategoryRequest)
            throws AwsServiceException, SdkClientException, AlexaForBusinessException {
        return listSkillsStoreSkillsByCategory(ListSkillsStoreSkillsByCategoryRequest.builder()
                .applyMutation(listSkillsStoreSkillsByCategoryRequest).build());
    }

    /**
     * <p>
     * Lists all skills in the Alexa skill store by category.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listSkillsStoreSkillsByCategory(software.amazon.awssdk.services.alexaforbusiness.model.ListSkillsStoreSkillsByCategoryRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.alexaforbusiness.paginators.ListSkillsStoreSkillsByCategoryIterable responses = client.listSkillsStoreSkillsByCategoryPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.alexaforbusiness.paginators.ListSkillsStoreSkillsByCategoryIterable responses = client
     *             .listSkillsStoreSkillsByCategoryPaginator(request);
     *     for (software.amazon.awssdk.services.alexaforbusiness.model.ListSkillsStoreSkillsByCategoryResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.alexaforbusiness.paginators.ListSkillsStoreSkillsByCategoryIterable responses = client.listSkillsStoreSkillsByCategoryPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listSkillsStoreSkillsByCategory(software.amazon.awssdk.services.alexaforbusiness.model.ListSkillsStoreSkillsByCategoryRequest)}
     * operation.</b>
     * </p>
     *
     * @param listSkillsStoreSkillsByCategoryRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AlexaForBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AlexaForBusinessClient.ListSkillsStoreSkillsByCategory
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/ListSkillsStoreSkillsByCategory"
     *      target="_top">AWS API Documentation</a>
     */
    default ListSkillsStoreSkillsByCategoryIterable listSkillsStoreSkillsByCategoryPaginator(
            ListSkillsStoreSkillsByCategoryRequest listSkillsStoreSkillsByCategoryRequest) throws AwsServiceException,
            SdkClientException, AlexaForBusinessException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all skills in the Alexa skill store by category.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listSkillsStoreSkillsByCategory(software.amazon.awssdk.services.alexaforbusiness.model.ListSkillsStoreSkillsByCategoryRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.alexaforbusiness.paginators.ListSkillsStoreSkillsByCategoryIterable responses = client.listSkillsStoreSkillsByCategoryPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.alexaforbusiness.paginators.ListSkillsStoreSkillsByCategoryIterable responses = client
     *             .listSkillsStoreSkillsByCategoryPaginator(request);
     *     for (software.amazon.awssdk.services.alexaforbusiness.model.ListSkillsStoreSkillsByCategoryResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.alexaforbusiness.paginators.ListSkillsStoreSkillsByCategoryIterable responses = client.listSkillsStoreSkillsByCategoryPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listSkillsStoreSkillsByCategory(software.amazon.awssdk.services.alexaforbusiness.model.ListSkillsStoreSkillsByCategoryRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListSkillsStoreSkillsByCategoryRequest.Builder}
     * avoiding the need to create one manually via {@link ListSkillsStoreSkillsByCategoryRequest#builder()}
     * </p>
     *
     * @param listSkillsStoreSkillsByCategoryRequest
     *        A {@link Consumer} that will call methods on {@link ListSkillsStoreSkillsByCategoryRequest.Builder} to
     *        create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AlexaForBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AlexaForBusinessClient.ListSkillsStoreSkillsByCategory
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/ListSkillsStoreSkillsByCategory"
     *      target="_top">AWS API Documentation</a>
     */
    default ListSkillsStoreSkillsByCategoryIterable listSkillsStoreSkillsByCategoryPaginator(
            Consumer<ListSkillsStoreSkillsByCategoryRequest.Builder> listSkillsStoreSkillsByCategoryRequest)
            throws AwsServiceException, SdkClientException, AlexaForBusinessException {
        return listSkillsStoreSkillsByCategoryPaginator(ListSkillsStoreSkillsByCategoryRequest.builder()
                .applyMutation(listSkillsStoreSkillsByCategoryRequest).build());
    }

    /**
     * <p>
     * Lists all of the smart home appliances associated with a room.
     * </p>
     *
     * @param listSmartHomeAppliancesRequest
     * @return Result of the ListSmartHomeAppliances operation returned by the service.
     * @throws NotFoundException
     *         The resource is not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AlexaForBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AlexaForBusinessClient.ListSmartHomeAppliances
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/ListSmartHomeAppliances"
     *      target="_top">AWS API Documentation</a>
     */
    default ListSmartHomeAppliancesResponse listSmartHomeAppliances(ListSmartHomeAppliancesRequest listSmartHomeAppliancesRequest)
            throws NotFoundException, AwsServiceException, SdkClientException, AlexaForBusinessException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all of the smart home appliances associated with a room.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListSmartHomeAppliancesRequest.Builder} avoiding
     * the need to create one manually via {@link ListSmartHomeAppliancesRequest#builder()}
     * </p>
     *
     * @param listSmartHomeAppliancesRequest
     *        A {@link Consumer} that will call methods on {@link ListSmartHomeAppliancesRequest.Builder} to create a
     *        request.
     * @return Result of the ListSmartHomeAppliances operation returned by the service.
     * @throws NotFoundException
     *         The resource is not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AlexaForBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AlexaForBusinessClient.ListSmartHomeAppliances
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/ListSmartHomeAppliances"
     *      target="_top">AWS API Documentation</a>
     */
    default ListSmartHomeAppliancesResponse listSmartHomeAppliances(
            Consumer<ListSmartHomeAppliancesRequest.Builder> listSmartHomeAppliancesRequest) throws NotFoundException,
            AwsServiceException, SdkClientException, AlexaForBusinessException {
        return listSmartHomeAppliances(ListSmartHomeAppliancesRequest.builder().applyMutation(listSmartHomeAppliancesRequest)
                .build());
    }

    /**
     * <p>
     * Lists all of the smart home appliances associated with a room.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listSmartHomeAppliances(software.amazon.awssdk.services.alexaforbusiness.model.ListSmartHomeAppliancesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.alexaforbusiness.paginators.ListSmartHomeAppliancesIterable responses = client.listSmartHomeAppliancesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.alexaforbusiness.paginators.ListSmartHomeAppliancesIterable responses = client
     *             .listSmartHomeAppliancesPaginator(request);
     *     for (software.amazon.awssdk.services.alexaforbusiness.model.ListSmartHomeAppliancesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.alexaforbusiness.paginators.ListSmartHomeAppliancesIterable responses = client.listSmartHomeAppliancesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listSmartHomeAppliances(software.amazon.awssdk.services.alexaforbusiness.model.ListSmartHomeAppliancesRequest)}
     * operation.</b>
     * </p>
     *
     * @param listSmartHomeAppliancesRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws NotFoundException
     *         The resource is not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AlexaForBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AlexaForBusinessClient.ListSmartHomeAppliances
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/ListSmartHomeAppliances"
     *      target="_top">AWS API Documentation</a>
     */
    default ListSmartHomeAppliancesIterable listSmartHomeAppliancesPaginator(
            ListSmartHomeAppliancesRequest listSmartHomeAppliancesRequest) throws NotFoundException, AwsServiceException,
            SdkClientException, AlexaForBusinessException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all of the smart home appliances associated with a room.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listSmartHomeAppliances(software.amazon.awssdk.services.alexaforbusiness.model.ListSmartHomeAppliancesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.alexaforbusiness.paginators.ListSmartHomeAppliancesIterable responses = client.listSmartHomeAppliancesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.alexaforbusiness.paginators.ListSmartHomeAppliancesIterable responses = client
     *             .listSmartHomeAppliancesPaginator(request);
     *     for (software.amazon.awssdk.services.alexaforbusiness.model.ListSmartHomeAppliancesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.alexaforbusiness.paginators.ListSmartHomeAppliancesIterable responses = client.listSmartHomeAppliancesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listSmartHomeAppliances(software.amazon.awssdk.services.alexaforbusiness.model.ListSmartHomeAppliancesRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListSmartHomeAppliancesRequest.Builder} avoiding
     * the need to create one manually via {@link ListSmartHomeAppliancesRequest#builder()}
     * </p>
     *
     * @param listSmartHomeAppliancesRequest
     *        A {@link Consumer} that will call methods on {@link ListSmartHomeAppliancesRequest.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws NotFoundException
     *         The resource is not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AlexaForBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AlexaForBusinessClient.ListSmartHomeAppliances
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/ListSmartHomeAppliances"
     *      target="_top">AWS API Documentation</a>
     */
    default ListSmartHomeAppliancesIterable listSmartHomeAppliancesPaginator(
            Consumer<ListSmartHomeAppliancesRequest.Builder> listSmartHomeAppliancesRequest) throws NotFoundException,
            AwsServiceException, SdkClientException, AlexaForBusinessException {
        return listSmartHomeAppliancesPaginator(ListSmartHomeAppliancesRequest.builder()
                .applyMutation(listSmartHomeAppliancesRequest).build());
    }

    /**
     * <p>
     * Lists all tags for the specified resource.
     * </p>
     *
     * @param listTagsRequest
     * @return Result of the ListTags operation returned by the service.
     * @throws NotFoundException
     *         The resource is not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AlexaForBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AlexaForBusinessClient.ListTags
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/ListTags" target="_top">AWS API
     *      Documentation</a>
     */
    default ListTagsResponse listTags(ListTagsRequest listTagsRequest) throws NotFoundException, AwsServiceException,
            SdkClientException, AlexaForBusinessException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all tags for the specified resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTagsRequest.Builder} avoiding the need to
     * create one manually via {@link ListTagsRequest#builder()}
     * </p>
     *
     * @param listTagsRequest
     *        A {@link Consumer} that will call methods on {@link ListTagsRequest.Builder} to create a request.
     * @return Result of the ListTags operation returned by the service.
     * @throws NotFoundException
     *         The resource is not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AlexaForBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AlexaForBusinessClient.ListTags
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/ListTags" target="_top">AWS API
     *      Documentation</a>
     */
    default ListTagsResponse listTags(Consumer<ListTagsRequest.Builder> listTagsRequest) throws NotFoundException,
            AwsServiceException, SdkClientException, AlexaForBusinessException {
        return listTags(ListTagsRequest.builder().applyMutation(listTagsRequest).build());
    }

    /**
     * <p>
     * Lists all tags for the specified resource.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listTags(software.amazon.awssdk.services.alexaforbusiness.model.ListTagsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.alexaforbusiness.paginators.ListTagsIterable responses = client.listTagsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.alexaforbusiness.paginators.ListTagsIterable responses = client.listTagsPaginator(request);
     *     for (software.amazon.awssdk.services.alexaforbusiness.model.ListTagsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.alexaforbusiness.paginators.ListTagsIterable responses = client.listTagsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listTags(software.amazon.awssdk.services.alexaforbusiness.model.ListTagsRequest)} operation.</b>
     * </p>
     *
     * @param listTagsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws NotFoundException
     *         The resource is not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AlexaForBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AlexaForBusinessClient.ListTags
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/ListTags" target="_top">AWS API
     *      Documentation</a>
     */
    default ListTagsIterable listTagsPaginator(ListTagsRequest listTagsRequest) throws NotFoundException, AwsServiceException,
            SdkClientException, AlexaForBusinessException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all tags for the specified resource.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listTags(software.amazon.awssdk.services.alexaforbusiness.model.ListTagsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.alexaforbusiness.paginators.ListTagsIterable responses = client.listTagsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.alexaforbusiness.paginators.ListTagsIterable responses = client.listTagsPaginator(request);
     *     for (software.amazon.awssdk.services.alexaforbusiness.model.ListTagsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.alexaforbusiness.paginators.ListTagsIterable responses = client.listTagsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listTags(software.amazon.awssdk.services.alexaforbusiness.model.ListTagsRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTagsRequest.Builder} avoiding the need to
     * create one manually via {@link ListTagsRequest#builder()}
     * </p>
     *
     * @param listTagsRequest
     *        A {@link Consumer} that will call methods on {@link ListTagsRequest.Builder} to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws NotFoundException
     *         The resource is not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AlexaForBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AlexaForBusinessClient.ListTags
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/ListTags" target="_top">AWS API
     *      Documentation</a>
     */
    default ListTagsIterable listTagsPaginator(Consumer<ListTagsRequest.Builder> listTagsRequest) throws NotFoundException,
            AwsServiceException, SdkClientException, AlexaForBusinessException {
        return listTagsPaginator(ListTagsRequest.builder().applyMutation(listTagsRequest).build());
    }

    /**
     * <p>
     * Sets the conference preferences on a specific conference provider at the account level.
     * </p>
     *
     * @param putConferencePreferenceRequest
     * @return Result of the PutConferencePreference operation returned by the service.
     * @throws NotFoundException
     *         The resource is not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AlexaForBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AlexaForBusinessClient.PutConferencePreference
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/PutConferencePreference"
     *      target="_top">AWS API Documentation</a>
     */
    default PutConferencePreferenceResponse putConferencePreference(PutConferencePreferenceRequest putConferencePreferenceRequest)
            throws NotFoundException, AwsServiceException, SdkClientException, AlexaForBusinessException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Sets the conference preferences on a specific conference provider at the account level.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link PutConferencePreferenceRequest.Builder} avoiding
     * the need to create one manually via {@link PutConferencePreferenceRequest#builder()}
     * </p>
     *
     * @param putConferencePreferenceRequest
     *        A {@link Consumer} that will call methods on {@link PutConferencePreferenceRequest.Builder} to create a
     *        request.
     * @return Result of the PutConferencePreference operation returned by the service.
     * @throws NotFoundException
     *         The resource is not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AlexaForBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AlexaForBusinessClient.PutConferencePreference
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/PutConferencePreference"
     *      target="_top">AWS API Documentation</a>
     */
    default PutConferencePreferenceResponse putConferencePreference(
            Consumer<PutConferencePreferenceRequest.Builder> putConferencePreferenceRequest) throws NotFoundException,
            AwsServiceException, SdkClientException, AlexaForBusinessException {
        return putConferencePreference(PutConferencePreferenceRequest.builder().applyMutation(putConferencePreferenceRequest)
                .build());
    }

    /**
     * <p>
     * Configures the email template for the user enrollment invitation with the specified attributes.
     * </p>
     *
     * @param putInvitationConfigurationRequest
     * @return Result of the PutInvitationConfiguration operation returned by the service.
     * @throws NotFoundException
     *         The resource is not found.
     * @throws ConcurrentModificationException
     *         There is a concurrent modification of resources.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AlexaForBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AlexaForBusinessClient.PutInvitationConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/PutInvitationConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default PutInvitationConfigurationResponse putInvitationConfiguration(
            PutInvitationConfigurationRequest putInvitationConfigurationRequest) throws NotFoundException,
            ConcurrentModificationException, AwsServiceException, SdkClientException, AlexaForBusinessException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Configures the email template for the user enrollment invitation with the specified attributes.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link PutInvitationConfigurationRequest.Builder} avoiding
     * the need to create one manually via {@link PutInvitationConfigurationRequest#builder()}
     * </p>
     *
     * @param putInvitationConfigurationRequest
     *        A {@link Consumer} that will call methods on {@link PutInvitationConfigurationRequest.Builder} to create a
     *        request.
     * @return Result of the PutInvitationConfiguration operation returned by the service.
     * @throws NotFoundException
     *         The resource is not found.
     * @throws ConcurrentModificationException
     *         There is a concurrent modification of resources.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AlexaForBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AlexaForBusinessClient.PutInvitationConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/PutInvitationConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default PutInvitationConfigurationResponse putInvitationConfiguration(
            Consumer<PutInvitationConfigurationRequest.Builder> putInvitationConfigurationRequest) throws NotFoundException,
            ConcurrentModificationException, AwsServiceException, SdkClientException, AlexaForBusinessException {
        return putInvitationConfiguration(PutInvitationConfigurationRequest.builder()
                .applyMutation(putInvitationConfigurationRequest).build());
    }

    /**
     * <p>
     * Updates room skill parameter details by room, skill, and parameter key ID. Not all skills have a room skill
     * parameter.
     * </p>
     *
     * @param putRoomSkillParameterRequest
     * @return Result of the PutRoomSkillParameter operation returned by the service.
     * @throws ConcurrentModificationException
     *         There is a concurrent modification of resources.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AlexaForBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AlexaForBusinessClient.PutRoomSkillParameter
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/PutRoomSkillParameter"
     *      target="_top">AWS API Documentation</a>
     */
    default PutRoomSkillParameterResponse putRoomSkillParameter(PutRoomSkillParameterRequest putRoomSkillParameterRequest)
            throws ConcurrentModificationException, AwsServiceException, SdkClientException, AlexaForBusinessException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates room skill parameter details by room, skill, and parameter key ID. Not all skills have a room skill
     * parameter.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link PutRoomSkillParameterRequest.Builder} avoiding the
     * need to create one manually via {@link PutRoomSkillParameterRequest#builder()}
     * </p>
     *
     * @param putRoomSkillParameterRequest
     *        A {@link Consumer} that will call methods on {@link PutRoomSkillParameterRequest.Builder} to create a
     *        request.
     * @return Result of the PutRoomSkillParameter operation returned by the service.
     * @throws ConcurrentModificationException
     *         There is a concurrent modification of resources.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AlexaForBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AlexaForBusinessClient.PutRoomSkillParameter
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/PutRoomSkillParameter"
     *      target="_top">AWS API Documentation</a>
     */
    default PutRoomSkillParameterResponse putRoomSkillParameter(
            Consumer<PutRoomSkillParameterRequest.Builder> putRoomSkillParameterRequest) throws ConcurrentModificationException,
            AwsServiceException, SdkClientException, AlexaForBusinessException {
        return putRoomSkillParameter(PutRoomSkillParameterRequest.builder().applyMutation(putRoomSkillParameterRequest).build());
    }

    /**
     * <p>
     * Links a user's account to a third-party skill provider. If this API operation is called by an assumed IAM role,
     * the skill being linked must be a private skill. Also, the skill must be owned by the AWS account that assumed the
     * IAM role.
     * </p>
     *
     * @param putSkillAuthorizationRequest
     * @return Result of the PutSkillAuthorization operation returned by the service.
     * @throws UnauthorizedException
     *         The caller has no permissions to operate on the resource involved in the API call.
     * @throws ConcurrentModificationException
     *         There is a concurrent modification of resources.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AlexaForBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AlexaForBusinessClient.PutSkillAuthorization
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/PutSkillAuthorization"
     *      target="_top">AWS API Documentation</a>
     */
    default PutSkillAuthorizationResponse putSkillAuthorization(PutSkillAuthorizationRequest putSkillAuthorizationRequest)
            throws UnauthorizedException, ConcurrentModificationException, AwsServiceException, SdkClientException,
            AlexaForBusinessException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Links a user's account to a third-party skill provider. If this API operation is called by an assumed IAM role,
     * the skill being linked must be a private skill. Also, the skill must be owned by the AWS account that assumed the
     * IAM role.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link PutSkillAuthorizationRequest.Builder} avoiding the
     * need to create one manually via {@link PutSkillAuthorizationRequest#builder()}
     * </p>
     *
     * @param putSkillAuthorizationRequest
     *        A {@link Consumer} that will call methods on {@link PutSkillAuthorizationRequest.Builder} to create a
     *        request.
     * @return Result of the PutSkillAuthorization operation returned by the service.
     * @throws UnauthorizedException
     *         The caller has no permissions to operate on the resource involved in the API call.
     * @throws ConcurrentModificationException
     *         There is a concurrent modification of resources.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AlexaForBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AlexaForBusinessClient.PutSkillAuthorization
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/PutSkillAuthorization"
     *      target="_top">AWS API Documentation</a>
     */
    default PutSkillAuthorizationResponse putSkillAuthorization(
            Consumer<PutSkillAuthorizationRequest.Builder> putSkillAuthorizationRequest) throws UnauthorizedException,
            ConcurrentModificationException, AwsServiceException, SdkClientException, AlexaForBusinessException {
        return putSkillAuthorization(PutSkillAuthorizationRequest.builder().applyMutation(putSkillAuthorizationRequest).build());
    }

    /**
     * <p>
     * Registers an Alexa-enabled device built by an Original Equipment Manufacturer (OEM) using Alexa Voice Service
     * (AVS).
     * </p>
     *
     * @param registerAvsDeviceRequest
     * @return Result of the RegisterAVSDevice operation returned by the service.
     * @throws LimitExceededException
     *         You are performing an action that would put you beyond your account's limits.
     * @throws ConcurrentModificationException
     *         There is a concurrent modification of resources.
     * @throws NotFoundException
     *         The resource is not found.
     * @throws InvalidDeviceException
     *         The device is in an invalid state.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AlexaForBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AlexaForBusinessClient.RegisterAVSDevice
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/RegisterAVSDevice"
     *      target="_top">AWS API Documentation</a>
     */
    default RegisterAvsDeviceResponse registerAVSDevice(RegisterAvsDeviceRequest registerAvsDeviceRequest)
            throws LimitExceededException, ConcurrentModificationException, NotFoundException, InvalidDeviceException,
            AwsServiceException, SdkClientException, AlexaForBusinessException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Registers an Alexa-enabled device built by an Original Equipment Manufacturer (OEM) using Alexa Voice Service
     * (AVS).
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link RegisterAvsDeviceRequest.Builder} avoiding the need
     * to create one manually via {@link RegisterAvsDeviceRequest#builder()}
     * </p>
     *
     * @param registerAvsDeviceRequest
     *        A {@link Consumer} that will call methods on {@link RegisterAVSDeviceRequest.Builder} to create a request.
     * @return Result of the RegisterAVSDevice operation returned by the service.
     * @throws LimitExceededException
     *         You are performing an action that would put you beyond your account's limits.
     * @throws ConcurrentModificationException
     *         There is a concurrent modification of resources.
     * @throws NotFoundException
     *         The resource is not found.
     * @throws InvalidDeviceException
     *         The device is in an invalid state.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AlexaForBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AlexaForBusinessClient.RegisterAVSDevice
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/RegisterAVSDevice"
     *      target="_top">AWS API Documentation</a>
     */
    default RegisterAvsDeviceResponse registerAVSDevice(Consumer<RegisterAvsDeviceRequest.Builder> registerAvsDeviceRequest)
            throws LimitExceededException, ConcurrentModificationException, NotFoundException, InvalidDeviceException,
            AwsServiceException, SdkClientException, AlexaForBusinessException {
        return registerAVSDevice(RegisterAvsDeviceRequest.builder().applyMutation(registerAvsDeviceRequest).build());
    }

    /**
     * <p>
     * Disassociates a skill from the organization under a user's AWS account. If the skill is a private skill, it moves
     * to an AcceptStatus of PENDING. Any private or public skill that is rejected can be added later by calling the
     * ApproveSkill API.
     * </p>
     *
     * @param rejectSkillRequest
     * @return Result of the RejectSkill operation returned by the service.
     * @throws ConcurrentModificationException
     *         There is a concurrent modification of resources.
     * @throws NotFoundException
     *         The resource is not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AlexaForBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AlexaForBusinessClient.RejectSkill
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/RejectSkill" target="_top">AWS
     *      API Documentation</a>
     */
    default RejectSkillResponse rejectSkill(RejectSkillRequest rejectSkillRequest) throws ConcurrentModificationException,
            NotFoundException, AwsServiceException, SdkClientException, AlexaForBusinessException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Disassociates a skill from the organization under a user's AWS account. If the skill is a private skill, it moves
     * to an AcceptStatus of PENDING. Any private or public skill that is rejected can be added later by calling the
     * ApproveSkill API.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link RejectSkillRequest.Builder} avoiding the need to
     * create one manually via {@link RejectSkillRequest#builder()}
     * </p>
     *
     * @param rejectSkillRequest
     *        A {@link Consumer} that will call methods on {@link RejectSkillRequest.Builder} to create a request.
     * @return Result of the RejectSkill operation returned by the service.
     * @throws ConcurrentModificationException
     *         There is a concurrent modification of resources.
     * @throws NotFoundException
     *         The resource is not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AlexaForBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AlexaForBusinessClient.RejectSkill
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/RejectSkill" target="_top">AWS
     *      API Documentation</a>
     */
    default RejectSkillResponse rejectSkill(Consumer<RejectSkillRequest.Builder> rejectSkillRequest)
            throws ConcurrentModificationException, NotFoundException, AwsServiceException, SdkClientException,
            AlexaForBusinessException {
        return rejectSkill(RejectSkillRequest.builder().applyMutation(rejectSkillRequest).build());
    }

    /**
     * <p>
     * Determines the details for the room from which a skill request was invoked. This operation is used by skill
     * developers.
     * </p>
     * <p>
     * To query ResolveRoom from an Alexa skill, the skill ID needs to be authorized. When the skill is using an AWS
     * Lambda function, the skill is automatically authorized when you publish your skill as a private skill to your AWS
     * account. Skills that are hosted using a custom web service must be manually authorized. To get your skill
     * authorized, contact AWS Support with your AWS account ID that queries the ResolveRoom API and skill ID.
     * </p>
     *
     * @param resolveRoomRequest
     * @return Result of the ResolveRoom operation returned by the service.
     * @throws NotFoundException
     *         The resource is not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AlexaForBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AlexaForBusinessClient.ResolveRoom
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/ResolveRoom" target="_top">AWS
     *      API Documentation</a>
     */
    default ResolveRoomResponse resolveRoom(ResolveRoomRequest resolveRoomRequest) throws NotFoundException, AwsServiceException,
            SdkClientException, AlexaForBusinessException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Determines the details for the room from which a skill request was invoked. This operation is used by skill
     * developers.
     * </p>
     * <p>
     * To query ResolveRoom from an Alexa skill, the skill ID needs to be authorized. When the skill is using an AWS
     * Lambda function, the skill is automatically authorized when you publish your skill as a private skill to your AWS
     * account. Skills that are hosted using a custom web service must be manually authorized. To get your skill
     * authorized, contact AWS Support with your AWS account ID that queries the ResolveRoom API and skill ID.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ResolveRoomRequest.Builder} avoiding the need to
     * create one manually via {@link ResolveRoomRequest#builder()}
     * </p>
     *
     * @param resolveRoomRequest
     *        A {@link Consumer} that will call methods on {@link ResolveRoomRequest.Builder} to create a request.
     * @return Result of the ResolveRoom operation returned by the service.
     * @throws NotFoundException
     *         The resource is not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AlexaForBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AlexaForBusinessClient.ResolveRoom
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/ResolveRoom" target="_top">AWS
     *      API Documentation</a>
     */
    default ResolveRoomResponse resolveRoom(Consumer<ResolveRoomRequest.Builder> resolveRoomRequest) throws NotFoundException,
            AwsServiceException, SdkClientException, AlexaForBusinessException {
        return resolveRoom(ResolveRoomRequest.builder().applyMutation(resolveRoomRequest).build());
    }

    /**
     * <p>
     * Revokes an invitation and invalidates the enrollment URL.
     * </p>
     *
     * @param revokeInvitationRequest
     * @return Result of the RevokeInvitation operation returned by the service.
     * @throws NotFoundException
     *         The resource is not found.
     * @throws ConcurrentModificationException
     *         There is a concurrent modification of resources.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AlexaForBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AlexaForBusinessClient.RevokeInvitation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/RevokeInvitation"
     *      target="_top">AWS API Documentation</a>
     */
    default RevokeInvitationResponse revokeInvitation(RevokeInvitationRequest revokeInvitationRequest) throws NotFoundException,
            ConcurrentModificationException, AwsServiceException, SdkClientException, AlexaForBusinessException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Revokes an invitation and invalidates the enrollment URL.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link RevokeInvitationRequest.Builder} avoiding the need
     * to create one manually via {@link RevokeInvitationRequest#builder()}
     * </p>
     *
     * @param revokeInvitationRequest
     *        A {@link Consumer} that will call methods on {@link RevokeInvitationRequest.Builder} to create a request.
     * @return Result of the RevokeInvitation operation returned by the service.
     * @throws NotFoundException
     *         The resource is not found.
     * @throws ConcurrentModificationException
     *         There is a concurrent modification of resources.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AlexaForBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AlexaForBusinessClient.RevokeInvitation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/RevokeInvitation"
     *      target="_top">AWS API Documentation</a>
     */
    default RevokeInvitationResponse revokeInvitation(Consumer<RevokeInvitationRequest.Builder> revokeInvitationRequest)
            throws NotFoundException, ConcurrentModificationException, AwsServiceException, SdkClientException,
            AlexaForBusinessException {
        return revokeInvitation(RevokeInvitationRequest.builder().applyMutation(revokeInvitationRequest).build());
    }

    /**
     * <p>
     * Searches address books and lists the ones that meet a set of filter and sort criteria.
     * </p>
     *
     * @param searchAddressBooksRequest
     * @return Result of the SearchAddressBooks operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AlexaForBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AlexaForBusinessClient.SearchAddressBooks
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/SearchAddressBooks"
     *      target="_top">AWS API Documentation</a>
     */
    default SearchAddressBooksResponse searchAddressBooks(SearchAddressBooksRequest searchAddressBooksRequest)
            throws AwsServiceException, SdkClientException, AlexaForBusinessException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Searches address books and lists the ones that meet a set of filter and sort criteria.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link SearchAddressBooksRequest.Builder} avoiding the
     * need to create one manually via {@link SearchAddressBooksRequest#builder()}
     * </p>
     *
     * @param searchAddressBooksRequest
     *        A {@link Consumer} that will call methods on {@link SearchAddressBooksRequest.Builder} to create a
     *        request.
     * @return Result of the SearchAddressBooks operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AlexaForBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AlexaForBusinessClient.SearchAddressBooks
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/SearchAddressBooks"
     *      target="_top">AWS API Documentation</a>
     */
    default SearchAddressBooksResponse searchAddressBooks(Consumer<SearchAddressBooksRequest.Builder> searchAddressBooksRequest)
            throws AwsServiceException, SdkClientException, AlexaForBusinessException {
        return searchAddressBooks(SearchAddressBooksRequest.builder().applyMutation(searchAddressBooksRequest).build());
    }

    /**
     * <p>
     * Searches address books and lists the ones that meet a set of filter and sort criteria.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #searchAddressBooks(software.amazon.awssdk.services.alexaforbusiness.model.SearchAddressBooksRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.alexaforbusiness.paginators.SearchAddressBooksIterable responses = client.searchAddressBooksPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.alexaforbusiness.paginators.SearchAddressBooksIterable responses = client
     *             .searchAddressBooksPaginator(request);
     *     for (software.amazon.awssdk.services.alexaforbusiness.model.SearchAddressBooksResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.alexaforbusiness.paginators.SearchAddressBooksIterable responses = client.searchAddressBooksPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #searchAddressBooks(software.amazon.awssdk.services.alexaforbusiness.model.SearchAddressBooksRequest)}
     * operation.</b>
     * </p>
     *
     * @param searchAddressBooksRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AlexaForBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AlexaForBusinessClient.SearchAddressBooks
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/SearchAddressBooks"
     *      target="_top">AWS API Documentation</a>
     */
    default SearchAddressBooksIterable searchAddressBooksPaginator(SearchAddressBooksRequest searchAddressBooksRequest)
            throws AwsServiceException, SdkClientException, AlexaForBusinessException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Searches address books and lists the ones that meet a set of filter and sort criteria.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #searchAddressBooks(software.amazon.awssdk.services.alexaforbusiness.model.SearchAddressBooksRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.alexaforbusiness.paginators.SearchAddressBooksIterable responses = client.searchAddressBooksPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.alexaforbusiness.paginators.SearchAddressBooksIterable responses = client
     *             .searchAddressBooksPaginator(request);
     *     for (software.amazon.awssdk.services.alexaforbusiness.model.SearchAddressBooksResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.alexaforbusiness.paginators.SearchAddressBooksIterable responses = client.searchAddressBooksPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #searchAddressBooks(software.amazon.awssdk.services.alexaforbusiness.model.SearchAddressBooksRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link SearchAddressBooksRequest.Builder} avoiding the
     * need to create one manually via {@link SearchAddressBooksRequest#builder()}
     * </p>
     *
     * @param searchAddressBooksRequest
     *        A {@link Consumer} that will call methods on {@link SearchAddressBooksRequest.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AlexaForBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AlexaForBusinessClient.SearchAddressBooks
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/SearchAddressBooks"
     *      target="_top">AWS API Documentation</a>
     */
    default SearchAddressBooksIterable searchAddressBooksPaginator(
            Consumer<SearchAddressBooksRequest.Builder> searchAddressBooksRequest) throws AwsServiceException,
            SdkClientException, AlexaForBusinessException {
        return searchAddressBooksPaginator(SearchAddressBooksRequest.builder().applyMutation(searchAddressBooksRequest).build());
    }

    /**
     * <p>
     * Searches contacts and lists the ones that meet a set of filter and sort criteria.
     * </p>
     *
     * @param searchContactsRequest
     * @return Result of the SearchContacts operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AlexaForBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AlexaForBusinessClient.SearchContacts
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/SearchContacts"
     *      target="_top">AWS API Documentation</a>
     */
    default SearchContactsResponse searchContacts(SearchContactsRequest searchContactsRequest) throws AwsServiceException,
            SdkClientException, AlexaForBusinessException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Searches contacts and lists the ones that meet a set of filter and sort criteria.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link SearchContactsRequest.Builder} avoiding the need to
     * create one manually via {@link SearchContactsRequest#builder()}
     * </p>
     *
     * @param searchContactsRequest
     *        A {@link Consumer} that will call methods on {@link SearchContactsRequest.Builder} to create a request.
     * @return Result of the SearchContacts operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AlexaForBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AlexaForBusinessClient.SearchContacts
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/SearchContacts"
     *      target="_top">AWS API Documentation</a>
     */
    default SearchContactsResponse searchContacts(Consumer<SearchContactsRequest.Builder> searchContactsRequest)
            throws AwsServiceException, SdkClientException, AlexaForBusinessException {
        return searchContacts(SearchContactsRequest.builder().applyMutation(searchContactsRequest).build());
    }

    /**
     * <p>
     * Searches contacts and lists the ones that meet a set of filter and sort criteria.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #searchContacts(software.amazon.awssdk.services.alexaforbusiness.model.SearchContactsRequest)} operation.
     * The return type is a custom iterable that can be used to iterate through all the pages. SDK will internally
     * handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.alexaforbusiness.paginators.SearchContactsIterable responses = client.searchContactsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.alexaforbusiness.paginators.SearchContactsIterable responses = client
     *             .searchContactsPaginator(request);
     *     for (software.amazon.awssdk.services.alexaforbusiness.model.SearchContactsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.alexaforbusiness.paginators.SearchContactsIterable responses = client.searchContactsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #searchContacts(software.amazon.awssdk.services.alexaforbusiness.model.SearchContactsRequest)}
     * operation.</b>
     * </p>
     *
     * @param searchContactsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AlexaForBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AlexaForBusinessClient.SearchContacts
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/SearchContacts"
     *      target="_top">AWS API Documentation</a>
     */
    default SearchContactsIterable searchContactsPaginator(SearchContactsRequest searchContactsRequest)
            throws AwsServiceException, SdkClientException, AlexaForBusinessException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Searches contacts and lists the ones that meet a set of filter and sort criteria.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #searchContacts(software.amazon.awssdk.services.alexaforbusiness.model.SearchContactsRequest)} operation.
     * The return type is a custom iterable that can be used to iterate through all the pages. SDK will internally
     * handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.alexaforbusiness.paginators.SearchContactsIterable responses = client.searchContactsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.alexaforbusiness.paginators.SearchContactsIterable responses = client
     *             .searchContactsPaginator(request);
     *     for (software.amazon.awssdk.services.alexaforbusiness.model.SearchContactsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.alexaforbusiness.paginators.SearchContactsIterable responses = client.searchContactsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #searchContacts(software.amazon.awssdk.services.alexaforbusiness.model.SearchContactsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link SearchContactsRequest.Builder} avoiding the need to
     * create one manually via {@link SearchContactsRequest#builder()}
     * </p>
     *
     * @param searchContactsRequest
     *        A {@link Consumer} that will call methods on {@link SearchContactsRequest.Builder} to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AlexaForBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AlexaForBusinessClient.SearchContacts
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/SearchContacts"
     *      target="_top">AWS API Documentation</a>
     */
    default SearchContactsIterable searchContactsPaginator(Consumer<SearchContactsRequest.Builder> searchContactsRequest)
            throws AwsServiceException, SdkClientException, AlexaForBusinessException {
        return searchContactsPaginator(SearchContactsRequest.builder().applyMutation(searchContactsRequest).build());
    }

    /**
     * <p>
     * Searches devices and lists the ones that meet a set of filter criteria.
     * </p>
     *
     * @param searchDevicesRequest
     * @return Result of the SearchDevices operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AlexaForBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AlexaForBusinessClient.SearchDevices
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/SearchDevices"
     *      target="_top">AWS API Documentation</a>
     */
    default SearchDevicesResponse searchDevices(SearchDevicesRequest searchDevicesRequest) throws AwsServiceException,
            SdkClientException, AlexaForBusinessException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Searches devices and lists the ones that meet a set of filter criteria.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link SearchDevicesRequest.Builder} avoiding the need to
     * create one manually via {@link SearchDevicesRequest#builder()}
     * </p>
     *
     * @param searchDevicesRequest
     *        A {@link Consumer} that will call methods on {@link SearchDevicesRequest.Builder} to create a request.
     * @return Result of the SearchDevices operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AlexaForBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AlexaForBusinessClient.SearchDevices
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/SearchDevices"
     *      target="_top">AWS API Documentation</a>
     */
    default SearchDevicesResponse searchDevices(Consumer<SearchDevicesRequest.Builder> searchDevicesRequest)
            throws AwsServiceException, SdkClientException, AlexaForBusinessException {
        return searchDevices(SearchDevicesRequest.builder().applyMutation(searchDevicesRequest).build());
    }

    /**
     * <p>
     * Searches devices and lists the ones that meet a set of filter criteria.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #searchDevices(software.amazon.awssdk.services.alexaforbusiness.model.SearchDevicesRequest)} operation.
     * The return type is a custom iterable that can be used to iterate through all the pages. SDK will internally
     * handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.alexaforbusiness.paginators.SearchDevicesIterable responses = client.searchDevicesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.alexaforbusiness.paginators.SearchDevicesIterable responses = client
     *             .searchDevicesPaginator(request);
     *     for (software.amazon.awssdk.services.alexaforbusiness.model.SearchDevicesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.alexaforbusiness.paginators.SearchDevicesIterable responses = client.searchDevicesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #searchDevices(software.amazon.awssdk.services.alexaforbusiness.model.SearchDevicesRequest)}
     * operation.</b>
     * </p>
     *
     * @param searchDevicesRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AlexaForBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AlexaForBusinessClient.SearchDevices
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/SearchDevices"
     *      target="_top">AWS API Documentation</a>
     */
    default SearchDevicesIterable searchDevicesPaginator(SearchDevicesRequest searchDevicesRequest) throws AwsServiceException,
            SdkClientException, AlexaForBusinessException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Searches devices and lists the ones that meet a set of filter criteria.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #searchDevices(software.amazon.awssdk.services.alexaforbusiness.model.SearchDevicesRequest)} operation.
     * The return type is a custom iterable that can be used to iterate through all the pages. SDK will internally
     * handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.alexaforbusiness.paginators.SearchDevicesIterable responses = client.searchDevicesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.alexaforbusiness.paginators.SearchDevicesIterable responses = client
     *             .searchDevicesPaginator(request);
     *     for (software.amazon.awssdk.services.alexaforbusiness.model.SearchDevicesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.alexaforbusiness.paginators.SearchDevicesIterable responses = client.searchDevicesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #searchDevices(software.amazon.awssdk.services.alexaforbusiness.model.SearchDevicesRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link SearchDevicesRequest.Builder} avoiding the need to
     * create one manually via {@link SearchDevicesRequest#builder()}
     * </p>
     *
     * @param searchDevicesRequest
     *        A {@link Consumer} that will call methods on {@link SearchDevicesRequest.Builder} to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AlexaForBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AlexaForBusinessClient.SearchDevices
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/SearchDevices"
     *      target="_top">AWS API Documentation</a>
     */
    default SearchDevicesIterable searchDevicesPaginator(Consumer<SearchDevicesRequest.Builder> searchDevicesRequest)
            throws AwsServiceException, SdkClientException, AlexaForBusinessException {
        return searchDevicesPaginator(SearchDevicesRequest.builder().applyMutation(searchDevicesRequest).build());
    }

    /**
     * <p>
     * Searches network profiles and lists the ones that meet a set of filter and sort criteria.
     * </p>
     *
     * @param searchNetworkProfilesRequest
     * @return Result of the SearchNetworkProfiles operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AlexaForBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AlexaForBusinessClient.SearchNetworkProfiles
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/SearchNetworkProfiles"
     *      target="_top">AWS API Documentation</a>
     */
    default SearchNetworkProfilesResponse searchNetworkProfiles(SearchNetworkProfilesRequest searchNetworkProfilesRequest)
            throws AwsServiceException, SdkClientException, AlexaForBusinessException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Searches network profiles and lists the ones that meet a set of filter and sort criteria.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link SearchNetworkProfilesRequest.Builder} avoiding the
     * need to create one manually via {@link SearchNetworkProfilesRequest#builder()}
     * </p>
     *
     * @param searchNetworkProfilesRequest
     *        A {@link Consumer} that will call methods on {@link SearchNetworkProfilesRequest.Builder} to create a
     *        request.
     * @return Result of the SearchNetworkProfiles operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AlexaForBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AlexaForBusinessClient.SearchNetworkProfiles
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/SearchNetworkProfiles"
     *      target="_top">AWS API Documentation</a>
     */
    default SearchNetworkProfilesResponse searchNetworkProfiles(
            Consumer<SearchNetworkProfilesRequest.Builder> searchNetworkProfilesRequest) throws AwsServiceException,
            SdkClientException, AlexaForBusinessException {
        return searchNetworkProfiles(SearchNetworkProfilesRequest.builder().applyMutation(searchNetworkProfilesRequest).build());
    }

    /**
     * <p>
     * Searches network profiles and lists the ones that meet a set of filter and sort criteria.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #searchNetworkProfiles(software.amazon.awssdk.services.alexaforbusiness.model.SearchNetworkProfilesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.alexaforbusiness.paginators.SearchNetworkProfilesIterable responses = client.searchNetworkProfilesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.alexaforbusiness.paginators.SearchNetworkProfilesIterable responses = client
     *             .searchNetworkProfilesPaginator(request);
     *     for (software.amazon.awssdk.services.alexaforbusiness.model.SearchNetworkProfilesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.alexaforbusiness.paginators.SearchNetworkProfilesIterable responses = client.searchNetworkProfilesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #searchNetworkProfiles(software.amazon.awssdk.services.alexaforbusiness.model.SearchNetworkProfilesRequest)}
     * operation.</b>
     * </p>
     *
     * @param searchNetworkProfilesRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AlexaForBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AlexaForBusinessClient.SearchNetworkProfiles
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/SearchNetworkProfiles"
     *      target="_top">AWS API Documentation</a>
     */
    default SearchNetworkProfilesIterable searchNetworkProfilesPaginator(SearchNetworkProfilesRequest searchNetworkProfilesRequest)
            throws AwsServiceException, SdkClientException, AlexaForBusinessException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Searches network profiles and lists the ones that meet a set of filter and sort criteria.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #searchNetworkProfiles(software.amazon.awssdk.services.alexaforbusiness.model.SearchNetworkProfilesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.alexaforbusiness.paginators.SearchNetworkProfilesIterable responses = client.searchNetworkProfilesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.alexaforbusiness.paginators.SearchNetworkProfilesIterable responses = client
     *             .searchNetworkProfilesPaginator(request);
     *     for (software.amazon.awssdk.services.alexaforbusiness.model.SearchNetworkProfilesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.alexaforbusiness.paginators.SearchNetworkProfilesIterable responses = client.searchNetworkProfilesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #searchNetworkProfiles(software.amazon.awssdk.services.alexaforbusiness.model.SearchNetworkProfilesRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link SearchNetworkProfilesRequest.Builder} avoiding the
     * need to create one manually via {@link SearchNetworkProfilesRequest#builder()}
     * </p>
     *
     * @param searchNetworkProfilesRequest
     *        A {@link Consumer} that will call methods on {@link SearchNetworkProfilesRequest.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AlexaForBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AlexaForBusinessClient.SearchNetworkProfiles
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/SearchNetworkProfiles"
     *      target="_top">AWS API Documentation</a>
     */
    default SearchNetworkProfilesIterable searchNetworkProfilesPaginator(
            Consumer<SearchNetworkProfilesRequest.Builder> searchNetworkProfilesRequest) throws AwsServiceException,
            SdkClientException, AlexaForBusinessException {
        return searchNetworkProfilesPaginator(SearchNetworkProfilesRequest.builder().applyMutation(searchNetworkProfilesRequest)
                .build());
    }

    /**
     * <p>
     * Searches room profiles and lists the ones that meet a set of filter criteria.
     * </p>
     *
     * @param searchProfilesRequest
     * @return Result of the SearchProfiles operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AlexaForBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AlexaForBusinessClient.SearchProfiles
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/SearchProfiles"
     *      target="_top">AWS API Documentation</a>
     */
    default SearchProfilesResponse searchProfiles(SearchProfilesRequest searchProfilesRequest) throws AwsServiceException,
            SdkClientException, AlexaForBusinessException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Searches room profiles and lists the ones that meet a set of filter criteria.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link SearchProfilesRequest.Builder} avoiding the need to
     * create one manually via {@link SearchProfilesRequest#builder()}
     * </p>
     *
     * @param searchProfilesRequest
     *        A {@link Consumer} that will call methods on {@link SearchProfilesRequest.Builder} to create a request.
     * @return Result of the SearchProfiles operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AlexaForBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AlexaForBusinessClient.SearchProfiles
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/SearchProfiles"
     *      target="_top">AWS API Documentation</a>
     */
    default SearchProfilesResponse searchProfiles(Consumer<SearchProfilesRequest.Builder> searchProfilesRequest)
            throws AwsServiceException, SdkClientException, AlexaForBusinessException {
        return searchProfiles(SearchProfilesRequest.builder().applyMutation(searchProfilesRequest).build());
    }

    /**
     * <p>
     * Searches room profiles and lists the ones that meet a set of filter criteria.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #searchProfiles(software.amazon.awssdk.services.alexaforbusiness.model.SearchProfilesRequest)} operation.
     * The return type is a custom iterable that can be used to iterate through all the pages. SDK will internally
     * handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.alexaforbusiness.paginators.SearchProfilesIterable responses = client.searchProfilesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.alexaforbusiness.paginators.SearchProfilesIterable responses = client
     *             .searchProfilesPaginator(request);
     *     for (software.amazon.awssdk.services.alexaforbusiness.model.SearchProfilesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.alexaforbusiness.paginators.SearchProfilesIterable responses = client.searchProfilesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #searchProfiles(software.amazon.awssdk.services.alexaforbusiness.model.SearchProfilesRequest)}
     * operation.</b>
     * </p>
     *
     * @param searchProfilesRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AlexaForBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AlexaForBusinessClient.SearchProfiles
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/SearchProfiles"
     *      target="_top">AWS API Documentation</a>
     */
    default SearchProfilesIterable searchProfilesPaginator(SearchProfilesRequest searchProfilesRequest)
            throws AwsServiceException, SdkClientException, AlexaForBusinessException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Searches room profiles and lists the ones that meet a set of filter criteria.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #searchProfiles(software.amazon.awssdk.services.alexaforbusiness.model.SearchProfilesRequest)} operation.
     * The return type is a custom iterable that can be used to iterate through all the pages. SDK will internally
     * handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.alexaforbusiness.paginators.SearchProfilesIterable responses = client.searchProfilesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.alexaforbusiness.paginators.SearchProfilesIterable responses = client
     *             .searchProfilesPaginator(request);
     *     for (software.amazon.awssdk.services.alexaforbusiness.model.SearchProfilesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.alexaforbusiness.paginators.SearchProfilesIterable responses = client.searchProfilesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #searchProfiles(software.amazon.awssdk.services.alexaforbusiness.model.SearchProfilesRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link SearchProfilesRequest.Builder} avoiding the need to
     * create one manually via {@link SearchProfilesRequest#builder()}
     * </p>
     *
     * @param searchProfilesRequest
     *        A {@link Consumer} that will call methods on {@link SearchProfilesRequest.Builder} to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AlexaForBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AlexaForBusinessClient.SearchProfiles
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/SearchProfiles"
     *      target="_top">AWS API Documentation</a>
     */
    default SearchProfilesIterable searchProfilesPaginator(Consumer<SearchProfilesRequest.Builder> searchProfilesRequest)
            throws AwsServiceException, SdkClientException, AlexaForBusinessException {
        return searchProfilesPaginator(SearchProfilesRequest.builder().applyMutation(searchProfilesRequest).build());
    }

    /**
     * <p>
     * Searches rooms and lists the ones that meet a set of filter and sort criteria.
     * </p>
     *
     * @param searchRoomsRequest
     * @return Result of the SearchRooms operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AlexaForBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AlexaForBusinessClient.SearchRooms
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/SearchRooms" target="_top">AWS
     *      API Documentation</a>
     */
    default SearchRoomsResponse searchRooms(SearchRoomsRequest searchRoomsRequest) throws AwsServiceException,
            SdkClientException, AlexaForBusinessException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Searches rooms and lists the ones that meet a set of filter and sort criteria.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link SearchRoomsRequest.Builder} avoiding the need to
     * create one manually via {@link SearchRoomsRequest#builder()}
     * </p>
     *
     * @param searchRoomsRequest
     *        A {@link Consumer} that will call methods on {@link SearchRoomsRequest.Builder} to create a request.
     * @return Result of the SearchRooms operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AlexaForBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AlexaForBusinessClient.SearchRooms
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/SearchRooms" target="_top">AWS
     *      API Documentation</a>
     */
    default SearchRoomsResponse searchRooms(Consumer<SearchRoomsRequest.Builder> searchRoomsRequest) throws AwsServiceException,
            SdkClientException, AlexaForBusinessException {
        return searchRooms(SearchRoomsRequest.builder().applyMutation(searchRoomsRequest).build());
    }

    /**
     * <p>
     * Searches rooms and lists the ones that meet a set of filter and sort criteria.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #searchRooms(software.amazon.awssdk.services.alexaforbusiness.model.SearchRoomsRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.alexaforbusiness.paginators.SearchRoomsIterable responses = client.searchRoomsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.alexaforbusiness.paginators.SearchRoomsIterable responses = client
     *             .searchRoomsPaginator(request);
     *     for (software.amazon.awssdk.services.alexaforbusiness.model.SearchRoomsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.alexaforbusiness.paginators.SearchRoomsIterable responses = client.searchRoomsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #searchRooms(software.amazon.awssdk.services.alexaforbusiness.model.SearchRoomsRequest)} operation.</b>
     * </p>
     *
     * @param searchRoomsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AlexaForBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AlexaForBusinessClient.SearchRooms
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/SearchRooms" target="_top">AWS
     *      API Documentation</a>
     */
    default SearchRoomsIterable searchRoomsPaginator(SearchRoomsRequest searchRoomsRequest) throws AwsServiceException,
            SdkClientException, AlexaForBusinessException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Searches rooms and lists the ones that meet a set of filter and sort criteria.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #searchRooms(software.amazon.awssdk.services.alexaforbusiness.model.SearchRoomsRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.alexaforbusiness.paginators.SearchRoomsIterable responses = client.searchRoomsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.alexaforbusiness.paginators.SearchRoomsIterable responses = client
     *             .searchRoomsPaginator(request);
     *     for (software.amazon.awssdk.services.alexaforbusiness.model.SearchRoomsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.alexaforbusiness.paginators.SearchRoomsIterable responses = client.searchRoomsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #searchRooms(software.amazon.awssdk.services.alexaforbusiness.model.SearchRoomsRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link SearchRoomsRequest.Builder} avoiding the need to
     * create one manually via {@link SearchRoomsRequest#builder()}
     * </p>
     *
     * @param searchRoomsRequest
     *        A {@link Consumer} that will call methods on {@link SearchRoomsRequest.Builder} to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AlexaForBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AlexaForBusinessClient.SearchRooms
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/SearchRooms" target="_top">AWS
     *      API Documentation</a>
     */
    default SearchRoomsIterable searchRoomsPaginator(Consumer<SearchRoomsRequest.Builder> searchRoomsRequest)
            throws AwsServiceException, SdkClientException, AlexaForBusinessException {
        return searchRoomsPaginator(SearchRoomsRequest.builder().applyMutation(searchRoomsRequest).build());
    }

    /**
     * <p>
     * Searches skill groups and lists the ones that meet a set of filter and sort criteria.
     * </p>
     *
     * @param searchSkillGroupsRequest
     * @return Result of the SearchSkillGroups operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AlexaForBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AlexaForBusinessClient.SearchSkillGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/SearchSkillGroups"
     *      target="_top">AWS API Documentation</a>
     */
    default SearchSkillGroupsResponse searchSkillGroups(SearchSkillGroupsRequest searchSkillGroupsRequest)
            throws AwsServiceException, SdkClientException, AlexaForBusinessException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Searches skill groups and lists the ones that meet a set of filter and sort criteria.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link SearchSkillGroupsRequest.Builder} avoiding the need
     * to create one manually via {@link SearchSkillGroupsRequest#builder()}
     * </p>
     *
     * @param searchSkillGroupsRequest
     *        A {@link Consumer} that will call methods on {@link SearchSkillGroupsRequest.Builder} to create a request.
     * @return Result of the SearchSkillGroups operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AlexaForBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AlexaForBusinessClient.SearchSkillGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/SearchSkillGroups"
     *      target="_top">AWS API Documentation</a>
     */
    default SearchSkillGroupsResponse searchSkillGroups(Consumer<SearchSkillGroupsRequest.Builder> searchSkillGroupsRequest)
            throws AwsServiceException, SdkClientException, AlexaForBusinessException {
        return searchSkillGroups(SearchSkillGroupsRequest.builder().applyMutation(searchSkillGroupsRequest).build());
    }

    /**
     * <p>
     * Searches skill groups and lists the ones that meet a set of filter and sort criteria.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #searchSkillGroups(software.amazon.awssdk.services.alexaforbusiness.model.SearchSkillGroupsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.alexaforbusiness.paginators.SearchSkillGroupsIterable responses = client.searchSkillGroupsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.alexaforbusiness.paginators.SearchSkillGroupsIterable responses = client
     *             .searchSkillGroupsPaginator(request);
     *     for (software.amazon.awssdk.services.alexaforbusiness.model.SearchSkillGroupsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.alexaforbusiness.paginators.SearchSkillGroupsIterable responses = client.searchSkillGroupsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #searchSkillGroups(software.amazon.awssdk.services.alexaforbusiness.model.SearchSkillGroupsRequest)}
     * operation.</b>
     * </p>
     *
     * @param searchSkillGroupsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AlexaForBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AlexaForBusinessClient.SearchSkillGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/SearchSkillGroups"
     *      target="_top">AWS API Documentation</a>
     */
    default SearchSkillGroupsIterable searchSkillGroupsPaginator(SearchSkillGroupsRequest searchSkillGroupsRequest)
            throws AwsServiceException, SdkClientException, AlexaForBusinessException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Searches skill groups and lists the ones that meet a set of filter and sort criteria.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #searchSkillGroups(software.amazon.awssdk.services.alexaforbusiness.model.SearchSkillGroupsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.alexaforbusiness.paginators.SearchSkillGroupsIterable responses = client.searchSkillGroupsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.alexaforbusiness.paginators.SearchSkillGroupsIterable responses = client
     *             .searchSkillGroupsPaginator(request);
     *     for (software.amazon.awssdk.services.alexaforbusiness.model.SearchSkillGroupsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.alexaforbusiness.paginators.SearchSkillGroupsIterable responses = client.searchSkillGroupsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #searchSkillGroups(software.amazon.awssdk.services.alexaforbusiness.model.SearchSkillGroupsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link SearchSkillGroupsRequest.Builder} avoiding the need
     * to create one manually via {@link SearchSkillGroupsRequest#builder()}
     * </p>
     *
     * @param searchSkillGroupsRequest
     *        A {@link Consumer} that will call methods on {@link SearchSkillGroupsRequest.Builder} to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AlexaForBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AlexaForBusinessClient.SearchSkillGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/SearchSkillGroups"
     *      target="_top">AWS API Documentation</a>
     */
    default SearchSkillGroupsIterable searchSkillGroupsPaginator(
            Consumer<SearchSkillGroupsRequest.Builder> searchSkillGroupsRequest) throws AwsServiceException, SdkClientException,
            AlexaForBusinessException {
        return searchSkillGroupsPaginator(SearchSkillGroupsRequest.builder().applyMutation(searchSkillGroupsRequest).build());
    }

    /**
     * <p>
     * Searches users and lists the ones that meet a set of filter and sort criteria.
     * </p>
     *
     * @param searchUsersRequest
     * @return Result of the SearchUsers operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AlexaForBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AlexaForBusinessClient.SearchUsers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/SearchUsers" target="_top">AWS
     *      API Documentation</a>
     */
    default SearchUsersResponse searchUsers(SearchUsersRequest searchUsersRequest) throws AwsServiceException,
            SdkClientException, AlexaForBusinessException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Searches users and lists the ones that meet a set of filter and sort criteria.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link SearchUsersRequest.Builder} avoiding the need to
     * create one manually via {@link SearchUsersRequest#builder()}
     * </p>
     *
     * @param searchUsersRequest
     *        A {@link Consumer} that will call methods on {@link SearchUsersRequest.Builder} to create a request.
     * @return Result of the SearchUsers operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AlexaForBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AlexaForBusinessClient.SearchUsers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/SearchUsers" target="_top">AWS
     *      API Documentation</a>
     */
    default SearchUsersResponse searchUsers(Consumer<SearchUsersRequest.Builder> searchUsersRequest) throws AwsServiceException,
            SdkClientException, AlexaForBusinessException {
        return searchUsers(SearchUsersRequest.builder().applyMutation(searchUsersRequest).build());
    }

    /**
     * <p>
     * Searches users and lists the ones that meet a set of filter and sort criteria.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #searchUsers(software.amazon.awssdk.services.alexaforbusiness.model.SearchUsersRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.alexaforbusiness.paginators.SearchUsersIterable responses = client.searchUsersPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.alexaforbusiness.paginators.SearchUsersIterable responses = client
     *             .searchUsersPaginator(request);
     *     for (software.amazon.awssdk.services.alexaforbusiness.model.SearchUsersResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.alexaforbusiness.paginators.SearchUsersIterable responses = client.searchUsersPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #searchUsers(software.amazon.awssdk.services.alexaforbusiness.model.SearchUsersRequest)} operation.</b>
     * </p>
     *
     * @param searchUsersRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AlexaForBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AlexaForBusinessClient.SearchUsers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/SearchUsers" target="_top">AWS
     *      API Documentation</a>
     */
    default SearchUsersIterable searchUsersPaginator(SearchUsersRequest searchUsersRequest) throws AwsServiceException,
            SdkClientException, AlexaForBusinessException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Searches users and lists the ones that meet a set of filter and sort criteria.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #searchUsers(software.amazon.awssdk.services.alexaforbusiness.model.SearchUsersRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.alexaforbusiness.paginators.SearchUsersIterable responses = client.searchUsersPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.alexaforbusiness.paginators.SearchUsersIterable responses = client
     *             .searchUsersPaginator(request);
     *     for (software.amazon.awssdk.services.alexaforbusiness.model.SearchUsersResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.alexaforbusiness.paginators.SearchUsersIterable responses = client.searchUsersPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #searchUsers(software.amazon.awssdk.services.alexaforbusiness.model.SearchUsersRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link SearchUsersRequest.Builder} avoiding the need to
     * create one manually via {@link SearchUsersRequest#builder()}
     * </p>
     *
     * @param searchUsersRequest
     *        A {@link Consumer} that will call methods on {@link SearchUsersRequest.Builder} to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AlexaForBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AlexaForBusinessClient.SearchUsers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/SearchUsers" target="_top">AWS
     *      API Documentation</a>
     */
    default SearchUsersIterable searchUsersPaginator(Consumer<SearchUsersRequest.Builder> searchUsersRequest)
            throws AwsServiceException, SdkClientException, AlexaForBusinessException {
        return searchUsersPaginator(SearchUsersRequest.builder().applyMutation(searchUsersRequest).build());
    }

    /**
     * <p>
     * Triggers an asynchronous flow to send text, SSML, or audio announcements to rooms that are identified by a search
     * or filter.
     * </p>
     *
     * @param sendAnnouncementRequest
     * @return Result of the SendAnnouncement operation returned by the service.
     * @throws LimitExceededException
     *         You are performing an action that would put you beyond your account's limits.
     * @throws AlreadyExistsException
     *         The resource being created already exists.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AlexaForBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AlexaForBusinessClient.SendAnnouncement
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/SendAnnouncement"
     *      target="_top">AWS API Documentation</a>
     */
    default SendAnnouncementResponse sendAnnouncement(SendAnnouncementRequest sendAnnouncementRequest)
            throws LimitExceededException, AlreadyExistsException, AwsServiceException, SdkClientException,
            AlexaForBusinessException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Triggers an asynchronous flow to send text, SSML, or audio announcements to rooms that are identified by a search
     * or filter.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link SendAnnouncementRequest.Builder} avoiding the need
     * to create one manually via {@link SendAnnouncementRequest#builder()}
     * </p>
     *
     * @param sendAnnouncementRequest
     *        A {@link Consumer} that will call methods on {@link SendAnnouncementRequest.Builder} to create a request.
     * @return Result of the SendAnnouncement operation returned by the service.
     * @throws LimitExceededException
     *         You are performing an action that would put you beyond your account's limits.
     * @throws AlreadyExistsException
     *         The resource being created already exists.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AlexaForBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AlexaForBusinessClient.SendAnnouncement
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/SendAnnouncement"
     *      target="_top">AWS API Documentation</a>
     */
    default SendAnnouncementResponse sendAnnouncement(Consumer<SendAnnouncementRequest.Builder> sendAnnouncementRequest)
            throws LimitExceededException, AlreadyExistsException, AwsServiceException, SdkClientException,
            AlexaForBusinessException {
        return sendAnnouncement(SendAnnouncementRequest.builder().applyMutation(sendAnnouncementRequest).build());
    }

    /**
     * <p>
     * Sends an enrollment invitation email with a URL to a user. The URL is valid for 30 days or until you call this
     * operation again, whichever comes first.
     * </p>
     *
     * @param sendInvitationRequest
     * @return Result of the SendInvitation operation returned by the service.
     * @throws NotFoundException
     *         The resource is not found.
     * @throws InvalidUserStatusException
     *         The attempt to update a user is invalid due to the user's current status.
     * @throws ConcurrentModificationException
     *         There is a concurrent modification of resources.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AlexaForBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AlexaForBusinessClient.SendInvitation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/SendInvitation"
     *      target="_top">AWS API Documentation</a>
     */
    default SendInvitationResponse sendInvitation(SendInvitationRequest sendInvitationRequest) throws NotFoundException,
            InvalidUserStatusException, ConcurrentModificationException, AwsServiceException, SdkClientException,
            AlexaForBusinessException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Sends an enrollment invitation email with a URL to a user. The URL is valid for 30 days or until you call this
     * operation again, whichever comes first.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link SendInvitationRequest.Builder} avoiding the need to
     * create one manually via {@link SendInvitationRequest#builder()}
     * </p>
     *
     * @param sendInvitationRequest
     *        A {@link Consumer} that will call methods on {@link SendInvitationRequest.Builder} to create a request.
     * @return Result of the SendInvitation operation returned by the service.
     * @throws NotFoundException
     *         The resource is not found.
     * @throws InvalidUserStatusException
     *         The attempt to update a user is invalid due to the user's current status.
     * @throws ConcurrentModificationException
     *         There is a concurrent modification of resources.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AlexaForBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AlexaForBusinessClient.SendInvitation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/SendInvitation"
     *      target="_top">AWS API Documentation</a>
     */
    default SendInvitationResponse sendInvitation(Consumer<SendInvitationRequest.Builder> sendInvitationRequest)
            throws NotFoundException, InvalidUserStatusException, ConcurrentModificationException, AwsServiceException,
            SdkClientException, AlexaForBusinessException {
        return sendInvitation(SendInvitationRequest.builder().applyMutation(sendInvitationRequest).build());
    }

    /**
     * <p>
     * Resets a device and its account to the known default settings. This clears all information and settings set by
     * previous users in the following ways:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Bluetooth - This unpairs all bluetooth devices paired with your echo device.
     * </p>
     * </li>
     * <li>
     * <p>
     * Volume - This resets the echo device's volume to the default value.
     * </p>
     * </li>
     * <li>
     * <p>
     * Notifications - This clears all notifications from your echo device.
     * </p>
     * </li>
     * <li>
     * <p>
     * Lists - This clears all to-do items from your echo device.
     * </p>
     * </li>
     * <li>
     * <p>
     * Settings - This internally syncs the room's profile (if the device is assigned to a room), contacts, address
     * books, delegation access for account linking, and communications (if enabled on the room profile).
     * </p>
     * </li>
     * </ul>
     *
     * @param startDeviceSyncRequest
     * @return Result of the StartDeviceSync operation returned by the service.
     * @throws DeviceNotRegisteredException
     *         The request failed because this device is no longer registered and therefore no longer managed by this
     *         account.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AlexaForBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AlexaForBusinessClient.StartDeviceSync
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/StartDeviceSync"
     *      target="_top">AWS API Documentation</a>
     */
    default StartDeviceSyncResponse startDeviceSync(StartDeviceSyncRequest startDeviceSyncRequest)
            throws DeviceNotRegisteredException, AwsServiceException, SdkClientException, AlexaForBusinessException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Resets a device and its account to the known default settings. This clears all information and settings set by
     * previous users in the following ways:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Bluetooth - This unpairs all bluetooth devices paired with your echo device.
     * </p>
     * </li>
     * <li>
     * <p>
     * Volume - This resets the echo device's volume to the default value.
     * </p>
     * </li>
     * <li>
     * <p>
     * Notifications - This clears all notifications from your echo device.
     * </p>
     * </li>
     * <li>
     * <p>
     * Lists - This clears all to-do items from your echo device.
     * </p>
     * </li>
     * <li>
     * <p>
     * Settings - This internally syncs the room's profile (if the device is assigned to a room), contacts, address
     * books, delegation access for account linking, and communications (if enabled on the room profile).
     * </p>
     * </li>
     * </ul>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StartDeviceSyncRequest.Builder} avoiding the need
     * to create one manually via {@link StartDeviceSyncRequest#builder()}
     * </p>
     *
     * @param startDeviceSyncRequest
     *        A {@link Consumer} that will call methods on {@link StartDeviceSyncRequest.Builder} to create a request.
     * @return Result of the StartDeviceSync operation returned by the service.
     * @throws DeviceNotRegisteredException
     *         The request failed because this device is no longer registered and therefore no longer managed by this
     *         account.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AlexaForBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AlexaForBusinessClient.StartDeviceSync
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/StartDeviceSync"
     *      target="_top">AWS API Documentation</a>
     */
    default StartDeviceSyncResponse startDeviceSync(Consumer<StartDeviceSyncRequest.Builder> startDeviceSyncRequest)
            throws DeviceNotRegisteredException, AwsServiceException, SdkClientException, AlexaForBusinessException {
        return startDeviceSync(StartDeviceSyncRequest.builder().applyMutation(startDeviceSyncRequest).build());
    }

    /**
     * <p>
     * Initiates the discovery of any smart home appliances associated with the room.
     * </p>
     *
     * @param startSmartHomeApplianceDiscoveryRequest
     * @return Result of the StartSmartHomeApplianceDiscovery operation returned by the service.
     * @throws NotFoundException
     *         The resource is not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AlexaForBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AlexaForBusinessClient.StartSmartHomeApplianceDiscovery
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/StartSmartHomeApplianceDiscovery"
     *      target="_top">AWS API Documentation</a>
     */
    default StartSmartHomeApplianceDiscoveryResponse startSmartHomeApplianceDiscovery(
            StartSmartHomeApplianceDiscoveryRequest startSmartHomeApplianceDiscoveryRequest) throws NotFoundException,
            AwsServiceException, SdkClientException, AlexaForBusinessException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Initiates the discovery of any smart home appliances associated with the room.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StartSmartHomeApplianceDiscoveryRequest.Builder}
     * avoiding the need to create one manually via {@link StartSmartHomeApplianceDiscoveryRequest#builder()}
     * </p>
     *
     * @param startSmartHomeApplianceDiscoveryRequest
     *        A {@link Consumer} that will call methods on {@link StartSmartHomeApplianceDiscoveryRequest.Builder} to
     *        create a request.
     * @return Result of the StartSmartHomeApplianceDiscovery operation returned by the service.
     * @throws NotFoundException
     *         The resource is not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AlexaForBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AlexaForBusinessClient.StartSmartHomeApplianceDiscovery
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/StartSmartHomeApplianceDiscovery"
     *      target="_top">AWS API Documentation</a>
     */
    default StartSmartHomeApplianceDiscoveryResponse startSmartHomeApplianceDiscovery(
            Consumer<StartSmartHomeApplianceDiscoveryRequest.Builder> startSmartHomeApplianceDiscoveryRequest)
            throws NotFoundException, AwsServiceException, SdkClientException, AlexaForBusinessException {
        return startSmartHomeApplianceDiscovery(StartSmartHomeApplianceDiscoveryRequest.builder()
                .applyMutation(startSmartHomeApplianceDiscoveryRequest).build());
    }

    /**
     * <p>
     * Adds metadata tags to a specified resource.
     * </p>
     *
     * @param tagResourceRequest
     * @return Result of the TagResource operation returned by the service.
     * @throws NotFoundException
     *         The resource is not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AlexaForBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AlexaForBusinessClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/TagResource" target="_top">AWS
     *      API Documentation</a>
     */
    default TagResourceResponse tagResource(TagResourceRequest tagResourceRequest) throws NotFoundException, AwsServiceException,
            SdkClientException, AlexaForBusinessException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Adds metadata tags to a specified resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link TagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link TagResourceRequest#builder()}
     * </p>
     *
     * @param tagResourceRequest
     *        A {@link Consumer} that will call methods on {@link TagResourceRequest.Builder} to create a request.
     * @return Result of the TagResource operation returned by the service.
     * @throws NotFoundException
     *         The resource is not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AlexaForBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AlexaForBusinessClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/TagResource" target="_top">AWS
     *      API Documentation</a>
     */
    default TagResourceResponse tagResource(Consumer<TagResourceRequest.Builder> tagResourceRequest) throws NotFoundException,
            AwsServiceException, SdkClientException, AlexaForBusinessException {
        return tagResource(TagResourceRequest.builder().applyMutation(tagResourceRequest).build());
    }

    /**
     * <p>
     * Removes metadata tags from a specified resource.
     * </p>
     *
     * @param untagResourceRequest
     * @return Result of the UntagResource operation returned by the service.
     * @throws NotFoundException
     *         The resource is not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AlexaForBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AlexaForBusinessClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/UntagResource"
     *      target="_top">AWS API Documentation</a>
     */
    default UntagResourceResponse untagResource(UntagResourceRequest untagResourceRequest) throws NotFoundException,
            AwsServiceException, SdkClientException, AlexaForBusinessException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Removes metadata tags from a specified resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UntagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link UntagResourceRequest#builder()}
     * </p>
     *
     * @param untagResourceRequest
     *        A {@link Consumer} that will call methods on {@link UntagResourceRequest.Builder} to create a request.
     * @return Result of the UntagResource operation returned by the service.
     * @throws NotFoundException
     *         The resource is not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AlexaForBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AlexaForBusinessClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/UntagResource"
     *      target="_top">AWS API Documentation</a>
     */
    default UntagResourceResponse untagResource(Consumer<UntagResourceRequest.Builder> untagResourceRequest)
            throws NotFoundException, AwsServiceException, SdkClientException, AlexaForBusinessException {
        return untagResource(UntagResourceRequest.builder().applyMutation(untagResourceRequest).build());
    }

    /**
     * <p>
     * Updates address book details by the address book ARN.
     * </p>
     *
     * @param updateAddressBookRequest
     * @return Result of the UpdateAddressBook operation returned by the service.
     * @throws NotFoundException
     *         The resource is not found.
     * @throws NameInUseException
     *         The name sent in the request is already in use.
     * @throws ConcurrentModificationException
     *         There is a concurrent modification of resources.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AlexaForBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AlexaForBusinessClient.UpdateAddressBook
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/UpdateAddressBook"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateAddressBookResponse updateAddressBook(UpdateAddressBookRequest updateAddressBookRequest)
            throws NotFoundException, NameInUseException, ConcurrentModificationException, AwsServiceException,
            SdkClientException, AlexaForBusinessException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates address book details by the address book ARN.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateAddressBookRequest.Builder} avoiding the need
     * to create one manually via {@link UpdateAddressBookRequest#builder()}
     * </p>
     *
     * @param updateAddressBookRequest
     *        A {@link Consumer} that will call methods on {@link UpdateAddressBookRequest.Builder} to create a request.
     * @return Result of the UpdateAddressBook operation returned by the service.
     * @throws NotFoundException
     *         The resource is not found.
     * @throws NameInUseException
     *         The name sent in the request is already in use.
     * @throws ConcurrentModificationException
     *         There is a concurrent modification of resources.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AlexaForBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AlexaForBusinessClient.UpdateAddressBook
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/UpdateAddressBook"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateAddressBookResponse updateAddressBook(Consumer<UpdateAddressBookRequest.Builder> updateAddressBookRequest)
            throws NotFoundException, NameInUseException, ConcurrentModificationException, AwsServiceException,
            SdkClientException, AlexaForBusinessException {
        return updateAddressBook(UpdateAddressBookRequest.builder().applyMutation(updateAddressBookRequest).build());
    }

    /**
     * <p>
     * Updates the configuration of the report delivery schedule with the specified schedule ARN.
     * </p>
     *
     * @param updateBusinessReportScheduleRequest
     * @return Result of the UpdateBusinessReportSchedule operation returned by the service.
     * @throws NotFoundException
     *         The resource is not found.
     * @throws ConcurrentModificationException
     *         There is a concurrent modification of resources.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AlexaForBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AlexaForBusinessClient.UpdateBusinessReportSchedule
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/UpdateBusinessReportSchedule"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateBusinessReportScheduleResponse updateBusinessReportSchedule(
            UpdateBusinessReportScheduleRequest updateBusinessReportScheduleRequest) throws NotFoundException,
            ConcurrentModificationException, AwsServiceException, SdkClientException, AlexaForBusinessException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the configuration of the report delivery schedule with the specified schedule ARN.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateBusinessReportScheduleRequest.Builder}
     * avoiding the need to create one manually via {@link UpdateBusinessReportScheduleRequest#builder()}
     * </p>
     *
     * @param updateBusinessReportScheduleRequest
     *        A {@link Consumer} that will call methods on {@link UpdateBusinessReportScheduleRequest.Builder} to create
     *        a request.
     * @return Result of the UpdateBusinessReportSchedule operation returned by the service.
     * @throws NotFoundException
     *         The resource is not found.
     * @throws ConcurrentModificationException
     *         There is a concurrent modification of resources.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AlexaForBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AlexaForBusinessClient.UpdateBusinessReportSchedule
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/UpdateBusinessReportSchedule"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateBusinessReportScheduleResponse updateBusinessReportSchedule(
            Consumer<UpdateBusinessReportScheduleRequest.Builder> updateBusinessReportScheduleRequest) throws NotFoundException,
            ConcurrentModificationException, AwsServiceException, SdkClientException, AlexaForBusinessException {
        return updateBusinessReportSchedule(UpdateBusinessReportScheduleRequest.builder()
                .applyMutation(updateBusinessReportScheduleRequest).build());
    }

    /**
     * <p>
     * Updates an existing conference provider's settings.
     * </p>
     *
     * @param updateConferenceProviderRequest
     * @return Result of the UpdateConferenceProvider operation returned by the service.
     * @throws NotFoundException
     *         The resource is not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AlexaForBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AlexaForBusinessClient.UpdateConferenceProvider
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/UpdateConferenceProvider"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateConferenceProviderResponse updateConferenceProvider(
            UpdateConferenceProviderRequest updateConferenceProviderRequest) throws NotFoundException, AwsServiceException,
            SdkClientException, AlexaForBusinessException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates an existing conference provider's settings.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateConferenceProviderRequest.Builder} avoiding
     * the need to create one manually via {@link UpdateConferenceProviderRequest#builder()}
     * </p>
     *
     * @param updateConferenceProviderRequest
     *        A {@link Consumer} that will call methods on {@link UpdateConferenceProviderRequest.Builder} to create a
     *        request.
     * @return Result of the UpdateConferenceProvider operation returned by the service.
     * @throws NotFoundException
     *         The resource is not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AlexaForBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AlexaForBusinessClient.UpdateConferenceProvider
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/UpdateConferenceProvider"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateConferenceProviderResponse updateConferenceProvider(
            Consumer<UpdateConferenceProviderRequest.Builder> updateConferenceProviderRequest) throws NotFoundException,
            AwsServiceException, SdkClientException, AlexaForBusinessException {
        return updateConferenceProvider(UpdateConferenceProviderRequest.builder().applyMutation(updateConferenceProviderRequest)
                .build());
    }

    /**
     * <p>
     * Updates the contact details by the contact ARN.
     * </p>
     *
     * @param updateContactRequest
     * @return Result of the UpdateContact operation returned by the service.
     * @throws NotFoundException
     *         The resource is not found.
     * @throws ConcurrentModificationException
     *         There is a concurrent modification of resources.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AlexaForBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AlexaForBusinessClient.UpdateContact
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/UpdateContact"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateContactResponse updateContact(UpdateContactRequest updateContactRequest) throws NotFoundException,
            ConcurrentModificationException, AwsServiceException, SdkClientException, AlexaForBusinessException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the contact details by the contact ARN.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateContactRequest.Builder} avoiding the need to
     * create one manually via {@link UpdateContactRequest#builder()}
     * </p>
     *
     * @param updateContactRequest
     *        A {@link Consumer} that will call methods on {@link UpdateContactRequest.Builder} to create a request.
     * @return Result of the UpdateContact operation returned by the service.
     * @throws NotFoundException
     *         The resource is not found.
     * @throws ConcurrentModificationException
     *         There is a concurrent modification of resources.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AlexaForBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AlexaForBusinessClient.UpdateContact
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/UpdateContact"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateContactResponse updateContact(Consumer<UpdateContactRequest.Builder> updateContactRequest)
            throws NotFoundException, ConcurrentModificationException, AwsServiceException, SdkClientException,
            AlexaForBusinessException {
        return updateContact(UpdateContactRequest.builder().applyMutation(updateContactRequest).build());
    }

    /**
     * <p>
     * Updates the device name by device ARN.
     * </p>
     *
     * @param updateDeviceRequest
     * @return Result of the UpdateDevice operation returned by the service.
     * @throws NotFoundException
     *         The resource is not found.
     * @throws ConcurrentModificationException
     *         There is a concurrent modification of resources.
     * @throws DeviceNotRegisteredException
     *         The request failed because this device is no longer registered and therefore no longer managed by this
     *         account.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AlexaForBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AlexaForBusinessClient.UpdateDevice
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/UpdateDevice" target="_top">AWS
     *      API Documentation</a>
     */
    default UpdateDeviceResponse updateDevice(UpdateDeviceRequest updateDeviceRequest) throws NotFoundException,
            ConcurrentModificationException, DeviceNotRegisteredException, AwsServiceException, SdkClientException,
            AlexaForBusinessException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the device name by device ARN.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateDeviceRequest.Builder} avoiding the need to
     * create one manually via {@link UpdateDeviceRequest#builder()}
     * </p>
     *
     * @param updateDeviceRequest
     *        A {@link Consumer} that will call methods on {@link UpdateDeviceRequest.Builder} to create a request.
     * @return Result of the UpdateDevice operation returned by the service.
     * @throws NotFoundException
     *         The resource is not found.
     * @throws ConcurrentModificationException
     *         There is a concurrent modification of resources.
     * @throws DeviceNotRegisteredException
     *         The request failed because this device is no longer registered and therefore no longer managed by this
     *         account.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AlexaForBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AlexaForBusinessClient.UpdateDevice
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/UpdateDevice" target="_top">AWS
     *      API Documentation</a>
     */
    default UpdateDeviceResponse updateDevice(Consumer<UpdateDeviceRequest.Builder> updateDeviceRequest)
            throws NotFoundException, ConcurrentModificationException, DeviceNotRegisteredException, AwsServiceException,
            SdkClientException, AlexaForBusinessException {
        return updateDevice(UpdateDeviceRequest.builder().applyMutation(updateDeviceRequest).build());
    }

    /**
     * <p>
     * Updates the details of a gateway. If any optional field is not provided, the existing corresponding value is left
     * unmodified.
     * </p>
     *
     * @param updateGatewayRequest
     * @return Result of the UpdateGateway operation returned by the service.
     * @throws NotFoundException
     *         The resource is not found.
     * @throws NameInUseException
     *         The name sent in the request is already in use.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AlexaForBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AlexaForBusinessClient.UpdateGateway
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/UpdateGateway"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateGatewayResponse updateGateway(UpdateGatewayRequest updateGatewayRequest) throws NotFoundException,
            NameInUseException, AwsServiceException, SdkClientException, AlexaForBusinessException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the details of a gateway. If any optional field is not provided, the existing corresponding value is left
     * unmodified.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateGatewayRequest.Builder} avoiding the need to
     * create one manually via {@link UpdateGatewayRequest#builder()}
     * </p>
     *
     * @param updateGatewayRequest
     *        A {@link Consumer} that will call methods on {@link UpdateGatewayRequest.Builder} to create a request.
     * @return Result of the UpdateGateway operation returned by the service.
     * @throws NotFoundException
     *         The resource is not found.
     * @throws NameInUseException
     *         The name sent in the request is already in use.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AlexaForBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AlexaForBusinessClient.UpdateGateway
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/UpdateGateway"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateGatewayResponse updateGateway(Consumer<UpdateGatewayRequest.Builder> updateGatewayRequest)
            throws NotFoundException, NameInUseException, AwsServiceException, SdkClientException, AlexaForBusinessException {
        return updateGateway(UpdateGatewayRequest.builder().applyMutation(updateGatewayRequest).build());
    }

    /**
     * <p>
     * Updates the details of a gateway group. If any optional field is not provided, the existing corresponding value
     * is left unmodified.
     * </p>
     *
     * @param updateGatewayGroupRequest
     * @return Result of the UpdateGatewayGroup operation returned by the service.
     * @throws NotFoundException
     *         The resource is not found.
     * @throws NameInUseException
     *         The name sent in the request is already in use.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AlexaForBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AlexaForBusinessClient.UpdateGatewayGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/UpdateGatewayGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateGatewayGroupResponse updateGatewayGroup(UpdateGatewayGroupRequest updateGatewayGroupRequest)
            throws NotFoundException, NameInUseException, AwsServiceException, SdkClientException, AlexaForBusinessException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the details of a gateway group. If any optional field is not provided, the existing corresponding value
     * is left unmodified.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateGatewayGroupRequest.Builder} avoiding the
     * need to create one manually via {@link UpdateGatewayGroupRequest#builder()}
     * </p>
     *
     * @param updateGatewayGroupRequest
     *        A {@link Consumer} that will call methods on {@link UpdateGatewayGroupRequest.Builder} to create a
     *        request.
     * @return Result of the UpdateGatewayGroup operation returned by the service.
     * @throws NotFoundException
     *         The resource is not found.
     * @throws NameInUseException
     *         The name sent in the request is already in use.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AlexaForBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AlexaForBusinessClient.UpdateGatewayGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/UpdateGatewayGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateGatewayGroupResponse updateGatewayGroup(Consumer<UpdateGatewayGroupRequest.Builder> updateGatewayGroupRequest)
            throws NotFoundException, NameInUseException, AwsServiceException, SdkClientException, AlexaForBusinessException {
        return updateGatewayGroup(UpdateGatewayGroupRequest.builder().applyMutation(updateGatewayGroupRequest).build());
    }

    /**
     * <p>
     * Updates a network profile by the network profile ARN.
     * </p>
     *
     * @param updateNetworkProfileRequest
     * @return Result of the UpdateNetworkProfile operation returned by the service.
     * @throws NotFoundException
     *         The resource is not found.
     * @throws NameInUseException
     *         The name sent in the request is already in use.
     * @throws ConcurrentModificationException
     *         There is a concurrent modification of resources.
     * @throws InvalidCertificateAuthorityException
     *         The Certificate Authority can't issue or revoke a certificate.
     * @throws InvalidSecretsManagerResourceException
     *         A password in SecretsManager is in an invalid state.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AlexaForBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AlexaForBusinessClient.UpdateNetworkProfile
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/UpdateNetworkProfile"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateNetworkProfileResponse updateNetworkProfile(UpdateNetworkProfileRequest updateNetworkProfileRequest)
            throws NotFoundException, NameInUseException, ConcurrentModificationException, InvalidCertificateAuthorityException,
            InvalidSecretsManagerResourceException, AwsServiceException, SdkClientException, AlexaForBusinessException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates a network profile by the network profile ARN.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateNetworkProfileRequest.Builder} avoiding the
     * need to create one manually via {@link UpdateNetworkProfileRequest#builder()}
     * </p>
     *
     * @param updateNetworkProfileRequest
     *        A {@link Consumer} that will call methods on {@link UpdateNetworkProfileRequest.Builder} to create a
     *        request.
     * @return Result of the UpdateNetworkProfile operation returned by the service.
     * @throws NotFoundException
     *         The resource is not found.
     * @throws NameInUseException
     *         The name sent in the request is already in use.
     * @throws ConcurrentModificationException
     *         There is a concurrent modification of resources.
     * @throws InvalidCertificateAuthorityException
     *         The Certificate Authority can't issue or revoke a certificate.
     * @throws InvalidSecretsManagerResourceException
     *         A password in SecretsManager is in an invalid state.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AlexaForBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AlexaForBusinessClient.UpdateNetworkProfile
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/UpdateNetworkProfile"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateNetworkProfileResponse updateNetworkProfile(
            Consumer<UpdateNetworkProfileRequest.Builder> updateNetworkProfileRequest) throws NotFoundException,
            NameInUseException, ConcurrentModificationException, InvalidCertificateAuthorityException,
            InvalidSecretsManagerResourceException, AwsServiceException, SdkClientException, AlexaForBusinessException {
        return updateNetworkProfile(UpdateNetworkProfileRequest.builder().applyMutation(updateNetworkProfileRequest).build());
    }

    /**
     * <p>
     * Updates an existing room profile by room profile ARN.
     * </p>
     *
     * @param updateProfileRequest
     * @return Result of the UpdateProfile operation returned by the service.
     * @throws NotFoundException
     *         The resource is not found.
     * @throws NameInUseException
     *         The name sent in the request is already in use.
     * @throws ConcurrentModificationException
     *         There is a concurrent modification of resources.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AlexaForBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AlexaForBusinessClient.UpdateProfile
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/UpdateProfile"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateProfileResponse updateProfile(UpdateProfileRequest updateProfileRequest) throws NotFoundException,
            NameInUseException, ConcurrentModificationException, AwsServiceException, SdkClientException,
            AlexaForBusinessException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates an existing room profile by room profile ARN.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateProfileRequest.Builder} avoiding the need to
     * create one manually via {@link UpdateProfileRequest#builder()}
     * </p>
     *
     * @param updateProfileRequest
     *        A {@link Consumer} that will call methods on {@link UpdateProfileRequest.Builder} to create a request.
     * @return Result of the UpdateProfile operation returned by the service.
     * @throws NotFoundException
     *         The resource is not found.
     * @throws NameInUseException
     *         The name sent in the request is already in use.
     * @throws ConcurrentModificationException
     *         There is a concurrent modification of resources.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AlexaForBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AlexaForBusinessClient.UpdateProfile
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/UpdateProfile"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateProfileResponse updateProfile(Consumer<UpdateProfileRequest.Builder> updateProfileRequest)
            throws NotFoundException, NameInUseException, ConcurrentModificationException, AwsServiceException,
            SdkClientException, AlexaForBusinessException {
        return updateProfile(UpdateProfileRequest.builder().applyMutation(updateProfileRequest).build());
    }

    /**
     * <p>
     * Updates room details by room ARN.
     * </p>
     *
     * @param updateRoomRequest
     * @return Result of the UpdateRoom operation returned by the service.
     * @throws NotFoundException
     *         The resource is not found.
     * @throws NameInUseException
     *         The name sent in the request is already in use.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AlexaForBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AlexaForBusinessClient.UpdateRoom
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/UpdateRoom" target="_top">AWS
     *      API Documentation</a>
     */
    default UpdateRoomResponse updateRoom(UpdateRoomRequest updateRoomRequest) throws NotFoundException, NameInUseException,
            AwsServiceException, SdkClientException, AlexaForBusinessException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates room details by room ARN.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateRoomRequest.Builder} avoiding the need to
     * create one manually via {@link UpdateRoomRequest#builder()}
     * </p>
     *
     * @param updateRoomRequest
     *        A {@link Consumer} that will call methods on {@link UpdateRoomRequest.Builder} to create a request.
     * @return Result of the UpdateRoom operation returned by the service.
     * @throws NotFoundException
     *         The resource is not found.
     * @throws NameInUseException
     *         The name sent in the request is already in use.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AlexaForBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AlexaForBusinessClient.UpdateRoom
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/UpdateRoom" target="_top">AWS
     *      API Documentation</a>
     */
    default UpdateRoomResponse updateRoom(Consumer<UpdateRoomRequest.Builder> updateRoomRequest) throws NotFoundException,
            NameInUseException, AwsServiceException, SdkClientException, AlexaForBusinessException {
        return updateRoom(UpdateRoomRequest.builder().applyMutation(updateRoomRequest).build());
    }

    /**
     * <p>
     * Updates skill group details by skill group ARN.
     * </p>
     *
     * @param updateSkillGroupRequest
     * @return Result of the UpdateSkillGroup operation returned by the service.
     * @throws NotFoundException
     *         The resource is not found.
     * @throws NameInUseException
     *         The name sent in the request is already in use.
     * @throws ConcurrentModificationException
     *         There is a concurrent modification of resources.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AlexaForBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AlexaForBusinessClient.UpdateSkillGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/UpdateSkillGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateSkillGroupResponse updateSkillGroup(UpdateSkillGroupRequest updateSkillGroupRequest) throws NotFoundException,
            NameInUseException, ConcurrentModificationException, AwsServiceException, SdkClientException,
            AlexaForBusinessException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates skill group details by skill group ARN.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateSkillGroupRequest.Builder} avoiding the need
     * to create one manually via {@link UpdateSkillGroupRequest#builder()}
     * </p>
     *
     * @param updateSkillGroupRequest
     *        A {@link Consumer} that will call methods on {@link UpdateSkillGroupRequest.Builder} to create a request.
     * @return Result of the UpdateSkillGroup operation returned by the service.
     * @throws NotFoundException
     *         The resource is not found.
     * @throws NameInUseException
     *         The name sent in the request is already in use.
     * @throws ConcurrentModificationException
     *         There is a concurrent modification of resources.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AlexaForBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AlexaForBusinessClient.UpdateSkillGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/UpdateSkillGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateSkillGroupResponse updateSkillGroup(Consumer<UpdateSkillGroupRequest.Builder> updateSkillGroupRequest)
            throws NotFoundException, NameInUseException, ConcurrentModificationException, AwsServiceException,
            SdkClientException, AlexaForBusinessException {
        return updateSkillGroup(UpdateSkillGroupRequest.builder().applyMutation(updateSkillGroupRequest).build());
    }

    /**
     * Create a {@link AlexaForBusinessClient} with the region loaded from the
     * {@link software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain} and credentials loaded from the
     * {@link software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider}.
     */
    static AlexaForBusinessClient create() {
        return builder().build();
    }

    /**
     * Create a builder that can be used to configure and create a {@link AlexaForBusinessClient}.
     */
    static AlexaForBusinessClientBuilder builder() {
        return new DefaultAlexaForBusinessClientBuilder();
    }

    static ServiceMetadata serviceMetadata() {
        return ServiceMetadata.of(SERVICE_METADATA_ID);
    }

    @Override
    AlexaForBusinessServiceClientConfiguration serviceClientConfiguration();
}
