/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.alexaforbusiness.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ResolveRoomResponse extends AlexaForBusinessResponse implements
        ToCopyableBuilder<ResolveRoomResponse.Builder, ResolveRoomResponse> {
    private static final SdkField<String> ROOM_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RoomArn").getter(getter(ResolveRoomResponse::roomArn)).setter(setter(Builder::roomArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoomArn").build()).build();

    private static final SdkField<String> ROOM_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RoomName").getter(getter(ResolveRoomResponse::roomName)).setter(setter(Builder::roomName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoomName").build()).build();

    private static final SdkField<List<RoomSkillParameter>> ROOM_SKILL_PARAMETERS_FIELD = SdkField
            .<List<RoomSkillParameter>> builder(MarshallingType.LIST)
            .memberName("RoomSkillParameters")
            .getter(getter(ResolveRoomResponse::roomSkillParameters))
            .setter(setter(Builder::roomSkillParameters))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoomSkillParameters").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<RoomSkillParameter> builder(MarshallingType.SDK_POJO)
                                            .constructor(RoomSkillParameter::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ROOM_ARN_FIELD,
            ROOM_NAME_FIELD, ROOM_SKILL_PARAMETERS_FIELD));

    private final String roomArn;

    private final String roomName;

    private final List<RoomSkillParameter> roomSkillParameters;

    private ResolveRoomResponse(BuilderImpl builder) {
        super(builder);
        this.roomArn = builder.roomArn;
        this.roomName = builder.roomName;
        this.roomSkillParameters = builder.roomSkillParameters;
    }

    /**
     * <p>
     * The ARN of the room from which the skill request was invoked.
     * </p>
     * 
     * @return The ARN of the room from which the skill request was invoked.
     */
    public final String roomArn() {
        return roomArn;
    }

    /**
     * <p>
     * The name of the room from which the skill request was invoked.
     * </p>
     * 
     * @return The name of the room from which the skill request was invoked.
     */
    public final String roomName() {
        return roomName;
    }

    /**
     * For responses, this returns true if the service returned a value for the RoomSkillParameters property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasRoomSkillParameters() {
        return roomSkillParameters != null && !(roomSkillParameters instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Response to get the room profile request. Required.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasRoomSkillParameters} method.
     * </p>
     * 
     * @return Response to get the room profile request. Required.
     */
    public final List<RoomSkillParameter> roomSkillParameters() {
        return roomSkillParameters;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(roomArn());
        hashCode = 31 * hashCode + Objects.hashCode(roomName());
        hashCode = 31 * hashCode + Objects.hashCode(hasRoomSkillParameters() ? roomSkillParameters() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ResolveRoomResponse)) {
            return false;
        }
        ResolveRoomResponse other = (ResolveRoomResponse) obj;
        return Objects.equals(roomArn(), other.roomArn()) && Objects.equals(roomName(), other.roomName())
                && hasRoomSkillParameters() == other.hasRoomSkillParameters()
                && Objects.equals(roomSkillParameters(), other.roomSkillParameters());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ResolveRoomResponse").add("RoomArn", roomArn()).add("RoomName", roomName())
                .add("RoomSkillParameters", hasRoomSkillParameters() ? roomSkillParameters() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "RoomArn":
            return Optional.ofNullable(clazz.cast(roomArn()));
        case "RoomName":
            return Optional.ofNullable(clazz.cast(roomName()));
        case "RoomSkillParameters":
            return Optional.ofNullable(clazz.cast(roomSkillParameters()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ResolveRoomResponse, T> g) {
        return obj -> g.apply((ResolveRoomResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends AlexaForBusinessResponse.Builder, SdkPojo, CopyableBuilder<Builder, ResolveRoomResponse> {
        /**
         * <p>
         * The ARN of the room from which the skill request was invoked.
         * </p>
         * 
         * @param roomArn
         *        The ARN of the room from which the skill request was invoked.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roomArn(String roomArn);

        /**
         * <p>
         * The name of the room from which the skill request was invoked.
         * </p>
         * 
         * @param roomName
         *        The name of the room from which the skill request was invoked.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roomName(String roomName);

        /**
         * <p>
         * Response to get the room profile request. Required.
         * </p>
         * 
         * @param roomSkillParameters
         *        Response to get the room profile request. Required.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roomSkillParameters(Collection<RoomSkillParameter> roomSkillParameters);

        /**
         * <p>
         * Response to get the room profile request. Required.
         * </p>
         * 
         * @param roomSkillParameters
         *        Response to get the room profile request. Required.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roomSkillParameters(RoomSkillParameter... roomSkillParameters);

        /**
         * <p>
         * Response to get the room profile request. Required.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.alexaforbusiness.model.RoomSkillParameter.Builder} avoiding the need
         * to create one manually via
         * {@link software.amazon.awssdk.services.alexaforbusiness.model.RoomSkillParameter#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.alexaforbusiness.model.RoomSkillParameter.Builder#build()} is called
         * immediately and its result is passed to {@link #roomSkillParameters(List<RoomSkillParameter>)}.
         * 
         * @param roomSkillParameters
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.alexaforbusiness.model.RoomSkillParameter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #roomSkillParameters(java.util.Collection<RoomSkillParameter>)
         */
        Builder roomSkillParameters(Consumer<RoomSkillParameter.Builder>... roomSkillParameters);
    }

    static final class BuilderImpl extends AlexaForBusinessResponse.BuilderImpl implements Builder {
        private String roomArn;

        private String roomName;

        private List<RoomSkillParameter> roomSkillParameters = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ResolveRoomResponse model) {
            super(model);
            roomArn(model.roomArn);
            roomName(model.roomName);
            roomSkillParameters(model.roomSkillParameters);
        }

        public final String getRoomArn() {
            return roomArn;
        }

        public final void setRoomArn(String roomArn) {
            this.roomArn = roomArn;
        }

        @Override
        public final Builder roomArn(String roomArn) {
            this.roomArn = roomArn;
            return this;
        }

        public final String getRoomName() {
            return roomName;
        }

        public final void setRoomName(String roomName) {
            this.roomName = roomName;
        }

        @Override
        public final Builder roomName(String roomName) {
            this.roomName = roomName;
            return this;
        }

        public final List<RoomSkillParameter.Builder> getRoomSkillParameters() {
            List<RoomSkillParameter.Builder> result = RoomSkillParametersCopier.copyToBuilder(this.roomSkillParameters);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setRoomSkillParameters(Collection<RoomSkillParameter.BuilderImpl> roomSkillParameters) {
            this.roomSkillParameters = RoomSkillParametersCopier.copyFromBuilder(roomSkillParameters);
        }

        @Override
        public final Builder roomSkillParameters(Collection<RoomSkillParameter> roomSkillParameters) {
            this.roomSkillParameters = RoomSkillParametersCopier.copy(roomSkillParameters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder roomSkillParameters(RoomSkillParameter... roomSkillParameters) {
            roomSkillParameters(Arrays.asList(roomSkillParameters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder roomSkillParameters(Consumer<RoomSkillParameter.Builder>... roomSkillParameters) {
            roomSkillParameters(Stream.of(roomSkillParameters).map(c -> RoomSkillParameter.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public ResolveRoomResponse build() {
            return new ResolveRoomResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
