/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.alexaforbusiness.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.alexaforbusiness.model.BusinessReportFailureCode;
import software.amazon.awssdk.services.alexaforbusiness.model.BusinessReportS3Location;
import software.amazon.awssdk.services.alexaforbusiness.model.BusinessReportStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class BusinessReport
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, BusinessReport> {
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(BusinessReport.getter(BusinessReport::statusAsString)).setter(BusinessReport.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<String> FAILURE_CODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FailureCode").getter(BusinessReport.getter(BusinessReport::failureCodeAsString)).setter(BusinessReport.setter(Builder::failureCode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FailureCode").build()}).build();
    private static final SdkField<BusinessReportS3Location> S3_LOCATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("S3Location").getter(BusinessReport.getter(BusinessReport::s3Location)).setter(BusinessReport.setter(Builder::s3Location)).constructor(BusinessReportS3Location::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3Location").build()}).build();
    private static final SdkField<Instant> DELIVERY_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("DeliveryTime").getter(BusinessReport.getter(BusinessReport::deliveryTime)).setter(BusinessReport.setter(Builder::deliveryTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeliveryTime").build()}).build();
    private static final SdkField<String> DOWNLOAD_URL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DownloadUrl").getter(BusinessReport.getter(BusinessReport::downloadUrl)).setter(BusinessReport.setter(Builder::downloadUrl)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DownloadUrl").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STATUS_FIELD, FAILURE_CODE_FIELD, S3_LOCATION_FIELD, DELIVERY_TIME_FIELD, DOWNLOAD_URL_FIELD));
    private static final long serialVersionUID = 1L;
    private final String status;
    private final String failureCode;
    private final BusinessReportS3Location s3Location;
    private final Instant deliveryTime;
    private final String downloadUrl;

    private BusinessReport(BuilderImpl builder) {
        this.status = builder.status;
        this.failureCode = builder.failureCode;
        this.s3Location = builder.s3Location;
        this.deliveryTime = builder.deliveryTime;
        this.downloadUrl = builder.downloadUrl;
    }

    public final BusinessReportStatus status() {
        return BusinessReportStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final BusinessReportFailureCode failureCode() {
        return BusinessReportFailureCode.fromValue(this.failureCode);
    }

    public final String failureCodeAsString() {
        return this.failureCode;
    }

    public final BusinessReportS3Location s3Location() {
        return this.s3Location;
    }

    public final Instant deliveryTime() {
        return this.deliveryTime;
    }

    public final String downloadUrl() {
        return this.downloadUrl;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.failureCodeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.s3Location());
        hashCode = 31 * hashCode + Objects.hashCode(this.deliveryTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.downloadUrl());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BusinessReport)) {
            return false;
        }
        BusinessReport other = (BusinessReport)obj;
        return Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.failureCodeAsString(), other.failureCodeAsString()) && Objects.equals(this.s3Location(), other.s3Location()) && Objects.equals(this.deliveryTime(), other.deliveryTime()) && Objects.equals(this.downloadUrl(), other.downloadUrl());
    }

    public final String toString() {
        return ToString.builder((String)"BusinessReport").add("Status", (Object)this.statusAsString()).add("FailureCode", (Object)this.failureCodeAsString()).add("S3Location", (Object)this.s3Location()).add("DeliveryTime", (Object)this.deliveryTime()).add("DownloadUrl", (Object)this.downloadUrl()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "FailureCode": {
                return Optional.ofNullable(clazz.cast(this.failureCodeAsString()));
            }
            case "S3Location": {
                return Optional.ofNullable(clazz.cast(this.s3Location()));
            }
            case "DeliveryTime": {
                return Optional.ofNullable(clazz.cast(this.deliveryTime()));
            }
            case "DownloadUrl": {
                return Optional.ofNullable(clazz.cast(this.downloadUrl()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<BusinessReport, T> g) {
        return obj -> g.apply((BusinessReport)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String status;
        private String failureCode;
        private BusinessReportS3Location s3Location;
        private Instant deliveryTime;
        private String downloadUrl;

        private BuilderImpl() {
        }

        private BuilderImpl(BusinessReport model) {
            this.status(model.status);
            this.failureCode(model.failureCode);
            this.s3Location(model.s3Location);
            this.deliveryTime(model.deliveryTime);
            this.downloadUrl(model.downloadUrl);
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(BusinessReportStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getFailureCode() {
            return this.failureCode;
        }

        public final void setFailureCode(String failureCode) {
            this.failureCode = failureCode;
        }

        @Override
        public final Builder failureCode(String failureCode) {
            this.failureCode = failureCode;
            return this;
        }

        @Override
        public final Builder failureCode(BusinessReportFailureCode failureCode) {
            this.failureCode(failureCode == null ? null : failureCode.toString());
            return this;
        }

        public final BusinessReportS3Location.Builder getS3Location() {
            return this.s3Location != null ? this.s3Location.toBuilder() : null;
        }

        public final void setS3Location(BusinessReportS3Location.BuilderImpl s3Location) {
            this.s3Location = s3Location != null ? s3Location.build() : null;
        }

        @Override
        public final Builder s3Location(BusinessReportS3Location s3Location) {
            this.s3Location = s3Location;
            return this;
        }

        public final Instant getDeliveryTime() {
            return this.deliveryTime;
        }

        public final void setDeliveryTime(Instant deliveryTime) {
            this.deliveryTime = deliveryTime;
        }

        @Override
        public final Builder deliveryTime(Instant deliveryTime) {
            this.deliveryTime = deliveryTime;
            return this;
        }

        public final String getDownloadUrl() {
            return this.downloadUrl;
        }

        public final void setDownloadUrl(String downloadUrl) {
            this.downloadUrl = downloadUrl;
        }

        @Override
        public final Builder downloadUrl(String downloadUrl) {
            this.downloadUrl = downloadUrl;
            return this;
        }

        public BusinessReport build() {
            return new BusinessReport(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, BusinessReport> {
        public Builder status(String var1);

        public Builder status(BusinessReportStatus var1);

        public Builder failureCode(String var1);

        public Builder failureCode(BusinessReportFailureCode var1);

        public Builder s3Location(BusinessReportS3Location var1);

        default public Builder s3Location(Consumer<BusinessReportS3Location.Builder> s3Location) {
            return this.s3Location((BusinessReportS3Location)((BusinessReportS3Location.Builder)BusinessReportS3Location.builder().applyMutation(s3Location)).build());
        }

        public Builder deliveryTime(Instant var1);

        public Builder downloadUrl(String var1);
    }
}

