/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.alexaforbusiness.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum CommsProtocol {
    SIP("SIP"),
    SIPS("SIPS"),
    H323("H323"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, CommsProtocol> VALUE_MAP;
    private final String value;

    private CommsProtocol(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static CommsProtocol fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<CommsProtocol> knownValues() {
        EnumSet<CommsProtocol> knownValues = EnumSet.allOf(CommsProtocol.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(CommsProtocol.class, CommsProtocol::toString);
    }
}

