/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.alexaforbusiness.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.alexaforbusiness.AlexaForBusinessClient;
import software.amazon.awssdk.services.alexaforbusiness.internal.UserAgentUtils;
import software.amazon.awssdk.services.alexaforbusiness.model.SearchProfilesRequest;
import software.amazon.awssdk.services.alexaforbusiness.model.SearchProfilesResponse;

public class SearchProfilesIterable
implements SdkIterable<SearchProfilesResponse> {
    private final AlexaForBusinessClient client;
    private final SearchProfilesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public SearchProfilesIterable(AlexaForBusinessClient client, SearchProfilesRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new SearchProfilesResponseFetcher();
    }

    public Iterator<SearchProfilesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class SearchProfilesResponseFetcher
    implements SyncPageFetcher<SearchProfilesResponse> {
        private SearchProfilesResponseFetcher() {
        }

        public boolean hasNextPage(SearchProfilesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public SearchProfilesResponse nextPage(SearchProfilesResponse previousPage) {
            if (previousPage == null) {
                return SearchProfilesIterable.this.client.searchProfiles(SearchProfilesIterable.this.firstRequest);
            }
            return SearchProfilesIterable.this.client.searchProfiles((SearchProfilesRequest)((Object)SearchProfilesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

