/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.alexaforbusiness.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum SkillTypeFilter {
    PUBLIC("PUBLIC"),
    PRIVATE("PRIVATE"),
    ALL("ALL"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, SkillTypeFilter> VALUE_MAP;
    private final String value;

    private SkillTypeFilter(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static SkillTypeFilter fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<SkillTypeFilter> knownValues() {
        EnumSet<SkillTypeFilter> knownValues = EnumSet.allOf(SkillTypeFilter.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(SkillTypeFilter.class, SkillTypeFilter::toString);
    }
}

